/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.documentation;

import com.intellij.openapi.util.text.HtmlChunk;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClionHoverInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\b\u001a\u00020\t*\u00060\nj\u0002`\u000bH\u0002\u001a\u0018\u0010\f\u001a\u00020\t*\u00060\nj\u0002`\u000b2\u0006\u0010\u0007\u001a\u00020\u0001H\u0002\u001a\u001a\u0010\r\u001a\u00020\t*\u00060\nj\u0002`\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002\u001a\u001a\u0010\u0010\u001a\u00020\t*\u00060\nj\u0002`\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002\u001a-\u0010\u0011\u001a\u00020\t*\u00060\nj\u0002`\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u000b\u0010\u0015\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0016H\u0002\u001a\u001a\u0010\u0017\u001a\u00020\t*\u00060\nj\u0002`\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"addBytes", "", "numBytes", "", "stringRegex", "Lkotlin/text/Regex;", "tryParseValueFromHover", "value", "addBreakIfRequired", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "addValueFromHover", "addOffset", "hoverInfo", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClionHoverInfo;", "addSizeAndPadding", "addConstructionAssignment", "construction", "", "assignment", "copyOrMoveText", "Lorg/jetbrains/annotations/Nls;", "addMoveCopyability", "intellij.cidr.clangd.legacyBridge"})
public final class ClangDocumentationProviderKt {
    @NotNull
    private static final Regex stringRegex = new Regex("&((u8|u|U|L)?R?\".*?\")\\[0]");

    private static final String addBytes(long numBytes) {
        Object[] objectArray = new Object[]{numBytes};
        String string = OCBundle.message((String)"qdoc.byte.0", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String byteWord = string;
        return numBytes + " " + byteWord;
    }

    private static final String tryParseValueFromHover(String value) {
        Integer numberVal;
        Number number = StringsKt.toIntOrNull((String)value);
        if (number == null) {
            number = StringsKt.toDoubleOrNull((String)value);
        }
        if ((numberVal = number) != null) {
            return ((Object)numberVal).toString();
        }
        return stringRegex.replace((CharSequence)value, ClangDocumentationProviderKt::tryParseValueFromHover$lambda$0);
    }

    private static final void addBreakIfRequired(StringBuilder $this$addBreakIfRequired) {
        if (((CharSequence)$this$addBreakIfRequired).length() > 0) {
            $this$addBreakIfRequired.append(HtmlChunk.br());
        }
    }

    private static final void addValueFromHover(StringBuilder $this$addValueFromHover, String value) {
        $this$addValueFromHover.append(HtmlChunk.text((String)OCBundle.message((String)"qdoc.value", (Object[])new Object[0])).bold());
        $this$addValueFromHover.append(" = ");
        String valueStr = ClangDocumentationProviderKt.tryParseValueFromHover(value);
        $this$addValueFromHover.append(valueStr);
    }

    private static final void addOffset(StringBuilder $this$addOffset, ClionHoverInfo hoverInfo) {
        Object object = hoverInfo;
        if (object == null || (object = object.getOffset()) == null) {
            return;
        }
        long offset = (Long)object;
        if (offset == 0L) {
            return;
        }
        ClangDocumentationProviderKt.addBreakIfRequired($this$addOffset);
        String bytesStr = ClangDocumentationProviderKt.addBytes(offset);
        $this$addOffset.append(HtmlChunk.text((String)OCBundle.message((String)"qdoc.offset", (Object[])new Object[0])).bold());
        $this$addOffset.append(" = ");
        $this$addOffset.append(bytesStr);
    }

    private static final void addSizeAndPadding(StringBuilder $this$addSizeAndPadding, ClionHoverInfo hoverInfo) {
        long padding;
        Object object = hoverInfo;
        if (object == null || (object = object.getSize()) == null) {
            return;
        }
        long size = (Long)object;
        ClangDocumentationProviderKt.addBreakIfRequired($this$addSizeAndPadding);
        String sizeStr = ClangDocumentationProviderKt.addBytes(size);
        $this$addSizeAndPadding.append(HtmlChunk.text((String)OCBundle.message((String)"qdoc.size", (Object[])new Object[0])).bold());
        $this$addSizeAndPadding.append(" = ");
        $this$addSizeAndPadding.append(sizeStr);
        Long l = hoverInfo.getPadding();
        long l2 = padding = l != null ? l : 0L;
        if (padding != 0L) {
            $this$addSizeAndPadding.append(" (+ ");
            $this$addSizeAndPadding.append(padding);
            $this$addSizeAndPadding.append(" " + OCBundle.message((String)"qdoc.padding", (Object[])new Object[0]) + ")");
        }
    }

    private static final void addConstructionAssignment(StringBuilder $this$addConstructionAssignment, boolean construction, boolean assignment, String copyOrMoveText) {
        if (!construction && !assignment) {
            return;
        }
        ClangDocumentationProviderKt.addBreakIfRequired($this$addConstructionAssignment);
        $this$addConstructionAssignment.append(HtmlChunk.text((String)copyOrMoveText).bold());
        $this$addConstructionAssignment.append(": ");
        if (construction) {
            $this$addConstructionAssignment.append(HtmlChunk.text((String)OCBundle.message((String)"qdoc.construction", (Object[])new Object[0])));
        }
        if (assignment) {
            if (construction) {
                $this$addConstructionAssignment.append(", ");
            }
            $this$addConstructionAssignment.append(HtmlChunk.text((String)OCBundle.message((String)"qdoc.assignment", (Object[])new Object[0])));
        }
    }

    private static final void addMoveCopyability(StringBuilder $this$addMoveCopyability, ClionHoverInfo hoverInfo) {
        if (hoverInfo == null) {
            return;
        }
        boolean bl = Intrinsics.areEqual((Object)hoverInfo.getCopyConstructible(), (Object)true);
        boolean bl2 = Intrinsics.areEqual((Object)hoverInfo.getCopyAssignable(), (Object)true);
        String string = OCBundle.message((String)"qdoc.copy", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ClangDocumentationProviderKt.addConstructionAssignment($this$addMoveCopyability, bl, bl2, string);
        boolean bl3 = Intrinsics.areEqual((Object)hoverInfo.getMoveConstructible(), (Object)true);
        boolean bl4 = Intrinsics.areEqual((Object)hoverInfo.getMoveAssignable(), (Object)true);
        String string2 = OCBundle.message((String)"qdoc.move", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        ClangDocumentationProviderKt.addConstructionAssignment($this$addMoveCopyability, bl3, bl4, string2);
    }

    private static final CharSequence tryParseValueFromHover$lambda$0(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (String)it.getDestructured().getMatch().getGroupValues().get(1);
    }

    public static final /* synthetic */ void access$addValueFromHover(StringBuilder $receiver, String value) {
        ClangDocumentationProviderKt.addValueFromHover($receiver, value);
    }

    public static final /* synthetic */ void access$addOffset(StringBuilder $receiver, ClionHoverInfo hoverInfo) {
        ClangDocumentationProviderKt.addOffset($receiver, hoverInfo);
    }

    public static final /* synthetic */ void access$addSizeAndPadding(StringBuilder $receiver, ClionHoverInfo hoverInfo) {
        ClangDocumentationProviderKt.addSizeAndPadding($receiver, hoverInfo);
    }

    public static final /* synthetic */ void access$addMoveCopyability(StringBuilder $receiver, ClionHoverInfo hoverInfo) {
        ClangDocumentationProviderKt.addMoveCopyability($receiver, hoverInfo);
    }
}

