/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.annotator;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangAnnotatorUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangAppliedDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangErrorsAnnotatorPass;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangHighlightKey;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangProblemGroup;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangQuickFixFactoryKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionFixItHint;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangErrorsAnnotatorSlowPass
extends TextEditorHighlightingPass {
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final TextRange myRestrictRange;
    private final int myClangErrorsPassId;
    @Nullable
    private List<Pair<HighlightInfo.Builder, HighlightInfo>> updatedHighlights;

    public ClangErrorsAnnotatorSlowPass(@NotNull PsiFile file, @NotNull Document document, @NotNull TextRange restrictRange, int clangErrorsPassId) {
        if (file == null) {
            ClangErrorsAnnotatorSlowPass.$$$reportNull$$$0(0);
        }
        if (document == null) {
            ClangErrorsAnnotatorSlowPass.$$$reportNull$$$0(1);
        }
        if (restrictRange == null) {
            ClangErrorsAnnotatorSlowPass.$$$reportNull$$$0(2);
        }
        super(file.getProject(), document);
        this.myFile = file;
        this.myRestrictRange = restrictRange;
        this.myClangErrorsPassId = clangErrorsPassId;
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            ClangErrorsAnnotatorSlowPass.$$$reportNull$$$0(3);
        }
        if (!ClangUtils.isClangdOn((Project)this.myProject)) {
            return;
        }
        if (!ClangAnnotatorUtil.shouldAnnotate((Project)this.myProject, (PsiFile)this.myFile)) {
            return;
        }
        Map clangDiagnosticsMap = (Map)this.myFile.getUserData(ClangAppliedDiagnostic.CLANGD_ANNOTATIONS);
        if (ContainerUtil.isEmpty((Map)clangDiagnosticsMap)) {
            return;
        }
        this.updatedHighlights = new ArrayList<Pair<HighlightInfo.Builder, HighlightInfo>>();
        DaemonCodeAnalyzerEx.processHighlights((Document)this.myDocument, (Project)this.myFile.getProject(), null, (int)this.myRestrictRange.getStartOffset(), (int)this.myRestrictRange.getEndOffset(), info -> {
            if (info.getProblemGroup() instanceof ClangProblemGroup) {
                HighlightInfo.Builder newHighlightInfo = ClangErrorsAnnotatorPass.mergeHighlights((HighlightInfo)info, (HighlightInfo)info, (Document)this.myDocument, (EditorColorsScheme)this.getColorsScheme());
                this.updatedHighlights.add((Pair<HighlightInfo.Builder, HighlightInfo>)Pair.create((Object)newHighlightInfo, (Object)info));
            }
            return true;
        });
        ClangLanguageService clangdService = ClangLanguageServiceProvider.getIfStarted((Project)this.myProject);
        @NotNull ClangUrlConverter urlConverter = clangdService != null ? clangdService.getUrlConverter() : new ClangUrlConverter();
        for (int i = 0; i < this.updatedHighlights.size(); ++i) {
            PsiElement psiContext;
            ClangHighlightKey highlightKey;
            ClangAppliedDiagnostic appliedDiag;
            Pair<HighlightInfo.Builder, HighlightInfo> pair = this.updatedHighlights.get(i);
            HighlightInfo oldHighlight = (HighlightInfo)pair.getSecond();
            if (!this.myRestrictRange.contains(oldHighlight.getStartOffset()) || !this.myRestrictRange.containsOffset(oldHighlight.getEndOffset()) || (appliedDiag = (ClangAppliedDiagnostic)clangDiagnosticsMap.get(highlightKey = new ClangHighlightKey(oldHighlight))) == null || (psiContext = this.myFile.findElementAt(oldHighlight.getStartOffset())) == null) continue;
            OCResolveContext context = OCResolveContext.forPsi((PsiElement)psiContext);
            HighlightInfo.Builder clonedHighlight = ClangErrorsAnnotatorPass.mergeHighlights((HighlightInfo)appliedDiag.annotation, (HighlightInfo)appliedDiag.annotation, (Document)this.myDocument, (EditorColorsScheme)this.getColorsScheme());
            assert (appliedDiag.annotation.getProblemGroup() instanceof ClangProblemGroup);
            for (ClionFixItHint fixit : appliedDiag.diagnostic.getClionFixits()) {
                for (IntentionAction quickFix : ClangQuickFixFactoryKt.getClangQuickFixes(fixit, context, psiContext, urlConverter)) {
                    clonedHighlight.registerFix(quickFix, null, null, null, null);
                }
            }
            this.updatedHighlights.set(i, (Pair<HighlightInfo.Builder, HighlightInfo>)Pair.create((Object)clonedHighlight, (Object)appliedDiag.annotation));
        }
    }

    public void doApplyInformationToEditor() {
        if (this.updatedHighlights == null) {
            return;
        }
        UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.myDocument, (int)this.myRestrictRange.getStartOffset(), (int)this.myRestrictRange.getEndOffset(), (Collection)ContainerUtil.mapNotNull(this.updatedHighlights, p -> ((HighlightInfo.Builder)p.getFirst()).create()), (EditorColorsScheme)this.getColorsScheme(), (int)this.myClangErrorsPassId);
        ClangAppliedDiagnostic.clearDiagnostics((UserDataHolder)this.myFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restrictRange";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/annotator/ClangErrorsAnnotatorSlowPass";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doCollectInformation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

