/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.util;

import com.android.ide.common.util.PathMapEntry;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0017\u0012\u000e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\r\u001a\u00020\u000eH\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\t\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0011R \u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\t\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/android/ide/common/util/PathTreeMapIterator;", "T", "", "startNode", "Lcom/android/ide/common/util/PathMapEntry;", "<init>", "(Lcom/android/ide/common/util/PathMapEntry;)V", "iteratorStack", "Ljava/util/ArrayDeque;", "next", "getNext", "()Lcom/android/ide/common/util/PathMapEntry;", "setNext", "hasNext", "", "advance", "", "()Ljava/lang/Object;", "android.sdktools.sdk-common"})
public final class PathTreeMapIterator<T>
implements Iterator<T>,
KMappedMarker {
    @NotNull
    private final ArrayDeque<Iterator<PathMapEntry<T>>> iteratorStack = new ArrayDeque();
    @Nullable
    private PathMapEntry<T> next;

    public PathTreeMapIterator(@Nullable PathMapEntry<T> startNode) {
        if (startNode != null) {
            this.iteratorStack.addLast(startNode.iterator());
            if (startNode.getExplicitlyInserted()) {
                this.next = startNode;
            }
            this.advance();
        }
    }

    @Nullable
    public final PathMapEntry<T> getNext() {
        return this.next;
    }

    public final void setNext(@Nullable PathMapEntry<T> pathMapEntry) {
        this.next = pathMapEntry;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    private final void advance() {
        while (this.next == null && !this.iteratorStack.isEmpty()) {
            Iterator iterator = (Iterator)CollectionsKt.last((Iterable)this.iteratorStack);
            if (!iterator.hasNext()) {
                this.iteratorStack.removeLast();
                continue;
            }
            PathMapEntry nextChild = (PathMapEntry)iterator.next();
            if (nextChild.getExplicitlyInserted()) {
                this.next = nextChild;
            }
            this.iteratorStack.addLast(nextChild.iterator());
        }
    }

    @Override
    public T next() {
        PathMapEntry<T> pathMapEntry = this.next;
        if (pathMapEntry == null) {
            throw new NoSuchElementException();
        }
        PathMapEntry<T> result = pathMapEntry;
        this.next = null;
        this.advance();
        T t = result.getValue();
        Intrinsics.checkNotNull(t);
        return t;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

