/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.util;

import com.android.ide.common.util.PathStringUtil;
import java.io.File;
import java.net.URI;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderNotFoundException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u000f\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B;\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rB!\b\u0012\u0012\u0006\u0010\u000e\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u000f\u001a\u00020\u0007\u00a2\u0006\u0004\b\f\u0010\u0010B\u0019\b\u0016\u0012\u0006\u0010\u0011\u001a\u00020\u0005\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\f\u0010\u0012B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\f\u0010\u0013B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\f\u0010\u0014B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0015\u00a2\u0006\u0004\b\f\u0010\u0016B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0017\u00a2\u0006\u0004\b\f\u0010\u0018J\b\u0010#\u001a\u00020\u0005H\u0016J\u0006\u0010$\u001a\u00020\u0005J\b\u0010%\u001a\u0004\u0018\u00010\u0015J\b\u0010&\u001a\u0004\u0018\u00010\u0017J\u000e\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u0007J\u0011\u0010.\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u0007H\u0086\u0002J\u0011\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u000200H\u0086\u0002J\u0016\u00101\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u00072\u0006\u00103\u001a\u00020\u0007J\u000e\u00104\u001a\u00020(2\u0006\u00105\u001a\u00020\u0000J\u0013\u0010B\u001a\u00020(2\b\u0010C\u001a\u0004\u0018\u00010DH\u0096\u0002J\b\u0010E\u001a\u00020\u0007H\u0016J\b\u0010F\u001a\u00020\u0007H\u0002J\u0006\u0010G\u001a\u00020\u0000J\u0006\u0010H\u001a\u00020\u0000J\u000e\u0010J\u001a\u00020\u00002\u0006\u0010C\u001a\u00020\u0000J\u000e\u0010L\u001a\u00020\u00002\u0006\u0010C\u001a\u00020\u0005J\u000e\u0010L\u001a\u00020\u00002\u0006\u0010C\u001a\u00020\u0000J\u0011\u0010Q\u001a\u00020\u00072\u0006\u0010C\u001a\u00020\u0000H\u0096\u0002J\u0010\u0010R\u001a\u00020(2\u0006\u0010C\u001a\u00020\u0000H\u0002J\u001c\u0010S\u001a\u00020(2\b\u0010T\u001a\u0004\u0018\u00010\u00002\b\u0010U\u001a\u0004\u0018\u00010\u0000H\u0002J\u0010\u0010V\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J\u001c\u0010W\u001a\u0004\u0018\u00010\u00002\u0006\u0010-\u001a\u00020\u00072\b\b\u0002\u0010X\u001a\u00020\u0007H\u0002J\u001a\u0010Y\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u00072\b\b\u0002\u0010X\u001a\u00020\u0007H\u0002J\u0010\u0010[\u001a\u00020\u00072\u0006\u0010\\\u001a\u00020\u0007H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001eR\u0011\u0010!\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001eR\u0011\u0010'\u001a\u00020(8G\u00a2\u0006\u0006\u001a\u0004\b'\u0010)R\u0011\u0010*\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u001eR\u0011\u00106\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u0013\u00109\u001a\u0004\u0018\u00010\u00008F\u00a2\u0006\u0006\u001a\u0004\b:\u00108R\u0013\u0010;\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b<\u0010\u001eR\u0013\u0010=\u001a\u0004\u0018\u00010\u00008F\u00a2\u0006\u0006\u001a\u0004\b>\u00108R\u0011\u0010?\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b@\u0010AR\u0011\u0010I\u001a\u00020(8G\u00a2\u0006\u0006\u001a\u0004\bI\u0010)R\u0011\u0010K\u001a\u00020(8G\u00a2\u0006\u0006\u001a\u0004\bK\u0010)R\u0017\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00050N8F\u00a2\u0006\u0006\u001a\u0004\bO\u0010PR\u0014\u00103\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bZ\u0010A\u00a8\u0006]"}, d2={"Lcom/android/ide/common/util/PathString;", "", "filesystemUri", "Ljava/net/URI;", "path", "", "startIndex", "", "suffixEndIndex", "prefixEndIndex", "separator", "", "<init>", "(Ljava/net/URI;Ljava/lang/String;IIIC)V", "filesystem", "rootLength", "(Ljava/net/URI;Ljava/lang/String;I)V", "protocol", "(Ljava/lang/String;Ljava/lang/String;)V", "(Ljava/net/URI;Ljava/lang/String;)V", "(Ljava/lang/String;)V", "Ljava/io/File;", "(Ljava/io/File;)V", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "getFilesystemUri", "()Ljava/net/URI;", "hash", "rawPath", "getRawPath", "()Ljava/lang/String;", "portablePath", "getPortablePath", "nativePath", "getNativePath", "toString", "toDebugString", "toFile", "toPath", "isAbsolute", "", "()Z", "fileName", "getFileName", "segment", "index", "get", "range", "Lkotlin/ranges/IntRange;", "subpath", "beginIndex", "endIndex", "startsWith", "possiblePrefix", "parentOrRoot", "getParentOrRoot", "()Lcom/android/ide/common/util/PathString;", "parent", "getParent", "parentFileName", "getParentFileName", "root", "getRoot", "nameCount", "getNameCount", "()I", "equals", "other", "", "hashCode", "computeHash", "normalize", "withoutTrailingSeparator", "hasTrailingSeparator", "relativize", "isEmptyPath", "resolve", "segments", "", "getSegments", "()Ljava/util/List;", "compareTo", "sameRootAs", "compatibleRoots", "root1", "root2", "driveName", "subRangeOrNull", "length", "subRange", "getEndIndex", "computeNameStart", "end", "android.sdktools.sdk-common"})
@SourceDebugExtension(value={"SMAP\nPathString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathString.kt\ncom/android/ide/common/util/PathString\n+ 2 PathString.kt\ncom/android/ide/common/util/PathStringUtil\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,871:1\n820#2,9:872\n820#2,9:881\n820#2,9:896\n820#2,9:905\n820#2,9:914\n820#2,9:933\n820#2,9:942\n820#2,9:951\n1788#3,4:890\n1869#3,2:894\n1563#3:923\n1634#3,3:924\n1563#3:927\n1634#3,3:928\n1869#3,2:931\n*S KotlinDebug\n*F\n+ 1 PathString.kt\ncom/android/ide/common/util/PathString\n*L\n215#1:872,9\n232#1:881,9\n515#1:896,9\n518#1:905,9\n533#1:914,9\n728#1:933,9\n745#1:942,9\n775#1:951,9\n387#1:890,4\n456#1:894,2\n535#1:923\n535#1:924,3\n536#1:927\n536#1:928,3\n637#1:931,2\n*E\n"})
public final class PathString
implements Comparable<PathString> {
    @NotNull
    private final URI filesystemUri;
    @NotNull
    private final String path;
    private final int startIndex;
    private final int suffixEndIndex;
    private final int prefixEndIndex;
    private final char separator;
    private int hash;

    private PathString(URI filesystemUri, String path, int startIndex, int suffixEndIndex, int prefixEndIndex, char separator) {
        this.filesystemUri = filesystemUri;
        this.path = path;
        this.startIndex = startIndex;
        this.suffixEndIndex = suffixEndIndex;
        this.prefixEndIndex = prefixEndIndex;
        this.separator = separator;
    }

    /* synthetic */ PathString(URI uRI, String string, int n, int n2, int n3, char c, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 0x10) != 0) {
            n3 = 0;
        }
        this(uRI, string, n, n2, n3, c);
    }

    @NotNull
    public final URI getFilesystemUri() {
        return this.filesystemUri;
    }

    private PathString(URI filesystem, String path, int rootLength) {
        this(filesystem, path, rootLength, path.length(), rootLength, PathStringUtil.access$detectSeparator(path, rootLength));
    }

    public PathString(@NotNull String protocol, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this(PathStringUtil.access$getUri(protocol), path, PathStringUtil.access$prefixLength(path));
    }

    public PathString(@NotNull URI filesystemUri, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)filesystemUri, (String)"filesystemUri");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this(filesystemUri, path, PathStringUtil.access$prefixLength(path));
    }

    public PathString(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this(PathStringUtil.getDefaultFilesystemUri(), path);
    }

    public PathString(@NotNull File path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        URI uRI = PathStringUtil.getDefaultFilesystemUri();
        String string = path.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        this(uRI, string);
    }

    public PathString(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        URI uRI = path.getFileSystem().getPath(path.getFileSystem().getSeparator(), new String[0]).toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toUri(...)");
        this(uRI, ((Object)path).toString());
    }

    @NotNull
    public final String getRawPath() {
        String string;
        if (this.startIndex == this.prefixEndIndex) {
            String string2 = this.path.substring(0, this.suffixEndIndex);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = this.path.substring(0, this.prefixEndIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            StringBuilder stringBuilder2 = stringBuilder.append(string3);
            String string4 = this.path.substring(this.startIndex, this.suffixEndIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            string = stringBuilder2.append(string4).toString();
        }
        return string;
    }

    @NotNull
    public final String getPortablePath() {
        return StringsKt.replace$default((String)this.getRawPath(), (char)'\\', (char)'/', (boolean)false, (int)4, null);
    }

    @NotNull
    public final String getNativePath() {
        return PathStringUtil.access$withSeparator(this.getRawPath(), File.separatorChar);
    }

    @NotNull
    public String toString() {
        String string = this.filesystemUri.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String schemeString = string;
        if (StringsKt.startsWith$default((String)schemeString, (String)"file:///", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)schemeString, (String)":/", (boolean)false, (int)2, null) && schemeString.length() == 11) {
            schemeString = "file:///";
        }
        String path = this.getRawPath();
        StringBuilder buf = new StringBuilder(schemeString.length() + 1 + path.length());
        if (StringsKt.endsWith$default((String)schemeString, (String)"///", (boolean)false, (int)2, null)) {
            buf.append(schemeString, 0, schemeString.length() - 1);
        } else {
            buf.append(schemeString);
            if (!StringsKt.endsWith$default((CharSequence)schemeString, (char)'/', (boolean)false, (int)2, null)) {
                buf.append("!/");
            }
        }
        buf.append(path);
        String string2 = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @NotNull
    public final String toDebugString() {
        return "PathString filesystemUri=\"" + this.filesystemUri + "\" path=\"" + this.path + "\" startIndex=" + this.startIndex + " suffixEndIndex=" + this.suffixEndIndex + " prefixEndIndex=" + this.prefixEndIndex + " separator='" + this.separator + '\'';
    }

    @Nullable
    public final File toFile() {
        if (Intrinsics.areEqual((Object)this.filesystemUri.getScheme(), (Object)"file")) {
            return new File(this.getRawPath());
        }
        return null;
    }

    @Nullable
    public final Path toPath() {
        Path path;
        try {
            path = Paths.get(this.filesystemUri).getFileSystem().getPath(this.getRawPath(), new String[0]);
        }
        catch (FileSystemNotFoundException e) {
            path = null;
        }
        catch (IllegalArgumentException e) {
            path = null;
        }
        catch (ProviderNotFoundException e) {
            path = null;
        }
        return path;
    }

    @JvmName(name="isAbsolute")
    public final boolean isAbsolute() {
        return this.prefixEndIndex != 0 && PathStringUtil.access$isSeparator(this.path.charAt(this.prefixEndIndex - 1));
    }

    @NotNull
    public final String getFileName() {
        int end = this.getEndIndex();
        String string = this.path.substring(this.computeNameStart(end), end);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String segment(int index) {
        int n;
        int lengthCount;
        int subRangeStart;
        int n2;
        int n3;
        block13: {
            void $this$countUntil$iv;
            int n4;
            block12: {
                void $this$countUntil$iv2;
                if (index < 0) {
                    throw new IllegalArgumentException("Negative index: " + index);
                }
                int separatorCount = 0;
                IntProgression intProgression = (IntProgression)RangesKt.until((int)this.startIndex, (int)this.getEndIndex());
                n3 = this.startIndex;
                boolean $i$f$countUntil = false;
                int result$iv = 0;
                int item$iv = $this$countUntil$iv2.getFirst();
                int n5 = $this$countUntil$iv2.getLast();
                int n6 = $this$countUntil$iv2.getStep();
                if (n6 > 0 && item$iv <= n5 || n6 < 0 && n5 <= item$iv) {
                    while (true) {
                        int it = item$iv;
                        boolean bl = false;
                        if (PathStringUtil.access$isSeparator(this.path.charAt(it))) {
                            ++separatorCount;
                        }
                        if (separatorCount >= index) {
                            n4 = result$iv;
                            break block12;
                        }
                        ++result$iv;
                        if (item$iv == n5) break;
                        item$iv += n6;
                    }
                }
                n4 = result$iv;
            }
            n2 = n4;
            subRangeStart = n3 + n2;
            if (subRangeStart >= this.getEndIndex() - 1) {
                throw new IllegalArgumentException("Invalid index " + index + " for path " + this);
            }
            if (PathStringUtil.access$isSeparator(this.path.charAt(subRangeStart))) {
                ++subRangeStart;
            }
            lengthCount = 0;
            IntProgression result$iv = (IntProgression)RangesKt.until((int)subRangeStart, (int)this.getEndIndex());
            n3 = subRangeStart;
            boolean $i$f$countUntil = false;
            int result$iv2 = 0;
            int item$iv = $this$countUntil$iv.getFirst();
            int n7 = $this$countUntil$iv.getLast();
            int n8 = $this$countUntil$iv.getStep();
            if (n8 > 0 && item$iv <= n7 || n8 < 0 && n7 <= item$iv) {
                while (true) {
                    int it = item$iv;
                    boolean bl = false;
                    if (PathStringUtil.access$isSeparator(this.path.charAt(it))) {
                        ++lengthCount;
                    }
                    if (lengthCount >= 1) {
                        n = result$iv2;
                        break block13;
                    }
                    ++result$iv2;
                    if (item$iv == n7) break;
                    item$iv += n8;
                }
            }
            n = result$iv2;
        }
        n2 = n;
        int subRangeEnd = n3 + n2;
        if (lengthCount < 0) {
            throw new IllegalArgumentException();
        }
        String string = this.path.substring(subRangeStart, subRangeEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    @NotNull
    public final PathString get(int index) {
        return PathString.subRange$default(this, index, 0, 2, null);
    }

    @NotNull
    public final PathString get(@NotNull IntRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        if (range.getStep() != 1) {
            throw new IllegalArgumentException("Step must be 1");
        }
        return this.subRange(range.getFirst(), range.getLast() - range.getFirst() + 1);
    }

    @NotNull
    public final PathString subpath(int beginIndex, int endIndex) {
        return this.subRange(beginIndex, endIndex - beginIndex);
    }

    public final boolean startsWith(@NotNull PathString possiblePrefix) {
        Intrinsics.checkNotNullParameter((Object)possiblePrefix, (String)"possiblePrefix");
        PathString toTest = possiblePrefix.withoutTrailingSeparator();
        if (!this.sameRootAs(toTest)) {
            return false;
        }
        int ourEnd = this.getEndIndex();
        int thisLength = ourEnd - this.startIndex;
        int prefixLength = toTest.getEndIndex() - toTest.startIndex;
        if (prefixLength > thisLength) {
            return false;
        }
        if (prefixLength == 0) {
            return true;
        }
        int requiredSeparatorPosition = this.startIndex + prefixLength;
        if (requiredSeparatorPosition > ourEnd || requiredSeparatorPosition < ourEnd && !PathStringUtil.access$isSeparator(this.path.charAt(requiredSeparatorPosition))) {
            return false;
        }
        for (int idx = 0; idx < prefixLength; ++idx) {
            char otherChar;
            char thisChar = this.path.charAt(this.startIndex + idx);
            if (thisChar == (otherChar = toTest.path.charAt(toTest.startIndex + idx)) || PathStringUtil.access$isSeparator(thisChar) && PathStringUtil.access$isSeparator(otherChar)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public final PathString getParentOrRoot() {
        PathString pathString = this.getParent();
        if (pathString == null) {
            pathString = this;
        }
        return pathString;
    }

    @Nullable
    public final PathString getParent() {
        if (this.getEndIndex() <= this.startIndex) {
            return null;
        }
        int newEnd = this.computeNameStart(this.getEndIndex()) - 1;
        if (newEnd <= this.startIndex) {
            return this.getRoot();
        }
        PathString result = new PathString(this.filesystemUri, this.path, this.startIndex, newEnd, this.prefixEndIndex, this.separator);
        if (this.hash != 0) {
            int parentHash = this.hash;
            int hashCodeForSegment = 0;
            int n = this.suffixEndIndex;
            for (int i2 = newEnd; i2 < n; ++i2) {
                char nextChar = this.path.charAt(i2);
                if (PathStringUtil.access$isSeparator(nextChar)) {
                    parentHash -= hashCodeForSegment;
                    hashCodeForSegment = 0;
                }
                hashCodeForSegment = 31 * hashCodeForSegment + nextChar;
            }
            result.hash = parentHash -= hashCodeForSegment;
        }
        return result;
    }

    @Nullable
    public final String getParentFileName() {
        PathString pathString = this.getParent();
        return pathString != null ? pathString.getFileName() : null;
    }

    @Nullable
    public final PathString getRoot() {
        if (this.prefixEndIndex == 0) {
            return null;
        }
        return new PathString(this.filesystemUri, this.path, this.prefixEndIndex, this.prefixEndIndex, this.prefixEndIndex, this.separator);
    }

    /*
     * WARNING - void declaration
     */
    public final int getNameCount() {
        int n;
        if (this.getEndIndex() == this.prefixEndIndex) {
            return 0;
        }
        Iterable $this$count$iv = (Iterable)RangesKt.until((int)this.startIndex, (int)this.getEndIndex());
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_3;
            int count$iv = 0;
            Iterator iterator = $this$count$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv;
                int it = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                if (!PathStringUtil.access$isSeparator(this.path.charAt(it)) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_3;
        }
        return n + 1;
    }

    public boolean equals(@Nullable Object other) {
        int i2;
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.android.ide.common.util.PathString");
        PathString cfr_ignored_0 = (PathString)object2;
        if (!Intrinsics.areEqual((Object)this.filesystemUri, (Object)((PathString)other).filesystemUri)) {
            return false;
        }
        int length = this.suffixEndIndex - this.startIndex;
        if (length != ((PathString)other).suffixEndIndex - ((PathString)other).startIndex) {
            return false;
        }
        if (this.prefixEndIndex != ((PathString)other).prefixEndIndex) {
            return false;
        }
        int n = this.prefixEndIndex;
        for (i2 = 0; i2 < n; ++i2) {
            if (this.path.charAt(i2) == ((PathString)other).path.charAt(i2)) continue;
            return false;
        }
        for (i2 = 0; i2 < length; ++i2) {
            if (this.path.charAt(this.startIndex + i2) == ((PathString)other).path.charAt(((PathString)other).startIndex + i2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.computeHash();
        }
        return this.hash;
    }

    private final int computeHash() {
        int result = this.filesystemUri.hashCode();
        int n = this.prefixEndIndex;
        for (int i2 = 0; i2 < n; ++i2) {
            result = 31 * result + this.path.charAt(i2);
        }
        int hashCodeForSegment = 0;
        int n2 = this.suffixEndIndex;
        for (int i3 = this.startIndex; i3 < n2; ++i3) {
            char nextChar = this.path.charAt(i3);
            if (PathStringUtil.access$isSeparator(nextChar)) {
                result += hashCodeForSegment;
                hashCodeForSegment = 0;
            }
            hashCodeForSegment = 31 * hashCodeForSegment + nextChar;
        }
        return result += hashCodeForSegment;
    }

    @NotNull
    public final PathString normalize() {
        Object object;
        boolean absolute = this.isAbsolute();
        ArrayDeque<String> newNames = new ArrayDeque<String>();
        Iterable $this$forEach$iv = this.getSegments();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it, (Object)"..")) {
                String lastName = (String)newNames.peekLast();
                if (lastName != null && !Intrinsics.areEqual((Object)lastName, (Object)"..")) {
                    newNames.removeLast();
                    continue;
                }
                if (absolute) continue;
                newNames.add(it);
                continue;
            }
            if (Intrinsics.areEqual((Object)it, (Object)".")) continue;
            newNames.add(it);
        }
        if (this.hasTrailingSeparator()) {
            newNames.addLast("");
        }
        if ((object = this.getRoot()) == null || (object = ((PathString)object).getRawPath()) == null || (object = PathStringUtil.access$withSeparator((String)object, this.separator)) == null) {
            object = "";
        }
        Object rootString = object;
        return new PathString(this.filesystemUri, (String)rootString + CollectionsKt.joinToString$default((Iterable)newNames, (CharSequence)String.valueOf(this.separator), null, null, (int)0, null, null, (int)62, null));
    }

    @NotNull
    public final PathString withoutTrailingSeparator() {
        return this.hasTrailingSeparator() ? new PathString(this.filesystemUri, this.path, this.startIndex, this.getEndIndex(), this.prefixEndIndex, this.separator) : this;
    }

    @JvmName(name="hasTrailingSeparator")
    public final boolean hasTrailingSeparator() {
        return this.suffixEndIndex > this.startIndex && PathStringUtil.access$isSeparator(this.path.charAt(this.suffixEndIndex - 1));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PathString relativize(@NotNull PathString other) {
        Collection collection;
        int it3;
        int item$iv$iv;
        Iterable $this$mapTo$iv$iv;
        int n;
        List<String> otherSegments;
        List<String> segments;
        block21: {
            void $this$countUntil$iv;
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            if (this.isEmptyPath()) {
                return other;
            }
            if (this.isAbsolute() && other.isEmptyPath()) {
                return other;
            }
            PathString otherRoot = other.getRoot();
            if (!Intrinsics.areEqual((Object)this.getRoot(), (Object)otherRoot)) {
                Object convertedRootString;
                Object object;
                Object otherRootString;
                Object object2 = otherRoot;
                if (object2 == null || (object2 = ((PathString)object2).getRawPath()) == null) {
                    object2 = otherRootString = "";
                }
                if ((object = this.getRoot()) == null || (object = ((PathString)object).getRawPath()) == null || (object = PathStringUtil.access$withSeparator((String)object, other.separator)) == null) {
                    object = "";
                }
                if (!Intrinsics.areEqual((Object)otherRootString, (Object)(convertedRootString = object))) {
                    int n2;
                    int it2;
                    int n3;
                    int n4;
                    Object rootString;
                    block19: {
                        void $this$countUntil$iv2;
                        rootString = otherRootString;
                        IntProgression intProgression = RangesKt.reversed((IntProgression)((IntProgression)RangesKt.until((int)0, (int)this.prefixEndIndex)));
                        n4 = this.prefixEndIndex;
                        boolean $i$f$countUntil = false;
                        int result$iv = 0;
                        int item$iv = $this$countUntil$iv2.getFirst();
                        int n5 = $this$countUntil$iv2.getLast();
                        n3 = $this$countUntil$iv2.getStep();
                        if (n3 > 0 && item$iv <= n5 || n3 < 0 && n5 <= item$iv) {
                            while (true) {
                                it2 = item$iv;
                                boolean bl = false;
                                if (this.path.charAt(it2) == ':') {
                                    n2 = result$iv;
                                    break block19;
                                }
                                ++result$iv;
                                if (item$iv == n5) break;
                                item$iv += n3;
                            }
                        }
                        n2 = result$iv;
                    }
                    int n6 = n2;
                    int afterDriveSeparator = n4 - n6;
                    if (afterDriveSeparator > 0) {
                        int firstDifference;
                        block20: {
                            int n7;
                            void $this$countUntil$iv3;
                            IntProgression $i$f$countUntil = (IntProgression)RangesKt.until((int)0, (int)Math.min(afterDriveSeparator, other.prefixEndIndex));
                            boolean $i$f$countUntil2 = false;
                            int result$iv2 = 0;
                            int item$iv2 = $this$countUntil$iv3.getFirst();
                            n3 = $this$countUntil$iv3.getLast();
                            it2 = $this$countUntil$iv3.getStep();
                            if (it2 > 0 && item$iv2 <= n3 || it2 < 0 && n3 <= item$iv2) {
                                while (true) {
                                    int it3 = item$iv2;
                                    boolean bl = false;
                                    if (this.path.charAt(it3) != other.path.charAt(it3)) {
                                        n7 = result$iv2;
                                        break block20;
                                    }
                                    ++result$iv2;
                                    if (item$iv2 == n3) break;
                                    item$iv2 += it2;
                                }
                            }
                            n7 = firstDifference = result$iv2;
                        }
                        if (firstDifference >= afterDriveSeparator) {
                            String string = other.path.substring(afterDriveSeparator, other.prefixEndIndex);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                            rootString = string;
                        }
                    }
                    StringBuilder stringBuilder = new StringBuilder().append((String)rootString);
                    String string = other.path.substring(other.startIndex, other.suffixEndIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    return new PathString(this.filesystemUri, stringBuilder.append(string).toString(), ((String)rootString).length());
                }
            }
            segments = this.getSegments();
            otherSegments = other.getSegments();
            IntProgression afterDriveSeparator = (IntProgression)RangesKt.until((int)0, (int)Math.min(((Collection)segments).size(), ((Collection)otherSegments).size()));
            boolean $i$f$countUntil = false;
            int result$iv = 0;
            int item$iv = $this$countUntil$iv.getFirst();
            int result$iv2 = $this$countUntil$iv.getLast();
            int item$iv2 = $this$countUntil$iv.getStep();
            if (item$iv2 > 0 && item$iv <= result$iv2 || item$iv2 < 0 && result$iv2 <= item$iv) {
                while (true) {
                    int it4 = item$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)segments.get(it4), (Object)otherSegments.get(it4))) {
                        n = result$iv;
                        break block21;
                    }
                    ++result$iv;
                    if (item$iv == result$iv2) break;
                    item$iv += item$iv2;
                }
            }
            n = result$iv;
        }
        int commonPrefixLength = n;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)commonPrefixLength, (int)segments.size());
        boolean $i$f$map = false;
        Iterable item$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            it3 = item$iv$iv = ((IntIterator)iterator).nextInt();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add("..");
        }
        $this$map$iv = (Iterable)RangesKt.until((int)commonPrefixLength, (int)otherSegments.size());
        collection = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            it3 = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(otherSegments.get(it3));
        }
        List newSegments = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
        char newSeparator = PathStringUtil.access$chooseSeparator(other.separator, this.separator);
        String finalString = CollectionsKt.joinToString$default((Iterable)newSegments, (CharSequence)String.valueOf(newSeparator), null, null, (int)0, null, null, (int)62, null) + (other.hasTrailingSeparator() && !((Collection)newSegments).isEmpty() ? Character.valueOf(newSeparator) : "");
        return new PathString(this.filesystemUri, finalString, 0, finalString.length(), 0, this.separator);
    }

    @JvmName(name="isEmptyPath")
    public final boolean isEmptyPath() {
        return this.prefixEndIndex == 0 && this.startIndex == this.suffixEndIndex;
    }

    @NotNull
    public final PathString resolve(@NotNull String other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.resolve(new PathString(this.filesystemUri, other));
    }

    @NotNull
    public final PathString resolve(@NotNull PathString other) {
        String string;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        PathString otherRoot = other.getRoot();
        if (this.isEmptyPath()) {
            return other;
        }
        if (other.isAbsolute()) {
            if (otherRoot != null && otherRoot.prefixEndIndex == 1) {
                String string2;
                int indexOfDriveSeparator = StringsKt.lastIndexOf$default((CharSequence)this.path, (char)':', (int)this.prefixEndIndex, (boolean)false, (int)4, null);
                if (indexOfDriveSeparator > 0) {
                    StringBuilder stringBuilder = new StringBuilder();
                    String string3 = this.path.substring(0, indexOfDriveSeparator + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    string2 = stringBuilder.append(string3).append(other.getRawPath()).toString();
                } else {
                    string2 = other.getRawPath();
                }
                String newPath = string2;
                return new PathString(this.filesystemUri, newPath);
            }
            return other;
        }
        if (otherRoot != null && !this.compatibleRoots(this.getRoot(), otherRoot)) {
            return other;
        }
        if (other.isEmptyPath() || other.startIndex == other.suffixEndIndex) {
            return this;
        }
        String string4 = other.path.substring(other.startIndex, other.suffixEndIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        String otherRelPath = string4;
        if (this.separator == '\u0000') {
            if (this.startIndex == this.path.length()) {
                string = this.path + otherRelPath;
            } else {
                char newSeparator = PathStringUtil.access$chooseSeparator(other.separator, '\u0000');
                string = this.path + newSeparator + PathStringUtil.access$withSeparator(otherRelPath, newSeparator);
            }
        } else {
            string = this.startIndex < this.suffixEndIndex && !PathStringUtil.access$isSeparator(this.path.charAt(this.suffixEndIndex - 1)) ? this.getRawPath() + this.separator + PathStringUtil.access$withSeparator(otherRelPath, this.separator) : this.getRawPath() + PathStringUtil.access$withSeparator(otherRelPath, this.separator);
        }
        String newPath = string;
        return new PathString(this.filesystemUri, newPath);
    }

    @NotNull
    public final List<String> getSegments() {
        ArrayList<String> result = new ArrayList<String>();
        int lastSegment = 0;
        lastSegment = this.startIndex;
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)this.startIndex, (int)this.getEndIndex());
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            if (!PathStringUtil.access$isSeparator(this.path.charAt(it))) continue;
            String string = this.path.substring(lastSegment, it);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            result.add(string);
            lastSegment = it + 1;
        }
        if (lastSegment < this.getEndIndex()) {
            String string = this.path.substring(lastSegment, this.getEndIndex());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            result.add(string);
        }
        return result;
    }

    @Override
    public int compareTo(@NotNull PathString other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int schemeResult = this.filesystemUri.compareTo(other.filesystemUri);
        if (schemeResult != 0) {
            return schemeResult;
        }
        int otherPrefixEndIndex = other.prefixEndIndex;
        int n = Math.min(otherPrefixEndIndex, this.prefixEndIndex);
        for (int i2 = 0; i2 < n; ++i2) {
            int cmpResult = Intrinsics.compare((int)this.path.charAt(i2), (int)other.path.charAt(i2));
            if (cmpResult == 0) continue;
            return cmpResult;
        }
        if (otherPrefixEndIndex != this.prefixEndIndex) {
            return Intrinsics.compare((int)this.prefixEndIndex, (int)otherPrefixEndIndex);
        }
        int length = this.suffixEndIndex - this.startIndex;
        int otherLength = other.suffixEndIndex - other.startIndex;
        int min = Math.min(length, otherLength);
        for (int i3 = 0; i3 < min; ++i3) {
            int cmpResult = Intrinsics.compare((int)this.path.charAt(this.startIndex + i3), (int)other.path.charAt(other.startIndex + i3));
            if (cmpResult == 0) continue;
            return cmpResult;
        }
        return Intrinsics.compare((int)length, (int)otherLength);
    }

    private final boolean sameRootAs(PathString other) {
        if (!Intrinsics.areEqual((Object)this.filesystemUri, (Object)other.filesystemUri)) {
            return false;
        }
        if (this.prefixEndIndex != other.prefixEndIndex) {
            return false;
        }
        int n = this.prefixEndIndex;
        for (int idx = 0; idx < n; ++idx) {
            if (this.path.charAt(idx) == other.path.charAt(idx) || PathStringUtil.access$isSeparator(this.path.charAt(idx)) && PathStringUtil.access$isSeparator(other.path.charAt(idx))) continue;
            return false;
        }
        return true;
    }

    private final boolean compatibleRoots(PathString root1, PathString root2) {
        if (Intrinsics.areEqual((Object)root1, (Object)root2)) {
            return true;
        }
        if (root1 == null || root2 == null) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.driveName(root1.getRawPath()), (Object)this.driveName(root2.getRawPath()));
    }

    private final String driveName(String rawPath) {
        String string = rawPath.substring(0, PathStringUtil.countUntil$default(rawPath, ':', 0, false, 6, null));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String string2 = string.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private final PathString subRangeOrNull(int index, int length) {
        int n;
        int lengthCount;
        int subRangeStart;
        int n2;
        int n3;
        block14: {
            void $this$countUntil$iv;
            int n4;
            block13: {
                void $this$countUntil$iv2;
                if (index < 0 || length < 0) {
                    return null;
                }
                if (length == 0) {
                    return new PathString(this.filesystemUri, "");
                }
                int separatorCount = 0;
                IntProgression intProgression = (IntProgression)RangesKt.until((int)this.startIndex, (int)this.getEndIndex());
                n3 = this.startIndex;
                boolean $i$f$countUntil = false;
                int result$iv = 0;
                int item$iv = $this$countUntil$iv2.getFirst();
                int n5 = $this$countUntil$iv2.getLast();
                int n6 = $this$countUntil$iv2.getStep();
                if (n6 > 0 && item$iv <= n5 || n6 < 0 && n5 <= item$iv) {
                    while (true) {
                        int it = item$iv;
                        boolean bl = false;
                        if (PathStringUtil.access$isSeparator(this.path.charAt(it))) {
                            ++separatorCount;
                        }
                        if (separatorCount >= index) {
                            n4 = result$iv;
                            break block13;
                        }
                        ++result$iv;
                        if (item$iv == n5) break;
                        item$iv += n6;
                    }
                }
                n4 = result$iv;
            }
            n2 = n4;
            subRangeStart = n3 + n2;
            if (subRangeStart >= this.getEndIndex() - 1) {
                return null;
            }
            if (PathStringUtil.access$isSeparator(this.path.charAt(subRangeStart))) {
                ++subRangeStart;
            }
            lengthCount = 0;
            IntProgression result$iv = (IntProgression)RangesKt.until((int)subRangeStart, (int)this.getEndIndex());
            n3 = subRangeStart;
            boolean $i$f$countUntil = false;
            int result$iv2 = 0;
            int item$iv = $this$countUntil$iv.getFirst();
            int n7 = $this$countUntil$iv.getLast();
            int n8 = $this$countUntil$iv.getStep();
            if (n8 > 0 && item$iv <= n7 || n8 < 0 && n7 <= item$iv) {
                while (true) {
                    int it = item$iv;
                    boolean bl = false;
                    if (PathStringUtil.access$isSeparator(this.path.charAt(it))) {
                        ++lengthCount;
                    }
                    if (lengthCount >= length) {
                        n = result$iv2;
                        break block14;
                    }
                    ++result$iv2;
                    if (item$iv == n7) break;
                    item$iv += n8;
                }
            }
            n = result$iv2;
        }
        n2 = n;
        int subRangeEnd = n3 + n2;
        if (lengthCount < length - 1) {
            return null;
        }
        return new PathString(this.filesystemUri, this.path, subRangeStart, subRangeEnd, 0, this.separator);
    }

    static /* synthetic */ PathString subRangeOrNull$default(PathString pathString, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 1;
        }
        return pathString.subRangeOrNull(n, n2);
    }

    private final PathString subRange(int index, int length) {
        PathString pathString = this.subRangeOrNull(index, length);
        if (pathString == null) {
            throw new IllegalArgumentException("beginIndex " + index + " and suffixEndIndex " + (index + length) + " are out of range for path " + this);
        }
        return pathString;
    }

    static /* synthetic */ PathString subRange$default(PathString pathString, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 1;
        }
        return pathString.subRange(n, n2);
    }

    private final int getEndIndex() {
        return this.hasTrailingSeparator() ? this.suffixEndIndex - 1 : this.suffixEndIndex;
    }

    /*
     * WARNING - void declaration
     */
    private final int computeNameStart(int end) {
        int n;
        int n2;
        block3: {
            void $this$countUntil$iv;
            IntProgression intProgression = RangesKt.reversed((IntProgression)((IntProgression)RangesKt.until((int)this.startIndex, (int)end)));
            n2 = end;
            boolean $i$f$countUntil = false;
            int result$iv = 0;
            int item$iv = $this$countUntil$iv.getFirst();
            int n3 = $this$countUntil$iv.getLast();
            int n4 = $this$countUntil$iv.getStep();
            if (n4 > 0 && item$iv <= n3 || n4 < 0 && n3 <= item$iv) {
                while (true) {
                    int it = item$iv;
                    boolean bl = false;
                    if (PathStringUtil.access$isSeparator(this.path.charAt(it))) {
                        n = result$iv;
                        break block3;
                    }
                    ++result$iv;
                    if (item$iv == n3) break;
                    item$iv += n4;
                }
            }
            n = result$iv;
        }
        int n5 = n;
        return n2 - n5;
    }
}

