/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.fonts;

import com.android.ide.common.fonts.FontFamily;
import com.android.ide.common.fonts.FontType;
import com.android.ide.common.fonts.MutableFontDetail;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0013\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0000\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\nJ\u0006\u0010*\u001a\u00020\u0005J\u0006\u0010+\u001a\u00020!J\u0006\u0010,\u001a\u00020!J\b\u0010-\u001a\u00020\u0013H\u0016J\u0013\u0010.\u001a\u00020\u001d2\b\u0010/\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0010\u00100\u001a\u00020!2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u00101\u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u00102\u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u0017H\u0002J\f\u00103\u001a\u00020!*\u00020\u0017H\u0002R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010#R\u0011\u0010&\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u001fR\u0011\u0010(\u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010#\u00a8\u00064"}, d2={"Lcom/android/ide/common/fonts/FontDetail;", "", "fontFamily", "Lcom/android/ide/common/fonts/FontFamily;", "font", "Lcom/android/ide/common/fonts/MutableFontDetail;", "<init>", "(Lcom/android/ide/common/fonts/FontFamily;Lcom/android/ide/common/fonts/MutableFontDetail;)V", "detail", "withStyle", "(Lcom/android/ide/common/fonts/FontDetail;Lcom/android/ide/common/fonts/MutableFontDetail;)V", "family", "getFamily", "()Lcom/android/ide/common/fonts/FontFamily;", "type", "Lcom/android/ide/common/fonts/FontType;", "getType", "()Lcom/android/ide/common/fonts/FontType;", "weight", "", "getWeight", "()I", "width", "", "getWidth", "()F", "italics", "getItalics", "exact", "", "getExact", "()Z", "fontUrl", "", "getFontUrl", "()Ljava/lang/String;", "styleName", "getStyleName", "hasExplicitStyle", "getHasExplicitStyle", "fontStyle", "getFontStyle", "toMutableFontDetail", "generateQueryV12", "generateQueryV11", "hashCode", "equals", "other", "generateStyleName", "getWeightStyleName", "getItalicStyleNameSuffix", "floatAsString", "android.sdktools.sdk-common"})
public final class FontDetail {
    @NotNull
    private final FontFamily family;
    @NotNull
    private final FontType type;
    private final int weight;
    private final float width;
    private final float italics;
    private final boolean exact;
    @NotNull
    private final String fontUrl;
    @NotNull
    private final String styleName;
    private final boolean hasExplicitStyle;

    @NotNull
    public final FontFamily getFamily() {
        return this.family;
    }

    @NotNull
    public final FontType getType() {
        return this.type;
    }

    public final int getWeight() {
        return this.weight;
    }

    public final float getWidth() {
        return this.width;
    }

    public final float getItalics() {
        return this.italics;
    }

    public final boolean getExact() {
        return this.exact;
    }

    @NotNull
    public final String getFontUrl() {
        return this.fontUrl;
    }

    @NotNull
    public final String getStyleName() {
        return this.styleName;
    }

    public final boolean getHasExplicitStyle() {
        return this.hasExplicitStyle;
    }

    @NotNull
    public final String getFontStyle() {
        return !(this.italics == 0.0f) ? "italic" : "normal";
    }

    public FontDetail(@NotNull FontFamily fontFamily, @NotNull MutableFontDetail font) {
        Intrinsics.checkNotNullParameter((Object)fontFamily, (String)"fontFamily");
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        this.family = fontFamily;
        this.type = font.getType();
        this.weight = font.getWeight();
        this.width = font.getWidth();
        this.italics = font.getItalics();
        this.exact = font.getExact();
        this.fontUrl = font.getFontUrl();
        this.hasExplicitStyle = font.getHasExplicitStyle();
        this.styleName = this.generateStyleName(font);
    }

    public FontDetail(@NotNull FontDetail detail, @NotNull MutableFontDetail withStyle) {
        Intrinsics.checkNotNullParameter((Object)detail, (String)"detail");
        Intrinsics.checkNotNullParameter((Object)withStyle, (String)"withStyle");
        this.family = detail.family;
        this.type = withStyle.getType();
        this.weight = withStyle.getWeight();
        this.width = withStyle.getWidth();
        this.italics = withStyle.getItalics();
        this.exact = withStyle.getExact();
        this.fontUrl = detail.fontUrl;
        this.hasExplicitStyle = detail.hasExplicitStyle;
        this.styleName = this.generateStyleName(withStyle);
    }

    @NotNull
    public final MutableFontDetail toMutableFontDetail() {
        return new MutableFontDetail(this.family.getName(), this.type, this.weight, this.width, this.italics, this.exact, this.fontUrl, this.styleName, this.hasExplicitStyle);
    }

    @NotNull
    public final String generateQueryV12() {
        StringBuilder query = new StringBuilder().append(this.family.getName());
        if (this.type == FontType.VARIABLE) {
            query.append(":vf");
            if (!(this.italics == 0.0f)) {
                query.append(":italic");
            }
            String string = query.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        if (this.weight != 400) {
            query.append(":wght").append(this.weight);
        }
        if (!(this.italics == 0.0f)) {
            query.append(":ital").append(this.floatAsString(this.italics));
        }
        if (!(this.width == 100.0f)) {
            query.append(":wdth").append(this.floatAsString(this.width));
        }
        if (!this.exact) {
            query.append(":nearest");
        }
        String string = query.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String generateQueryV11() {
        if (this.weight == 400 && this.width == 100.0f && this.italics == 0.0f && this.exact) {
            return this.family.getName();
        }
        StringBuilder query = new StringBuilder().append("name=").append(this.family.getName());
        if (this.weight != 400) {
            query.append("&weight=").append(this.weight);
        }
        if (!(this.italics == 0.0f)) {
            query.append("&italic=").append(this.floatAsString(this.italics));
        }
        if (!(this.width == 100.0f)) {
            query.append("&width=").append(this.floatAsString(this.width));
        }
        if (!this.exact) {
            query.append("&besteffort=true");
        }
        String string = query.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.weight, Float.valueOf(this.width), Float.valueOf(this.italics)};
        return Objects.hash(objectArray);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof FontDetail && this.weight == ((FontDetail)other).weight && this.width == ((FontDetail)other).width && this.italics == ((FontDetail)other).italics;
    }

    private final String generateStyleName(MutableFontDetail font) {
        if (((CharSequence)font.getStyleName()).length() > 0) {
            return font.getStyleName();
        }
        return this.getWeightStyleName(font.getWeight()) + this.getItalicStyleNameSuffix(font.getItalics());
    }

    private final String getWeightStyleName(int weight) {
        switch (weight) {
            case 100: {
                return "Thin";
            }
            case 200: {
                return "Extra-Light";
            }
            case 300: {
                return "Light";
            }
            case 400: {
                return "Regular";
            }
            case 500: {
                return "Medium";
            }
            case 600: {
                return "Semi-Bold";
            }
            case 700: {
                return "Bold";
            }
            case 800: {
                return "Extra-Bold";
            }
            case 900: {
                return "Black";
            }
        }
        return weight > 400 ? "Custom-Bold" : "Custom-Light";
    }

    private final String getItalicStyleNameSuffix(float italics) {
        return !(italics == 0.0f) ? " Italic" : "";
    }

    private final String floatAsString(float $this$floatAsString) {
        Locale locale = Locale.ROOT;
        String string = !($this$floatAsString % 1.0f == 0.0f) ? "%s" : "%.0f";
        Object[] objectArray = new Object[]{Float.valueOf($this$floatAsString)};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }
}

