/*
 * Decompiled with CFR 0.152.
 */
package shark.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import shark.internal.ObjectDominators;
import shark.internal.hppc.LongLongScatterMap;
import shark.internal.hppc.LongScatterSet;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0016B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00030\fJ@\u0010\r\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000e0\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u00102\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00030\fJ\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\tJ\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lshark/internal/DominatorTree;", "", "expectedElements", "", "(I)V", "dominated", "Lshark/internal/hppc/LongLongScatterMap;", "buildFullDominatorTree", "", "", "Lshark/internal/ObjectDominators$DominatorNode;", "computeSize", "Lkotlin/Function1;", "computeRetainedSizes", "Lkotlin/Pair;", "retainedObjectIds", "", "updateDominated", "", "objectId", "parentObjectId", "updateDominatedAsRoot", "MutableDominatorNode", "shark"})
public final class DominatorTree {
    private final LongLongScatterMap dominated;

    public final boolean updateDominatedAsRoot(long objectId) {
        return this.updateDominated(objectId, 0L);
    }

    public final boolean updateDominated(long objectId, long parentObjectId) {
        boolean hasDominator;
        int dominatedSlot = this.dominated.getSlot(objectId);
        boolean bl = hasDominator = dominatedSlot != -1;
        if (!hasDominator || parentObjectId == 0L) {
            this.dominated.set(objectId, parentObjectId);
        } else {
            long currentDominator = this.dominated.getSlotValue(dominatedSlot);
            if (currentDominator != 0L) {
                int nextDominatorSlot;
                LongScatterSet currentDominators = new LongScatterSet(0, 1, null);
                long dominator = currentDominator;
                while (dominator != 0L) {
                    currentDominators.add(dominator);
                    nextDominatorSlot = this.dominated.getSlot(dominator);
                    if (nextDominatorSlot == -1) {
                        throw (Throwable)new IllegalStateException("Did not find dominator for " + dominator + " when going through the dominator chain for " + currentDominator + ": " + currentDominators);
                    }
                    dominator = this.dominated.getSlotValue(nextDominatorSlot);
                }
                dominator = parentObjectId;
                while (dominator != 0L && !currentDominators.contains(dominator)) {
                    nextDominatorSlot = this.dominated.getSlot(dominator);
                    if (nextDominatorSlot == -1) {
                        throw (Throwable)new IllegalStateException("Did not find dominator for " + dominator + " when going through the dominator chain for " + parentObjectId);
                    }
                    dominator = this.dominated.getSlotValue(nextDominatorSlot);
                }
                this.dominated.set(objectId, dominator);
            }
        }
        return hasDominator;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Long, ObjectDominators.DominatorNode> buildFullDominatorTree(@NotNull Function1<? super Long, Integer> computeSize) {
        void $this$mapValuesTo$iv$iv;
        Object object;
        Object object2;
        Collection<Integer> collection;
        Object $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object object3;
        Iterator $dstr$objectId$node;
        Intrinsics.checkParameterIsNotNull(computeSize, (String)"computeSize");
        boolean bl = false;
        Map dominators = new LinkedHashMap();
        this.dominated.forEach(new LongLongScatterMap.ForEachCallback(dominators){
            final /* synthetic */ Map $dominators;

            public final void onEntry(long key, long value) {
                Object object;
                Map $this$getOrPut$iv;
                Object object2 = this.$dominators;
                Long key$iv = key;
                boolean $i$f$getOrPut = false;
                V value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    MutableDominatorNode answer$iv = new MutableDominatorNode();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                }
                $this$getOrPut$iv = this.$dominators;
                key$iv = value;
                $i$f$getOrPut = false;
                value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    MutableDominatorNode answer$iv = new MutableDominatorNode();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                object2 = ((MutableDominatorNode)object).getDominated();
                Long l = key;
                boolean bl = false;
                object2.add(l);
            }
            {
                this.$dominators = map;
            }
        });
        Set allReachableObjectIds = SetsKt.minus((Set)CollectionsKt.toSet((Iterable)dominators.keySet()), (Object)0L);
        Map<Long, Pair<Integer, Integer>> retainedSizes2 = this.computeRetainedSizes(allReachableObjectIds, (Function1<? super Long, Integer>)((Function1)new Function1<Long, Integer>(computeSize, dominators){
            final /* synthetic */ Function1 $computeSize;
            final /* synthetic */ Map $dominators;

            /*
             * WARNING - void declaration
             */
            public final int invoke(long objectId) {
                void var3_2;
                int shallowSize = ((Number)this.$computeSize.invoke((Object)objectId)).intValue();
                ((MutableDominatorNode)MapsKt.getValue((Map)this.$dominators, (Object)objectId)).setShallowSize(shallowSize);
                return (int)var3_2;
            }
            {
                this.$computeSize = function1;
                this.$dominators = map;
                super(1);
            }
        }));
        Map $this$forEach$iv = dominators;
        boolean $i$f$forEach22 = false;
        Map map = $this$forEach$iv;
        boolean bl2 = false;
        for (Map.Entry element$iv : map.entrySet()) {
            void retainedSize;
            void objectId;
            $dstr$objectId$node = element$iv;
            boolean bl3 = false;
            Map.Entry entry = $dstr$objectId$node;
            boolean bl4 = false;
            long l = ((Number)entry.getKey()).longValue();
            entry = $dstr$objectId$node;
            bl4 = false;
            MutableDominatorNode node = (MutableDominatorNode)entry.getValue();
            if (objectId == 0L) continue;
            object3 = (Pair)MapsKt.getValue(retainedSizes2, (Object)((long)objectId));
            int n = ((Number)object3.component1()).intValue();
            int retainedCount = ((Number)object3.component2()).intValue();
            node.setRetainedSize((int)retainedSize);
            node.setRetainedCount(retainedCount);
        }
        MutableDominatorNode rootDominator = (MutableDominatorNode)MapsKt.getValue((Map)dominators, (Object)0L);
        Iterable $i$f$forEach22 = rootDominator.getDominated();
        Object object4 = rootDominator;
        boolean $i$f$map = false;
        void var8_12 = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        $dstr$objectId$node = $this$mapTo$iv$iv.iterator();
        while ($dstr$objectId$node.hasNext()) {
            void it;
            Object item$iv$iv = $dstr$objectId$node.next();
            long retainedSize = ((Number)item$iv$iv).longValue();
            collection = destination$iv$iv;
            boolean bl5 = false;
            Object v = dominators.get((long)it);
            if (v == null) {
                Intrinsics.throwNpe();
            }
            object2 = ((MutableDominatorNode)v).getRetainedSize();
            collection.add((Integer)object2);
        }
        collection = (List)destination$iv$iv;
        ((MutableDominatorNode)object4).setRetainedSize(CollectionsKt.sumOfInt((Iterable)collection));
        $this$map$iv = rootDominator.getDominated();
        object4 = rootDominator;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        $dstr$objectId$node = $this$mapTo$iv$iv.iterator();
        while ($dstr$objectId$node.hasNext()) {
            Object item$iv$iv = $dstr$objectId$node.next();
            long it = ((Number)item$iv$iv).longValue();
            collection = destination$iv$iv;
            boolean bl6 = false;
            Object v = dominators.get(it);
            if (v == null) {
                Intrinsics.throwNpe();
            }
            object2 = ((MutableDominatorNode)v).getRetainedCount();
            collection.add((Integer)object2);
        }
        collection = (List)destination$iv$iv;
        ((MutableDominatorNode)object4).setRetainedCount(CollectionsKt.sumOfInt((Iterable)collection));
        Iterable $this$forEach$iv2 = dominators.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv2) {
            MutableDominatorNode node = (MutableDominatorNode)element$iv;
            boolean bl7 = false;
            List<Long> $this$sortBy$iv = node.getDominated();
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() <= 1) continue;
            List<Long> retainedCount = $this$sortBy$iv;
            boolean bl6 = false;
            object = new Comparator<T>(dominators){
                final /* synthetic */ Map $dominators$inlined;
                {
                    this.$dominators$inlined = map;
                }

                public final int compare(T a, T b) {
                    boolean bl = false;
                    long it = ((Number)a).longValue();
                    boolean bl2 = false;
                    Comparable comparable = Integer.valueOf(-((MutableDominatorNode)MapsKt.getValue((Map)this.$dominators$inlined, (Object)it)).getRetainedSize());
                    it = ((Number)b).longValue();
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Integer n = -((MutableDominatorNode)MapsKt.getValue((Map)this.$dominators$inlined, (Object)it)).getRetainedSize();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            };
            CollectionsKt.sortWith(retainedCount, (Comparator)object);
        }
        Map $this$mapValues$iv = dominators;
        boolean $i$f$mapValues = false;
        $this$mapTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $dstr$_u24__u24$node;
            void it$iv$iv;
            Map.Entry bl6 = (Map.Entry)element$iv$iv$iv;
            object = destination$iv$iv;
            boolean bl8 = false;
            object3 = it$iv$iv.getKey();
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            collection = object3;
            object4 = object;
            boolean bl9 = false;
            void var21_50 = $dstr$_u24__u24$node;
            boolean bl10 = false;
            MutableDominatorNode node = (MutableDominatorNode)var21_50.getValue();
            object2 = new ObjectDominators.DominatorNode(node.getShallowSize(), node.getRetainedSize(), node.getRetainedCount(), node.getDominated());
            object4.put(collection, object2);
        }
        return destination$iv$iv;
    }

    @NotNull
    public final Map<Long, Pair<Integer, Integer>> computeRetainedSizes(@NotNull Set<Long> retainedObjectIds, @NotNull Function1<? super Long, Integer> computeSize) {
        Intrinsics.checkParameterIsNotNull(retainedObjectIds, (String)"retainedObjectIds");
        Intrinsics.checkParameterIsNotNull(computeSize, (String)"computeSize");
        boolean bl = false;
        Map nodeRetainedSizes = new LinkedHashMap();
        Iterable $this$forEach$iv = retainedObjectIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            long objectId = ((Number)element$iv).longValue();
            boolean bl2 = false;
            nodeRetainedSizes.put(objectId, TuplesKt.to((Object)0, (Object)0));
        }
        this.dominated.forEach(new LongLongScatterMap.ForEachCallback(this, nodeRetainedSizes, computeSize){
            final /* synthetic */ DominatorTree this$0;
            final /* synthetic */ Map $nodeRetainedSizes;
            final /* synthetic */ Function1 $computeSize;

            /*
             * WARNING - void declaration
             */
            public void onEntry(long key, long value) {
                int instanceSize = -1;
                Pair pair = (Pair)this.$nodeRetainedSizes.get(key);
                if (pair != null) {
                    void currentRetainedSize;
                    Pair pair2 = pair;
                    boolean bl = false;
                    boolean bl2 = false;
                    Pair $dstr$currentRetainedSize$currentRetainedCount = pair2;
                    boolean bl3 = false;
                    int n = ((Number)$dstr$currentRetainedSize$currentRetainedCount.component1()).intValue();
                    int currentRetainedCount = ((Number)$dstr$currentRetainedSize$currentRetainedCount.component2()).intValue();
                    instanceSize = ((Number)this.$computeSize.invoke((Object)key)).intValue();
                    this.$nodeRetainedSizes.put(key, TuplesKt.to((Object)((int)(currentRetainedSize + instanceSize)), (Object)(currentRetainedCount + 1)));
                }
                if (value != 0L) {
                    long dominator = value;
                    List dominatedByNextNode = CollectionsKt.mutableListOf((Object[])new Long[]{key});
                    while (dominator != 0L) {
                        if (this.$nodeRetainedSizes.containsKey(dominator)) {
                            void currentRetainedSize;
                            Iterable $this$forEach$iv22 = dominatedByNextNode;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv22) {
                                long objectId = ((Number)element$iv).longValue();
                                boolean bl = false;
                                DominatorTree.access$getDominated$p(this.this$0).set(objectId, dominator);
                            }
                            if (instanceSize == -1) {
                                instanceSize = ((Number)this.$computeSize.invoke((Object)key)).intValue();
                            }
                            Pair pair3 = (Pair)MapsKt.getValue((Map)this.$nodeRetainedSizes, (Object)dominator);
                            int $this$forEach$iv22 = ((Number)pair3.component1()).intValue();
                            int currentRetainedCount = ((Number)pair3.component2()).intValue();
                            this.$nodeRetainedSizes.put(dominator, TuplesKt.to((Object)((int)(currentRetainedSize + instanceSize)), (Object)(currentRetainedCount + 1)));
                            dominatedByNextNode.clear();
                        } else {
                            Collection currentRetainedSize = dominatedByNextNode;
                            Long currentRetainedCount = dominator;
                            boolean bl = false;
                            currentRetainedSize.add(currentRetainedCount);
                        }
                        dominator = DominatorTree.access$getDominated$p(this.this$0).get(dominator);
                    }
                    Iterable $this$forEach$iv = dominatedByNextNode;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        long objectId = ((Number)element$iv).longValue();
                        boolean bl = false;
                        DominatorTree.access$getDominated$p(this.this$0).set(objectId, 0L);
                    }
                }
            }
            {
                this.this$0 = this$0;
                this.$nodeRetainedSizes = $captured_local_variable$1;
                this.$computeSize = $captured_local_variable$2;
            }
        });
        this.dominated.release();
        return nodeRetainedSizes;
    }

    public DominatorTree(int expectedElements) {
        this.dominated = new LongLongScatterMap(expectedElements);
    }

    public /* synthetic */ DominatorTree(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 4;
        }
        this(n);
    }

    public DominatorTree() {
        this(0, 1, null);
    }

    public static final /* synthetic */ LongLongScatterMap access$getDominated$p(DominatorTree $this) {
        return $this.dominated;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001a\u0010\u0011\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\r\u00a8\u0006\u0014"}, d2={"Lshark/internal/DominatorTree$MutableDominatorNode;", "", "()V", "dominated", "", "", "getDominated", "()Ljava/util/List;", "retainedCount", "", "getRetainedCount", "()I", "setRetainedCount", "(I)V", "retainedSize", "getRetainedSize", "setRetainedSize", "shallowSize", "getShallowSize", "setShallowSize", "shark"})
    private static final class MutableDominatorNode {
        private int shallowSize;
        private int retainedSize;
        private int retainedCount;
        @NotNull
        private final List<Long> dominated;

        public final int getShallowSize() {
            return this.shallowSize;
        }

        public final void setShallowSize(int n) {
            this.shallowSize = n;
        }

        public final int getRetainedSize() {
            return this.retainedSize;
        }

        public final void setRetainedSize(int n) {
            this.retainedSize = n;
        }

        public final int getRetainedCount() {
            return this.retainedCount;
        }

        public final void setRetainedCount(int n) {
            this.retainedCount = n;
        }

        @NotNull
        public final List<Long> getDominated() {
            return this.dominated;
        }

        public MutableDominatorNode() {
            boolean bl = false;
            this.dominated = new ArrayList();
        }
    }
}

