/*
 * Decompiled with CFR 0.152.
 */
package com.google.targetsdkversionassistant.plan;

import com.google.targetsdkversionassistant.dsl.ElementListBuilder;
import com.google.targetsdkversionassistant.dsl.Ordering;
import com.google.targetsdkversionassistant.dsl.Par;
import com.google.targetsdkversionassistant.dsl.Seq;
import com.google.targetsdkversionassistant.plan.Api33;
import com.google.targetsdkversionassistant.plan.ApiUtils;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/google/targetsdkversionassistant/plan/Api34;", "", "<init>", "()V", "label", "", "getLabel", "()Ljava/lang/String;", "description", "getDescription", "steps", "Lcom/google/targetsdkversionassistant/dsl/Seq;", "getSteps", "()Lcom/google/targetsdkversionassistant/dsl/Seq;", "targetsdkversion-upgrade-assistant"})
public final class Api34 {
    @NotNull
    public static final Api34 INSTANCE = new Api34();
    @NotNull
    private static final String label = ApiUtils.INSTANCE.rarrow$targetsdkversion_upgrade_assistant("Android 13 / API level 33", "Android 14 / API level 34");
    @NotNull
    private static final String description = StringsKt.trimIndent((String)("\n    Here are the major steps required to migrate from Android 13 (API level 33) to Android 14 (API level 34).\n    " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n    For the complete list of changes introduced in Android 14 (API level 34), see the\n    " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Android 14 behavior changes", "https://developer.android.com/about/versions/14/behavior-changes-14") + ".\n  "));
    @NotNull
    private static final Seq steps = Ordering.Companion.seq((Function1<? super Seq, Unit>)((Function1)Api34::steps$lambda$0));

    private Api34() {
    }

    @NotNull
    public final String getLabel() {
        return label;
    }

    @NotNull
    public final String getDescription() {
        return description;
    }

    @NotNull
    public final Seq getSteps() {
        return steps;
    }

    private static final Unit steps$lambda$0(Seq $this$seq) {
        Intrinsics.checkNotNullParameter((Object)$this$seq, (String)"$this$seq");
        $this$seq.par((Function1<? super Par, Unit>)((Function1)Api34::steps$lambda$0$0));
        $this$seq.raw("Remember to check for other changes", (Function1<? super ElementListBuilder, Unit>)((Function1)Api34::steps$lambda$0$1));
        $this$seq.raw("Update the SDK version", (Function1<? super ElementListBuilder, Unit>)((Function1)Api34::steps$lambda$0$2));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$0$0(Par $this$par) {
        Intrinsics.checkNotNullParameter((Object)$this$par, (String)"$this$par");
        $this$par.raw("Reminder: Schedule exact alarms are denied by default", (Function1<? super ElementListBuilder, Unit>)((Function1)Api34::steps$lambda$0$0$0));
        $this$par.filtered("Foreground service types are required", "foregroundServiceTypeMissing", (Function1<? super ElementListBuilder, Unit>)((Function1)Api34::steps$lambda$0$0$1));
        $this$par.seq((Function1<? super Seq, Unit>)((Function1)Api34::steps$lambda$0$0$2));
        $this$par.raw("Restrictions to implicit and pending intents", (Function1<? super ElementListBuilder, Unit>)((Function1)Api34::steps$lambda$0$0$3));
        $this$par.raw("Runtime-registered broadcasts receivers must specify export behavior", (Function1<? super ElementListBuilder, Unit>)((Function1)Api34::steps$lambda$0$0$4));
        $this$par.raw("Safer dynamic code loading", (Function1<? super ElementListBuilder, Unit>)((Function1)Api34::steps$lambda$0$0$5));
        $this$par.filtered("Zip path traversal", "zipPathTraversal", (Function1<? super ElementListBuilder, Unit>)((Function1)Api34::steps$lambda$0$0$6));
        $this$par.raw("Additional restrictions on starting activities from the background", (Function1<? super ElementListBuilder, Unit>)((Function1)Api34::steps$lambda$0$0$7));
        $this$par.raw("Grant partial access to photos and videos", (Function1<? super ElementListBuilder, Unit>)((Function1)Api34::steps$lambda$0$0$8));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$0$0$0(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        $this$raw.text(StringsKt.trimIndent((String)("\n            With the launch of Android 14, apps targeting Android 13 (API level 33) or higher\n            have new restrictions on using " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("SCHEDULE_EXACT_ALARM") + ".\n            " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n            If you had already upgraded your app to API level 33 before Android 14 then\n            please go back to the " + Api33.INSTANCE.getLabel() + " sequence and find this new upgrade step.\n            " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n            If you have already completed that migration step as part of the upgrade to API level 33\n            then there is nothing extra to do as part of the upgrade to API level 34.\n            " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n            For more information, see " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Schedule exact alarms are denied by default", "https://developer.android.com/about/versions/14/changes/schedule-exact-alarms") + ".\n          ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$0$0$1(ElementListBuilder $this$filtered) {
        Intrinsics.checkNotNullParameter((Object)$this$filtered, (String)"$this$filtered");
        $this$filtered.text(StringsKt.trimIndent((String)("\n            If your app targets Android 14, it must\n            " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("specify at least one foreground service type", "https://developer.android.com/about/versions/14/changes/fgs-types-required") + "\n            for each foreground service within your app.\n            You should choose a foreground service type that represents your app's use case.\n            The system expects foreground services that have a particular type to satisfy a particular use case.\n            " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n            Note: Android 14 introduces foreground service types for\n            " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("health", "https://developer.android.com/about/versions/14/changes/fgs-types-required#health") + "\n            and\n            " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("remote messaging", "https://developer.android.com/about/versions/14/changes/fgs-types-required#remote-messaging") + "\n            use cases. The system also reserves new types for\n            " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("short services", "https://developer.android.com/about/versions/14/changes/fgs-types-required#short-service") + ",\n            " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("special use cases", "https://developer.android.com/about/versions/14/changes/fgs-types-required#special-use") + ", and\n            " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("system exemptions", "https://developer.android.com/about/versions/14/changes/fgs-types-required#system-exempted") + ".\n            " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n            If a use case in your app isn't associated with any of these types,\n            it's strongly recommended that you migrate your logic to use\n            " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("WorkManager", "https://developer.android.com/topic/libraries/architecture/workmanager") + " or\n            " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("user-initiated data transfer jobs", "https://developer.android.com/about/versions/14/changes/user-initiated-data-transfers") + ".\n          ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$0$0$2(Seq $this$seq) {
        Intrinsics.checkNotNullParameter((Object)$this$seq, (String)"$this$seq");
        $this$seq.raw("OpenJDK 17 updates", (Function1<? super ElementListBuilder, Unit>)((Function1)Api34::steps$lambda$0$0$2$0));
        $this$seq.par((Function1<? super Par, Unit>)((Function1)Api34::steps$lambda$0$0$2$1));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$0$0$2$0(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        $this$raw.text(StringsKt.trimIndent((String)("\n              Android 14 continues the work of refreshing Android's core libraries\n              to align with the features in the latest OpenJDK LTS releases,\n              including both library updates and Java 17 language support for app and platform developers.\n              " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n              A few of these changes can affect app compatibility.\n            ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$0$0$2$1(Par $this$par) {
        Intrinsics.checkNotNullParameter((Object)$this$par, (String)"$this$par");
        $this$par.raw("OpenJDK 17 updates: Changes to regular expressions", (Function1<? super ElementListBuilder, Unit>)((Function1)Api34::steps$lambda$0$0$2$1$0));
        $this$par.filtered("OpenJDK 17 updates: UUID handling", "openJdk17ChangesUUID", (Function1<? super ElementListBuilder, Unit>)((Function1)Api34::steps$lambda$0$0$2$1$1));
        $this$par.raw("OpenJDK 17 updates: ProGuard issues", (Function1<? super ElementListBuilder, Unit>)((Function1)Api34::steps$lambda$0$0$2$1$2));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$0$0$2$1$0(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        $this$raw.text(StringsKt.trimIndent((String)("\n              Invalid group references are no longer allowed, to more closely follow the semantics of OpenJDK.\n              You might see new cases where an " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("IllegalArgumentException") + " is thrown by the\n              " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("java.util.regex.Matcher"), "https://developer.android.com/reference/java/util/regex/Matcher") + " class,\n              so make sure to test your app for areas that use regular expressions.\n              To enable or disable this change while testing,\n              toggle the " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("DISALLOW_INVALID_GROUP_REFERENCE") + " flag using the\n              " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("compatibility framework tools", "https://developer.android.com/guide/app-compatibility/test-debug#toggle-dev-options") + ".\n            ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$0$0$2$1$1(ElementListBuilder $this$filtered) {
        Intrinsics.checkNotNullParameter((Object)$this$filtered, (String)"$this$filtered");
        $this$filtered.text(StringsKt.trimIndent((String)("\n              The\n              " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("java.util.UUID.fromString()"), "https://developer.android.com/reference/java/util/UUID#fromString(java.lang.String)") + " method now does more strict checks when validating the input argument,\n              so you might see an " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("IllegalArgumentException") + " during deserialization.\n              To enable or disable this change while testing, toggle the " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("ENABLE_STRICT_VALIDATION") + " flag using the\n              " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("compatibility framework tools", "https://developer.android.com/guide/app-compatibility/test-debug#toggle-dev-options") + ".\n            ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$0$0$2$1$2(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        $this$raw.text(StringsKt.trimIndent((String)("\n              In some cases, the addition of the\n              " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("java.lang.ClassValue"), "https://developer.android.com/reference/java/lang/ClassValue") + " class causes an issue if you try to shrink, obfuscate, and optimize your app using ProGuard.\n              If your app was developed against an older version of the runtime\n              without the " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("java.lang.ClassValue") + " class available,\n              then these optimizations might remove the " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("computeValue") + " method\n              from classes derived from " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("java.lang.ClassValue") + ".\n            ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$0$0$3(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        $this$raw.text(StringsKt.trimIndent((String)("\n            For apps targeting Android 14,\n            Android restricts apps from sending implicit intents to internal app components in the following ways:\n            " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant("Implicit intents are only delivered to exported components.\nApps must either use an explicit intent to unexported components, or mark the component as exported.") + "\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant("If an app creates a mutable pending intent with an intent that doesn't specify a component or package,\nthe system now throws an exception.") + "\n            "))) + "\n            These changes prevent malicious apps from intercepting implicit intents\n            that are intended for use by an app's internal components.\n            " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n            For example, here is an\n            " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("intent filter", "https://developer.android.com/guide/components/intents-filters#Receiving") + " that could be declared in your app's manifest file:\n          ")));
        $this$raw.xml("<activity\n    android:name=\".AppActivity\"\n    android:exported=\"false\">\n    <intent-filter>\n        <action android:name=\"com.example.action.APP_ACTION\" />\n        <category android:name=\"android.intent.category.DEFAULT\" />\n    </intent-filter>\n</activity>");
        $this$raw.text("If your app tried to launch this activity using an implicit intent, and exception would be thrown:");
        $this$raw.kotlin("// Throws an exception when targeting Android 14.\ncontext.startActivity(Intent(\"com.example.action.APP_ACTION\"))");
        $this$raw.text("To launch the non-exported activity, your app should use an explicit intent instead:");
        $this$raw.kotlin("// This makes the intent explicit.\nval explicitIntent = Intent(\"com.example.action.APP_ACTION\")\nexplicitIntent.apply {\n    package = context.packageName\n}\ncontext.startActivity(explicitIntent)");
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$0$0$4(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        $this$raw.text(StringsKt.trimIndent((String)("\n            Apps and services that target Android 14 and use\n            " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("context-registered receivers", "https://developer.android.com/guide/components/broadcasts#context-registered-receivers") + " are required to specify a flag to indicate whether or not the receiver should be exported to all other apps on the device:\n            either " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("RECEIVER_EXPORTED") + " or " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("RECEIVER_NOT_EXPORTED") + ", respectively.\n            This requirement helps protect apps from security vulnerabilities by leveraging the\n            " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("features for these receivers introduced in Android 13", "https://developer.android.com/about/versions/13/features#runtime-receivers") + ".\n            " + ApiUtils.INSTANCE.heading$targetsdkversion_upgrade_assistant(2, "Exception for receivers that receive only system broadcasts") + "\n            If your app is registering a receiver only for\n            " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("system broadcasts", "https://developer.android.com/guide/components/broadcasts#system-broadcasts") + " through " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("Context#registerReceiver") + " methods, such as\n            " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("Context#registerReceiver()"), "https://developer.android.com/reference/android/content/Context#registerReceiver(android.content.BroadcastReceiver,%20android.content.IntentFilter)") + ", then it shouldn't specify a flag when registering the receiver.\n          ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$0$0$5(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        $this$raw.text(StringsKt.trimIndent((String)("\n            If your app targets Android 14 and uses Dynamic Code Loading (DCL), all dynamically-loaded files must be marked as read-only.\n            Otherwise, the system throws an exception. We recommend that apps\n            " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("avoid dynamically loading code", "https://developer.android.com/training/articles/security-tips#DynamicCode") + " whenever possible, as doing so greatly increases the risk that an app can be compromised by code injection or code tampering.\n            " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n            If you must dynamically load code, use the following approach to set the dynamically-loaded file\n            (such as a DEX, JAR, or APK file) as read-only as soon as the file is opened and before any content is written:\n          ")));
        $this$raw.kotlin("val jar = File(\"DYNAMICALLY_LOADED_FILE.jar\")\nval os = FileOutputStream(jar)\nos.use {\n   // Set the file to read-only first to prevent race conditions\n   jar.setReadOnly()\n   // Then write the actual file content\n}\nval cl = PathClassLoader(jar, parentClassLoader)");
        $this$raw.text(StringsKt.trimIndent((String)("\n            " + ApiUtils.INSTANCE.heading$targetsdkversion_upgrade_assistant(2, "Handle dynamically-loaded files that already exist") + "\n            To prevent exceptions from being thrown for existing dynamically-loaded files,\n            we recommend deleting and recreating the files before you try to dynamically load them again in your app.\n            As you recreate the files, follow the preceding guidance for marking the files read-only at write time.\n            Alternatively, you can re-label the existing files as read-only, but in this case, we strongly recommend\n            that you verify the integrity of the files first (for example, by checking the file's signature against a trusted value),\n            to help protect your app from malicious actions.\n          ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$0$0$6(ElementListBuilder $this$filtered) {
        Intrinsics.checkNotNullParameter((Object)$this$filtered, (String)"$this$filtered");
        $this$filtered.text(StringsKt.trimIndent((String)("\n            For apps targeting Android 14, Android prevents the Zip Path Traversal Vulnerability in the following way:\n            " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("ZipFile(String)"), "https://developer.android.com/reference/java/util/zip/ZipFile#public-constructors") + " and\n            " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("ZipInputStream.getNextEntry()"), "https://developer.android.com/reference/java/util/zip/ZipInputStream#getNextEntry()") + " throws a\n            " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("ZipException"), "https://developer.android.com/reference/java/util/zip/ZipException") + " if zip file entry names contain \"..\" or start with \"/\".\n            " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n            Apps can opt-out from this validation by calling\n            " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("dalvik.system.ZipPathValidator.clearCallback()"), "https://developer.android.com/reference/dalvik/system/ZipPathValidator#clearCallback()") + ".\n          ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$0$0$7(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        $this$raw.text(StringsKt.trimIndent((String)("\n            For apps targeting Android 14, the system further restricts when apps are allowed to start activities from the background:\n            " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                When an app sends a " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("PendingIntent") + " using\n                " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("PendingIntent#send()"), "https://developer.android.com/reference/android/app/PendingIntent#send(android.content.Context,%20int,%20android.content.Intent,%20android.app.PendingIntent.OnFinished,%20android.os.Handler,%20java.lang.String,%20android.os.Bundle)") + " or similar methods, the app must now opt in if it wants to grant its own background activity launch privileges\n                to start the pending intent. To opt in, the app should pass an " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("ActivityOptions") + " bundle with\n                " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("setPendingIntentBackgroundActivityStartMode(MODE_BACKGROUND_ACTIVITY_START_ALLOWED"), "https://developer.android.com/reference/android/app/ActivityOptions#setPendingIntentBackgroundActivityStartMode(int)") + ".\n              "))) + "\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                When a visible app binds a service of another app that's in the background using the\n                " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("bindService()"), "https://developer.android.com/reference/android/content/Context#bindService(android.content.Intent,%20android.content.Context.BindServiceFlags,%20java.util.concurrent.Executor,%20android.content.ServiceConnection)") + " method, the visible app must now opt in if it wants to grant its own background activity launch privileges\n                to the bound service. To opt in, the app should include the\n                " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("BIND_ALLOW_ACTIVITY_STARTS"), "https://developer.android.com/reference/android/content/Context#BIND_ALLOW_ACTIVITY_STARTS") + " flag when calling the " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("bindService()") + " method.\n              "))) + "\n            "))) + "\n            These changes expand the\n            " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("existing set of restrictions", "https://developer.android.com/guide/components/activities/background-starts") + " to protect users by preventing malicious apps from abusing APIs to start disruptive activities from the background.\n          ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$0$0$8(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        $this$raw.text(StringsKt.trimIndent((String)("\n            Users who interact with your app on Android 14 devices can now grant partial access\n            to their visual media library (Photos/Videos) when an app requests any visual media permissions\n            (" + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("READ_MEDIA_IMAGES") + " or " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("READ_MEDIA_VIDEO") + ") introduced in Android 13 (API level 33).\n            " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n            " + ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("Note:") + " If your app already uses the " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("photo picker", "https://developer.android.com/training/data-storage/shared/photopicker") + ", you don't need to take any action to support this change.\n            Otherwise, consider using the photo picker instead of adopting this change.\n            " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n            The new dialog contains the following options:\n            " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                " + ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("Select photos and videos:") + " New in Android 14.\n                The user selects the specific photos and videos that they want to make available to your app.\n                "))) + "\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("Allow all:") + " The user grants full-library access to all photos and videos on the device.") + "\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("Don't allow:") + " The user denies access.") + "\n            "))) + "\n            If the user chooses " + ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("Select photos and videos") + " and your app later requests\n            " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("READ_MEDIA_IMAGES ") + " or " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("READ_MEDIA_VIDEO") + " again,\n            the system displays a different dialog, giving the user a chance to grant full access,\n            keep the current selection, or grant additional photos and videos.\n            After a certain period of time, the system directly shows the system picker instead.\n            " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n            To help apps support the new changes, the system introduces a new permission,\n            " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("READ_MEDIA_VISUAL_USER_SELECTED"), "https://developer.android.com/reference/android/Manifest.permission#READ_MEDIA_VISUAL_USER_SELECTED") + ". The system behaves differently, based on whether or not your app uses the new permission.\n\n            " + ApiUtils.INSTANCE.heading$targetsdkversion_upgrade_assistant(2, "Behavior if your app makes no change") + "\n            If you don't declare the " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("READ_MEDIA_VISUAL_USER_SELECTED") + " permission, the following behavior occurs:\n            " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n               " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                 The " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("READ_MEDIA_IMAGES") + " and " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("READ_MEDIA_VIDEO") + " permissions are granted during the app session,\n                 providing a temporary permission grant and temporary access to the user-selected photos and videos.\n                 When your app moves to the background, or when the user actively kills your app,\n                 the system eventually denies these permissions. This behavior is just like other one-time permissions.\n              "))) + "\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                If your app needs access to additional photos and videos at a later time,\n                you must manually request the " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("READ_MEDIA_IMAGES") + " permission\n                or the " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("READ_MEDIA_VIDEO") + " permission again.\n                The system follows the same flow as with the initial permission request,\n                prompting users to select photos and videos.\n              "))) + "\n            "))) + "\n            If your app is following " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("permissions best practices", "https://developer.android.com/about/versions/14/changes/partial-photo-video-access#best-practices") + ", this change shouldn't break your app.\n            This is especially true if your app doesn't assume that URI access is retained,\n            stores system permission state, or refreshes the set of displayed images after the permission changes.\n            However, this behavior might not be ideal depending on your app's use case.\n\n            " + ApiUtils.INSTANCE.heading$targetsdkversion_upgrade_assistant(2, "Migrate to control behaviour in your app") + "\n            If you declare the " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("READ_MEDIA_VISUAL_USER_SELECTED") + " permission,\n            and the user chooses " + ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("Select photos and videos") + " in the system permissions dialog, the following behavior occurs:\n            " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant("The " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("READ_MEDIA_IMAGES") + " and " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("READ_MEDIA_VIDEO") + " permissions are both denied.") + "\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                The " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("READ_MEDIA_VISUAL_USER_SELECTED") + " permission is granted,\n                providing partial and temporary access to the user's photos and videos.\n              "))) + "\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                If your app needs access to other photos and videos,\n                you must manually request the " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("READ_MEDIA_IMAGES") + " permission\n                or the " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("READ_MEDIA_VIDEO") + " permission (or both permissions) again.\n              "))) + "\n            "))) + "\n            " + ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("Note:") + " Create a UI element in your app that the user must press before you re-request\n            the " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("READ_MEDIA_IMAGES") + " or " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("READ_MEDIA_VIDEO") + " permission.\n            The user shouldn't be surprised to see the system dialog again.\n            " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n            Keep in mind that " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("READ_MEDIA_IMAGES") + " and " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("READ_MEDIA_VIDEO") + " are the only other permissions\n            needed to access the user's photos and videos photo library. Declaring " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("READ_MEDIA_VISUAL_USER_SELECTED") + "\n            makes the permission controller aware that your app supports a manual re-request to select more photos and videos.\n            " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n            To prevent users from seeing multiple system runtime dialog boxes, request the " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("READ_MEDIA_VISUAL_USER_SELECTED") + ",\n            " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("ACCESS_MEDIA_LOCATION") + " and the \"read media\" permissions (" + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("READ_MEDIA_IMAGES") + ",\n            " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("READ_MEDIA_VIDEO") + ", or both) in a single operation.\n\n\n            " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n            For more information, see " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Grant partial access to photos and videos", "https://developer.android.com/about/versions/14/changes/partial-photo-video-access") + ".\n          ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$0$1(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        $this$raw.text(StringsKt.trimIndent((String)("\n          Make sure to review the\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("complete set of changes", "https://developer.android.com/about/versions/14/behavior-changes-14") + ".\n        ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$0$2(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        $this$raw.text(StringsKt.trimIndent((String)("\n          Once you've finished migrating your code, update " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("targetSdkVersion") + " to 34.\n        ")));
        return Unit.INSTANCE;
    }
}

