/*
 * Decompiled with CFR 0.152.
 */
package com.google.targetsdkversionassistant;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.assistant.AssistActionState;
import com.android.tools.idea.assistant.AssistActionStateManager;
import com.android.tools.idea.assistant.datamodel.ActionData;
import com.android.tools.idea.assistant.datamodel.DefaultActionState;
import com.android.tools.idea.assistant.view.StatefulButtonMessage;
import com.google.targetsdkversionassistant.SyncService;
import com.google.targetsdkversionassistant.VerifyActionMessage;
import com.google.targetsdkversionassistant.filter.FilterService;
import com.google.targetsdkversionassistant.filter.Location;
import com.google.targetsdkversionassistant.filter.LocationProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.AndroidPluginDisposable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0017J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\bH\u0017J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/google/targetsdkversionassistant/VerifyActionStateManager;", "Lcom/android/tools/idea/assistant/AssistActionStateManager;", "<init>", "()V", "myRegisteredProjects", "", "Lcom/intellij/openapi/project/Project;", "getId", "", "init", "", "project", "actionData", "Lcom/android/tools/idea/assistant/datamodel/ActionData;", "getState", "Lcom/android/tools/idea/assistant/AssistActionState;", "getStateDisplay", "Lcom/android/tools/idea/assistant/view/StatefulButtonMessage;", "message", "problemCount", "", "nonLocatableProblemCount", "targetsdkversion-upgrade-assistant"})
@SourceDebugExtension(value={"SMAP\nVerifyActionStateManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VerifyActionStateManager.kt\ncom/google/targetsdkversionassistant/VerifyActionStateManager\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Grouping.kt\nkotlin/collections/GroupingKt__GroupingKt\n*L\n1#1,159:1\n30#2,2:160\n30#2,2:162\n30#2,2:164\n1550#3:166\n1788#3,4:175\n164#4:167\n53#4:168\n80#4,6:169\n*S KotlinDebug\n*F\n+ 1 VerifyActionStateManager.kt\ncom/google/targetsdkversionassistant/VerifyActionStateManager\n*L\n67#1:160,2\n70#1:162,2\n95#1:164,2\n110#1:166\n133#1:175,4\n112#1:167\n112#1:168\n112#1:169,6\n*E\n"})
public final class VerifyActionStateManager
extends AssistActionStateManager {
    @NotNull
    private final Set<Project> myRegisteredProjects = new LinkedHashSet();

    @NotNull
    public String getId() {
        return "VerifyAction";
    }

    public void init(@NotNull Project project, @NotNull ActionData actionData) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)actionData, (String)"actionData");
        if (this.myRegisteredProjects.add(project)) {
            AndroidPluginDisposable parentDisposable = AndroidPluginDisposable.Companion.getProjectInstance(project);
            project.getMessageBus().connect((Disposable)parentDisposable).subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(this, project){
                final /* synthetic */ VerifyActionStateManager this$0;
                final /* synthetic */ Project $project;
                {
                    this.this$0 = $receiver;
                    this.$project = $project;
                }

                public void enteredDumbMode() {
                    this.this$0.refreshDependencyState(this.$project);
                }

                public void exitDumbMode() {
                    this.this$0.refreshDependencyState(this.$project);
                }
            });
            Disposer.register((Disposable)((Disposable)parentDisposable), () -> VerifyActionStateManager.init$lambda$0(this, project));
        }
    }

    @UiThread
    @NotNull
    public AssistActionState getState(@NotNull Project project, @NotNull ActionData actionData) {
        AssistActionState assistActionState;
        FilterService.FilterResult result;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)actionData, (String)"actionData");
        if (DumbService.Companion.getInstance(project).isDumb()) {
            return (AssistActionState)DefaultActionState.IN_PROGRESS;
        }
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<SyncService> serviceClass$iv = SyncService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        if (!((SyncService)object).isSuccessful()) {
            return (AssistActionState)DefaultActionState.IN_PROGRESS;
        }
        String string = actionData.getActionArgument();
        Intrinsics.checkNotNull((Object)string);
        String filter2 = string;
        ComponentManager $this$service$iv2 = (ComponentManager)project;
        boolean $i$f$service2 = false;
        Class<FilterService> serviceClass$iv2 = FilterService.class;
        Object object2 = $this$service$iv2.getService(serviceClass$iv2);
        if (object2 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv2, serviceClass$iv2);
        }
        FilterService service = (FilterService)object2;
        if (service.getFiltersInProgress().contains(filter2)) {
            return (AssistActionState)DefaultActionState.IN_PROGRESS;
        }
        FilterService.FilterResult filterResult = service.getFilterResults().get(filter2);
        Intrinsics.checkNotNull((Object)filterResult);
        FilterService.FilterResult filterResult2 = result = filterResult;
        if (Intrinsics.areEqual((Object)filterResult2, (Object)FilterService.FilterResult.Init.INSTANCE)) {
            assistActionState = (AssistActionState)DefaultActionState.INCOMPLETE;
        } else if (Intrinsics.areEqual((Object)filterResult2, (Object)FilterService.FilterResult.Irrelevant.INSTANCE)) {
            assistActionState = (AssistActionState)DefaultActionState.COMPLETE;
        } else if (Intrinsics.areEqual((Object)filterResult2, (Object)FilterService.FilterResult.Threw.INSTANCE)) {
            assistActionState = (AssistActionState)DefaultActionState.ERROR_RETRY;
        } else if (filterResult2 instanceof FilterService.FilterResult.HasProblems) {
            DefaultActionState defaultActionState;
            boolean bl = ((FilterService.FilterResult.HasProblems)result).getProblems().isEmpty();
            if (bl) {
                defaultActionState = DefaultActionState.PARTIALLY_COMPLETE;
            } else if (!bl) {
                defaultActionState = DefaultActionState.NOT_APPLICABLE;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            assistActionState = (AssistActionState)defaultActionState;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return assistActionState;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @UiThread
    @NotNull
    public StatefulButtonMessage getStateDisplay(@NotNull Project project, @NotNull ActionData actionData, @Nullable String message) {
        StatefulButtonMessage statefulButtonMessage;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)actionData, (String)"actionData");
        String string = actionData.getActionArgument();
        Intrinsics.checkNotNull((Object)string);
        String filter2 = string;
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<FilterService> serviceClass$iv = FilterService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        FilterService service = (FilterService)object;
        FilterService.FilterResult filterResult = service.getFilterResults().get(filter2);
        Intrinsics.checkNotNull((Object)filterResult);
        FilterService.FilterResult result = filterResult;
        AssistActionState state = this.getState(project, actionData);
        FilterService.FilterResult filterResult2 = result;
        if (Intrinsics.areEqual((Object)filterResult2, (Object)FilterService.FilterResult.Init.INSTANCE)) {
            statefulButtonMessage = new StatefulButtonMessage("", state, null, 4, null);
            return statefulButtonMessage;
        } else if (Intrinsics.areEqual((Object)filterResult2, (Object)FilterService.FilterResult.Irrelevant.INSTANCE)) {
            statefulButtonMessage = new StatefulButtonMessage("Step complete!", state, null, 4, null);
            return statefulButtonMessage;
        } else if (Intrinsics.areEqual((Object)filterResult2, (Object)FilterService.FilterResult.Threw.INSTANCE)) {
            statefulButtonMessage = new StatefulButtonMessage("Something went wrong!", state, null, 4, null);
            return statefulButtonMessage;
        } else {
            void destination$iv$iv$iv;
            void $this$aggregateTo$iv$iv$iv;
            void $this$fold$iv;
            Grouping $this$groupingBy$iv;
            if (!(filterResult2 instanceof FilterService.FilterResult.HasProblems)) throw new NoWhenBranchMatchedException();
            Iterable iterable = ((FilterService.FilterResult.HasProblems)result).getProblems();
            boolean bl = false;
            $this$groupingBy$iv = (Grouping)new Grouping<LocationProvider, Location>((Iterable)$this$groupingBy$iv){
                final /* synthetic */ Iterable $this_groupingBy;
                {
                    this.$this_groupingBy = $receiver;
                }

                public Iterator<LocationProvider> sourceIterator() {
                    return this.$this_groupingBy.iterator();
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public Object keyOf(Object element) {
                    LocationProvider it = (LocationProvider)element;
                    boolean bl = false;
                    return it.getLocation();
                }
            };
            List list = CollectionsKt.emptyList();
            boolean $i$f$fold = false;
            void $this$aggregate$iv$iv = $this$fold$iv;
            boolean $i$f$aggregate = false;
            void var15_20 = $this$aggregate$iv$iv;
            Map map = new LinkedHashMap();
            boolean $i$f$aggregateTo = false;
            Iterator iterator = $this$aggregateTo$iv$iv$iv.sourceIterator();
            while (iterator.hasNext()) {
                void ele;
                void acc$iv;
                void first$iv;
                void e$iv;
                Object e$iv$iv$iv = iterator.next();
                Object key$iv$iv$iv = $this$aggregateTo$iv$iv$iv.keyOf(e$iv$iv$iv);
                Object accumulator$iv$iv$iv = destination$iv$iv$iv.get(key$iv$iv$iv);
                boolean bl2 = accumulator$iv$iv$iv == null && !destination$iv$iv$iv.containsKey(key$iv$iv$iv);
                Object e = e$iv$iv$iv;
                Object v = accumulator$iv$iv$iv;
                Object object2 = key$iv$iv$iv;
                void var26_31 = destination$iv$iv$iv;
                boolean bl3 = false;
                LocationProvider locationProvider = (LocationProvider)e$iv;
                List list2 = first$iv != false ? list : acc$iv;
                boolean bl4 = false;
                List list3 = ele.getLocation() == null ? CollectionsKt.plus((Collection)list2, (Object)ele) : CollectionsKt.listOf((Object)ele);
                var26_31.put(object2, list3);
            }
            List problems = CollectionsKt.flatten((Iterable)destination$iv$iv$iv.values());
            boolean bl5 = problems.isEmpty();
            if (bl5) {
                statefulButtonMessage = new StatefulButtonMessage("Step complete!", state, null, 4, null);
                return statefulButtonMessage;
            } else {
                int n;
                if (bl5) throw new NoWhenBranchMatchedException();
                Iterable iterable2 = problems;
                int n2 = problems.size();
                VerifyActionStateManager verifyActionStateManager = this;
                boolean $i$f$count = false;
                if (iterable2 instanceof Collection && ((Collection)iterable2).isEmpty()) {
                    n = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : iterable2) {
                        LocationProvider it = (LocationProvider)element$iv;
                        boolean bl6 = false;
                        if (!(it.getLocation() == null) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = count$iv;
                }
                int n3 = n;
                List list4 = problems;
                AssistActionState assistActionState = state;
                String string2 = verifyActionStateManager.message(n2, n3);
                statefulButtonMessage = new VerifyActionMessage(string2, assistActionState, list4);
            }
        }
        return statefulButtonMessage;
    }

    private final String message(int problemCount, int nonLocatableProblemCount) {
        StringBuilder stringBuilder;
        int linkProblemCount = problemCount - nonLocatableProblemCount;
        StringBuilder $this$message_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (nonLocatableProblemCount > 0) {
            $this$message_u24lambda_u240.append("Found " + nonLocatableProblemCount + " " + VerifyActionStateManager.message$problemString(problemCount) + " without a location.");
        }
        if (linkProblemCount > 0) {
            $this$message_u24lambda_u240.append("Review the " + linkProblemCount + " " + VerifyActionStateManager.message$problemString(linkProblemCount) + " that " + VerifyActionStateManager.message$wasString(linkProblemCount) + " found:");
        }
        return stringBuilder.toString();
    }

    private static final void init$lambda$0(VerifyActionStateManager this$0, Project $project) {
        this$0.myRegisteredProjects.remove($project);
    }

    private static final String message$problemString(int count) {
        return count > 1 ? "problems" : "problem";
    }

    private static final String message$wasString(int count) {
        return count > 1 ? "were" : "was";
    }
}

