/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.usb;

import com.android.tools.usb.Platform;
import com.android.tools.usb.UsbDevice;
import com.android.tools.usb.UsbDeviceCollector;
import com.android.tools.usb.parser.OutputParser;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00052\u0006\u0010\u0010\u001a\u00020\u000bH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/usb/UsbDeviceCollectorImpl;", "Lcom/android/tools/usb/UsbDeviceCollector;", "<init>", "()V", "listUsbDevices", "Ljava/util/concurrent/CompletableFuture;", "", "Lcom/android/tools/usb/UsbDevice;", "isSupported", "", "platform", "", "getPlatform", "Lcom/android/tools/usb/Platform;", "execute", "Ljava/io/InputStream;", "command", "usb-devices"})
public final class UsbDeviceCollectorImpl
implements UsbDeviceCollector {
    @Override
    @NotNull
    public CompletableFuture<List<UsbDevice>> listUsbDevices() {
        Platform currentOS = Platform.Factory.currentOS();
        if (!currentOS.getSupported()) {
            CompletableFuture<List<UsbDevice>> completableFuture = CompletableFuture.completedFuture(Collections.emptyList());
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        String string2 = currentOS.getCommand();
        Intrinsics.checkNotNull((Object)string2);
        CompletionStage completionStage = this.execute(string2).thenApply(arg_0 -> UsbDeviceCollectorImpl.listUsbDevices$lambda$1(arg_0 -> UsbDeviceCollectorImpl.listUsbDevices$lambda$0(currentOS, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    @Override
    public boolean isSupported(@NotNull String platform) {
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        return Platform.Factory.currentOS(platform).getSupported();
    }

    @Override
    @NotNull
    public Platform getPlatform() {
        return Platform.Factory.currentOS();
    }

    private final CompletableFuture<InputStream> execute(String command) {
        CompletableFuture<InputStream> completableFuture = CompletableFuture.supplyAsync(() -> UsbDeviceCollectorImpl.execute$lambda$0(command));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(...)");
        return completableFuture;
    }

    private static final List listUsbDevices$lambda$0(Platform $currentOS, InputStream it) {
        OutputParser outputParser = $currentOS.parser();
        Intrinsics.checkNotNull((Object)it);
        return outputParser.parse(it);
    }

    private static final List listUsbDevices$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final InputStream execute$lambda$0(String $command) {
        String[] stringArray = new String[]{" "};
        return new ProcessBuilder(StringsKt.split$default((CharSequence)$command, (String[])stringArray, (boolean)false, (int)0, (int)6, null)).redirectErrorStream(true).start().getInputStream();
    }
}

