/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.detector.api.ApiConstraintKt;
import com.android.tools.lint.detector.api.ApiLevel;
import com.android.tools.lint.detector.api.ExtensionSdkRegistry;
import com.android.tools.lint.detector.api.Intervals;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 (2\u00020\u0001:\u0004()*+B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\b\u0010\u0006\u001a\u00020\u0005H&J\b\u0010\u0007\u001a\u00020\u0005H&J\b\u0010\b\u001a\u00020\u0005H&J\b\u0010\t\u001a\u00020\u0005H&J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0000H&J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0005H&J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0000H&J\t\u0010\u0011\u001a\u00020\u0000H\u00a6\u0002J\b\u0010\u0012\u001a\u00020\u000bH&J\b\u0010\u0013\u001a\u00020\u0000H&J\b\u0010\u0014\u001a\u00020\u000bH&J\u0013\u0010\u0015\u001a\u00020\u00002\b\u0010\u0016\u001a\u0004\u0018\u00010\u0000H\u00a6\u0004J\u0013\u0010\u0017\u001a\u00020\u00002\b\u0010\u0016\u001a\u0004\u0018\u00010\u0000H\u00a6\u0004J\b\u0010\u0018\u001a\u00020\u0019H&J\b\u0010\u001a\u001a\u00020\u0019H&J\u0014\u0010\u001a\u001a\u00020\u00192\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001cH&J\u0006\u0010\u001d\u001a\u00020\u0019J\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u00052\b\b\u0002\u0010!\u001a\u00020\u000bH&J\b\u0010\"\u001a\u00020\u0005H&J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001f0$H&J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0005H\u0017J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0005H'J\u0010\u0010%\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0005H'J\u0012\u0010&\u001a\u0004\u0018\u00010\u001f2\u0006\u0010'\u001a\u00020\u0000H&\u0082\u0001\u0002,\u001f\u00a8\u0006-"}, d2={"Lcom/android/tools/lint/detector/api/ApiConstraint;", "", "<init>", "()V", "min", "", "fromInclusive", "fromInclusiveMinor", "toExclusive", "toExclusiveMinor", "isAtLeast", "", "constraint", "includes", "apiLevel", "alwaysAtLeast", "minSdk", "not", "negatable", "asNonNegatable", "isEmpty", "or", "other", "and", "serialize", "", "toString", "sdkRegistry", "Lcom/android/tools/lint/detector/api/ExtensionSdkRegistry;", "minString", "findSdk", "Lcom/android/tools/lint/detector/api/ApiConstraint$SdkApiConstraint;", "sdkId", "certain", "getSdk", "getConstraints", "", "everHigher", "firstMissing", "requirement", "Companion", "SdkApiConstraint", "SdkApiConstraints", "MultiSdkApiConstraint", "Lcom/android/tools/lint/detector/api/ApiConstraint$MultiSdkApiConstraint;", "android.sdktools.lint-api"})
@SourceDebugExtension(value={"SMAP\nApiConstraint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiConstraint.kt\ncom/android/tools/lint/detector/api/ApiConstraint\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1464:1\n1#2:1465\n*E\n"})
public abstract sealed class ApiConstraint {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final SdkApiConstraint NONE = SdkApiConstraint.Companion.getNO_LEVELS();
    @JvmField
    @NotNull
    public static final SdkApiConstraint UNKNOWN = new SdkApiConstraint(Intervals.Companion.getNONE(), -2, false, 4, null);
    @JvmField
    @NotNull
    public static final SdkApiConstraint ALL = com.android.tools.lint.detector.api.ApiConstraint$Companion.atLeast$default(Companion, 1, 0, 2, null);
    @NotNull
    private static final List<SdkApiConstraint> simpleApiLevels;

    private ApiConstraint() {
    }

    public final int min() {
        return this.fromInclusive();
    }

    public abstract int fromInclusive();

    public abstract int fromInclusiveMinor();

    public abstract int toExclusive();

    public abstract int toExclusiveMinor();

    public abstract boolean isAtLeast(@NotNull ApiConstraint var1);

    public abstract boolean includes(int var1);

    public abstract boolean alwaysAtLeast(@NotNull ApiConstraint var1);

    @NotNull
    public abstract ApiConstraint not();

    public abstract boolean negatable();

    @NotNull
    public abstract ApiConstraint asNonNegatable();

    public abstract boolean isEmpty();

    @NotNull
    public abstract ApiConstraint or(@Nullable ApiConstraint var1);

    @NotNull
    public abstract ApiConstraint and(@Nullable ApiConstraint var1);

    @NotNull
    public abstract String serialize();

    @NotNull
    public abstract String toString();

    @NotNull
    public abstract String toString(@Nullable ExtensionSdkRegistry var1);

    public static /* synthetic */ String toString$default(ApiConstraint apiConstraint, ExtensionSdkRegistry extensionSdkRegistry, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toString");
        }
        if ((n & 1) != 0) {
            extensionSdkRegistry = null;
        }
        return apiConstraint.toString(extensionSdkRegistry);
    }

    @NotNull
    public final String minString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(this.fromInclusive()));
        int minor = this.fromInclusiveMinor();
        if (minor > 0) {
            sb.append('.').append(String.valueOf(minor));
        }
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @Nullable
    public abstract SdkApiConstraint findSdk(int var1, boolean var2);

    public static /* synthetic */ SdkApiConstraint findSdk$default(ApiConstraint apiConstraint, int n, boolean bl, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findSdk");
        }
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return apiConstraint.findSdk(n, bl);
    }

    public abstract int getSdk();

    @NotNull
    public abstract List<SdkApiConstraint> getConstraints();

    @Deprecated(message="Use the ApiConstraint version instead to make sure you're checking the right SDK extension", replaceWith=@ReplaceWith(expression="isAtLeast(ApiConstraint.get(apiLevel,com.android.tools.lint.detector.api.ExtensionSdk.Companion.ANDROID_SDK_ID))", imports={}))
    public boolean isAtLeast(int apiLevel) {
        return this.isAtLeast(Companion.atLeast(apiLevel, 0, this.getSdk()));
    }

    @Deprecated(message="Use the ApiConstraint version instead to make sure you're checking the right SDK extension", replaceWith=@ReplaceWith(expression="alwaysAtLeast(ApiConstraint.get(apiLevel,com.android.tools.lint.detector.api.ExtensionSdk.Companion.ANDROID_SDK_ID))", imports={}))
    public abstract boolean alwaysAtLeast(int var1);

    @Deprecated(message="Use the ApiConstraint version instead to make sure you're checking the right SDK extension", replaceWith=@ReplaceWith(expression="everHigher(ApiConstraint.get(apiLevel,com.android.tools.lint.detector.api.ExtensionSdk.Companion.ANDROID_SDK_ID))", imports={}))
    public abstract boolean everHigher(int var1);

    @Nullable
    public abstract SdkApiConstraint firstMissing(@NotNull ApiConstraint var1);

    @JvmStatic
    @NotNull
    public static final SdkApiConstraint get(int apiLevel, int sdkId) {
        return Companion.get(apiLevel, sdkId);
    }

    @JvmStatic
    @NotNull
    public static final SdkApiConstraint atLeast(int apiLevel, int sdkId) {
        return Companion.atLeast(apiLevel, sdkId);
    }

    @JvmStatic
    @NotNull
    public static final SdkApiConstraint atLeast(int apiLevel, int minorLevel, int sdkId) {
        return Companion.atLeast(apiLevel, minorLevel, sdkId);
    }

    public /* synthetic */ ApiConstraint(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    /*
     * WARNING - void declaration
     */
    static {
        int n = 37;
        Companion companion = Companion;
        ArrayList<SdkApiConstraint> arrayList = new ArrayList<SdkApiConstraint>(n);
        int n2 = 0;
        while (n2 < n) {
            void p0;
            int n3;
            int n4 = n3 = n2++;
            ArrayList<SdkApiConstraint> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(com.android.tools.lint.detector.api.ApiConstraint$Companion.atLeast$default(companion, (int)p0, 0, 2, null));
        }
        simpleApiLevels = arrayList;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fH\u0007J-\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0007\u00a2\u0006\u0002\b\u0014J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\b\b\u0002\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\fJ\u001f\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00182\b\b\u0002\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001a\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fH\u0007J \u0010\u0017\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0007J\u001f\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00182\b\b\u0002\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u001d\u0010\u001aJ\u001e\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u001f\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00182\b\b\u0002\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u001f\u0010\u001aJ\u0018\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fJ \u0010\u001e\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fJ\u001f\u0010 \u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00182\b\b\u0002\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b!\u0010\u001aJ\u0018\u0010 \u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fJ \u0010 \u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fJ'\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u00182\b\b\u0002\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b%\u0010&J0\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\f2\u0006\u0010'\u001a\u00020\f2\u0006\u0010$\u001a\u00020\f2\u0006\u0010(\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fJ\u001f\u0010)\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00182\b\b\u0002\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b*\u0010\u001aJ\u0018\u0010)\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fJ \u0010)\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fJ\u001f\u0010+\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00182\b\b\u0002\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b,\u0010\u001aJ\u0018\u0010+\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fJ \u0010+\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fJ\u000e\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u000fJ\u000e\u00100\u001a\u00020\u000f2\u0006\u00101\u001a\u00020.J\u0010\u00102\u001a\u0004\u0018\u00010\u000f2\u0006\u00103\u001a\u000204R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/android/tools/lint/detector/api/ApiConstraint$Companion;", "", "<init>", "()V", "NONE", "Lcom/android/tools/lint/detector/api/ApiConstraint$SdkApiConstraint;", "UNKNOWN", "ALL", "simpleApiLevels", "", "get", "apiLevel", "", "sdkId", "max", "Lcom/android/tools/lint/detector/api/ApiConstraint;", "api1", "api2", "either", "", "maxNullable", "isInfinity", "level", "atLeast", "Lcom/android/tools/lint/detector/api/ApiLevel;", "atLeast-kG1hquA", "(II)Lcom/android/tools/lint/detector/api/ApiConstraint$SdkApiConstraint;", "minorLevel", "below", "below-kG1hquA", "above", "above-kG1hquA", "atMost", "atMost-kG1hquA", "range", "fromInclusive", "toExclusive", "range-OpYL1XQ", "(III)Lcom/android/tools/lint/detector/api/ApiConstraint$SdkApiConstraint;", "fromInclusiveMinor", "toExclusiveMinor", "exactly", "exactly-kG1hquA", "not", "not-kG1hquA", "serialize", "", "constraint", "deserialize", "s", "getFromUsesSdk", "usesSdk", "Lorg/w3c/dom/Element;", "android.sdktools.lint-api"})
    @SourceDebugExtension(value={"SMAP\nApiConstraint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiConstraint.kt\ncom/android/tools/lint/detector/api/ApiConstraint$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1464:1\n1563#2:1465\n1634#2,3:1466\n1563#2:1469\n1634#2,3:1470\n1869#2,2:1473\n*S KotlinDebug\n*F\n+ 1 ApiConstraint.kt\ncom/android/tools/lint/detector/api/ApiConstraint$Companion\n*L\n313#1:1465\n313#1:1466,3\n324#1:1469\n324#1:1470,3\n334#1:1473,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SdkApiConstraint get(int apiLevel, int sdkId) {
            if (apiLevel == -1) {
                return UNKNOWN;
            }
            if (apiLevel < simpleApiLevels.size() && sdkId == 0) {
                return (SdkApiConstraint)simpleApiLevels.get(apiLevel);
            }
            return this.atLeast(apiLevel, sdkId);
        }

        public static /* synthetic */ SdkApiConstraint get$default(Companion companion, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            return companion.get(n, n2);
        }

        @JvmName(name="maxNullable")
        @Nullable
        public final ApiConstraint maxNullable(@Nullable ApiConstraint api1, @Nullable ApiConstraint api2, boolean either) {
            if (api1 == null) {
                return api2;
            }
            return this.max(api1, api2, either);
        }

        public static /* synthetic */ ApiConstraint maxNullable$default(Companion companion, ApiConstraint apiConstraint, ApiConstraint apiConstraint2, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            return companion.maxNullable(apiConstraint, apiConstraint2, bl);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ApiConstraint max(@NotNull ApiConstraint api1, @Nullable ApiConstraint api2, boolean either) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)api1, (String)"api1");
            boolean bl2 = bl = api1 != UNKNOWN;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            boolean bl3 = bl = api2 != UNKNOWN;
            if (_Assertions.ENABLED && !bl) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            if (api2 == null) {
                return api1;
            }
            if (api1.isEmpty()) {
                return NONE;
            }
            if (api2.isEmpty()) {
                return NONE;
            }
            ApiConstraint apiConstraint = api1;
            if (apiConstraint instanceof SdkApiConstraint) {
                ApiConstraint apiConstraint2;
                if (api2 instanceof SdkApiConstraint) {
                    int sdkId = ((SdkApiConstraint)api1).getSdkId();
                    if (sdkId == ((SdkApiConstraint)api2).getSdkId()) {
                        apiConstraint2 = new SdkApiConstraint(((SdkApiConstraint)api1).getIntervals().and(((SdkApiConstraint)api2).getIntervals()), sdkId, false, 4, null);
                    } else {
                        Object[] objectArray = new SdkApiConstraints[]{new SdkApiConstraints(sdkId, (SdkApiConstraint)api1, either), new SdkApiConstraints(((SdkApiConstraint)api2).getSdkId(), (SdkApiConstraint)api2, either)};
                        apiConstraint2 = new MultiSdkApiConstraint(CollectionsKt.listOf((Object[])objectArray));
                    }
                } else {
                    apiConstraint2 = this.max(api2, api1, either);
                }
                return apiConstraint2;
            }
            if (apiConstraint instanceof MultiSdkApiConstraint) {
                ApiConstraint apiConstraint3 = api2;
                if (apiConstraint3 instanceof SdkApiConstraint) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    SdkApiConstraints sdkApiConstraints = ((MultiSdkApiConstraint)api1).findSdks$android_sdktools_lint_api(((SdkApiConstraint)api2).getSdkId());
                    if (sdkApiConstraints == null) {
                        return new MultiSdkApiConstraint(CollectionsKt.plus((Collection)((MultiSdkApiConstraint)api1).getSdkConstraints$android_sdktools_lint_api(), (Object)new SdkApiConstraints(((SdkApiConstraint)api2).getSdkId(), (SdkApiConstraint)api2, either)));
                    }
                    SdkApiConstraints match = sdkApiConstraints;
                    Iterable iterable = ((MultiSdkApiConstraint)api1).getSdkConstraints$android_sdktools_lint_api();
                    boolean $i$f$map2 = false;
                    void var10_17 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                        void it;
                        SdkApiConstraints sdkApiConstraints2 = (SdkApiConstraints)item$iv$iv2;
                        Collection collection = destination$iv$iv;
                        boolean bl4 = false;
                        collection.add(it == match ? it.andWith((SdkApiConstraint)api2, either) : it);
                    }
                    List apis = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                    return new MultiSdkApiConstraint(apis);
                }
                if (apiConstraint3 instanceof MultiSdkApiConstraint) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable apis = ((MultiSdkApiConstraint)api1).getSdkConstraints$android_sdktools_lint_api();
                    boolean $i$f$map = false;
                    void $i$f$map2 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void have;
                        SdkApiConstraints item$iv$iv2 = (SdkApiConstraints)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl5 = false;
                        SdkApiConstraints match = ((MultiSdkApiConstraint)api2).findSdks$android_sdktools_lint_api(have.getSdkId());
                        collection.add(match != null ? have.and(match) : have);
                    }
                    List apis2 = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
                    Iterable $this$forEach$iv = ((MultiSdkApiConstraint)api2).getSdkConstraints$android_sdktools_lint_api();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        SdkApiConstraints it = (SdkApiConstraints)element$iv;
                        boolean bl6 = false;
                        if (((MultiSdkApiConstraint)api1).findSdks$android_sdktools_lint_api(it.getSdkId()) != null) continue;
                        apis2.add(it);
                    }
                    return new MultiSdkApiConstraint(apis2);
                }
                throw new NoWhenBranchMatchedException();
            }
            throw new NoWhenBranchMatchedException();
        }

        public static /* synthetic */ ApiConstraint max$default(Companion companion, ApiConstraint apiConstraint, ApiConstraint apiConstraint2, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            return companion.max(apiConstraint, apiConstraint2, bl);
        }

        public final boolean isInfinity(int level) {
            return Intervals.Companion.isInfinity(level);
        }

        @NotNull
        public final SdkApiConstraint atLeast-kG1hquA(int n, int sdkId) {
            return this.atLeast(ApiLevel.getMajor-impl(n), ApiLevel.getMinor-impl(n), sdkId);
        }

        public static /* synthetic */ SdkApiConstraint atLeast-kG1hquA$default(Companion companion, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            return companion.atLeast-kG1hquA(n, n2);
        }

        @JvmStatic
        @NotNull
        public final SdkApiConstraint atLeast(int apiLevel, int sdkId) {
            return SdkApiConstraint.Companion.createConstraint$default(SdkApiConstraint.Companion, apiLevel, null, sdkId, 2, null);
        }

        public static /* synthetic */ SdkApiConstraint atLeast$default(Companion companion, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            return companion.atLeast(n, n2);
        }

        @JvmStatic
        @NotNull
        public final SdkApiConstraint atLeast(int apiLevel, int minorLevel, int sdkId) {
            return SdkApiConstraint.Companion.createConstraint$default(SdkApiConstraint.Companion, apiLevel, minorLevel, null, null, sdkId, 12, null);
        }

        @NotNull
        public final SdkApiConstraint below-kG1hquA(int n, int sdkId) {
            return this.below(ApiLevel.getMajor-impl(n), ApiLevel.getMinor-impl(n), sdkId);
        }

        public static /* synthetic */ SdkApiConstraint below-kG1hquA$default(Companion companion, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            return companion.below-kG1hquA(n, n2);
        }

        @NotNull
        public final SdkApiConstraint below(int apiLevel, int minorLevel, int sdkId) {
            return SdkApiConstraint.Companion.createConstraint$default(SdkApiConstraint.Companion, null, null, apiLevel, minorLevel, sdkId, 3, null);
        }

        @NotNull
        public final SdkApiConstraint above-kG1hquA(int n, int sdkId) {
            return ApiLevel.isDotted-impl(n) ? this.above(ApiLevel.getMajor-impl(n), ApiLevel.getMinor-impl(n), sdkId) : this.above(ApiLevel.getMajor-impl(n), sdkId);
        }

        public static /* synthetic */ SdkApiConstraint above-kG1hquA$default(Companion companion, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            return companion.above-kG1hquA(n, n2);
        }

        @NotNull
        public final SdkApiConstraint above(int apiLevel, int sdkId) {
            return SdkApiConstraint.Companion.createConstraint$default(SdkApiConstraint.Companion, apiLevel + 1, null, sdkId, 2, null);
        }

        public static /* synthetic */ SdkApiConstraint above$default(Companion companion, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            return companion.above(n, n2);
        }

        @NotNull
        public final SdkApiConstraint above(int apiLevel, int minorLevel, int sdkId) {
            return SdkApiConstraint.Companion.createConstraint$default(SdkApiConstraint.Companion, apiLevel, minorLevel + 1, null, null, sdkId, 12, null);
        }

        public static /* synthetic */ SdkApiConstraint above$default(Companion companion, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 4) != 0) {
                n3 = 0;
            }
            return companion.above(n, n2, n3);
        }

        @NotNull
        public final SdkApiConstraint atMost-kG1hquA(int n, int sdkId) {
            return ApiLevel.isDotted-impl(n) ? this.atMost(ApiLevel.getMajor-impl(n), ApiLevel.getMinor-impl(n), sdkId) : this.atMost(ApiLevel.getMajor-impl(n), sdkId);
        }

        public static /* synthetic */ SdkApiConstraint atMost-kG1hquA$default(Companion companion, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            return companion.atMost-kG1hquA(n, n2);
        }

        @NotNull
        public final SdkApiConstraint atMost(int apiLevel, int sdkId) {
            return SdkApiConstraint.Companion.createConstraint$default(SdkApiConstraint.Companion, null, apiLevel + 1, sdkId, 1, null);
        }

        public static /* synthetic */ SdkApiConstraint atMost$default(Companion companion, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            return companion.atMost(n, n2);
        }

        @NotNull
        public final SdkApiConstraint atMost(int apiLevel, int minorLevel, int sdkId) {
            return SdkApiConstraint.Companion.createConstraint$default(SdkApiConstraint.Companion, null, null, apiLevel, minorLevel + 1, sdkId, 3, null);
        }

        public static /* synthetic */ SdkApiConstraint atMost$default(Companion companion, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 4) != 0) {
                n3 = 0;
            }
            return companion.atMost(n, n2, n3);
        }

        @NotNull
        public final SdkApiConstraint range-OpYL1XQ(int n, int n2, int sdkId) {
            return this.range(ApiLevel.getMajor-impl(n), ApiLevel.getMinor-impl(n), ApiLevel.getMajor-impl(n2), ApiLevel.getMinor-impl(n2), sdkId);
        }

        public static /* synthetic */ SdkApiConstraint range-OpYL1XQ$default(Companion companion, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 4) != 0) {
                n3 = 0;
            }
            return companion.range-OpYL1XQ(n, n2, n3);
        }

        @NotNull
        public final SdkApiConstraint range(int fromInclusive, int fromInclusiveMinor, int toExclusive, int toExclusiveMinor, int sdkId) {
            return SdkApiConstraint.Companion.createConstraint(fromInclusive, fromInclusiveMinor, toExclusive, toExclusiveMinor, sdkId);
        }

        public static /* synthetic */ SdkApiConstraint range$default(Companion companion, int n, int n2, int n3, int n4, int n5, int n6, Object object) {
            if ((n6 & 0x10) != 0) {
                n5 = 0;
            }
            return companion.range(n, n2, n3, n4, n5);
        }

        @NotNull
        public final SdkApiConstraint exactly-kG1hquA(int n, int sdkId) {
            return ApiLevel.isDotted-impl(n) ? this.exactly(ApiLevel.getMajor-impl(n), ApiLevel.getMinor-impl(n), sdkId) : this.exactly(ApiLevel.getMajor-impl(n), sdkId);
        }

        public static /* synthetic */ SdkApiConstraint exactly-kG1hquA$default(Companion companion, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            return companion.exactly-kG1hquA(n, n2);
        }

        @NotNull
        public final SdkApiConstraint exactly(int apiLevel, int sdkId) {
            return SdkApiConstraint.Companion.createConstraint(apiLevel, apiLevel + 1, sdkId);
        }

        public static /* synthetic */ SdkApiConstraint exactly$default(Companion companion, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            return companion.exactly(n, n2);
        }

        @NotNull
        public final SdkApiConstraint exactly(int apiLevel, int minorLevel, int sdkId) {
            return SdkApiConstraint.Companion.createConstraint(apiLevel, minorLevel, apiLevel, minorLevel + 1, sdkId);
        }

        public static /* synthetic */ SdkApiConstraint exactly$default(Companion companion, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 4) != 0) {
                n3 = 0;
            }
            return companion.exactly(n, n2, n3);
        }

        @NotNull
        public final SdkApiConstraint not-kG1hquA(int n, int sdkId) {
            return ApiLevel.isDotted-impl(n) ? this.not(ApiLevel.getMajor-impl(n), ApiLevel.getMinor-impl(n), sdkId) : this.not(ApiLevel.getMajor-impl(n), sdkId);
        }

        public static /* synthetic */ SdkApiConstraint not-kG1hquA$default(Companion companion, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            return companion.not-kG1hquA(n, n2);
        }

        @NotNull
        public final SdkApiConstraint not(int apiLevel, int sdkId) {
            return this.exactly(apiLevel, sdkId).not();
        }

        public static /* synthetic */ SdkApiConstraint not$default(Companion companion, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            return companion.not(n, n2);
        }

        @NotNull
        public final SdkApiConstraint not(int apiLevel, int minorLevel, int sdkId) {
            return this.exactly(apiLevel, minorLevel, sdkId).not();
        }

        public static /* synthetic */ SdkApiConstraint not$default(Companion companion, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 4) != 0) {
                n3 = 0;
            }
            return companion.not(n, n2, n3);
        }

        @NotNull
        public final String serialize(@NotNull ApiConstraint constraint) {
            Intrinsics.checkNotNullParameter((Object)constraint, (String)"constraint");
            return constraint.serialize();
        }

        @NotNull
        public final ApiConstraint deserialize(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            return StringsKt.startsWith$default((CharSequence)s, (char)'{', (boolean)false, (int)2, null) ? MultiSdkApiConstraint.Companion.deserialize(s) : (ApiConstraint)SdkApiConstraint.Companion.deserialize(s);
        }

        @Nullable
        public final ApiConstraint getFromUsesSdk(@NotNull Element usesSdk) {
            Intrinsics.checkNotNullParameter((Object)usesSdk, (String)"usesSdk");
            boolean bl = Intrinsics.areEqual((Object)usesSdk.getTagName(), (Object)"uses-sdk");
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            String minSdkVersionString = usesSdk.getAttributeNS("http://schemas.android.com/apk/res/android", "minSdkVersion");
            Intrinsics.checkNotNull((Object)minSdkVersionString);
            int minSdkVersion = ApiConstraintKt.access$getApiLevel(minSdkVersionString);
            String codeName = ApiConstraintKt.access$isNumber(minSdkVersionString) ? null : minSdkVersionString;
            Node node = usesSdk.getFirstChild();
            if (node == null) {
                return minSdkVersion != -1 ? (ApiConstraint)com.android.tools.lint.detector.api.ApiConstraint$Companion.get$default(this, minSdkVersion, 0, 2, null) : null;
            }
            Node curr = node;
            List list2 = new ArrayList();
            boolean addMinSdkVersion = minSdkVersion != -1;
            while (true) {
                if (curr.getNodeType() == 1 && Intrinsics.areEqual((Object)curr.getNodeName(), (Object)"extension-sdk")) {
                    Element extension = (Element)curr;
                    String sdkVersionString = extension.getAttributeNS("http://schemas.android.com/apk/res/android", "sdkVersion");
                    Intrinsics.checkNotNull((Object)sdkVersionString);
                    int sdkVersion = ApiConstraintKt.access$getApiLevel(sdkVersionString);
                    String string3 = extension.getAttributeNS("http://schemas.android.com/apk/res/android", "minExtensionVersion");
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAttributeNS(...)");
                    int extensionVersion = ApiConstraintKt.access$getApiLevel(string3);
                    if (sdkVersion == minSdkVersion && (codeName == null || Intrinsics.areEqual((Object)codeName, (Object)sdkVersionString))) {
                        addMinSdkVersion = false;
                    }
                    list2.add(SdkApiConstraint.Companion.createConstraint$default(SdkApiConstraint.Companion, extensionVersion, null, sdkVersion, 2, null));
                }
                if (curr.getNextSibling() == null) break;
            }
            if (addMinSdkVersion) {
                list2.add(0, SdkApiConstraint.Companion.createConstraint$default(SdkApiConstraint.Companion, minSdkVersion, null, 0, 2, null));
            }
            return new MultiSdkApiConstraint(list2, false);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 02\u00020\u0001:\u00010B\u0017\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u001f\b\u0016\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0005\u0010\u000bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0016J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0001H\u0016J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0010H\u0016J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0010H\u0016J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u0001H\u0016J\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0010H\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001c\u001a\u00020\u0001H\u0016J\t\u0010\u001d\u001a\u00020\u0001H\u0096\u0002J\b\u0010\u001e\u001a\u00020\nH\u0016J\b\u0010\u001f\u001a\u00020\u0001H\u0016J\b\u0010 \u001a\u00020\nH\u0016J\u0013\u0010!\u001a\u00020\u00012\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u0096\u0004J\u0013\u0010#\u001a\u00020\u00012\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u0096\u0004J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020%H\u0016J\u0012\u0010&\u001a\u00020%2\b\u0010'\u001a\u0004\u0018\u00010(H\u0016J\u001a\u0010)\u001a\u0004\u0018\u00010\b2\u0006\u0010*\u001a\u00020\u00102\u0006\u0010+\u001a\u00020\nH\u0016J\u0017\u0010,\u001a\u0004\u0018\u00010\u00042\u0006\u0010*\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b-J\b\u0010.\u001a\u00020\u0010H\u0016J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00020\b0\u0003H\u0016R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/android/tools/lint/detector/api/ApiConstraint$MultiSdkApiConstraint;", "Lcom/android/tools/lint/detector/api/ApiConstraint;", "sdkConstraints", "", "Lcom/android/tools/lint/detector/api/ApiConstraint$SdkApiConstraints;", "<init>", "(Ljava/util/List;)V", "apis", "Lcom/android/tools/lint/detector/api/ApiConstraint$SdkApiConstraint;", "anyOf", "", "(Ljava/util/List;Z)V", "getSdkConstraints$android_sdktools_lint_api", "()Ljava/util/List;", "Lkotlin/sequences/Sequence;", "fromInclusive", "", "fromInclusiveMinor", "toExclusive", "toExclusiveMinor", "isAtLeast", "constraint", "includes", "apiLevel", "alwaysAtLeast", "minSdk", "everHigher", "firstMissing", "requirement", "not", "negatable", "asNonNegatable", "isEmpty", "or", "other", "and", "serialize", "", "toString", "sdkRegistry", "Lcom/android/tools/lint/detector/api/ExtensionSdkRegistry;", "findSdk", "sdkId", "certain", "findSdks", "findSdks$android_sdktools_lint_api", "getSdk", "getConstraints", "Companion", "android.sdktools.lint-api"})
    @SourceDebugExtension(value={"SMAP\nApiConstraint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiConstraint.kt\ncom/android/tools/lint/detector/api/ApiConstraint$MultiSdkApiConstraint\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1464:1\n1563#2:1465\n1634#2,3:1466\n295#2,2:1469\n295#2,2:1471\n295#2,2:1473\n295#2,2:1475\n295#2,2:1477\n295#2,2:1479\n1761#2,3:1481\n295#2,2:1484\n295#2,2:1486\n1761#2,3:1488\n1563#2:1491\n1634#2,3:1492\n1740#2,3:1495\n1563#2:1498\n1634#2,3:1499\n1740#2,3:1502\n1563#2:1505\n1634#2,3:1506\n1869#2,2:1509\n1617#2,9:1511\n1869#2:1520\n1870#2:1522\n1626#2:1523\n1617#2,9:1524\n1869#2:1533\n1870#2:1535\n1626#2:1536\n295#2,2:1537\n295#2,2:1539\n1563#2:1541\n1634#2,3:1542\n1#3:1521\n1#3:1534\n*S KotlinDebug\n*F\n+ 1 ApiConstraint.kt\ncom/android/tools/lint/detector/api/ApiConstraint$MultiSdkApiConstraint\n*L\n1086#1:1465\n1086#1:1466,3\n1095#1:1469,2\n1100#1:1471,2\n1105#1:1473,2\n1110#1:1475,2\n1122#1:1477,2\n1129#1:1479,2\n1153#1:1481,3\n1218#1:1484,2\n1230#1:1486,2\n1266#1:1488,3\n1277#1:1491\n1277#1:1492,3\n1282#1:1495,3\n1290#1:1498\n1290#1:1499,3\n1297#1:1502,3\n1314#1:1505\n1314#1:1506,3\n1324#1:1509,2\n1365#1:1511,9\n1365#1:1520\n1365#1:1522\n1365#1:1523\n1366#1:1524,9\n1366#1:1533\n1366#1:1535\n1366#1:1536\n1382#1:1537,2\n1387#1:1539,2\n1393#1:1541\n1393#1:1542,3\n1365#1:1521\n1366#1:1534\n*E\n"})
    public static final class MultiSdkApiConstraint
    extends ApiConstraint {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final List<SdkApiConstraints> sdkConstraints;
        @NotNull
        private final Sequence<SdkApiConstraint> apis;

        public MultiSdkApiConstraint(@NotNull List<SdkApiConstraints> sdkConstraints) {
            Intrinsics.checkNotNullParameter(sdkConstraints, (String)"sdkConstraints");
            super(null);
            this.sdkConstraints = sdkConstraints;
            this.apis = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.sdkConstraints), MultiSdkApiConstraint::apis$lambda$0);
        }

        @NotNull
        public final List<SdkApiConstraints> getSdkConstraints$android_sdktools_lint_api() {
            return this.sdkConstraints;
        }

        /*
         * WARNING - void declaration
         */
        public MultiSdkApiConstraint(@NotNull List<SdkApiConstraint> apis, boolean anyOf) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(apis, (String)"apis");
            Iterable iterable = apis;
            MultiSdkApiConstraint multiSdkApiConstraint = this;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SdkApiConstraint sdkApiConstraint = (SdkApiConstraint)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(anyOf ? new SdkApiConstraints(it.getSdkId(), null, (SdkApiConstraint)it) : new SdkApiConstraints(it.getSdkId(), (SdkApiConstraint)it, null));
            }
            multiSdkApiConstraint((List)destination$iv$iv);
        }

        @Override
        public int fromInclusive() {
            Object v0;
            block2: {
                Iterable $this$firstOrNull$iv = this.sdkConstraints;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    SdkApiConstraints it = (SdkApiConstraints)element$iv;
                    boolean bl = false;
                    if (!(it.getSdkId() == 0)) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            SdkApiConstraints sdkApiConstraints = v0;
            if (sdkApiConstraints == null) {
                return -1;
            }
            SdkApiConstraints constraint = sdkApiConstraints;
            return constraint.lowest().fromInclusive();
        }

        @Override
        public int fromInclusiveMinor() {
            Object v0;
            block2: {
                Iterable $this$firstOrNull$iv = this.sdkConstraints;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    SdkApiConstraints it = (SdkApiConstraints)element$iv;
                    boolean bl = false;
                    if (!(it.getSdkId() == 0)) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            SdkApiConstraints sdkApiConstraints = v0;
            if (sdkApiConstraints == null) {
                return -1;
            }
            SdkApiConstraints constraint = sdkApiConstraints;
            return constraint.lowest().fromInclusiveMinor();
        }

        @Override
        public int toExclusive() {
            Object v0;
            block2: {
                Iterable $this$firstOrNull$iv = this.sdkConstraints;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    SdkApiConstraints it = (SdkApiConstraints)element$iv;
                    boolean bl = false;
                    if (!(it.getSdkId() == 0)) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            SdkApiConstraints sdkApiConstraints = v0;
            if (sdkApiConstraints == null) {
                return -1;
            }
            SdkApiConstraints constraint = sdkApiConstraints;
            return constraint.highest().toExclusive();
        }

        @Override
        public int toExclusiveMinor() {
            Object v0;
            block2: {
                Iterable $this$firstOrNull$iv = this.sdkConstraints;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    SdkApiConstraints it = (SdkApiConstraints)element$iv;
                    boolean bl = false;
                    if (!(it.getSdkId() == 0)) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            SdkApiConstraints sdkApiConstraints = v0;
            if (sdkApiConstraints == null) {
                return -1;
            }
            SdkApiConstraints constraint = sdkApiConstraints;
            return constraint.highest().toExclusiveMinor();
        }

        @Override
        public boolean isAtLeast(@NotNull ApiConstraint constraint) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)constraint, (String)"constraint");
            boolean bl2 = bl = constraint != UNKNOWN;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            if (constraint.isEmpty()) {
                return true;
            }
            ApiConstraint apiConstraint = constraint;
            if (apiConstraint instanceof SdkApiConstraint) {
                SdkApiConstraints match;
                Object object;
                Object v1;
                block15: {
                    int sdkId = ((SdkApiConstraint)constraint).getSdkId();
                    Iterable $this$firstOrNull$iv = this.sdkConstraints;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        SdkApiConstraints it = (SdkApiConstraints)element$iv;
                        boolean bl3 = false;
                        if (!(it.getSdkId() == sdkId)) continue;
                        v1 = element$iv;
                        break block15;
                    }
                    v1 = null;
                }
                return (object = (match = (SdkApiConstraints)v1)) != null && (object = ((SdkApiConstraints)object).getAlways()) != null ? ((SdkApiConstraint)object).isAtLeast(constraint) : false;
            }
            if (apiConstraint instanceof MultiSdkApiConstraint) {
                boolean bl4;
                boolean anyMatch;
                block17: {
                    anyMatch = false;
                    for (SdkApiConstraints $this$firstOrNull$iv : ((MultiSdkApiConstraint)constraint).sdkConstraints) {
                        Object v3;
                        SdkApiConstraint mightNeed;
                        SdkApiConstraint alwaysNeed;
                        block16: {
                            int sdkId = $this$firstOrNull$iv.component1();
                            alwaysNeed = $this$firstOrNull$iv.component2();
                            mightNeed = $this$firstOrNull$iv.component3();
                            Iterable $this$firstOrNull$iv2 = this.sdkConstraints;
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv : $this$firstOrNull$iv2) {
                                SdkApiConstraints it = (SdkApiConstraints)element$iv;
                                boolean bl5 = false;
                                if (!(it.getSdkId() == sdkId)) continue;
                                v3 = element$iv;
                                break block16;
                            }
                            v3 = null;
                        }
                        SdkApiConstraints match = v3;
                        if (alwaysNeed != null) {
                            Object object = match;
                            if (object == null || (object = ((SdkApiConstraints)object).getAlways()) == null) {
                                return false;
                            }
                            Object alwaysHave = object;
                            if (!((SdkApiConstraint)alwaysHave).isAtLeast(alwaysNeed)) {
                                return false;
                            }
                            anyMatch = true;
                            continue;
                        }
                        if (mightNeed != null) {
                            if (match == null || anyMatch) continue;
                            SdkApiConstraints sdkApiConstraints = match;
                            SdkApiConstraint alwaysHave = sdkApiConstraints.component2();
                            SdkApiConstraint sometimesHave = sdkApiConstraints.component3();
                            if ((alwaysHave == null || !alwaysHave.isAtLeast(mightNeed)) && (sometimesHave == null || !sometimesHave.isAtLeast(mightNeed))) continue;
                            anyMatch = true;
                            continue;
                        }
                        throw new IllegalStateException();
                    }
                    Iterable $this$any$iv = this.sdkConstraints;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl4 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            SdkApiConstraints it = (SdkApiConstraints)element$iv;
                            boolean bl6 = false;
                            if (!(it.getSometimes() != null && ((MultiSdkApiConstraint)constraint).findSdks$android_sdktools_lint_api(it.getSdkId()) == null)) continue;
                            bl4 = true;
                            break block17;
                        }
                        bl4 = false;
                    }
                }
                if (bl4) {
                    return false;
                }
                return anyMatch;
            }
            throw new NoWhenBranchMatchedException();
        }

        @Override
        public boolean includes(int apiLevel) {
            for (SdkApiConstraint api2 : this.apis) {
                if (!api2.includes(apiLevel)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean alwaysAtLeast(int apiLevel) {
            for (SdkApiConstraint api2 : this.apis) {
                if (!api2.alwaysAtLeast(apiLevel)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean alwaysAtLeast(@NotNull ApiConstraint minSdk) {
            Intrinsics.checkNotNullParameter((Object)minSdk, (String)"minSdk");
            ApiConstraint apiConstraint = minSdk;
            if (apiConstraint instanceof SdkApiConstraint) {
                SdkApiConstraint sdkApiConstraint = ApiConstraint.findSdk$default(this, ((SdkApiConstraint)minSdk).getSdkId(), false, 2, null);
                if (sdkApiConstraint == null) {
                    return false;
                }
                SdkApiConstraint sdk = sdkApiConstraint;
                return sdk.alwaysAtLeast(minSdk);
            }
            if (apiConstraint instanceof MultiSdkApiConstraint) {
                for (SdkApiConstraint api2 : this.apis) {
                    SdkApiConstraint match = ApiConstraint.findSdk$default(minSdk, api2.getSdkId(), false, 2, null);
                    if (match == null || !api2.alwaysAtLeast(match)) continue;
                    return true;
                }
                return false;
            }
            throw new NoWhenBranchMatchedException();
        }

        @Override
        public boolean everHigher(int apiLevel) {
            for (SdkApiConstraint api2 : this.apis) {
                if (!api2.everHigher(apiLevel)) continue;
                return true;
            }
            return false;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        @Nullable
        public SdkApiConstraint firstMissing(@NotNull ApiConstraint requirement) {
            block21: {
                block20: {
                    Intrinsics.checkNotNullParameter((Object)requirement, (String)"requirement");
                    if (requirement.isEmpty()) {
                        return null;
                    }
                    var2_2 = requirement;
                    if (var2_2 instanceof SdkApiConstraint) {
                        block18: {
                            sdkId = ((SdkApiConstraint)requirement).getSdkId();
                            $this$firstOrNull$iv = this.sdkConstraints;
                            $i$f$firstOrNull = false;
                            for (T element$iv : $this$firstOrNull$iv) {
                                it = (SdkApiConstraints)element$iv;
                                $i$a$-firstOrNull-ApiConstraint$MultiSdkApiConstraint$firstMissing$match$1 = false;
                                if (!(it.getSdkId() == sdkId)) continue;
                                v0 = element$iv;
                                break block18;
                            }
                            v0 = null;
                        }
                        return ((v1 = (match = (SdkApiConstraints)v0)) != null && (v1 = v1.getAlways()) != null ? v1.isAtLeast(requirement) : false) != false ? null : (SdkApiConstraint)requirement;
                    }
                    if (!(var2_2 instanceof MultiSdkApiConstraint)) break block21;
                    anyMatch = false;
                    firstMissing = null;
                    for (SdkApiConstraints $i$f$firstOrNull : ((MultiSdkApiConstraint)requirement).sdkConstraints) {
                        block19: {
                            sdkId = $i$f$firstOrNull.component1();
                            alwaysNeed = $i$f$firstOrNull.component2();
                            mightNeed = $i$f$firstOrNull.component3();
                            $this$firstOrNull$iv = this.sdkConstraints;
                            $i$f$firstOrNull = false;
                            for (T element$iv : $this$firstOrNull$iv) {
                                it = (SdkApiConstraints)element$iv;
                                $i$a$-firstOrNull-ApiConstraint$MultiSdkApiConstraint$firstMissing$sdkMatch$1 = false;
                                if (!(it.getSdkId() == sdkId)) continue;
                                v2 = element$iv;
                                break block19;
                            }
                            v2 = null;
                        }
                        sdkMatch = v2;
                        if (sdkMatch == null) ** GOTO lbl-1000
                        v3 = alwaysNeed;
                        if (v3 == null) {
                            v4 = mightNeed;
                            v3 = v4;
                            Intrinsics.checkNotNull((Object)v4);
                        }
                        if (v3.isAtLeast(sdkMatch.highest())) {
                            v5 = null;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v5 = match = sdkMatch;
                        }
                        if (alwaysNeed != null) {
                            v6 = sdkMatch;
                            if (v6 == null || (v6 = v6.getAlways()) == null) {
                                return alwaysNeed;
                            }
                            alwaysHave = v6;
                            if (!alwaysHave.isAtLeast(alwaysNeed)) {
                                return alwaysNeed;
                            }
                            anyMatch = true;
                            continue;
                        }
                        if (mightNeed != null) {
                            if (match == null && firstMissing == null) {
                                firstMissing = mightNeed;
                            }
                            if (anyMatch || match == null) continue;
                            var12_25 = match;
                            alwaysHave = var12_25.component2();
                            sometimesHave = var12_25.component3();
                            if (alwaysHave != null && alwaysHave.isAtLeast(mightNeed) || sometimesHave != null && sometimesHave.isAtLeast(mightNeed)) {
                                anyMatch = true;
                                continue;
                            }
                            if (firstMissing != null) continue;
                            firstMissing = mightNeed;
                            continue;
                        }
                        throw new IllegalStateException();
                    }
                    $this$any$iv = this.sdkConstraints;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v7 = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            it = (SdkApiConstraints)element$iv;
                            $i$a$-any-ApiConstraint$MultiSdkApiConstraint$firstMissing$1 = false;
                            if (!(it.getSometimes() != null && ((MultiSdkApiConstraint)requirement).findSdks$android_sdktools_lint_api(it.getSdkId()) == null)) continue;
                            v7 = true;
                            break block20;
                        }
                        v7 = false;
                    }
                }
                if (v7) {
                    return firstMissing;
                }
                return anyMatch != false ? null : firstMissing;
            }
            throw new NoWhenBranchMatchedException();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public ApiConstraint not() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.sdkConstraints;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SdkApiConstraints sdkApiConstraints = (SdkApiConstraints)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                SdkApiConstraint sdkApiConstraint = it.getSometimes();
                SdkApiConstraint sdkApiConstraint2 = it.getAlways();
                collection.add(new SdkApiConstraints(it.getSdkId(), sdkApiConstraint != null ? sdkApiConstraint.not() : null, sdkApiConstraint2 != null ? sdkApiConstraint2.not() : null));
            }
            List reversed = (List)destination$iv$iv;
            return new MultiSdkApiConstraint(reversed);
        }

        @Override
        public boolean negatable() {
            boolean bl;
            block5: {
                Iterable $this$all$iv = this.sdkConstraints;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        boolean bl2;
                        SdkApiConstraints it = (SdkApiConstraints)element$iv;
                        boolean bl3 = false;
                        SdkApiConstraint sdkApiConstraint = it.getAlways();
                        if (sdkApiConstraint != null) {
                            bl2 = sdkApiConstraint.negatable();
                        } else {
                            SdkApiConstraint sdkApiConstraint2 = it.getSometimes();
                            bl2 = sdkApiConstraint2 != null ? sdkApiConstraint2.negatable() : true;
                        }
                        if (bl2) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public ApiConstraint asNonNegatable() {
            void $this$mapTo$iv$iv;
            if (!this.negatable()) {
                return this;
            }
            Iterable $this$map$iv = this.sdkConstraints;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SdkApiConstraints sdkApiConstraints = (SdkApiConstraints)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                SdkApiConstraint sdkApiConstraint = it.getAlways();
                SdkApiConstraint sdkApiConstraint2 = it.getSometimes();
                collection.add(new SdkApiConstraints(it.getSdkId(), sdkApiConstraint != null ? sdkApiConstraint.asNonNegatable() : null, sdkApiConstraint2 != null ? sdkApiConstraint2.asNonNegatable() : null));
            }
            List reversed = (List)destination$iv$iv;
            return new MultiSdkApiConstraint(reversed);
        }

        @Override
        public boolean isEmpty() {
            boolean bl;
            block3: {
                Iterable $this$all$iv = this.sdkConstraints;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        SdkApiConstraints it = (SdkApiConstraints)element$iv;
                        boolean bl2 = false;
                        if (it.lowest().isEmpty()) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public ApiConstraint or(@Nullable ApiConstraint other) {
            boolean bl;
            boolean bl2 = bl = other != UNKNOWN;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            if (other == null) {
                return this;
            }
            ApiConstraint apiConstraint = other;
            if (apiConstraint instanceof SdkApiConstraint) {
                return ((SdkApiConstraint)other).or(this);
            }
            if (apiConstraint instanceof MultiSdkApiConstraint) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = this.sdkConstraints;
                boolean $i$f$map = false;
                Iterator iterator = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    SdkApiConstraints sdkApiConstraints = (SdkApiConstraints)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    SdkApiConstraints match = ((MultiSdkApiConstraint)other).findSdks$android_sdktools_lint_api(it.getSdkId());
                    collection.add(match != null ? match.or((SdkApiConstraints)it) : it);
                }
                List apis = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
                Iterable $this$forEach$iv = ((MultiSdkApiConstraint)other).sdkConstraints;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SdkApiConstraints it = (SdkApiConstraints)element$iv;
                    boolean bl4 = false;
                    if (this.findSdks$android_sdktools_lint_api(it.getSdkId()) != null) continue;
                    apis.add(it);
                }
                return new MultiSdkApiConstraint(apis);
            }
            throw new NoWhenBranchMatchedException();
        }

        @Override
        @NotNull
        public ApiConstraint and(@Nullable ApiConstraint other) {
            boolean bl;
            boolean bl2 = bl = other != UNKNOWN;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            if (other == null) {
                return this;
            }
            ApiConstraint apiConstraint = other;
            if (apiConstraint instanceof SdkApiConstraint) {
                return ((SdkApiConstraint)other).and(this);
            }
            if (apiConstraint instanceof MultiSdkApiConstraint) {
                List anded = new ArrayList();
                for (SdkApiConstraint api2 : this.apis) {
                    SdkApiConstraint match = ApiConstraint.findSdk$default(other, api2.getSdkId(), false, 2, null);
                    if (match == null) continue;
                    anded.add(new SdkApiConstraint(api2.getIntervals().and(match.getIntervals()), api2.getSdkId(), false, 4, null));
                }
                return Companion.create(anded, false);
            }
            throw new NoWhenBranchMatchedException();
        }

        @Override
        @NotNull
        public String serialize() {
            return "{" + CollectionsKt.joinToString$default((Iterable)this.sdkConstraints, (CharSequence)",", null, null, (int)0, null, MultiSdkApiConstraint::serialize$lambda$0, (int)30, null) + "}";
        }

        @Override
        @NotNull
        public String toString() {
            return this.toString(null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String toString(@Nullable ExtensionSdkRegistry sdkRegistry) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNullTo$iv$iv2;
            Iterable $this$mapNotNull$iv = this.sdkConstraints;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Iterable<SdkApiConstraint> destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                SdkApiConstraint it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                SdkApiConstraints it = (SdkApiConstraints)element$iv$iv;
                boolean bl2 = false;
                if (it.getAlways() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List andItems = (List)destination$iv$iv;
            Iterable $this$mapNotNull$iv2 = this.sdkConstraints;
            boolean $i$f$mapNotNull2 = false;
            destination$iv$iv = $this$mapNotNull$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                SdkApiConstraint it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                SdkApiConstraints it = (SdkApiConstraints)element$iv$iv;
                boolean bl4 = false;
                if (it.getSometimes() == null) continue;
                boolean bl5 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List orItems = (List)destination$iv$iv2;
            String andString = CollectionsKt.joinToString$default((Iterable)andItems, (CharSequence)" and ", null, null, (int)0, null, arg_0 -> MultiSdkApiConstraint.toString$lambda$2(sdkRegistry, arg_0), (int)30, null);
            String orString = CollectionsKt.joinToString$default((Iterable)orItems, (CharSequence)" or ", null, null, (int)0, null, arg_0 -> MultiSdkApiConstraint.toString$lambda$3(sdkRegistry, arg_0), (int)30, null);
            return !((Collection)andItems).isEmpty() ? (!((Collection)orItems).isEmpty() ? (orItems.size() == 1 ? andString + " and optionally " + orString : andString + " and any of (" + orString + ")") : andString) : orString;
        }

        @Override
        @Nullable
        public SdkApiConstraint findSdk(int sdkId, boolean certain) {
            Object v0;
            block2: {
                Iterable $this$firstOrNull$iv = this.sdkConstraints;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    SdkApiConstraints it = (SdkApiConstraints)element$iv;
                    boolean bl = false;
                    if (!(it.getSdkId() == sdkId)) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            SdkApiConstraints sdkApiConstraints = v0;
            if (sdkApiConstraints == null) {
                return null;
            }
            SdkApiConstraints sdkConstraints = sdkApiConstraints;
            return certain ? sdkConstraints.getAlways() : sdkConstraints.lowest();
        }

        @Nullable
        public final SdkApiConstraints findSdks$android_sdktools_lint_api(int sdkId) {
            Object v0;
            block1: {
                Iterable $this$firstOrNull$iv = this.sdkConstraints;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    SdkApiConstraints it = (SdkApiConstraints)element$iv;
                    boolean bl = false;
                    if (!(it.getSdkId() == sdkId)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        @Override
        public int getSdk() {
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<SdkApiConstraint> getConstraints() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.sdkConstraints;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SdkApiConstraints sdkApiConstraints = (SdkApiConstraints)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.lowest());
            }
            return (List)destination$iv$iv;
        }

        private static final SdkApiConstraint apis$lambda$0(SdkApiConstraints it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.lowest();
        }

        private static final CharSequence serialize$lambda$0(SdkApiConstraints it) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Object object2 = it.getAlways();
            if (object2 == null || (object2 = ((SdkApiConstraint)object2).serialize()) == null) {
                object2 = "";
            }
            if ((object = it.getSometimes()) == null || (object = ((SdkApiConstraint)object).serialize()) == null) {
                object = "";
            }
            return (String)object2 + ":" + (String)object;
        }

        private static final CharSequence toString$lambda$2(ExtensionSdkRegistry $sdkRegistry, SdkApiConstraint it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.toString($sdkRegistry);
        }

        private static final CharSequence toString$lambda$3(ExtensionSdkRegistry $sdkRegistry, SdkApiConstraint it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.toString($sdkRegistry);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u0004\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\t\u001a\u00020\nJ\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\r\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/detector/api/ApiConstraint$MultiSdkApiConstraint$Companion;", "", "<init>", "()V", "create", "Lcom/android/tools/lint/detector/api/ApiConstraint;", "apis", "", "Lcom/android/tools/lint/detector/api/ApiConstraint$SdkApiConstraint;", "anyOf", "", "Lcom/android/tools/lint/detector/api/ApiConstraint$MultiSdkApiConstraint;", "description", "", "describe", "constraint", "deserialize", "s", "android.sdktools.lint-api"})
        @SourceDebugExtension(value={"SMAP\nApiConstraint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiConstraint.kt\ncom/android/tools/lint/detector/api/ApiConstraint$MultiSdkApiConstraint$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1464:1\n1563#2:1465\n1634#2,3:1466\n1563#2:1469\n1634#2,3:1470\n*S KotlinDebug\n*F\n+ 1 ApiConstraint.kt\ncom/android/tools/lint/detector/api/ApiConstraint$MultiSdkApiConstraint$Companion\n*L\n1413#1:1465\n1413#1:1466,3\n1442#1:1469\n1442#1:1470,3\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ApiConstraint create(@NotNull List<SdkApiConstraint> apis, boolean anyOf) {
                ApiConstraint apiConstraint;
                Intrinsics.checkNotNullParameter(apis, (String)"apis");
                if (apis.size() == 1) {
                    apiConstraint = apis.get(0);
                } else {
                    if (apis.isEmpty()) {
                        return NONE;
                    }
                    apiConstraint = new MultiSdkApiConstraint(apis, anyOf);
                }
                return apiConstraint;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final MultiSdkApiConstraint create(@NotNull String description, boolean anyOf) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)description, (String)"description");
                String[] stringArray = new String[]{","};
                Iterable $this$map$iv = StringsKt.split$default((CharSequence)description, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void s;
                    String string2 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    int index2 = StringsKt.indexOf$default((CharSequence)((CharSequence)s), (char)':', (int)0, (boolean)false, (int)6, null);
                    if (index2 == -1) {
                        throw new IllegalStateException(("Invalid extension constraint descriptor " + (String)s + " (in " + description + ")").toString());
                    }
                    String string3 = s.substring(index2 + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    int apiLevel = Integer.parseInt(string3);
                    String string4 = s.substring(0, index2);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                    int sdk = Integer.parseInt(string4);
                    collection.add(sdk == 0 ? com.android.tools.lint.detector.api.ApiConstraint$Companion.get$default(ApiConstraint.Companion, apiLevel, 0, 2, null) : SdkApiConstraint.Companion.createConstraint$default(SdkApiConstraint.Companion, apiLevel, null, sdk, 2, null));
                }
                List constraints = (List)destination$iv$iv;
                return new MultiSdkApiConstraint(constraints, anyOf);
            }

            public static /* synthetic */ MultiSdkApiConstraint create$default(Companion companion, String string2, boolean bl, int n, Object object) {
                if ((n & 2) != 0) {
                    bl = true;
                }
                return companion.create(string2, bl);
            }

            @NotNull
            public final String describe(@NotNull ApiConstraint constraint) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)constraint, (String)"constraint");
                ApiConstraint apiConstraint = constraint;
                if (apiConstraint instanceof SdkApiConstraint) {
                    object = "0:" + constraint.minString();
                } else if (apiConstraint instanceof MultiSdkApiConstraint) {
                    object = CollectionsKt.joinToString$default((Iterable)((MultiSdkApiConstraint)constraint).getSdkConstraints$android_sdktools_lint_api(), (CharSequence)",", null, null, (int)0, null, Companion::describe$lambda$0, (int)30, null);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return object;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ApiConstraint deserialize(@NotNull String s) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                String[] stringArray = new String[]{","};
                Iterable $this$map$iv = StringsKt.split$default((CharSequence)StringsKt.removeSurrounding((String)s, (CharSequence)"{", (CharSequence)"}"), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    int n;
                    SdkApiConstraint sdkApiConstraint;
                    SdkApiConstraint always;
                    void t;
                    String string2 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    int index2 = StringsKt.indexOf$default((CharSequence)((CharSequence)t), (char)':', (int)0, (boolean)false, (int)6, null);
                    if (index2 > 0) {
                        String string3 = t.substring(0, index2);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                        v1 = SdkApiConstraint.Companion.deserialize(string3);
                    } else {
                        v1 = always = null;
                    }
                    if (index2 < t.length() - 1) {
                        String string4 = t.substring(index2 + 1);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                        sdkApiConstraint = SdkApiConstraint.Companion.deserialize(string4);
                    } else {
                        sdkApiConstraint = null;
                    }
                    SdkApiConstraint sometimes = sdkApiConstraint;
                    SdkApiConstraint sdkApiConstraint2 = always;
                    if (sdkApiConstraint2 != null) {
                        n = sdkApiConstraint2.getSdkId();
                    } else {
                        SdkApiConstraint sdkApiConstraint3 = sometimes;
                        Intrinsics.checkNotNull((Object)sdkApiConstraint3);
                        n = sdkApiConstraint3.getSdkId();
                    }
                    collection.add(new SdkApiConstraints(n, always, sometimes));
                }
                List apis = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                return new MultiSdkApiConstraint(apis);
            }

            private static final CharSequence describe$lambda$0(SdkApiConstraints it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getSdkId() + ":" + it.lowest().minString();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u001d\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 .2\u00020\u0001:\u0001.B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u0005H\u0016J\b\u0010\u000f\u001a\u00020\u0005H\u0016J\b\u0010\u0010\u001a\u00020\u0005H\u0016J\b\u0010\u0011\u001a\u00020\u0005H\u0016J\u0006\u0010\u0012\u001a\u00020\u0007J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0001H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0016\u001a\u00020\u0001H\u0016J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0001H\u0016J\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\t\u0010\u001c\u001a\u00020\u0000H\u0096\u0002J\b\u0010\u001d\u001a\u00020\u0007H\u0016J\b\u0010\u001e\u001a\u00020\u0000H\u0016J\b\u0010\u001f\u001a\u00020\u0007H\u0016J\u0006\u0010 \u001a\u00020\u0007J\u0013\u0010!\u001a\u00020\u00012\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u0096\u0004J\u0013\u0010#\u001a\u00020\u00002\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u0096\u0004J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020%H\u0016J\u0012\u0010&\u001a\u00020%2\b\u0010'\u001a\u0004\u0018\u00010(H\u0016J\u001a\u0010)\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u0007H\u0016J\b\u0010+\u001a\u00020\u0005H\u0016J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00000-H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/android/tools/lint/detector/api/ApiConstraint$SdkApiConstraint;", "Lcom/android/tools/lint/detector/api/ApiConstraint;", "intervals", "Lcom/android/tools/lint/detector/api/Intervals;", "sdkId", "", "isNegatable", "", "<init>", "(Lcom/android/tools/lint/detector/api/Intervals;IZ)V", "getIntervals", "()Lcom/android/tools/lint/detector/api/Intervals;", "getSdkId", "()I", "fromInclusive", "fromInclusiveMinor", "toExclusive", "toExclusiveMinor", "isOpenEnded", "isAtLeast", "constraint", "firstMissing", "requirement", "apiLevel", "includes", "alwaysAtLeast", "minSdk", "everHigher", "not", "negatable", "asNonNegatable", "isEmpty", "isNotEmpty", "or", "other", "and", "serialize", "", "toString", "sdkRegistry", "Lcom/android/tools/lint/detector/api/ExtensionSdkRegistry;", "findSdk", "certain", "getSdk", "getConstraints", "", "Companion", "android.sdktools.lint-api"})
    @SourceDebugExtension(value={"SMAP\nApiConstraint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiConstraint.kt\ncom/android/tools/lint/detector/api/ApiConstraint$SdkApiConstraint\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1464:1\n1563#2:1465\n1634#2,3:1466\n*S KotlinDebug\n*F\n+ 1 ApiConstraint.kt\ncom/android/tools/lint/detector/api/ApiConstraint$SdkApiConstraint\n*L\n805#1:1465\n805#1:1466,3\n*E\n"})
    public static final class SdkApiConstraint
    extends ApiConstraint {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Intervals intervals;
        private final int sdkId;
        private final boolean isNegatable;
        @NotNull
        private static final SdkApiConstraint NO_LEVELS = new SdkApiConstraint(Intervals.Companion.getNONE(), -1, false, 4, null);

        public SdkApiConstraint(@NotNull Intervals intervals, int sdkId, boolean isNegatable) {
            Intrinsics.checkNotNullParameter((Object)intervals, (String)"intervals");
            super(null);
            this.intervals = intervals;
            this.sdkId = sdkId;
            this.isNegatable = isNegatable;
        }

        public /* synthetic */ SdkApiConstraint(Intervals intervals, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            if ((n2 & 4) != 0) {
                bl = true;
            }
            this(intervals, n, bl);
        }

        @NotNull
        public final Intervals getIntervals() {
            return this.intervals;
        }

        public final int getSdkId() {
            return this.sdkId;
        }

        @Override
        public int fromInclusive() {
            return this.intervals.fromInclusive();
        }

        @Override
        public int fromInclusiveMinor() {
            return this.intervals.fromInclusiveMinor();
        }

        @Override
        public int toExclusive() {
            return this.intervals.toExclusive();
        }

        @Override
        public int toExclusiveMinor() {
            return this.intervals.toExclusiveMinor();
        }

        public final boolean isOpenEnded() {
            return this.toExclusive() == Integer.MAX_VALUE;
        }

        @Override
        public boolean isAtLeast(@NotNull ApiConstraint constraint) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)constraint, (String)"constraint");
            boolean bl2 = bl = this != UNKNOWN && constraint != UNKNOWN;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            if (this.intervals.isEmpty()) {
                return true;
            }
            ApiConstraint apiConstraint = constraint;
            if (apiConstraint instanceof SdkApiConstraint) {
                return this.sdkId == ((SdkApiConstraint)constraint).sdkId && this.intervals.isAtLeast(((SdkApiConstraint)constraint).intervals);
            }
            if (apiConstraint instanceof MultiSdkApiConstraint) {
                boolean anyMatch = false;
                for (SdkApiConstraints sdkApiConstraints : ((MultiSdkApiConstraint)constraint).getSdkConstraints$android_sdktools_lint_api()) {
                    SdkApiConstraint alwaysNeed = sdkApiConstraints.component2();
                    SdkApiConstraint mightNeed = sdkApiConstraints.component3();
                    if (alwaysNeed != null) {
                        if (!this.isAtLeast(alwaysNeed)) {
                            return false;
                        }
                        anyMatch = true;
                        continue;
                    }
                    if (mightNeed != null) {
                        if (anyMatch || !this.isAtLeast(mightNeed)) continue;
                        anyMatch = true;
                        continue;
                    }
                    throw new IllegalStateException();
                }
                return anyMatch;
            }
            throw new NoWhenBranchMatchedException();
        }

        @Override
        @Nullable
        public SdkApiConstraint firstMissing(@NotNull ApiConstraint requirement) {
            Intrinsics.checkNotNullParameter((Object)requirement, (String)"requirement");
            ApiConstraint apiConstraint = requirement;
            if (apiConstraint instanceof SdkApiConstraint) {
                return (SdkApiConstraint)requirement;
            }
            if (apiConstraint instanceof MultiSdkApiConstraint) {
                SdkApiConstraint sdkApiConstraint;
                boolean anyMatch = false;
                SdkApiConstraint firstMissing = null;
                for (SdkApiConstraints sdkApiConstraints : ((MultiSdkApiConstraint)requirement).getSdkConstraints$android_sdktools_lint_api()) {
                    SdkApiConstraint alwaysNeed = sdkApiConstraints.component2();
                    SdkApiConstraint mightNeed = sdkApiConstraints.component3();
                    if (alwaysNeed != null) {
                        if (!this.isAtLeast(alwaysNeed)) {
                            return alwaysNeed;
                        }
                        anyMatch = true;
                        continue;
                    }
                    if (mightNeed != null) {
                        if (anyMatch) continue;
                        if (this.isAtLeast(mightNeed)) {
                            anyMatch = true;
                            continue;
                        }
                        if (firstMissing != null) continue;
                        firstMissing = mightNeed;
                        continue;
                    }
                    throw new IllegalStateException();
                }
                if (anyMatch) {
                    sdkApiConstraint = null;
                } else {
                    sdkApiConstraint = firstMissing;
                    if (sdkApiConstraint == null) {
                        sdkApiConstraint = ((SdkApiConstraints)CollectionsKt.first(((MultiSdkApiConstraint)requirement).getSdkConstraints$android_sdktools_lint_api())).lowest();
                    }
                }
                return sdkApiConstraint;
            }
            throw new NoWhenBranchMatchedException();
        }

        @Override
        public boolean isAtLeast(int apiLevel) {
            boolean bl;
            boolean bl2 = bl = this != UNKNOWN;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            return this.sdkId == 0 && this.intervals.isAtLeast(Intervals.Companion.atLeast$default(Intervals.Companion, apiLevel, 0, 2, null));
        }

        @Override
        public boolean includes(int apiLevel) {
            return this.intervals.contains(apiLevel);
        }

        @Override
        public boolean alwaysAtLeast(int apiLevel) {
            return this.intervals.alwaysAtLeast(apiLevel);
        }

        @Override
        public boolean alwaysAtLeast(@NotNull ApiConstraint minSdk) {
            Intrinsics.checkNotNullParameter((Object)minSdk, (String)"minSdk");
            ApiConstraint apiConstraint = minSdk;
            if (apiConstraint instanceof SdkApiConstraint) {
                boolean bl;
                if (Intrinsics.areEqual((Object)minSdk, (Object)NONE) || Intrinsics.areEqual((Object)this, (Object)NONE)) {
                    return true;
                }
                boolean bl2 = bl = this.sdkId == ((SdkApiConstraint)minSdk).sdkId;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                return this.intervals.alwaysAtLeast(((SdkApiConstraint)minSdk).intervals);
            }
            if (apiConstraint instanceof MultiSdkApiConstraint) {
                SdkApiConstraint sdkApiConstraint = ApiConstraint.findSdk$default(minSdk, this.sdkId, false, 2, null);
                if (sdkApiConstraint == null) {
                    return false;
                }
                SdkApiConstraint sdk = sdkApiConstraint;
                return this.alwaysAtLeast(sdk);
            }
            throw new NoWhenBranchMatchedException();
        }

        @Override
        public boolean everHigher(int apiLevel) {
            return this.intervals.everHigher(apiLevel);
        }

        @Override
        @NotNull
        public SdkApiConstraint not() {
            if (!this.isNegatable) {
                return new SdkApiConstraint(Intervals.Companion.getNONE(), this.sdkId, false, 4, null);
            }
            if (Intrinsics.areEqual((Object)this, (Object)NONE)) {
                return ALL;
            }
            if (Intrinsics.areEqual((Object)this, (Object)ALL)) {
                return NONE;
            }
            return new SdkApiConstraint(this.intervals.not(), this.sdkId, false, 4, null);
        }

        @Override
        public boolean negatable() {
            return this.isNegatable;
        }

        @Override
        @NotNull
        public SdkApiConstraint asNonNegatable() {
            if (!this.negatable()) {
                return this;
            }
            return new SdkApiConstraint(this.intervals, this.sdkId, false);
        }

        @Override
        public boolean isEmpty() {
            return this.intervals.isEmpty();
        }

        public final boolean isNotEmpty() {
            return this.intervals.isNotEmpty();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public ApiConstraint or(@Nullable ApiConstraint other) {
            boolean bl;
            boolean bl2 = bl = this != UNKNOWN && other != UNKNOWN;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            ApiConstraint apiConstraint = other;
            if (apiConstraint == null) {
                return this;
            }
            if (apiConstraint instanceof SdkApiConstraint) {
                if (((SdkApiConstraint)other).isEmpty()) {
                    return this;
                }
                if (this.sdkId != ((SdkApiConstraint)other).sdkId) {
                    if (this.isEmpty()) {
                        return other;
                    }
                    Object[] objectArray = new SdkApiConstraints[]{new SdkApiConstraints(this.sdkId, null, this), new SdkApiConstraints(((SdkApiConstraint)other).sdkId, null, (SdkApiConstraint)other)};
                    return new MultiSdkApiConstraint(CollectionsKt.listOf((Object[])objectArray));
                }
                return new SdkApiConstraint(this.intervals.or(((SdkApiConstraint)other).intervals), this.sdkId, false, 4, null);
            }
            if (apiConstraint instanceof MultiSdkApiConstraint) {
                void $this$mapTo$iv$iv;
                if (this.isEmpty()) {
                    return other;
                }
                if (((MultiSdkApiConstraint)other).isEmpty()) {
                    return this;
                }
                Iterable $this$map$iv = ((MultiSdkApiConstraint)other).getSdkConstraints$android_sdktools_lint_api();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    SdkApiConstraints sdkApiConstraints = (SdkApiConstraints)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(it.getSdkId() == this.sdkId ? it.orWith(this, true) : it);
                }
                List list2 = (List)destination$iv$iv;
                List mergedList = ApiConstraint.findSdk$default(other, this.sdkId, false, 2, null) != null ? list2 : CollectionsKt.plus((Collection)list2, (Object)new SdkApiConstraints(this.sdkId, null, this));
                return new MultiSdkApiConstraint(mergedList);
            }
            throw new NoWhenBranchMatchedException();
        }

        @Override
        @NotNull
        public SdkApiConstraint and(@Nullable ApiConstraint other) {
            boolean bl;
            boolean bl2 = bl = this != UNKNOWN && other != UNKNOWN;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            if (this.isEmpty() || other != null && other.isEmpty()) {
                return NONE;
            }
            ApiConstraint apiConstraint = other;
            if (apiConstraint == null) {
                return this;
            }
            if (apiConstraint instanceof SdkApiConstraint) {
                if (this.sdkId != ((SdkApiConstraint)other).sdkId) {
                    return NONE;
                }
                return new SdkApiConstraint(this.intervals.and(((SdkApiConstraint)other).intervals), this.sdkId, false, 4, null);
            }
            if (apiConstraint instanceof MultiSdkApiConstraint) {
                SdkApiConstraint sdkApiConstraint = ApiConstraint.findSdk$default(other, this.sdkId, false, 2, null);
                if (sdkApiConstraint == null) {
                    return NONE;
                }
                SdkApiConstraint match = sdkApiConstraint;
                return new SdkApiConstraint(this.intervals.and(match.intervals), this.sdkId, false, 4, null);
            }
            throw new NoWhenBranchMatchedException();
        }

        @Override
        @NotNull
        public String serialize() {
            String s = this.intervals.serialize();
            return this.sdkId == 0 ? s : s + ";" + this.sdkId;
        }

        @Override
        @NotNull
        public String toString() {
            String desc = this.sdkId == 0 ? "API level" : "version";
            return this.intervals.toString(desc, false);
        }

        @Override
        @NotNull
        public String toString(@Nullable ExtensionSdkRegistry sdkRegistry) {
            Object object = sdkRegistry;
            Comparable sdk = object != null && (object = ((ExtensionSdkRegistry)object).find(this.sdkId)) != null ? (Comparable)object : (Comparable)((Object)("SDK " + this.sdkId));
            String constraintString = this.toString();
            return this.sdkId == 0 ? constraintString : sdk + ": " + constraintString;
        }

        @Override
        @Nullable
        public SdkApiConstraint findSdk(int sdkId, boolean certain) {
            return sdkId == this.sdkId ? this : null;
        }

        @Override
        public int getSdk() {
            return this.sdkId;
        }

        @Override
        @NotNull
        public List<SdkApiConstraint> getConstraints() {
            return CollectionsKt.listOf((Object)this);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\b\u001a\u00020\u00052\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\f\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJE\u0010\b\u001a\u00020\u00052\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\f\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005J\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/lint/detector/api/ApiConstraint$SdkApiConstraint$Companion;", "", "<init>", "()V", "NO_LEVELS", "Lcom/android/tools/lint/detector/api/ApiConstraint$SdkApiConstraint;", "getNO_LEVELS", "()Lcom/android/tools/lint/detector/api/ApiConstraint$SdkApiConstraint;", "createConstraint", "fromInclusive", "", "toExclusive", "sdkId", "(Ljava/lang/Integer;Ljava/lang/Integer;I)Lcom/android/tools/lint/detector/api/ApiConstraint$SdkApiConstraint;", "fromInclusiveMinor", "toExclusiveMinor", "(Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;I)Lcom/android/tools/lint/detector/api/ApiConstraint$SdkApiConstraint;", "serialize", "", "constraint", "deserialize", "s", "android.sdktools.lint-api"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final SdkApiConstraint getNO_LEVELS() {
                return NO_LEVELS;
            }

            @NotNull
            public final SdkApiConstraint createConstraint(@Nullable Integer fromInclusive, @Nullable Integer toExclusive, int sdkId) {
                return this.createConstraint(fromInclusive, null, toExclusive, null, sdkId);
            }

            public static /* synthetic */ SdkApiConstraint createConstraint$default(Companion companion, Integer n, Integer n2, int n3, int n4, Object object) {
                if ((n4 & 1) != 0) {
                    n = null;
                }
                if ((n4 & 2) != 0) {
                    n2 = null;
                }
                if ((n4 & 4) != 0) {
                    n3 = 0;
                }
                return companion.createConstraint(n, n2, n3);
            }

            @NotNull
            public final SdkApiConstraint createConstraint(@Nullable Integer fromInclusive, @Nullable Integer fromInclusiveMinor, @Nullable Integer toExclusive, @Nullable Integer toExclusiveMinor, int sdkId) {
                Intervals intervals;
                if (fromInclusive != null) {
                    if (toExclusive != null) {
                        Integer n = fromInclusiveMinor;
                        Integer n2 = toExclusiveMinor;
                        intervals = Intervals.Companion.range(fromInclusive, n != null ? n : 0, toExclusive, n2 != null ? n2 : 0);
                    } else {
                        intervals = fromInclusiveMinor != null ? Intervals.Companion.atLeast(fromInclusive, fromInclusiveMinor) : Intervals.Companion.atLeast$default(Intervals.Companion, fromInclusive, 0, 2, null);
                    }
                } else {
                    Integer n = toExclusive;
                    Intrinsics.checkNotNull((Object)n);
                    Integer n3 = toExclusiveMinor;
                    intervals = Intervals.Companion.below(n, n3 != null ? n3 : 0);
                }
                Intervals intervals2 = intervals;
                return new SdkApiConstraint(intervals2, sdkId, false, 4, null);
            }

            public static /* synthetic */ SdkApiConstraint createConstraint$default(Companion companion, Integer n, Integer n2, Integer n3, Integer n4, int n5, int n6, Object object) {
                if ((n6 & 1) != 0) {
                    n = null;
                }
                if ((n6 & 2) != 0) {
                    n2 = null;
                }
                if ((n6 & 4) != 0) {
                    n3 = null;
                }
                if ((n6 & 8) != 0) {
                    n4 = null;
                }
                if ((n6 & 0x10) != 0) {
                    n5 = 0;
                }
                return companion.createConstraint(n, n2, n3, n4, n5);
            }

            @NotNull
            public final String serialize(@NotNull SdkApiConstraint constraint) {
                Intrinsics.checkNotNullParameter((Object)constraint, (String)"constraint");
                return constraint.serialize();
            }

            @NotNull
            public final SdkApiConstraint deserialize(@NotNull String s) {
                Intervals intervals;
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                int index2 = StringsKt.indexOf$default((CharSequence)s, (char)';', (int)0, (boolean)false, (int)6, null);
                int sdkId = 0;
                if (index2 == -1) {
                    sdkId = 0;
                    intervals = Intervals.Companion.deserialize(s);
                } else {
                    String string2 = s.substring(index2 + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    sdkId = Integer.parseInt(string2);
                    String string3 = s.substring(0, index2);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    intervals = Intervals.Companion.deserialize(string3);
                }
                Intervals intervals2 = intervals;
                return new SdkApiConstraint(intervals2, sdkId, false, 4, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0007\u0010\fJ\u0006\u0010\u0012\u001a\u00020\u0005J\u0006\u0010\u0013\u001a\u00020\u0005J\u0011\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0000H\u0086\u0004J\u0016\u0010\u0016\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u001c\u0010\u0016\u001a\u00020\u00002\b\u0010\u0017\u001a\u0004\u0018\u00010\u00052\b\u0010\u0018\u001a\u0004\u0018\u00010\u0005H\u0002J\u0011\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0000H\u0086\u0004J\u0016\u0010\u001a\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u001c\u0010\u001a\u001a\u00020\u00002\b\u0010\u0017\u001a\u0004\u0018\u00010\u00052\b\u0010\u0018\u001a\u0004\u0018\u00010\u0005H\u0002J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J+\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020\u000b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020\u0003H\u00d6\u0001J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006#"}, d2={"Lcom/android/tools/lint/detector/api/ApiConstraint$SdkApiConstraints;", "", "sdkId", "", "always", "Lcom/android/tools/lint/detector/api/ApiConstraint$SdkApiConstraint;", "sometimes", "<init>", "(ILcom/android/tools/lint/detector/api/ApiConstraint$SdkApiConstraint;Lcom/android/tools/lint/detector/api/ApiConstraint$SdkApiConstraint;)V", "constraint", "either", "", "(ILcom/android/tools/lint/detector/api/ApiConstraint$SdkApiConstraint;Z)V", "getSdkId", "()I", "getAlways", "()Lcom/android/tools/lint/detector/api/ApiConstraint$SdkApiConstraint;", "getSometimes", "lowest", "highest", "and", "other", "andWith", "matchAlways", "matchSometimes", "or", "orWith", "component1", "component2", "component3", "copy", "equals", "hashCode", "toString", "", "android.sdktools.lint-api"})
    public static final class SdkApiConstraints {
        private final int sdkId;
        @Nullable
        private final SdkApiConstraint always;
        @Nullable
        private final SdkApiConstraint sometimes;

        public SdkApiConstraints(int sdkId, @Nullable SdkApiConstraint always, @Nullable SdkApiConstraint sometimes) {
            this.sdkId = sdkId;
            this.always = always;
            this.sometimes = sometimes;
        }

        public final int getSdkId() {
            return this.sdkId;
        }

        @Nullable
        public final SdkApiConstraint getAlways() {
            return this.always;
        }

        @Nullable
        public final SdkApiConstraint getSometimes() {
            return this.sometimes;
        }

        @NotNull
        public final SdkApiConstraint lowest() {
            SdkApiConstraint sdkApiConstraint = this.always;
            if (sdkApiConstraint == null) {
                SdkApiConstraint sdkApiConstraint2 = this.sometimes;
                sdkApiConstraint = sdkApiConstraint2;
                Intrinsics.checkNotNull((Object)sdkApiConstraint2);
            }
            return sdkApiConstraint;
        }

        @NotNull
        public final SdkApiConstraint highest() {
            SdkApiConstraint sdkApiConstraint = this.sometimes;
            if (sdkApiConstraint == null) {
                SdkApiConstraint sdkApiConstraint2 = this.always;
                sdkApiConstraint = sdkApiConstraint2;
                Intrinsics.checkNotNull((Object)sdkApiConstraint2);
            }
            return sdkApiConstraint;
        }

        public SdkApiConstraints(int sdkId, @NotNull SdkApiConstraint constraint, boolean either) {
            Intrinsics.checkNotNullParameter((Object)constraint, (String)"constraint");
            this(sdkId, either ? null : constraint, either ? constraint : null);
        }

        @NotNull
        public final SdkApiConstraints and(@NotNull SdkApiConstraints other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.andWith(other.always, other.sometimes);
        }

        @NotNull
        public final SdkApiConstraints andWith(@NotNull SdkApiConstraint constraint, boolean either) {
            Intrinsics.checkNotNullParameter((Object)constraint, (String)"constraint");
            return this.andWith(either ? null : constraint, either ? constraint : null);
        }

        private final SdkApiConstraints andWith(SdkApiConstraint matchAlways, SdkApiConstraint matchSometimes) {
            boolean bl;
            SdkApiConstraint sometimes;
            SdkApiConstraint always;
            SdkApiConstraints have = this;
            SdkApiConstraint sdkApiConstraint = matchAlways != null ? (have.always != null ? new SdkApiConstraint(matchAlways.getIntervals().and(have.always.getIntervals()), have.sdkId, false, 4, null) : matchAlways) : (always = have.always);
            SdkApiConstraint sdkApiConstraint2 = matchSometimes != null ? (have.sometimes != null ? new SdkApiConstraint(matchSometimes.getIntervals().and(have.sometimes.getIntervals()), have.sdkId, false, 4, null) : matchSometimes) : (sometimes = have.sometimes);
            if (always != null && sometimes != null && Intrinsics.areEqual((Object)always.getIntervals().and(sometimes.getIntervals()), (Object)always.getIntervals())) {
                sometimes = null;
            }
            boolean bl2 = bl = always != null || sometimes != null;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            return new SdkApiConstraints(have.sdkId, always, sometimes);
        }

        @NotNull
        public final SdkApiConstraints or(@NotNull SdkApiConstraints other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.orWith(other.always, other.sometimes);
        }

        @NotNull
        public final SdkApiConstraints orWith(@NotNull SdkApiConstraint constraint, boolean either) {
            Intrinsics.checkNotNullParameter((Object)constraint, (String)"constraint");
            return this.orWith(either ? null : constraint, either ? constraint : null);
        }

        private final SdkApiConstraints orWith(SdkApiConstraint matchAlways, SdkApiConstraint matchSometimes) {
            boolean bl;
            SdkApiConstraint sometimes;
            SdkApiConstraint always;
            SdkApiConstraints have = this;
            SdkApiConstraint sdkApiConstraint = matchAlways != null ? (have.always != null ? new SdkApiConstraint(matchAlways.getIntervals().or(have.always.getIntervals()), have.sdkId, false, 4, null) : matchAlways) : (always = have.always);
            SdkApiConstraint sdkApiConstraint2 = matchSometimes != null ? (have.sometimes != null ? new SdkApiConstraint(matchSometimes.getIntervals().or(have.sometimes.getIntervals()), have.sdkId, false, 4, null) : matchSometimes) : (sometimes = have.sometimes);
            if (always != null && sometimes != null && Intrinsics.areEqual((Object)always.getIntervals().or(sometimes.getIntervals()), (Object)always.getIntervals())) {
                sometimes = null;
            }
            boolean bl2 = bl = always != null || sometimes != null;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            return new SdkApiConstraints(have.sdkId, always, sometimes);
        }

        public final int component1() {
            return this.sdkId;
        }

        @Nullable
        public final SdkApiConstraint component2() {
            return this.always;
        }

        @Nullable
        public final SdkApiConstraint component3() {
            return this.sometimes;
        }

        @NotNull
        public final SdkApiConstraints copy(int sdkId, @Nullable SdkApiConstraint always, @Nullable SdkApiConstraint sometimes) {
            return new SdkApiConstraints(sdkId, always, sometimes);
        }

        public static /* synthetic */ SdkApiConstraints copy$default(SdkApiConstraints sdkApiConstraints, int n, SdkApiConstraint sdkApiConstraint, SdkApiConstraint sdkApiConstraint2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = sdkApiConstraints.sdkId;
            }
            if ((n2 & 2) != 0) {
                sdkApiConstraint = sdkApiConstraints.always;
            }
            if ((n2 & 4) != 0) {
                sdkApiConstraint2 = sdkApiConstraints.sometimes;
            }
            return sdkApiConstraints.copy(n, sdkApiConstraint, sdkApiConstraint2);
        }

        @NotNull
        public String toString() {
            return "SdkApiConstraints(sdkId=" + this.sdkId + ", always=" + this.always + ", sometimes=" + this.sometimes + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.sdkId);
            result2 = result2 * 31 + (this.always == null ? 0 : this.always.hashCode());
            result2 = result2 * 31 + (this.sometimes == null ? 0 : this.sometimes.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SdkApiConstraints)) {
                return false;
            }
            SdkApiConstraints sdkApiConstraints = (SdkApiConstraints)other;
            if (this.sdkId != sdkApiConstraints.sdkId) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.always, (Object)sdkApiConstraints.always)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.sometimes, (Object)sdkApiConstraints.sometimes);
        }
    }
}

