/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.helpers.ZipStreamsKt;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002\u001d\u001eB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0011\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0000H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0011H\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u0013J\"\u0010\u0016\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001b2\b\b\u0002\u0010\u001a\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/lint/client/api/ClassEntry;", "", "file", "Ljava/io/File;", "jarFile", "binDir", "bytes", "", "<init>", "(Ljava/io/File;Ljava/io/File;Ljava/io/File;[B)V", "getFile", "()Ljava/io/File;", "getJarFile", "getBinDir", "getBytes", "()[B", "path", "", "compareTo", "", "other", "toString", "visit", "Lorg/objectweb/asm/tree/ClassNode;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "flags", "Lorg/objectweb/asm/ClassVisitor;", "visitor", "SuperclassVisitor", "Companion", "android.sdktools.lint-api"})
public final class ClassEntry
implements Comparable<ClassEntry> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File file;
    @Nullable
    private final File jarFile;
    @NotNull
    private final File binDir;
    @NotNull
    private final byte[] bytes;

    public ClassEntry(@NotNull File file, @Nullable File jarFile, @NotNull File binDir, @NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)binDir, (String)"binDir");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.file = file;
        this.jarFile = jarFile;
        this.binDir = binDir;
        this.bytes = bytes;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @Nullable
    public final File getJarFile() {
        return this.jarFile;
    }

    @NotNull
    public final File getBinDir() {
        return this.binDir;
    }

    @NotNull
    public final byte[] getBytes() {
        return this.bytes;
    }

    @NotNull
    public final String path() {
        Object object;
        if (this.jarFile != null) {
            object = this.jarFile.getPath() + ":" + this.file.getPath();
        } else {
            String string2 = this.file.getPath();
            Intrinsics.checkNotNull((Object)string2);
            object = string2;
        }
        return object;
    }

    @Override
    public int compareTo(@NotNull ClassEntry other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        String p1 = this.file.getPath();
        String p2 = other.file.getPath();
        int m1 = p1.length();
        int m2 = p2.length();
        if (m1 == m2 && Intrinsics.areEqual((Object)p1, (Object)p2)) {
            return 0;
        }
        int m = Math.min(m1, m2);
        for (int i = 0; i < m; ++i) {
            char c2;
            char c1 = p1.charAt(i);
            if (c1 == (c2 = p2.charAt(i))) continue;
            return c1 == '.' ? -1 : (c2 == '.' ? 1 : c1 - c2);
        }
        return m == m1 ? -1 : 1;
    }

    @NotNull
    public String toString() {
        String string2 = this.file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        return string2;
    }

    @Nullable
    public final ClassNode visit(@NotNull LintClient client, int flags) {
        ClassVisitor classVisitor;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        File file = this.jarFile;
        if (file == null) {
            file = this.file;
        }
        return (classVisitor = Companion.visit(client, file, this.file.getPath(), this.bytes, (ClassVisitor)new ClassNode(), flags)) instanceof ClassNode ? (ClassNode)classVisitor : null;
    }

    public static /* synthetic */ ClassNode visit$default(ClassEntry classEntry, LintClient lintClient, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return classEntry.visit(lintClient, n);
    }

    @Nullable
    public final ClassVisitor visit(@NotNull LintClient client, @NotNull ClassVisitor visitor2, int flags) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        File file = this.jarFile;
        if (file == null) {
            file = this.file;
        }
        return Companion.visit(client, file, this.file.getPath(), this.bytes, visitor2, flags);
    }

    public static /* synthetic */ ClassVisitor visit$default(ClassEntry classEntry, LintClient lintClient, ClassVisitor classVisitor, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return classEntry.visit(lintClient, classVisitor, n);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010(\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005J0\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u0005J,\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u00112\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005H\u0002J\u001e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\u0011H\u0002J\"\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00152\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005J6\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J(\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J&\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J<\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010 \u001a\u00020\n2\b\u0010!\u001a\u0004\u0018\u00010\u00182\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u001f2\b\b\u0002\u0010$\u001a\u00020%\u00a8\u0006&"}, d2={"Lcom/android/tools/lint/client/api/ClassEntry$Companion;", "", "<init>", "()V", "fromClassPath", "", "Lcom/android/tools/lint/client/api/ClassEntry;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "classPath", "Ljava/io/File;", "fromClassFiles", "classFiles", "classFolders", "addEntries", "", "entries", "", "addClassFiles", "dir", "fromLazyClassPath", "", "createSuperClassMap", "", "", "libraryEntries", "classEntries", "addSuperClasses", "visitor", "Lcom/android/tools/lint/client/api/ClassEntry$SuperclassVisitor;", "visit", "Lorg/objectweb/asm/ClassVisitor;", "file", "relative", "bytes", "", "flags", "", "android.sdktools.lint-api"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<ClassEntry> fromClassPath(@NotNull LintClient client, @NotNull List<? extends File> classPath) {
            List list2;
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(classPath, (String)"classPath");
            if (!((Collection)classPath).isEmpty()) {
                void var3_3;
                List libraryEntries = new ArrayList(64);
                this.addEntries(client, libraryEntries, classPath);
                CollectionsKt.sort((List)libraryEntries);
                list2 = var3_3;
            } else {
                list2 = CollectionsKt.emptyList();
            }
            return list2;
        }

        @NotNull
        public final List<ClassEntry> fromClassFiles(@NotNull LintClient client, @NotNull List<? extends File> classFiles, @NotNull List<? extends File> classFolders) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(classFiles, (String)"classFiles");
            Intrinsics.checkNotNullParameter(classFolders, (String)"classFolders");
            List entries = new ArrayList(classFiles.size());
            if (!((Collection)classFolders).isEmpty()) {
                for (File file : classFiles) {
                    String path = file.getPath();
                    if (!file.isFile()) continue;
                    Intrinsics.checkNotNull((Object)path);
                    if (!StringsKt.endsWith$default((String)path, (String)".class", (boolean)false, (int)2, null)) continue;
                    try {
                        byte[] bytes = client.readBytes(file);
                        for (File file2 : classFolders) {
                            String string2 = file2.getPath();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                            if (!StringsKt.startsWith$default((String)path, (String)string2, (boolean)false, (int)2, null)) continue;
                            entries.add(new ClassEntry(file, null, file2, bytes));
                        }
                    }
                    catch (IOException e) {
                        client.log(e, null, new Object[0]);
                    }
                }
                if (!((Collection)entries).isEmpty()) {
                    CollectionsKt.sort((List)entries);
                }
            }
            return entries;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void addEntries(LintClient client, List<ClassEntry> entries, List<? extends File> classPath) {
            for (File file : classPath) {
                Object[] objectArray;
                String name = file.getName();
                Intrinsics.checkNotNull((Object)name);
                if (StringsKt.endsWith$default((String)name, (String)".jar", (boolean)false, (int)2, null)) {
                    Object object;
                    if (!file.exists()) continue;
                    try {
                        objectArray = new ZipFile(file);
                        object = null;
                        try {
                            ZipFile jar = (ZipFile)objectArray;
                            boolean bl = false;
                            Enumeration<? extends ZipEntry> enumeration = jar.entries();
                            while (enumeration.hasMoreElements()) {
                                ZipEntry entry = enumeration.nextElement();
                                String string2 = entry.getName();
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                                if (!StringsKt.endsWith$default((String)string2, (String)".class", (boolean)false, (int)2, null)) continue;
                                try {
                                    Intrinsics.checkNotNull((Object)entry);
                                    byte[] bytes = ZipStreamsKt.readAllBytes(jar, entry);
                                    File file2 = new File(entry.getName());
                                    entries.add(new ClassEntry(file2, file, file, bytes));
                                }
                                catch (Throwable e) {
                                    client.log(e, null, new Object[0]);
                                }
                            }
                            jar = Unit.INSTANCE;
                        }
                        catch (Throwable bl) {
                            object = bl;
                            throw bl;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)objectArray, (Throwable)object);
                        }
                    }
                    catch (IOException e) {
                        object = new Object[]{file};
                        client.log(e, "Could not read jar file contents from %1$s", (Object[])object);
                    }
                    continue;
                }
                if (file.isDirectory()) {
                    List classFiles = new ArrayList();
                    this.addClassFiles(file, classFiles);
                    for (File file3 : classFiles) {
                        try {
                            byte[] bytes = client.readBytes(file3);
                            entries.add(new ClassEntry(file3, null, file, bytes));
                        }
                        catch (IOException e) {
                            client.log(e, null, new Object[0]);
                        }
                    }
                    continue;
                }
                objectArray = new Object[]{file};
                client.log(null, "Ignoring class path entry %1$s", objectArray);
            }
        }

        private final void addClassFiles(File dir, List<File> classFiles) {
            File[] fileArray = dir.listFiles();
            if (fileArray == null) {
                return;
            }
            File[] files = fileArray;
            if (!(files.length == 0)) {
                for (File file : files) {
                    if (file.isFile()) {
                        String string2 = file.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                        if (StringsKt.endsWith$default((String)string2, (String)".class", (boolean)false, (int)2, null)) {
                            Intrinsics.checkNotNull((Object)file);
                            classFiles.add(file);
                            continue;
                        }
                    }
                    if (!file.isDirectory()) continue;
                    Intrinsics.checkNotNull((Object)file);
                    this.addClassFiles(file, classFiles);
                }
            }
        }

        @NotNull
        public final Iterator<ClassEntry> fromLazyClassPath(@NotNull LintClient client, @NotNull List<? extends File> classPath) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(classPath, (String)"classPath");
            if (classPath.isEmpty()) {
                Iterator<ClassEntry> iterator = Collections.emptyIterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"emptyIterator(...)");
                return iterator;
            }
            Sequence lazySequence2 = SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super ClassEntry>, Continuation<? super Unit>, Object>(classPath, client, null){
                Object L$1;
                Object L$2;
                Object L$3;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ List<File> $classPath;
                final /* synthetic */ LintClient $client;
                {
                    this.$classPath = $classPath;
                    this.$client = $client;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    block11: {
                        block12: {
                            var11_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            block2 : switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)var1_1);
                                    $this$sequence = (SequenceScope)this.L$0;
                                    var3_4 = this.$classPath.iterator();
lbl7:
                                    // 5 sources

                                    while (var3_4.hasNext()) {
                                        classPathEntry = (File)var3_4.next();
                                        path = classPathEntry.getPath();
                                        Intrinsics.checkNotNull((Object)path);
                                        if (!StringsKt.endsWith$default((String)path, (String)".jar", (boolean)false, (int)2, null) || !classPathEntry.isFile()) break block2;
                                        zipClassEntries = ClassEntry.Companion.fromClassPath(this.$client, CollectionsKt.listOf((Object)classPathEntry));
                                        this.L$0 = $this$sequence;
                                        this.L$1 = var3_4;
                                        this.L$2 = null;
                                        this.L$3 = null;
                                        this.label = 1;
                                        v0 = $this$sequence.yieldAll((Iterable)zipClassEntries, (Continuation)this);
                                        if (v0 != var11_2) continue;
                                        return var11_2;
                                    }
                                    break block11;
                                }
                                case 1: {
                                    var3_4 = (Iterator)this.L$1;
                                    $this$sequence = (SequenceScope)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
                                    ** GOTO lbl7
                                }
                            }
                            if (!classPathEntry.isDirectory()) break block12;
                            classFiles = new ArrayList<E>(64);
                            com.android.tools.lint.client.api.ClassEntry$Companion.access$addClassFiles(ClassEntry.Companion, classPathEntry, classFiles);
                            CollectionsKt.sort((List)classFiles);
                            var8_9 = classFiles.iterator();
                            Intrinsics.checkNotNullExpressionValue(var8_9, (String)"iterator(...)");
                            var7_8 = var8_9;
lbl35:
                            // 4 sources

                            while (var7_8.hasNext()) {
                                classFile = (File)var7_8.next();
                                bytes = this.$client.readBytes(classFile);
                                classEntry = new ClassEntry(classFile, null, classPathEntry, bytes);
                                this.L$0 = $this$sequence;
                                this.L$1 = var3_4;
                                this.L$2 = classPathEntry;
                                this.L$3 = var7_8;
                                this.label = 2;
                                v1 = $this$sequence.yield((Object)classEntry, (Continuation)this);
                                ** if (v1 != var11_2) goto lbl49
lbl48:
                                // 1 sources

                                return var11_2;
lbl49:
                                // 1 sources

                            }
                            {
                                ** GOTO lbl7
                                case 2: {
                                    var7_8 = (Iterator<E>)this.L$3;
                                    classPathEntry = (File)this.L$2;
                                    var3_4 = (Iterator)this.L$1;
                                    $this$sequence = (SequenceScope)this.L$0;
                                    try {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
                                    }
                                    catch (IOException e) {
                                        this.$client.log(e, null, new Object[0]);
                                    }
                                    ** GOTO lbl35
                                }
                            }
                        }
                        var6_7 = new Object[]{classPathEntry};
                        this.$client.log(null, "Ignoring class path entry %1$s", var6_7);
                        ** GOTO lbl7
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(SequenceScope<? super ClassEntry> p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
            return SequencesKt.asIterable((Sequence)lazySequence2).iterator();
        }

        @NotNull
        public final Map<String, String> createSuperClassMap(@NotNull LintClient client, @NotNull List<ClassEntry> libraryEntries, @NotNull List<ClassEntry> classEntries) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(libraryEntries, (String)"libraryEntries");
            Intrinsics.checkNotNullParameter(classEntries, (String)"classEntries");
            int size = libraryEntries.size() + classEntries.size();
            HashMap hashMap = Maps.newHashMapWithExpectedSize((int)size);
            Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"newHashMapWithExpectedSize(...)");
            Map map2 = hashMap;
            SuperclassVisitor visitor2 = new SuperclassVisitor(map2);
            this.addSuperClasses(client, visitor2, libraryEntries);
            this.addSuperClasses(client, visitor2, classEntries);
            return map2;
        }

        @NotNull
        public final Map<String, String> createSuperClassMap(@NotNull LintClient client, @NotNull List<ClassEntry> entries) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(entries, (String)"entries");
            HashMap hashMap = Maps.newHashMapWithExpectedSize((int)entries.size());
            Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"newHashMapWithExpectedSize(...)");
            Map map2 = hashMap;
            SuperclassVisitor visitor2 = new SuperclassVisitor(map2);
            this.addSuperClasses(client, visitor2, entries);
            return map2;
        }

        private final void addSuperClasses(LintClient client, SuperclassVisitor visitor2, List<ClassEntry> entries) {
            int flags = 7;
            for (ClassEntry entry : entries) {
                entry.visit(client, visitor2, flags);
            }
        }

        @Nullable
        public final ClassVisitor visit(@NotNull LintClient client, @NotNull File file, @Nullable String relative, @NotNull byte[] bytes, @NotNull ClassVisitor visitor2, int flags) {
            ClassVisitor classVisitor;
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
            try {
                ClassReader reader = new ClassReader(bytes);
                reader.accept(visitor2, flags);
                classVisitor = visitor2;
            }
            catch (Throwable t) {
                String message;
                String string2 = t.getMessage();
                if (string2 == null) {
                    string2 = message = t.toString();
                }
                if (relative != null && t instanceof IllegalArgumentException && StringsKt.startsWith$default((String)message, (String)"Unsupported class file", (boolean)false, (int)2, null) && (StringsKt.startsWith$default((String)relative, (String)"META-INF/versions/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)relative, (String)"META-INF\\versions\\", (boolean)false, (int)2, null))) {
                    return null;
                }
                Object[] objectArray = new Object[2];
                String string3 = relative;
                objectArray[0] = file.getPath() + (String)(string3 != null ? ":" + string3 : "");
                objectArray[1] = message;
                client.log(null, "Error processing %1$s: broken class file? (%2$s)", objectArray);
                classVisitor = null;
            }
            return classVisitor;
        }

        public static /* synthetic */ ClassVisitor visit$default(Companion companion, LintClient lintClient, File file, String string2, byte[] byArray, ClassVisitor classVisitor, int n, int n2, Object object) {
            if ((n2 & 0x20) != 0) {
                n = 0;
            }
            return companion.visit(lintClient, file, string2, byArray, classVisitor, n);
        }

        public static final /* synthetic */ void access$addClassFiles(Companion $this, File dir, List classFiles) {
            $this.addClassFiles(dir, classFiles);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006JI\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/client/api/ClassEntry$SuperclassVisitor;", "Lorg/objectweb/asm/ClassVisitor;", "map", "", "", "<init>", "(Ljava/util/Map;)V", "visit", "", "version", "", "access", "name", "signature", "superName", "interfaces", "", "(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "android.sdktools.lint-api"})
    private static final class SuperclassVisitor
    extends ClassVisitor {
        @NotNull
        private final Map<String, String> map;

        public SuperclassVisitor(@NotNull Map<String, String> map2) {
            Intrinsics.checkNotNullParameter(map2, (String)"map");
            super(589824);
            this.map = map2;
        }

        public void visit(int version2, int access, @NotNull String name, @Nullable String signature, @Nullable String superName, @Nullable String[] interfaces) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            if (superName != null && !Intrinsics.areEqual((Object)"java/lang/Object", (Object)superName)) {
                this.map.put(name, superName);
            }
        }
    }
}

