/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.AnnotationInfo;
import com.android.tools.lint.detector.api.AnnotationUsageInfo;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UThisExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/checks/ReturnThisDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "applicableAnnotations", "", "", "isApplicableAnnotationUsage", "", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "visitAnnotationUsage", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "element", "Lorg/jetbrains/uast/UElement;", "annotationInfo", "Lcom/android/tools/lint/detector/api/AnnotationInfo;", "usageInfo", "Lcom/android/tools/lint/detector/api/AnnotationUsageInfo;", "Companion", "android.sdktools.lint-checks"})
@SourceDebugExtension(value={"SMAP\nReturnThisDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReturnThisDetector.kt\ncom/android/tools/lint/checks/ReturnThisDetector\n+ 2 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n*L\n1#1,104:1\n18#2:105\n*S KotlinDebug\n*F\n+ 1 ReturnThisDetector.kt\ncom/android/tools/lint/checks/ReturnThisDetector\n*L\n78#1:105\n*E\n"})
public final class ReturnThisDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(ReturnThisDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ISSUE = Issue.Companion.create("ReturnThis", "Method must return `this`", "\n                Methods annotated with `@ReturnThis` (usually in the super method that this method is overriding) should \\\n                also `return this`.\n                ", Category.CORRECTNESS, 4, Severity.ERROR, IMPLEMENTATION);
    @NotNull
    public static final String RETURN_THIS_ANNOTATION = "androidx.annotation.ReturnThis";

    @Override
    @NotNull
    public List<String> applicableAnnotations() {
        return CollectionsKt.listOf((Object)RETURN_THIS_ANNOTATION);
    }

    @Override
    public boolean isApplicableAnnotationUsage(@NotNull AnnotationUsageType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return type == AnnotationUsageType.METHOD_OVERRIDE || type == AnnotationUsageType.DEFINITION;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitAnnotationUsage(@NotNull JavaContext context2, @NotNull UElement element, @NotNull AnnotationInfo annotationInfo, @NotNull AnnotationUsageInfo usageInfo) {
        UMethod uMethod;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)annotationInfo, (String)"annotationInfo");
        Intrinsics.checkNotNullParameter((Object)usageInfo, (String)"usageInfo");
        if (usageInfo.getType() == AnnotationUsageType.DEFINITION) {
            void $this$getParentOfType$iv;
            UElement uElement = element;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            uMethod = (UMethod)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv, UMethod.class, (boolean)strict$iv);
            if (uMethod == null) {
                return;
            }
        } else {
            uMethod = element instanceof UMethod ? (UMethod)element : null;
            if (uMethod == null) {
                return;
            }
        }
        UMethod method = uMethod;
        method.accept((UastVisitor)new AbstractUastVisitor(method, context2){
            final /* synthetic */ UMethod $method;
            final /* synthetic */ JavaContext $context;
            {
                this.$method = $method;
                this.$context = $context;
            }

            public boolean visitReturnExpression(UReturnExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                UElement jumpTarget = node.getJumpTarget();
                if (jumpTarget != null && !Intrinsics.areEqual((Object)jumpTarget, (Object)this.$method)) {
                    return super.visitReturnExpression(node);
                }
                UExpression expression = node.getReturnExpression();
                if (!(expression instanceof UThisExpression)) {
                    String message = "This method should `return this` (because it has been annotated with `@ReturnThis`)";
                    JavaContext.report$default(this.$context, ReturnThisDetector.ISSUE, (UElement)node, this.$context.getLocation((UElement)node), message, null, 16, null);
                }
                return super.visitReturnExpression(node);
            }

            public boolean visitClass(UClass node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                return true;
            }
        });
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/lint/checks/ReturnThisDetector$Companion;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "RETURN_THIS_ANNOTATION", "", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

