/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J>\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00100\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J4\u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00100\u0014H\u0002J\u0018\u0010\u001a\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\"\u0010\u001b\u001a\u0004\u0018\u00010\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0012H\u0002\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/lint/checks/RestrictionsDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "<init>", "()V", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "visitDocument", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "document", "Lorg/w3c/dom/Document;", "validateNestedRestrictions", "element", "Lorg/w3c/dom/Element;", "restrictionType", "", "keys", "", "depth", "", "validateRestriction", "node", "Lorg/w3c/dom/Node;", "verifyRestrictionTagName", "checkRequiredAttribute", "attribute", "Companion", "android.sdktools.lint-checks"})
public final class RestrictionsDetector
extends ResourceXmlDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int MAX_NESTING_DEPTH = 20;
    public static final int MAX_NUMBER_OF_NESTED_RESTRICTIONS = 1000;
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    public static final String TAG_RESTRICTIONS = "restrictions";
    @NotNull
    private static final String TAG_RESTRICTION = "restriction";
    @NotNull
    private static final String ATTR_RESTRICTION_TYPE = "restrictionType";
    @NotNull
    private static final String ATTR_KEY = "key";
    @NotNull
    public static final String ATTR_DESCRIPTION = "description";
    @NotNull
    private static final String VALUE_BUNDLE = "bundle";
    @NotNull
    private static final String VALUE_BUNDLE_ARRAY = "bundle_array";
    @NotNull
    private static final String VALUE_CHOICE = "choice";
    @NotNull
    private static final String VALUE_MULTI_SELECT = "multi-select";
    @NotNull
    private static final String VALUE_ENTRIES = "entries";
    @NotNull
    private static final String VALUE_ENTRY_VALUES = "entryValues";
    @NotNull
    private static final String VALUE_HIDDEN = "hidden";
    @NotNull
    private static final String VALUE_DEFAULT_VALUE = "defaultValue";
    @NotNull
    private static final String VALUE_INTEGER = "integer";

    @Override
    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkNotNullParameter((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.XML;
    }

    @Override
    public void visitDocument(@NotNull XmlContext context2, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Element element = document.getDocumentElement();
        if (element == null) {
            return;
        }
        Element root2 = element;
        if (!Intrinsics.areEqual((Object)TAG_RESTRICTIONS, (Object)root2.getTagName())) {
            return;
        }
        HashMap keys = Maps.newHashMap();
        Intrinsics.checkNotNull((Object)keys);
        this.validateNestedRestrictions(context2, root2, null, keys, 0);
    }

    private final void validateNestedRestrictions(XmlContext context2, Element element, String restrictionType, Map<String, Element> keys, int depth) {
        boolean bl;
        boolean bl2 = bl = depth == 0 || restrictionType != null;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        List<Element> children = Lint.getChildren(element);
        if (depth == 0 || Intrinsics.areEqual((Object)restrictionType, (Object)VALUE_BUNDLE) || Intrinsics.areEqual((Object)restrictionType, (Object)VALUE_BUNDLE_ARRAY)) {
            Attr defaultValue = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", VALUE_DEFAULT_VALUE);
            if (defaultValue != null) {
                XmlContext.report$default(context2, ISSUE, element, context2.getLocation(defaultValue), "Restriction type `" + restrictionType + "` should not have a default value", null, 16, null);
            }
            for (Element child : children) {
                if (!this.verifyRestrictionTagName(context2, child)) continue;
                this.validateRestriction(context2, child, depth + 1, keys);
            }
            if (depth != 0) {
                if (Intrinsics.areEqual((Object)restrictionType, (Object)VALUE_BUNDLE_ARRAY)) {
                    if (children.size() != 1) {
                        XmlContext.report$default(context2, ISSUE, element, context2.getElementLocation(element), "Expected exactly one child for restriction of type `bundle_array`", null, 16, null);
                    }
                } else {
                    boolean bl3 = Intrinsics.areEqual((Object)restrictionType, (Object)VALUE_BUNDLE);
                    if (_Assertions.ENABLED && !bl3) {
                        String string3 = "Assertion failed";
                        throw new AssertionError((Object)string3);
                    }
                    if (children.isEmpty()) {
                        XmlContext.report$default(context2, ISSUE, element, context2.getElementLocation(element), "Restriction type `bundle` should have at least one nested restriction", null, 16, null);
                    }
                }
            }
            if (children.size() > 1000) {
                XmlContext.report$default(context2, ISSUE, element, context2.getElementLocation(element), "Invalid nested restriction: too many nested restrictions (was " + children.size() + ", max 1000)", null, 16, null);
            } else if (depth > 20) {
                XmlContext.report$default(context2, ISSUE, element, context2.getElementLocation(element), "Invalid nested restriction: nesting depth " + depth + " too large (max 20", null, 16, null);
            }
        } else if (!((Collection)children).isEmpty()) {
            XmlContext.report$default(context2, ISSUE, element, context2.getNameLocation(element), "Only restrictions of type `bundle` and `bundle_array` can have one or multiple nested restriction elements", null, 16, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void validateRestriction(XmlContext context, Node node, int depth, Map<String, Element> keys) {
        block17: {
            if (node.getNodeType() != 1) {
                return;
            }
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
            element = (Element)node;
            restrictionType = this.checkRequiredAttribute(context, element, "restrictionType");
            key = this.checkRequiredAttribute(context, element, "key");
            title = this.checkRequiredAttribute(context, element, "title");
            if (restrictionType == null || key == null || title == null) {
                return;
            }
            if (StringsKt.startsWith$default((String)key, (String)"@string/", (boolean)false, (int)2, null)) {
                attribute = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "key");
                Intrinsics.checkNotNull((Object)attribute);
                valueLocation = context.getValueLocation(attribute);
                XmlContext.report$default(context, RestrictionsDetector.ISSUE, element, valueLocation, "Keys cannot be localized, they should be specified with a string literal", null, 16, null);
            } else if (keys.containsKey(key)) {
                thisAttribute = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "key");
                Intrinsics.checkNotNull((Object)thisAttribute);
                location = context.getValueLocation(thisAttribute);
                v0 = keys.get(key);
                if (v0 == null) {
                    return;
                }
                prev = v0;
                prevAttribute = prev.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "key");
                Intrinsics.checkNotNull((Object)prevAttribute);
                previousLocation = context.getValueLocation(prevAttribute);
                previousLocation.setMessage("Previous use of key here");
                location.setSecondary(previousLocation);
                XmlContext.report$default(context, RestrictionsDetector.ISSUE, element, location, "Duplicate key `" + key + "`", null, 16, null);
            } else {
                keys.put(key, element);
            }
            switch (restrictionType.hashCode()) {
                case -1217487446: {
                    if (restrictionType.equals("hidden")) break;
                    break;
                }
                case 1123690512: {
                    if (!restrictionType.equals("multi-select")) {
                        break;
                    }
                    ** GOTO lbl47
                }
                case 1958052158: {
                    if (!restrictionType.equals("integer")) {
                        break;
                    }
                    break block17;
                }
                case -1361224287: {
                    if (!restrictionType.equals("choice")) break;
lbl47:
                    // 2 sources

                    if (this.checkRequiredAttribute(context, element, "entries") != null) break;
                    this.checkRequiredAttribute(context, element, "entryValues");
                    break;
                }
            }
            this.checkRequiredAttribute(context, element, "defaultValue");
            ** break;
        }
        defaultValue = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "defaultValue");
        if (defaultValue == null) ** break;
        v1 = defaultValue.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getValue(...)");
        if (StringsKt.startsWith$default((String)v1, (String)"@", (boolean)false, (int)2, null)) ** break;
        try {
            Integer.decode(defaultValue.getValue());
        }
        catch (NumberFormatException e) {
            XmlContext.report$default(context, RestrictionsDetector.ISSUE, element, context.getValueLocation(defaultValue), "Invalid number", null, 16, null);
        }
        {
            break;
        }
lbl68:
        // 12 sources

        this.validateNestedRestrictions(context, element, restrictionType, keys, depth);
    }

    private final boolean verifyRestrictionTagName(XmlContext context2, Element element) {
        String tagName = element.getTagName();
        if (!Intrinsics.areEqual((Object)tagName, (Object)TAG_RESTRICTION)) {
            XmlContext.report$default(context2, ISSUE, element, context2.getNameLocation(element), "Unexpected tag `<" + tagName + ">`, expected `<restriction>`", null, 16, null);
            return false;
        }
        return true;
    }

    private final String checkRequiredAttribute(XmlContext context2, Element element, String attribute) {
        Object fullAttribute = attribute;
        if (!element.hasAttributeNS("http://schemas.android.com/apk/res/android", (String)fullAttribute)) {
            String prefix = element.lookupPrefix("http://schemas.android.com/apk/res/android");
            if (prefix != null) {
                fullAttribute = prefix + ":" + (String)fullAttribute;
            }
            XmlContext.report$default(context2, ISSUE, element, context2.getElementLocation(element), "Missing required attribute `" + (String)fullAttribute + "`", null, 16, null);
            return null;
        }
        return element.getAttributeNS("http://schemas.android.com/apk/res/android", (String)fullAttribute);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.FATAL;
        Implementation implementation = new Implementation(RestrictionsDetector.class, Scope.RESOURCE_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default(companion, "ValidRestrictions", "Invalid Restrictions Descriptor", "Ensures that an applications restrictions XML file is properly formed", implementation, "https://developer.android.com/reference/android/content/RestrictionsManager.html", category, 5, severity, false, null, null, null, 3840, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003R\u0016\u0010\u0007\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0003R\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/lint/checks/RestrictionsDetector$Companion;", "", "<init>", "()V", "MAX_NESTING_DEPTH", "", "getMAX_NESTING_DEPTH$annotations", "MAX_NUMBER_OF_NESTED_RESTRICTIONS", "getMAX_NUMBER_OF_NESTED_RESTRICTIONS$annotations", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "TAG_RESTRICTIONS", "", "TAG_RESTRICTION", "ATTR_RESTRICTION_TYPE", "ATTR_KEY", "ATTR_DESCRIPTION", "VALUE_BUNDLE", "VALUE_BUNDLE_ARRAY", "VALUE_CHOICE", "VALUE_MULTI_SELECT", "VALUE_ENTRIES", "VALUE_ENTRY_VALUES", "VALUE_HIDDEN", "VALUE_DEFAULT_VALUE", "VALUE_INTEGER", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getMAX_NESTING_DEPTH$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getMAX_NUMBER_OF_NESTED_RESTRICTIONS$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

