/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.AndroidXConstants;
import com.android.resources.ResourceFolderType;
import com.android.support.AndroidxName;
import com.android.tools.lint.checks.KeepRuleDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.UastParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.TypeEvaluator;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.tools.lint.model.LintModelModule;
import com.android.utils.DomExtensions;
import com.google.common.collect.Sets;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 F2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002EFB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J&\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\nH\u0002J(\u0010\u0019\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J<\u0010\u001c\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u00182\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001f\u001a\u00020\u000b2\b\u0010 \u001a\u0004\u0018\u00010!H\u0002J\u001a\u0010\"\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010#\u001a\u00020$H\u0002J\u001c\u0010%\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010&\u001a\u0004\u0018\u00010\u0018H\u0002J\u0018\u0010'\u001a\u00020(2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020\u0011H\u0002J\u0018\u0010*\u001a\u00020(2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\u001a\u0010/\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\u000b2\b\u00101\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u00102\u001a\u00020(2\u0006\u0010\u000e\u001a\u000203H\u0002J\u0010\u00104\u001a\u00020(2\u0006\u00105\u001a\u000206H\u0016J\u000e\u00107\u001a\b\u0012\u0004\u0012\u00020\u000b08H\u0016J\u0018\u0010<\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0016J \u0010@\u001a\u00020(2\u0006\u0010\u000e\u001a\u0002032\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020DH\u0016R\u0018\u0010\u0006\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u00109\u001a\n\u0012\u0004\u0012\u00020;\u0018\u00010:X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/android/tools/lint/checks/ObjectAnimatorDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "<init>", "()V", "mAlreadyWarned", "", "", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "checkPropertyValueHolders", "targetClass", "Lcom/intellij/psi/PsiClass;", "expressions", "Lorg/jetbrains/uast/UExpression;", "checkProperty", "propertyNameExpression", "expectedType", "report", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "originalMessage", "fix", "Lcom/android/tools/lint/detector/api/LintFix;", "getExpectedType", "evaluatorIndex", "", "findHolderConstruction", "arg", "isHolderConstructionMethod", "", "callExpression", "isInSameCompilationUnit", "element1", "Lorg/jetbrains/uast/UElement;", "element2", "Lcom/intellij/psi/PsiElement;", "getMethodName", "prefix", "propertyName", "isShrinking", "Lcom/android/tools/lint/detector/api/Context;", "appliesTo", "folderType", "Lcom/android/resources/ResourceFolderType;", "getApplicableElements", "", "sceneIds", "", "Lcom/android/tools/lint/checks/ObjectAnimatorDetector$SceneReference;", "visitElement", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "filterIncident", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "SceneReference", "Companion", "android.sdktools.lint-checks"})
public final class ObjectAnimatorDetector
extends Detector
implements SourceCodeScanner,
XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Set<Object> mAlreadyWarned;
    @Nullable
    private List<SceneReference> sceneIds;
    @NotNull
    private static final String MOTION_LAYOUT_URI = "http://schemas.android.com/apk/res-auto";
    private static final AndroidxName KEEP_ANNOTATION = AndroidxName.of((AndroidxName)AndroidXConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"Keep");
    @NotNull
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue MISSING_KEEP;
    @JvmField
    @NotNull
    public static final Issue BROKEN_PROPERTY;

    @Override
    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{"ofInt", "ofArgb", "ofFloat", "ofMultiInt", "ofMultiFloat", "ofObject", "ofPropertyValuesHolder"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void visitMethodCall(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        JavaEvaluator evaluator = context2.getEvaluator();
        if (!(evaluator.isMemberInClass((PsiMember)method, "android.animation.ObjectAnimator") || Intrinsics.areEqual((Object)method.getName(), (Object)"ofPropertyValuesHolder") && evaluator.isMemberInClass((PsiMember)method, "android.animation.ValueAnimator"))) {
            return;
        }
        List expressions = node.getValueArguments();
        if (expressions.size() < 2) {
            return;
        }
        PsiType psiType = TypeEvaluator.evaluate((UElement)expressions.get(0));
        PsiClassType psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
        if (psiClassType == null) {
            return;
        }
        PsiClassType type = psiClassType;
        PsiClass psiClass = type.resolve();
        if (psiClass == null) {
            return;
        }
        PsiClass targetClass = psiClass;
        String string2 = method.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String methodName = string2;
        if (Intrinsics.areEqual((Object)methodName, (Object)"ofPropertyValuesHolder")) {
            if (!evaluator.isMemberInClass((PsiMember)method, "android.animation.ObjectAnimator")) {
                return;
            }
            this.checkPropertyValueHolders(context2, targetClass, expressions);
        } else {
            String string3 = this.getExpectedType(node, 2);
            if (string3 == null) {
                return;
            }
            String expectedType = string3;
            this.checkProperty(context2, (UExpression)expressions.get(1), targetClass, expectedType);
        }
    }

    private final void checkPropertyValueHolders(JavaContext context2, PsiClass targetClass, List<? extends UExpression> expressions) {
        int n = expressions.size();
        for (int i = 1; i < n; ++i) {
            String expectedType;
            UCallExpression holder;
            UExpression arg = expressions.get(i);
            if (this.findHolderConstruction(context2, arg) == null) {
                return;
            }
            List args = holder.getValueArguments();
            if (args.size() < 2) continue;
            if (this.getExpectedType(holder, 1) == null) {
                return;
            }
            this.checkProperty(context2, (UExpression)args.get(0), targetClass, expectedType);
        }
    }

    private final void checkProperty(JavaContext context2, UExpression propertyNameExpression, PsiClass targetClass, String expectedType) {
        Object object = ConstantEvaluator.evaluate(context2, (UElement)propertyNameExpression);
        String string2 = object instanceof String ? (String)object : null;
        if (string2 == null) {
            return;
        }
        String property = string2;
        String string3 = targetClass.getQualifiedName();
        if (string3 == null) {
            return;
        }
        String qualifiedName = string3;
        if (StringsKt.indexOf$default((CharSequence)qualifiedName, (char)'.', (int)0, (boolean)false, (int)6, null) == -1) {
            return;
        }
        String methodName = this.getMethodName("set", property);
        PsiMethod[] psiMethodArray = targetClass.findMethodsByName(methodName, true);
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"findMethodsByName(...)");
        PsiMethod[] methods = psiMethodArray;
        PsiMethod bestMethod = null;
        boolean isExactMatch = false;
        for (PsiMethod m : methods) {
            if (m.getParameterList().getParametersCount() == 1) {
                if (bestMethod == null) {
                    bestMethod = m;
                }
                JavaEvaluator javaEvaluator = context2.getEvaluator();
                Intrinsics.checkNotNull((Object)m);
                String[] stringArray = new String[]{expectedType};
                if (!javaEvaluator.parametersMatch(m, stringArray)) continue;
                bestMethod = m;
                isExactMatch = true;
                break;
            }
            if (bestMethod != null) continue;
            bestMethod = m;
        }
        if (bestMethod == null) {
            this.report(context2, BROKEN_PROPERTY, propertyNameExpression, null, "Could not find property setter method `" + methodName + "` on `" + qualifiedName + "`", null);
            return;
        }
        if (!isExactMatch) {
            this.report(context2, BROKEN_PROPERTY, propertyNameExpression, bestMethod, "The setter for this property does not match the expected signature (`public void " + methodName + "(" + expectedType + " arg`)", null);
        } else if (context2.getEvaluator().isStatic((PsiModifierListOwner)bestMethod)) {
            this.report(context2, BROKEN_PROPERTY, propertyNameExpression, bestMethod, "The setter for this property (" + qualifiedName + "." + methodName + ") should not be static", null);
        } else {
            String className;
            PsiClass psiClass = bestMethod.getContainingClass();
            String string4 = className = psiClass != null ? psiClass.getQualifiedName() : null;
            if (className != null) {
                boolean handled1 = KeepRuleDetector.Companion.checkMethodUsage(context2, propertyNameExpression, null, className, methodName, null);
                boolean handled2 = KeepRuleDetector.Companion.checkMethodUsage(context2, propertyNameExpression, null, className, this.getMethodName("get", property), null);
                if (handled1 || handled2) {
                    return;
                }
            }
            PsiModifierListOwner owner = (PsiModifierListOwner)bestMethod;
            while (owner != null) {
                for (UAnnotation annotation : JavaEvaluator.getAnnotations$default(context2.getEvaluator(), owner, false, null, 4, null)) {
                    if (!KEEP_ANNOTATION.isEquals(annotation.getQualifiedName())) continue;
                    return;
                }
                owner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)owner), PsiModifierListOwner.class, (boolean)true);
            }
            if (!this.isShrinking(context2)) {
                return;
            }
            LintFix.Builder builder = this.fix();
            String string5 = KEEP_ANNOTATION.newName();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"newName(...)");
            LintFix fix2 = LintFix.Builder.annotate$default(builder, string5, context2, (PsiElement)bestMethod, false, 8, null).build();
            this.report(context2, MISSING_KEEP, propertyNameExpression, bestMethod, "This method is accessed from an ObjectAnimator so it should be annotated with `@Keep` to ensure that it is not discarded or renamed in release builds", fix2);
        }
    }

    private final void report(JavaContext context2, Issue issue, UExpression propertyNameExpression, PsiMethod method, String originalMessage, LintFix fix2) {
        Set alreadyWarned;
        boolean bl;
        boolean reportOnMethod;
        Object message = originalMessage;
        boolean bl2 = reportOnMethod = issue == MISSING_KEEP && method != null;
        if (reportOnMethod && method instanceof PsiCompiledElement) {
            return;
        }
        UExpression locationNode = reportOnMethod && method != null ? method : propertyNameExpression;
        Set set2 = this.mAlreadyWarned;
        if (set2 == null) {
            Set set3;
            ObjectAnimatorDetector $this$report_u24lambda_u240 = this;
            bl = false;
            Set set4 = Sets.newIdentityHashSet();
            Intrinsics.checkNotNullExpressionValue((Object)set4, (String)"newIdentityHashSet(...)");
            $this$report_u24lambda_u240.mAlreadyWarned = set3 = set4;
            set2 = set3;
        }
        if ((alreadyWarned = set2).contains(locationNode)) {
            return;
        }
        alreadyWarned.add((Object)locationNode);
        Location methodLocation = null;
        if (method != null && !(method instanceof PsiCompiledElement)) {
            Location location;
            PsiIdentifier nameIdentifier = method.getNameIdentifier();
            if (nameIdentifier != null) {
                PsiElement psiElement = (PsiElement)nameIdentifier;
                PsiParameterList psiParameterList = method.getParameterList();
                Intrinsics.checkNotNullExpressionValue((Object)psiParameterList, (String)"getParameterList(...)");
                location = context2.getRangeLocation(psiElement, 0, (PsiElement)psiParameterList, 0);
            } else {
                location = context2.getNameLocation((PsiElement)method);
            }
            methodLocation = location;
        }
        Location location = null;
        if (reportOnMethod && methodLocation != null && method != null) {
            location = methodLocation;
            Location secondary = context2.getLocation((UElement)propertyNameExpression);
            location.setSecondary(secondary);
            secondary.setMessage("ObjectAnimator usage here");
            if (this.isInSameCompilationUnit((UElement)propertyNameExpression, (PsiElement)method)) {
                secondary.setVisible(false);
            } else {
                boolean bl3 = bl = issue == MISSING_KEEP;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                String secondaryMessage = "The method referenced here (" + method.getName() + ") has not been annotated with `@Keep` which means it could be discarded or renamed in release builds";
                if (location == Location.NONE) {
                    location = secondary;
                    message = secondaryMessage;
                } else {
                    secondary.setMessage(secondaryMessage);
                }
            }
        } else {
            location = context2.getNameLocation((UElement)propertyNameExpression);
            if (methodLocation != null) {
                location = Location.withSecondary$default(location, methodLocation, "Property setter here", false, 4, null);
            }
        }
        UElement owner = UastUtils.getParentOfType((UElement)((UElement)propertyNameExpression), UDeclaration.class, (boolean)false);
        if (owner != null && context2.getDriver().isSuppressed(context2, issue, owner)) {
            return;
        }
        context2.report(issue, (PsiElement)method, location, (String)message, fix2);
    }

    private final String getExpectedType(UCallExpression method, int evaluatorIndex) {
        String methodName;
        String string2 = Lint.getMethodName(method);
        if (string2 == null) {
            return null;
        }
        switch (methodName = string2) {
            case "ofInt": 
            case "ofArgb": {
                return "int";
            }
            case "ofFloat": {
                return "float";
            }
            case "ofMultiInt": {
                return "int[]";
            }
            case "ofMultiFloat": {
                return "float[]";
            }
            case "ofKeyframe": {
                return "android.animation.Keyframe";
            }
            case "ofObject": {
                List args = method.getValueArguments();
                if (args.size() <= evaluatorIndex) break;
                PsiType psiType = TypeEvaluator.evaluate((UElement)args.get(evaluatorIndex));
                if (psiType == null) {
                    return null;
                }
                PsiType evaluatorType = psiType;
                return switch (evaluatorType.getCanonicalText()) {
                    case "android.animation.FloatEvaluator" -> "float";
                    case "android.animation.FloatArrayEvaluator" -> "float[]";
                    case "android.animation.IntEvaluator", "android.animation.ArgbEvaluator" -> "int";
                    case "android.animation.IntArrayEvaluator" -> "int[]";
                    case "android.animation.PointFEvaluator" -> "android.graphics.PointF";
                    default -> null;
                };
            }
        }
        return null;
    }

    private final UCallExpression findHolderConstruction(JavaContext context2, UExpression arg) {
        if (arg == null) {
            return null;
        }
        if (arg instanceof UCallExpression) {
            if (this.isHolderConstructionMethod(context2, (UCallExpression)arg)) {
                return (UCallExpression)arg;
            }
        } else if (arg instanceof UReferenceExpression) {
            PsiElement resolved;
            if (arg instanceof UQualifiedReferenceExpression && ((UQualifiedReferenceExpression)arg).getSelector() instanceof UCallExpression) {
                UExpression uExpression = ((UQualifiedReferenceExpression)arg).getSelector();
                Intrinsics.checkNotNull((Object)uExpression, (String)"null cannot be cast to non-null type org.jetbrains.uast.UCallExpression");
                UCallExpression selector = (UCallExpression)uExpression;
                if (this.isHolderConstructionMethod(context2, selector)) {
                    return selector;
                }
            }
            if ((resolved = ((UReferenceExpression)arg).resolve()) instanceof PsiVariable) {
                UExpression expression;
                PsiElement el;
                UExpression lastAssignment = UastLintUtils.Companion.findLastAssignment((PsiVariable)resolved, (UElement)arg);
                while (lastAssignment instanceof USimpleNameReferenceExpression && (el = ((USimpleNameReferenceExpression)lastAssignment).resolve()) instanceof PsiLocalVariable) {
                    lastAssignment = UastLintUtils.Companion.findLastAssignment((PsiVariable)el, (UElement)lastAssignment);
                }
                if (lastAssignment instanceof UCallExpression) {
                    UExpression callExpression = lastAssignment;
                    if (this.isHolderConstructionMethod(context2, (UCallExpression)callExpression)) {
                        return (UCallExpression)callExpression;
                    }
                } else if (lastAssignment instanceof UQualifiedReferenceExpression && ((UQualifiedReferenceExpression)(expression = lastAssignment)).getSelector() instanceof UCallExpression) {
                    UExpression uExpression = ((UQualifiedReferenceExpression)expression).getSelector();
                    Intrinsics.checkNotNull((Object)uExpression, (String)"null cannot be cast to non-null type org.jetbrains.uast.UCallExpression");
                    UCallExpression callExpression = (UCallExpression)uExpression;
                    if (this.isHolderConstructionMethod(context2, callExpression)) {
                        return callExpression;
                    }
                }
            }
        }
        return null;
    }

    private final boolean isHolderConstructionMethod(JavaContext context2, UCallExpression callExpression) {
        PsiMethod resolved;
        String referenceName = Lint.getMethodName(callExpression);
        return referenceName != null && StringsKt.startsWith$default((String)referenceName, (String)"of", (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)referenceName, (Object)"ofKeyframe") && (resolved = callExpression.resolve()) != null && context2.getEvaluator().isMemberInClass((PsiMember)resolved, "android.animation.PropertyValuesHolder");
    }

    private final boolean isInSameCompilationUnit(UElement element1, PsiElement element2) {
        PsiElement psi;
        PsiElement file;
        UFile containingFile;
        UFile uFile = containingFile = UastUtils.getContainingUFile((UElement)element1);
        Object object = file = uFile != null ? uFile.getJavaPsi() : null;
        if (file == null && (psi = element1.getJavaPsi()) != null) {
            file = (PsiElement)psi.getContainingFile();
        }
        return Intrinsics.areEqual((Object)file, (Object)element2.getContainingFile());
    }

    private final String getMethodName(String prefix, String propertyName) {
        if (propertyName == null || ((CharSequence)propertyName).length() == 0) {
            return prefix;
        }
        char firstLetter = Character.toUpperCase(propertyName.charAt(0));
        String string2 = propertyName.substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String theRest = string2;
        return prefix + firstLetter + theRest;
    }

    private final boolean isShrinking(Context context2) {
        Project project = context2.isGlobalAnalysis() ? context2.getMainProject() : context2.getProject();
        LintModelModule model = project.getBuildModule();
        return model != null ? !model.neverShrinking() : true;
    }

    @Override
    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkNotNullParameter((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.XML;
    }

    @Override
    @NotNull
    public Collection<String> getApplicableElements() {
        Object[] objectArray = new String[3];
        Intrinsics.checkNotNullExpressionValue((Object)AndroidXConstants.MOTION_LAYOUT.oldName(), (String)"oldName(...)");
        Intrinsics.checkNotNullExpressionValue((Object)AndroidXConstants.MOTION_LAYOUT.newName(), (String)"newName(...)");
        objectArray[2] = "CustomAttribute";
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void visitElement(@NotNull XmlContext context2, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (context2.getResourceFolderType() == ResourceFolderType.LAYOUT) {
            String sceneReference = element.getAttributeNS(MOTION_LAYOUT_URI, "layoutDescription");
            Intrinsics.checkNotNull((Object)sceneReference);
            if (((CharSequence)sceneReference).length() == 0) {
                return;
            }
            String string2 = sceneReference.substring(StringsKt.indexOf$default((CharSequence)sceneReference, (char)'/', (int)0, (boolean)false, (int)6, null) + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String sceneName = string2;
            Iterator iterator = DomExtensions.iterator((Element)element);
            while (iterator.hasNext()) {
                String id;
                Element view = (Element)iterator.next();
                String string3 = view.getTagName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getTagName(...)");
                if (!StringsKt.contains$default((CharSequence)string3, (CharSequence)".", (boolean)false, (int)2, null) || !(((CharSequence)(id = Lint.stripIdPrefix(view.getAttributeNS("http://schemas.android.com/apk/res/android", "id")))).length() > 0)) continue;
                List list2 = this.sceneIds;
                if (list2 == null) {
                    ObjectAnimatorDetector $this$visitElement_u24lambda_u240 = this;
                    boolean bl = false;
                    ArrayList list3 = new ArrayList();
                    $this$visitElement_u24lambda_u240.sceneIds = list3;
                    list2 = list3;
                }
                List list4 = list2;
                Collection collection = list4;
                String string4 = view.getTagName();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getTagName(...)");
                collection.add(new SceneReference(string4, id, sceneName));
            }
        } else {
            boolean sceneReference;
            boolean bl = sceneReference = context2.getResourceFolderType() == ResourceFolderType.XML;
            if (_Assertions.ENABLED && !sceneReference) {
                String sceneName = "Assertion failed";
                throw new AssertionError((Object)sceneName);
            }
            List<SceneReference> list5 = this.sceneIds;
            if (list5 == null) {
                return;
            }
            List<SceneReference> ids = list5;
            Attr attribute = element.getAttributeNodeNS(MOTION_LAYOUT_URI, "attributeName");
            if (attribute == null) {
                return;
            }
            String attributeName = attribute.getValue();
            Node list4 = element.getParentNode();
            Element element2 = list4 instanceof Element ? (Element)list4 : null;
            if (element2 == null) {
                return;
            }
            Element parent = element2;
            String parentId = Lint.stripIdPrefix(parent.getAttributeNS("http://schemas.android.com/apk/res/android", "id"));
            String string5 = context2.file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getName(...)");
            String sceneName = Lint.getBaseName(string5);
            for (SceneReference s : ids) {
                PsiMethod[] methods;
                PsiClass targetClass;
                if (!Intrinsics.areEqual((Object)parentId, (Object)s.getId()) || !Intrinsics.areEqual((Object)s.getScene(), (Object)sceneName)) continue;
                String viewClass = s.getViewClass();
                UastParser uastParser = context2.getClient().getUastParser(context2.getProject());
                JavaEvaluator evaluator = uastParser.getEvaluator();
                if (evaluator.findClass(viewClass) == null) continue;
                String methodName = this.getMethodName("set", attributeName);
                Intrinsics.checkNotNullExpressionValue((Object)targetClass.findMethodsByName(methodName, true), (String)"findMethodsByName(...)");
                for (PsiMethod m : methods) {
                    if (m.getParameterList().getParametersCount() != 1) continue;
                    PsiModifierListOwner owner = (PsiModifierListOwner)m;
                    while (owner != null) {
                        PsiModifierList modifierList = owner.getModifierList();
                        if (modifierList != null) {
                            PsiAnnotation[] psiAnnotationArray;
                            Intrinsics.checkNotNullExpressionValue((Object)modifierList.getAnnotations(), (String)"getAnnotations(...)");
                            for (PsiAnnotation annotation : psiAnnotationArray) {
                                if (!KEEP_ANNOTATION.isEquals(annotation.getQualifiedName())) continue;
                                return;
                            }
                        }
                        owner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)owner), PsiModifierListOwner.class, (boolean)true);
                    }
                    if (!this.isShrinking(context2)) {
                        return;
                    }
                    Location location = context2.getValueLocation(attribute);
                    LintDriver lintDriver = context2.getDriver();
                    Project project = context2.getProject();
                    Project project2 = context2.getProject();
                    File file = VfsUtilCore.virtualToIoFile((VirtualFile)targetClass.getContainingFile().getVirtualFile());
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"virtualToIoFile(...)");
                    JavaContext javaContext = new JavaContext(lintDriver, project, project2, file);
                    Intrinsics.checkNotNull((Object)m);
                    location.withSecondary(uastParser.getLocation(javaContext, (PsiElement)m), "This method is accessed via reflection from a MotionScene (" + sceneName + ") so it should be annotated with `@Keep` to ensure that it is not discarded or renamed in release builds", true);
                    Incident incident = new Incident(MISSING_KEEP, element, location, "This attribute references a method or property in custom view " + viewClass + " which is not annotated with `@Keep`; it should be annotated with `@Keep` to ensure that it is not discarded or renamed in release builds");
                    context2.report(incident, this.map());
                }
            }
        }
    }

    @Override
    public boolean filterIncident(@NotNull Context context2, @NotNull Incident incident, @NotNull LintMap map2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)map2, (String)"map");
        return this.isShrinking(context2);
    }

    static {
        Object object = new EnumSet[]{Scope.JAVA_FILE_SCOPE};
        IMPLEMENTATION = new Implementation((Class<? extends Detector>)ObjectAnimatorDetector.class, Scope.JAVA_AND_RESOURCE_FILES, (EnumSet<Scope>)object);
        object = Issue.Companion;
        Category category = Category.PERFORMANCE;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        MISSING_KEEP = Issue.Companion.create$default((Issue.Companion)object, "AnimatorKeep", "Missing @Keep for Animated Properties", "\n                    When you use property animators, properties can be accessed via reflection. \\\n                    Those methods should be annotated with @Keep to ensure that during release \\\n                    builds, the methods are not potentially treated as unused and removed, or \\\n                    treated as internal only and get renamed to something shorter.\n\n                    This check will also flag other potential reflection problems it encounters, \\\n                    such as a missing property, wrong argument types, etc.\n                    ", implementation, null, category, 4, severity, false, true, null, null, 3344, null);
        object = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.ERROR;
        implementation = IMPLEMENTATION;
        BROKEN_PROPERTY = Issue.Companion.create$default((Issue.Companion)object, "ObjectAnimatorBinding", "Incorrect ObjectAnimator Property", "\n                    This check cross references properties referenced by String from \\\n                    `ObjectAnimator` and `PropertyValuesHolder` method calls and ensures that \\\n                    the corresponding setter methods exist and have the right signatures.\n                    ", implementation, null, category, 4, severity, false, true, null, null, 3344, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/checks/ObjectAnimatorDetector$Companion;", "", "<init>", "()V", "MOTION_LAYOUT_URI", "", "KEEP_ANNOTATION", "Lcom/android/support/AndroidxName;", "kotlin.jvm.PlatformType", "getKEEP_ANNOTATION", "()Lcom/android/support/AndroidxName;", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "MISSING_KEEP", "Lcom/android/tools/lint/detector/api/Issue;", "BROKEN_PROPERTY", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public final AndroidxName getKEEP_ANNOTATION() {
            return KEEP_ANNOTATION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/lint/checks/ObjectAnimatorDetector$SceneReference;", "", "viewClass", "", "id", "scene", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getViewClass", "()Ljava/lang/String;", "getId", "getScene", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "android.sdktools.lint-checks"})
    private static final class SceneReference {
        @NotNull
        private final String viewClass;
        @NotNull
        private final String id;
        @NotNull
        private final String scene;

        public SceneReference(@NotNull String viewClass, @NotNull String id, @NotNull String scene) {
            Intrinsics.checkNotNullParameter((Object)viewClass, (String)"viewClass");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)scene, (String)"scene");
            this.viewClass = viewClass;
            this.id = id;
            this.scene = scene;
        }

        @NotNull
        public final String getViewClass() {
            return this.viewClass;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getScene() {
            return this.scene;
        }

        @NotNull
        public final String component1() {
            return this.viewClass;
        }

        @NotNull
        public final String component2() {
            return this.id;
        }

        @NotNull
        public final String component3() {
            return this.scene;
        }

        @NotNull
        public final SceneReference copy(@NotNull String viewClass, @NotNull String id, @NotNull String scene) {
            Intrinsics.checkNotNullParameter((Object)viewClass, (String)"viewClass");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)scene, (String)"scene");
            return new SceneReference(viewClass, id, scene);
        }

        public static /* synthetic */ SceneReference copy$default(SceneReference sceneReference, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = sceneReference.viewClass;
            }
            if ((n & 2) != 0) {
                string3 = sceneReference.id;
            }
            if ((n & 4) != 0) {
                string4 = sceneReference.scene;
            }
            return sceneReference.copy(string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "SceneReference(viewClass=" + this.viewClass + ", id=" + this.id + ", scene=" + this.scene + ")";
        }

        public int hashCode() {
            int result2 = this.viewClass.hashCode();
            result2 = result2 * 31 + this.id.hashCode();
            result2 = result2 * 31 + this.scene.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SceneReference)) {
                return false;
            }
            SceneReference sceneReference = (SceneReference)other;
            if (!Intrinsics.areEqual((Object)this.viewClass, (Object)sceneReference.viewClass)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.id, (Object)sceneReference.id)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.scene, (Object)sceneReference.scene);
        }
    }
}

