/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;

public class ManifestTypoDetector
extends Detector
implements XmlScanner {
    public static final Issue ISSUE = Issue.create("ManifestTypo", "Typos in manifest tags", "This check looks through the manifest, and if it finds any tags that look like likely misspellings, they are flagged.", Category.CORRECTNESS, 5, Severity.FATAL, new Implementation(ManifestTypoDetector.class, Scope.MANIFEST_SCOPE));
    private static final Set<String> sValidTags;

    @Override
    public Collection<String> getApplicableElements() {
        return Detector.XmlScanner.ALL;
    }

    @Override
    public void visitElement(XmlContext context2, Element element) {
        String tag = element.getTagName();
        if (!sValidTags.contains(tag)) {
            List suggestions = null;
            for (String suggestion : sValidTags) {
                if (!Lint.isEditableTo(suggestion, tag, 3)) continue;
                if (suggestions == null) {
                    suggestions = Lists.newArrayList();
                }
                suggestions.add("<" + suggestion + ">");
            }
            if (suggestions != null) {
                assert (!suggestions.isEmpty());
                String suggestionString = suggestions.size() == 1 ? (String)suggestions.get(0) : (suggestions.size() == 2 ? String.format("%1$s or %2$s", suggestions.get(0), suggestions.get(1)) : Lint.formatList(suggestions, -1));
                String message = String.format("Misspelled tag `<%1$s>`: Did you mean `%2$s`?", tag, suggestionString);
                context2.report(ISSUE, element, context2.getLocation(element), message);
            }
        }
    }

    static {
        int expectedSize = 32;
        sValidTags = Sets.newHashSetWithExpectedSize((int)expectedSize);
        sValidTags.add("manifest");
        sValidTags.add("application");
        sValidTags.add("activity");
        sValidTags.add("service");
        sValidTags.add("provider");
        sValidTags.add("receiver");
        sValidTags.add("sdk-library");
        sValidTags.add("uses-feature");
        sValidTags.add("uses-library");
        sValidTags.add("uses-sdk");
        sValidTags.add("uses-sdk-library");
        sValidTags.add("instrumentation");
        sValidTags.add("uses-permission");
        sValidTags.add("permission");
        sValidTags.add("permission-tree");
        sValidTags.add("permission-group");
        sValidTags.add("uses-configuration");
        sValidTags.add("activity-alias");
        sValidTags.add("intent-filter");
        sValidTags.add("meta-data");
        sValidTags.add("action");
        sValidTags.add("category");
        sValidTags.add("data");
        sValidTags.add("grant-uri-permission");
        sValidTags.add("path-permission");
        sValidTags.add("supports-screens");
        sValidTags.add("compatible-screens");
        sValidTags.add("supports-gl-texture");
        sValidTags.add("eat-comment");
        sValidTags.add("original-package");
        sValidTags.add("protected-broadcast");
        sValidTags.add("adopt-permissions");
        assert (sValidTags.size() <= expectedSize) : sValidTags.size();
    }
}

