/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.gradle.Component;
import com.android.ide.common.gradle.Version;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.repository.MavenRepositories;
import com.android.ide.common.repository.SdkMavenRepository;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceUrl;
import com.android.sdklib.AndroidVersion;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.client.api.XmlParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.LocationType;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.tools.lint.model.LintModelExternalLibrary;
import com.android.tools.lint.model.LintModelLibrary;
import com.android.tools.lint.model.LintModelMavenName;
import com.android.tools.lint.model.LintModelSourceProvider;
import com.android.tools.lint.model.LintModelVariant;
import com.android.utils.DomExtensions;
import com.android.utils.StringHelper;
import com.android.utils.XmlUtils;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 G2\u00020\u00012\u00020\u0002:\u0001GB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001a\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0003J\u001c\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\u0018\u0010!\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\"\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0015H\u0002J>\u0010%\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020,2\n\b\u0002\u0010-\u001a\u0004\u0018\u00010 H\u0002J \u0010.\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00152\u0006\u0010/\u001a\u00020\u000bH\u0002J\u000e\u00100\u001a\b\u0012\u0004\u0012\u00020\u000b01H\u0016J\u0018\u00102\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0015H\u0016J\u0010\u00104\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u00105\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J0\u00106\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u000b2\u0006\u0010<\u001a\u00020\u000bH\u0002J\u0010\u0010=\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0015H\u0002J\u0010\u0010>\u001a\u00020\u00062\u0006\u0010?\u001a\u00020@H\u0002J\u0018\u0010A\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0015H\u0002J\u0018\u0010B\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020#2\u0006\u0010C\u001a\u00020\u0015H\u0002J\u0018\u0010D\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020#2\u0006\u0010E\u001a\u00020\u001bH\u0002J\u0018\u0010F\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0015H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lcom/android/tools/lint/checks/ManifestDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "<init>", "()V", "seenApplication", "", "seenUsesSdk", "", "activities", "", "", "usesFeatures", "beforeCheckFile", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "afterCheckFile", "onlyCheckSourceManifest", "checkApplication", "application", "Lorg/w3c/dom/Element;", "checkBackup", "getExtraction", "client", "Lcom/android/tools/lint/client/api/LintClient;", "xmlFile", "Ljava/io/File;", "getDataExtractionFileContent", "fullBackupNode", "Lorg/w3c/dom/Attr;", "createDataExtractionRulesFix", "Lcom/android/tools/lint/detector/api/LintFix;", "checkIcon", "checkDocumentElement", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "reportFromManifest", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "node", "Lorg/w3c/dom/Node;", "message", "type", "Lcom/android/tools/lint/detector/api/LocationType;", "fix", "checkOverride", "attributeName", "getApplicableElements", "", "visitElement", "checkedUniquePermissions", "ensureUniquePermission", "checkMergedProject", "lookForNonUniqueNames", "mainProject", "Lcom/android/tools/lint/detector/api/Project;", "mergedManifest", "Lorg/w3c/dom/Document;", "humanReadableName", "tagName", "manifestMergerSkips", "hasWearableGmsDependency", "variant", "Lcom/android/tools/lint/model/LintModelVariant;", "checkMipmapIcon", "checkLabel", "activity", "isDebugOrTestManifest", "manifestFile", "checkDeviceAdmin", "Companion", "android.sdktools.lint-checks"})
@SourceDebugExtension(value={"SMAP\nManifestDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManifestDetector.kt\ncom/android/tools/lint/checks/ManifestDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1474:1\n1#2:1475\n1761#3,3:1476\n*S KotlinDebug\n*F\n+ 1 ManifestDetector.kt\ncom/android/tools/lint/checks/ManifestDetector\n*L\n1421#1:1476,3\n*E\n"})
public final class ManifestDetector
extends Detector
implements XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean seenApplication;
    private int seenUsesSdk;
    @Nullable
    private Set<String> activities;
    @Nullable
    private Set<String> usesFeatures;
    private boolean checkedUniquePermissions;
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(ManifestDetector.class, Scope.MANIFEST_SCOPE);
    @Nullable
    private static Calendar calendar;
    @JvmField
    @NotNull
    public static final Issue ORDER;
    @JvmField
    @NotNull
    public static final Issue MULTIPLE_USES_SDK;
    @JvmField
    @NotNull
    public static final Issue WRONG_PARENT;
    @JvmField
    @NotNull
    public static final Issue DUPLICATE_ACTIVITY;
    @JvmField
    @NotNull
    public static final Issue DATA_EXTRACTION_RULES;
    @JvmField
    @NotNull
    public static final Issue UNIQUE_PERMISSION;
    @JvmField
    @NotNull
    public static final Issue SET_VERSION;
    @JvmField
    @NotNull
    public static final Issue ILLEGAL_REFERENCE;
    @JvmField
    @NotNull
    public static final Issue DUPLICATE_USES_FEATURE;
    @JvmField
    @NotNull
    public static final Issue APPLICATION_ICON;
    @JvmField
    @NotNull
    public static final Issue DEVICE_ADMIN;
    @JvmField
    @NotNull
    public static final Issue MOCK_LOCATION;
    @JvmField
    @NotNull
    public static final Issue GRADLE_OVERRIDES;
    @JvmField
    @NotNull
    public static final Issue MIPMAP;
    @JvmField
    @NotNull
    public static final Issue WEARABLE_BIND_LISTENER;
    @JvmField
    @NotNull
    public static final Issue APP_INDEXING_SERVICE;
    @JvmField
    @NotNull
    public static final Issue REDUNDANT_LABEL;
    @NotNull
    public static final String MOCK_LOCATION_PERMISSION = "android.permission.ACCESS_MOCK_LOCATION";
    @NotNull
    private static final Version MIN_WEARABLE_GMS_VERSION;
    @NotNull
    private static final String PLAY_SERVICES_WEARABLE = "com.google.android.gms:play-services-wearable";
    @NotNull
    private static final String ATTR_DATA_EXTRACTION_RULES = "dataExtractionRules";

    @Override
    public void beforeCheckFile(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.seenApplication = false;
        this.seenUsesSdk = 0;
        this.activities = null;
        this.usesFeatures = null;
    }

    @Override
    public void afterCheckFile(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        XmlContext xmlContext = (XmlContext)context2;
        Element element = xmlContext.document.getDocumentElement();
        if (element == null) {
            return;
        }
        Element element2 = element;
        this.checkDocumentElement(xmlContext, element2);
    }

    private final boolean onlyCheckSourceManifest(Context context2) {
        return context2.getDriver().isIsolated();
    }

    private final void checkApplication(Context context2) {
        if (this.onlyCheckSourceManifest(context2)) {
            return;
        }
        Project mainProject = context2.getMainProject();
        Document document = mainProject.getMergedManifest();
        if (document == null) {
            return;
        }
        Document mergedManifest = document;
        Element element = mergedManifest.getDocumentElement();
        if (element == null) {
            return;
        }
        Element root2 = element;
        Element application = XmlUtils.getFirstSubTagByName((Node)root2, (String)"application");
        if (application == null || application.getFirstChild() == null && application.getAttributes().getLength() == 0) {
            return;
        }
        this.checkApplication(context2, application);
    }

    private final void checkApplication(Context context2, Element application) {
        if (context2.getProject().isLibrary()) {
            return;
        }
        this.checkBackup(context2, application);
        this.checkIcon(application, context2);
    }

    private final void checkBackup(Context context2, Element application) {
        if (!context2.isEnabled(DATA_EXTRACTION_RULES)) {
            return;
        }
        Attr allowBackupNode = application.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "allowBackup");
        Attr dataExtractionRules = application.getAttributeNodeNS("http://schemas.android.com/apk/res/android", ATTR_DATA_EXTRACTION_RULES);
        Attr fullBackupNode = application.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "fullBackupContent");
        Project project = context2.getMainProject();
        int min = project.getMinSdk();
        int target2 = project.getTargetSdk();
        if (min < 31 && target2 >= 31) {
            Attr attr = allowBackupNode;
            if (Intrinsics.areEqual((Object)(attr != null ? attr.getValue() : null), (Object)"false") && dataExtractionRules == null) {
                LintFix fix2 = this.createDataExtractionRulesFix(context2, fullBackupNode);
                this.reportFromManifest(context2, DATA_EXTRACTION_RULES, allowBackupNode, "The attribute `android:allowBackup` is deprecated from Android 12 and higher and may be removed in future versions. Consider adding the attribute `android:dataExtractionRules` specifying an `@xml` resource which configures cloud backups and device transfers on Android 12 and higher.", LocationType.VALUE, fix2);
            } else if (fullBackupNode != null && dataExtractionRules == null) {
                LintFix fix3 = this.createDataExtractionRulesFix(context2, fullBackupNode);
                this.reportFromManifest(context2, DATA_EXTRACTION_RULES, fullBackupNode, "The attribute `android:fullBackupContent` is deprecated from Android 12 and higher and may be removed in future versions. Consider adding the attribute `android:dataExtractionRules` specifying an `@xml` resource which configures cloud backups and device transfers on Android 12 and higher.", LocationType.VALUE, fix3);
            } else if (dataExtractionRules != null && fullBackupNode == null) {
                ManifestDetector.reportFromManifest$default(this, context2, DATA_EXTRACTION_RULES, dataExtractionRules, "The attribute `android:dataExtractionRules` only applies for Android 12 and higher; since `minSdkVersion` is API " + min + " you should also set `android:fullBackupContent`", LocationType.VALUE, null, 32, null);
            }
        } else if (min >= 31 && dataExtractionRules == null) {
            LintFix fix4;
            if (allowBackupNode != null && fullBackupNode == null && Intrinsics.areEqual((Object)allowBackupNode.getValue(), (Object)"true")) {
                this.reportFromManifest(context2, DATA_EXTRACTION_RULES, allowBackupNode, "The attribute `android:allowBackup` is deprecated from Android 12 and the default allows backup", LocationType.VALUE, this.fix().unset("http://schemas.android.com/apk/res/android", "allowBackup").build());
            } else if (allowBackupNode != null) {
                fix4 = this.createDataExtractionRulesFix(context2, fullBackupNode);
                this.reportFromManifest(context2, DATA_EXTRACTION_RULES, allowBackupNode, "The attribute `android:allowBackup` is deprecated from Android 12 and may be removed in future versions. Consider adding the attribute `android:dataExtractionRules` specifying an `@xml` resource which configures backups and device transfers on Android 12 and higher.", LocationType.VALUE, fix4);
            }
            if (fullBackupNode != null) {
                fix4 = this.createDataExtractionRulesFix(context2, fullBackupNode);
                this.reportFromManifest(context2, DATA_EXTRACTION_RULES, fullBackupNode, "The attribute `android:fullBackupContent` is deprecated from Android 12 and higher and may be removed in future versions. Consider adding the attribute `android:dataExtractionRules` specifying an `@xml` resource which configures backups and device transfers on Android 12 and higher.", LocationType.VALUE, fix4);
            }
        }
    }

    private final String getExtraction(LintClient client, File xmlFile) {
        String descriptor;
        block7: {
            String xml;
            XmlParser parser2 = client.getXmlParser();
            Node node = parser2.parseXml(xml = FilesKt.readText$default((File)xmlFile, null, (int)1, null), xmlFile);
            if (node == null || (node = node.getDocumentElement()) == null) {
                return null;
            }
            Node root2 = node;
            Node node2 = root2.getFirstChild();
            if (node2 == null) {
                return null;
            }
            Node first = node2;
            Node node3 = root2.getLastChild();
            if (node3 == null) {
                return null;
            }
            Node last = node3;
            int rootStart = parser2.getNodeStartOffset(client, xmlFile, root2);
            int firstStart = parser2.getNodeStartOffset(client, xmlFile, first);
            int lastEnd = parser2.getNodeEndOffset(client, xmlFile, last);
            if (rootStart == -1 || firstStart == -1 || lastEnd == -1) {
                return null;
            }
            List removeAttributes = new ArrayList();
            boolean clientSideEncryption = DomExtensions.visitAttributes((Element)root2, ManifestDetector::getExtraction$lambda$0);
            String string2 = xml.substring(0, rootStart);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String prefix = string2;
            String string3 = xml.substring(firstStart, lastEnd);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            Object childContent = string3;
            if (clientSideEncryption) {
                for (Attr attr : CollectionsKt.reversed((Iterable)removeAttributes)) {
                    int start2 = parser2.getNodeStartOffset(client, xmlFile, attr);
                    int end2 = parser2.getNodeEndOffset(client, xmlFile, attr);
                    if (start2 == -1 || end2 == -1) continue;
                    String string4 = ((String)childContent).substring(0, start2 - firstStart);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                    String string5 = ((String)childContent).substring(end2 - firstStart);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                    childContent = string4 + string5;
                }
            }
            String indented = StringsKt.removePrefix((String)CollectionsKt.joinToString$default((Iterable)StringsKt.lines((CharSequence)((CharSequence)childContent)), (CharSequence)"\n", null, null, (int)0, null, ManifestDetector::getExtraction$lambda$1, (int)30, null), (CharSequence)"    ");
            descriptor = null;
            descriptor = prefix + "<data-extraction-rules>\n    <cloud-backup" + (clientSideEncryption ? " disableIfNoEncryptionCapabilities=\"true\"" : "") + ">\n" + StringsKt.removePrefix((String)((Object)StringsKt.trimEnd((CharSequence)indented)).toString(), (CharSequence)"\n") + "\n    </cloud-backup>\n</data-extraction-rules>";
            Node node4 = parser2.parseXml(descriptor, xmlFile);
            if (node4 == null || (node4 = node4.getDocumentElement()) == null) break block7;
            Node doc = node4;
            boolean bl = false;
            List commentOut = new ArrayList();
            DomExtensions.visitAttributes((Element)doc, arg_0 -> ManifestDetector.getExtraction$lambda$2$0(commentOut, arg_0));
            for (Element element : CollectionsKt.reversed((Iterable)commentOut)) {
                int start3 = parser2.getNodeStartOffset(client, xmlFile, element);
                int end3 = parser2.getNodeEndOffset(client, xmlFile, element);
                if (start3 == -1 || end3 == -1) continue;
                String string6 = descriptor.substring(0, start3);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                String string7 = descriptor.substring(start3, end3);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
                String string8 = descriptor.substring(end3);
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"substring(...)");
                descriptor = string6 + "<!-- " + string7 + " -->" + string8;
            }
        }
        return descriptor;
    }

    @Language(value="XML")
    private final String getDataExtractionFileContent(Context context2, Attr fullBackupNode) {
        String string2;
        if (fullBackupNode != null && (string2 = fullBackupNode.getValue()) != null) {
            String it = string2;
            boolean bl = false;
            ResourceUrl resourceUrl = ResourceUrl.parse((String)it);
            if (resourceUrl != null) {
                ResourceUrl url = resourceUrl;
                boolean bl2 = false;
                LintClient client = context2.getClient();
                Project project = context2.getProject();
                ResourceRepository resources = client.getResources(project, ResourceRepositoryScope.LOCAL_DEPENDENCIES);
                List list2 = resources.getResources(ResourceNamespace.TODO(), url.type, url.name);
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getResources(...)");
                ResourceItem resourceItem = (ResourceItem)CollectionsKt.firstOrNull((List)list2);
                Object item = resourceItem != null ? resourceItem.getSource() : null;
                Object object = item;
                if (object != null && (object = object.toFile()) != null) {
                    Object file = object;
                    boolean bl3 = false;
                    String string3 = this.getExtraction(client, (File)file);
                    if (string3 != null) {
                        String it2 = string3;
                        boolean bl4 = false;
                        return it2;
                    }
                }
            }
        }
        String descriptor = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<!--\n   Sample data extraction rules file; uncomment and customize as necessary.\n   See https://developer.android.com/about/versions/12/backup-restore#xml-changes\n   for details.\n-->\n<data-extraction-rules>\n    <cloud-backup>\n        <!--\n        TODO: Use <include> and <exclude> to control what is backed up.\n        The domain can be file, database, sharedpref, external or root.\n        Examples:\n\n        <include domain=\"file\" path=\"file_to_include\"/>\n        <exclude domain=\"file\" path=\"file_to_exclude\"/>\n        <include domain=\"file\" path=\"include_folder\"/>\n        <exclude domain=\"file\" path=\"include_folder/file_to_exclude\"/>\n        <exclude domain=\"file\" path=\"exclude_folder\"/>\n        <include domain=\"file\" path=\"exclude_folder/file_to_include\"/>\n\n        <include domain=\"sharedpref\" path=\"include_shared_pref1.xml\"/>\n        <include domain=\"database\" path=\"db_name/file_to_include\"/>\n        <exclude domain=\"database\" path=\"db_name/include_folder/file_to_exclude\"/>\n        <include domain=\"external\" path=\"file_to_include\"/>\n        <exclude domain=\"external\" path=\"file_to_exclude\"/>\n        <include domain=\"root\" path=\"file_to_include\"/>\n        <exclude domain=\"root\" path=\"file_to_exclude\"/>\n        -->\n    </cloud-backup>\n    <!--\n    <device-transfer>\n        <include .../>\n        <exclude .../>\n    </device-transfer>\n    -->\n</data-extraction-rules>";
        return descriptor;
    }

    private final LintFix createDataExtractionRulesFix(Context context2, Attr fullBackupNode) {
        Project project = context2.getProject();
        List<File> list2 = project.getResourceFolders();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getResourceFolders(...)");
        File file = (File)CollectionsKt.firstOrNull(list2);
        if (file == null) {
            return null;
        }
        File folder = file;
        String name = "data_extraction_rules";
        File file2 = new File(folder, "xml" + File.separator + name + ".xml");
        if (file2.exists()) {
            return null;
        }
        String descriptor = this.getDataExtractionFileContent(context2, fullBackupNode);
        String select = StringsKt.contains$default((CharSequence)descriptor, (CharSequence)"TODO:", (boolean)false, (int)2, null) ? " ()TODO:" : (StringsKt.contains$default((CharSequence)descriptor, (CharSequence)"<include", (boolean)false, (int)2, null) ? "()<include" : "()");
        LintFix createFix = this.fix().newFile(file2, descriptor).select(select).build();
        LintFix setAttributeFix = this.fix().set("http://schemas.android.com/apk/res/android", ATTR_DATA_EXTRACTION_RULES, "@xml/" + name).build();
        LintFix[] lintFixArray = new LintFix[]{createFix, setAttributeFix};
        return this.fix().name("Create " + name + ".xml").composite(lintFixArray);
    }

    private final void checkIcon(Element application, Context context2) {
        if (!application.hasAttributeNS("http://schemas.android.com/apk/res/android", "icon") && context2.isEnabled(APPLICATION_ICON)) {
            LintFix fix2 = this.fix().set("http://schemas.android.com/apk/res/android", "icon", "@mipmap/").caretEnd().build();
            this.reportFromManifest(context2, APPLICATION_ICON, application, "Should explicitly set `android:icon`, there is no default", LocationType.NAME, fix2);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void checkDocumentElement(XmlContext context, Element element) {
        codeNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "versionCode");
        if (codeNode == null) ** GOTO lbl-1000
        v0 = codeNode.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getValue(...)");
        if (StringsKt.startsWith$default((String)v0, (String)"@", (boolean)false, (int)2, null) && context.isEnabled(ManifestDetector.ILLEGAL_REFERENCE)) {
            XmlContext.report$default(context, ManifestDetector.ILLEGAL_REFERENCE, element, context.getLocation(codeNode), "The `android:versionCode` cannot be a resource url, it must be a literal integer", null, 16, null);
        } else if (codeNode == null && context.isEnabled(ManifestDetector.SET_VERSION) && !context.getProject().isLibrary() && !context.getProject().isGradleProject()) {
            fix = LintFix.SetAttributeBuilder.todo$default(this.fix().set(), "http://schemas.android.com/apk/res/android", "versionCode", null, null, 12, null).build();
            context.report(ManifestDetector.SET_VERSION, element, context.getNameLocation(element), "Should set `android:versionCode` to specify the application version", fix);
        }
        nameNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "versionName");
        if (nameNode == null && context.isEnabled(ManifestDetector.SET_VERSION) && !context.getProject().isLibrary() && !context.getProject().isGradleProject()) {
            fix = LintFix.SetAttributeBuilder.todo$default(this.fix().set(), "http://schemas.android.com/apk/res/android", "versionName", null, null, 12, null).build();
            context.report(ManifestDetector.SET_VERSION, element, context.getNameLocation(element), "Should set `android:versionName` to specify the application version", fix);
        }
        if ((pkgNode = element.getAttributeNode("package")) != null) {
            pkg = pkgNode.getValue();
            Intrinsics.checkNotNull((Object)pkg);
            if (StringsKt.contains$default((CharSequence)pkg, (CharSequence)"${", (boolean)false, (int)2, null) && context.getProject().isGradleProject()) {
                XmlContext.report$default(context, ManifestDetector.GRADLE_OVERRIDES, pkgNode, context.getLocation(pkgNode), "Cannot use placeholder for the package in the manifest; set `applicationId` in `build.gradle` instead", null, 16, null);
            }
        }
    }

    private final void reportFromManifest(Context context2, Issue issue, Node node, String message, LocationType type, LintFix fix2) {
        Location location = context2.getLocation(node, type);
        if (location.getStart() == null) {
            return;
        }
        Incident incident = new Incident(issue, message, location, fix2);
        context2.report(incident);
        if (context2.isGlobalAnalysis()) {
            incident.project(context2.getMainProject());
        }
    }

    static /* synthetic */ void reportFromManifest$default(ManifestDetector manifestDetector, Context context2, Issue issue, Node node, String string2, LocationType locationType, LintFix lintFix, int n, Object object) {
        if ((n & 0x20) != 0) {
            lintFix = null;
        }
        manifestDetector.reportFromManifest(context2, issue, node, string2, locationType, lintFix);
    }

    private final void checkOverride(XmlContext context2, Element element, String attributeName) {
        LintModelVariant variant;
        Project project = context2.getProject();
        Attr attribute = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", attributeName);
        if (attribute != null && context2.isEnabled(GRADLE_OVERRIDES) && (variant = project.getBuildVariant()) != null) {
            String string2;
            if (Intrinsics.areEqual((Object)"minSdkVersion", (Object)attributeName)) {
                AndroidVersion minSdkVersion;
                if (element.hasAttributeNS("http://schemas.android.com/tools", "overrideLibrary")) {
                    return;
                }
                AndroidVersion androidVersion = minSdkVersion = variant.getMinSdkVersion();
                string2 = androidVersion != null ? androidVersion.getApiString() : null;
            } else if (Intrinsics.areEqual((Object)"targetSdkVersion", (Object)attributeName)) {
                AndroidVersion targetSdkVersion;
                AndroidVersion androidVersion = targetSdkVersion = variant.getTargetSdkVersion();
                string2 = androidVersion != null ? androidVersion.getApiString() : null;
            } else {
                if (_Assertions.ENABLED) {
                    boolean $i$a$-assert-ManifestDetector$checkOverride$gradleValue$22 = false;
                    String $i$a$-assert-ManifestDetector$checkOverride$gradleValue$22 = attributeName;
                    throw new AssertionError((Object)$i$a$-assert-ManifestDetector$checkOverride$gradleValue$22);
                }
                return;
            }
            String gradleValue = string2;
            if (gradleValue != null) {
                String manifestValue = attribute.getValue();
                String message = "This `" + attributeName + "` value (`" + manifestValue + "`) is not used; it is always overridden by the value specified in the Gradle build script (`" + gradleValue + "`)";
                XmlContext.report$default(context2, GRADLE_OVERRIDES, attribute, context2.getLocation(attribute), message, null, 16, null);
            }
        }
    }

    @Override
    @NotNull
    public Collection<String> getApplicableElements() {
        Object[] objectArray = new String[]{"application", "uses-permission", "permission", "permission-tree", "permission-group", "uses-sdk", "uses-configuration", "uses-feature", "supports-screens", "compatible-screens", "supports-gl-texture", "uses-library", "activity", "service", "provider", "receiver"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void visitElement(@NotNull XmlContext context2, @NotNull Element element) {
        Attr name;
        Attr nameNode;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String tag = element.getTagName();
        Node parentNode = element.getParentNode();
        boolean isReceiver = Intrinsics.areEqual((Object)tag, (Object)"receiver");
        if (isReceiver) {
            this.checkDeviceAdmin(context2, element);
        }
        if (Intrinsics.areEqual((Object)tag, (Object)"uses-library") || Intrinsics.areEqual((Object)tag, (Object)"activity") || Intrinsics.areEqual((Object)tag, (Object)"service") || isReceiver) {
            if (!Intrinsics.areEqual((Object)"application", (Object)parentNode.getNodeName()) && context2.isEnabled(WRONG_PARENT)) {
                XmlContext.report$default(context2, WRONG_PARENT, element, context2.getNameLocation(element), "The `<" + tag + ">` element must be a direct child of the <application> element", null, 16, null);
            }
            if (Intrinsics.areEqual((Object)tag, (Object)"activity")) {
                Attr nameNode2 = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
                if (nameNode2 != null) {
                    Object name2 = nameNode2.getValue();
                    String string2 = name2;
                    Intrinsics.checkNotNull((Object)string2);
                    if (((CharSequence)string2).length() > 0) {
                        Set set2;
                        Object pkg;
                        Object object = context2.document.getDocumentElement().getAttributeNode("package");
                        if (object == null || (object = object.getValue()) == null) {
                            object = pkg = context2.getProject().getPackage();
                        }
                        if (((String)name2).charAt(0) == '.') {
                            name2 = (String)pkg + (String)name2;
                        } else {
                            String string3 = name2;
                            Intrinsics.checkNotNull((Object)string3);
                            if (StringsKt.indexOf$default((CharSequence)string3, (char)'.', (int)0, (boolean)false, (int)6, null) == -1) {
                                name2 = (String)pkg + "." + (String)name2;
                            }
                        }
                        if ((set2 = this.activities) == null) {
                            Set set3;
                            Set it = set3 = (Set)new LinkedHashSet();
                            boolean bl = false;
                            this.activities = it;
                            set2 = set3;
                        }
                        Set activities = set2;
                        Object object2 = name2;
                        Intrinsics.checkNotNull((Object)object2);
                        if (!activities.add((String)object2)) {
                            String message = "Duplicate registration for activity `" + (String)name2 + "`";
                            XmlContext.report$default(context2, DUPLICATE_ACTIVITY, element, context2.getLocation(nameNode2), message, null, 16, null);
                        }
                    }
                }
                this.checkMipmapIcon(context2, element);
                this.checkLabel(context2, element);
            } else if (Intrinsics.areEqual((Object)tag, (Object)"service") && context2.getProject().isGradleProject()) {
                if (context2.getProject().getTargetSdk() >= 26) {
                    block0: for (Object child : XmlUtils.getSubTagsByName((Node)element, (String)"intent-filter")) {
                        for (Object innerChild : XmlUtils.getSubTagsByName((Node)((Node)child), (String)"action")) {
                            Attr attr = innerChild.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
                            if (attr == null || !Intrinsics.areEqual((Object)"com.google.firebase.appindexing.UPDATE_INDEX", (Object)attr.getValue())) continue;
                            String message = "`UPDATE_INDEX` is configured as a service in your app, which is no longer supported for the API level you're targeting. Use a `BroadcastReceiver` instead.";
                            Incident incident = new Incident(APP_INDEXING_SERVICE, attr, context2.getLocation(attr), message);
                            context2.report(incident, Constraints.targetSdkAtLeast(26));
                            continue block0;
                        }
                    }
                }
                Attr bindListenerAttr = null;
                block2: for (Element child : XmlUtils.getSubTagsByName((Node)element, (String)"intent-filter")) {
                    for (Element innerChild : XmlUtils.getSubTagsByName((Node)child, (String)"action")) {
                        Attr attr = innerChild.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
                        if (attr == null || !Intrinsics.areEqual((Object)"com.google.android.gms.wearable.BIND_LISTENER", (Object)attr.getValue())) continue;
                        bindListenerAttr = attr;
                        continue block2;
                    }
                }
                if (bindListenerAttr == null) {
                    return;
                }
                LintModelVariant variant = context2.getProject().getBuildVariant();
                if (variant != null && this.hasWearableGmsDependency(variant)) {
                    XmlContext.report$default(context2, WEARABLE_BIND_LISTENER, bindListenerAttr, context2.getLocation(bindListenerAttr), "The `com.google.android.gms.wearable.BIND_LISTENER` action is deprecated", null, 16, null);
                    return;
                }
                File sdkHome = context2.getClient().getSdkHome();
                if (context2.getProject().getBuildSdk() >= 24 && sdkHome != null) {
                    Component max;
                    Path repository2 = SdkMavenRepository.GOOGLE.getRepositoryLocation(sdkHome.toPath(), true);
                    Object message = "The `com.google.android.gms.wearable.BIND_LISTENER` action is deprecated. Please upgrade to the latest version of play-services-wearable 8.2.0 or later";
                    if (repository2 != null && (max = MavenRepositories.getHighestInstalledVersion((String)"com.google.android.gms", (String)"play-services-wearable", (Path)repository2, null, (boolean)false)) != null && max.getVersion().compareTo(MIN_WEARABLE_GMS_VERSION) > 0) {
                        message = "The `com.google.android.gms.wearable.BIND_LISTENER` action is deprecated. Please upgrade to the latest available version of play-services-wearable: `" + max.getVersion() + "`";
                    }
                    Location location = context2.getLocation(bindListenerAttr);
                    XmlContext.report$default(context2, WEARABLE_BIND_LISTENER, bindListenerAttr, location, (String)message, null, 16, null);
                }
            }
            return;
        }
        if (Intrinsics.areEqual((Object)tag, (Object)"provider")) {
            if (!Intrinsics.areEqual((Object)"application", (Object)parentNode.getNodeName()) && !Intrinsics.areEqual((Object)"queries", (Object)parentNode.getNodeName()) && context2.isEnabled(WRONG_PARENT)) {
                XmlContext.report$default(context2, WRONG_PARENT, element, context2.getNameLocation(element), "The `<" + tag + ">` element must be a direct child of the `<application>` element or the `<queries>` element", null, 16, null);
            }
            return;
        }
        if (parentNode != element.getOwnerDocument().getDocumentElement()) {
            Intrinsics.checkNotNull((Object)tag);
            if (StringsKt.indexOf$default((CharSequence)tag, (char)':', (int)0, (boolean)false, (int)6, null) == -1 && context2.isEnabled(WRONG_PARENT)) {
                XmlContext.report$default(context2, WRONG_PARENT, element, context2.getNameLocation(element), "The `<" + tag + ">` element must be a direct child of the `<manifest>` root element", null, 16, null);
            }
        }
        if (Intrinsics.areEqual((Object)tag, (Object)"uses-sdk")) {
            int bindListenerAttr = this.seenUsesSdk;
            this.seenUsesSdk = bindListenerAttr + 1;
            if (this.seenUsesSdk == 2) {
                Location location = context2.getNameLocation(element);
                NodeList elements = element.getOwnerDocument().getElementsByTagName("uses-sdk");
                Location secondary = null;
                for (int i = elements.getLength() - 1; -1 < i; --i) {
                    Node node = elements.item(i);
                    Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
                    Element e = (Element)node;
                    if (e == element) continue;
                    Location l = context2.getNameLocation(e);
                    l.setSecondary(secondary);
                    l.setMessage("Also appears here");
                    secondary = l;
                }
                location.setSecondary(secondary);
                if (context2.isEnabled(MULTIPLE_USES_SDK)) {
                    XmlContext.report$default(context2, MULTIPLE_USES_SDK, element, location, "There should only be a single `<uses-sdk>` element in the manifest: merge these together", null, 16, null);
                }
                return;
            }
            if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "minSdkVersion")) {
                Attr codeNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "minSdkVersion");
                if (codeNode != null) {
                    String string4 = codeNode.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getValue(...)");
                    if (StringsKt.startsWith$default((String)string4, (String)"@", (boolean)false, (int)2, null) && context2.isEnabled(ILLEGAL_REFERENCE)) {
                        XmlContext.report$default(context2, ILLEGAL_REFERENCE, element, context2.getLocation(codeNode), "The `android:minSdkVersion` cannot be a resource url, it must be a literal integer (or string if a preview codename)", null, 16, null);
                    }
                }
                this.checkOverride(context2, element, "minSdkVersion");
            }
            if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "targetSdkVersion")) {
                this.checkOverride(context2, element, "targetSdkVersion");
            }
            if ((nameNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "targetSdkVersion")) != null) {
                String string5 = nameNode.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getValue(...)");
                if (StringsKt.startsWith$default((String)string5, (String)"@", (boolean)false, (int)2, null) && context2.isEnabled(ILLEGAL_REFERENCE)) {
                    XmlContext.report$default(context2, ILLEGAL_REFERENCE, element, context2.getLocation(nameNode), "The `android:targetSdkVersion` cannot be a resource url, it must be a literal integer (or string if a preview codename)", null, 16, null);
                }
            }
        }
        if ((Intrinsics.areEqual((Object)tag, (Object)"permission") || Intrinsics.areEqual((Object)tag, (Object)"permission-group")) && context2.isGlobalAnalysis()) {
            this.ensureUniquePermission(context2);
        }
        if (Intrinsics.areEqual((Object)tag, (Object)"uses-permission") && (name = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name")) != null && Intrinsics.areEqual((Object)name.getValue(), (Object)MOCK_LOCATION_PERMISSION) && context2.getProject().getBuildModule() != null && !this.isDebugOrTestManifest(context2, context2.file) && context2.isEnabled(MOCK_LOCATION)) {
            String message = "Mock locations should only be requested in a test or debug-specific manifest file (typically `src/debug/AndroidManifest.xml`)";
            Location location = context2.getLocation(name);
            XmlContext.report$default(context2, MOCK_LOCATION, element, location, message, null, 16, null);
        }
        if (Intrinsics.areEqual((Object)tag, (Object)"application")) {
            this.seenApplication = true;
            if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "icon")) {
                this.checkMipmapIcon(context2, element);
            }
            if (this.onlyCheckSourceManifest(context2)) {
                this.checkApplication(context2, element);
            }
        } else if (this.seenApplication) {
            if (context2.isEnabled(ORDER)) {
                XmlContext.report$default(context2, ORDER, element, context2.getNameLocation(element), "`<" + tag + ">` tag appears after `<application>` tag", null, 16, null);
            }
            this.seenApplication = false;
        }
        if (Intrinsics.areEqual((Object)tag, (Object)"uses-feature") && (nameNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name")) != null) {
            String name3 = nameNode.getValue();
            Intrinsics.checkNotNull((Object)name3);
            if (((CharSequence)name3).length() > 0) {
                Set usesFeatures;
                Set set4 = this.usesFeatures;
                if (set4 == null) {
                    Set set5;
                    Set it = set5 = (Set)new LinkedHashSet();
                    boolean bl = false;
                    this.usesFeatures = it;
                    set4 = set5;
                }
                if (!(usesFeatures = set4).add((String)name3)) {
                    String message = "Duplicate declaration of uses-feature `" + name3 + "`";
                    XmlContext.report$default(context2, DUPLICATE_USES_FEATURE, element, context2.getLocation(nameNode), message, null, 16, null);
                }
            }
        }
    }

    private final void ensureUniquePermission(Context context2) {
        if (this.checkedUniquePermissions) {
            return;
        }
        this.checkedUniquePermissions = true;
        Project mainProject = context2.getMainProject();
        Document document = mainProject.getMergedManifest();
        if (document == null) {
            return;
        }
        Document mergedManifest = document;
        this.lookForNonUniqueNames(context2, mainProject, mergedManifest, "permission", "permission");
        this.lookForNonUniqueNames(context2, mainProject, mergedManifest, "permission group", "permission-group");
    }

    @Override
    public void checkMergedProject(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.ensureUniquePermission(context2);
        this.checkApplication(context2);
    }

    private final void lookForNonUniqueNames(Context context2, Project mainProject, Document mergedManifest, String humanReadableName, String tagName) {
        Map nameToFull = null;
        Element element = mergedManifest.getDocumentElement();
        if (element == null) {
            return;
        }
        Element root2 = element;
        Iterator iterator = DomExtensions.iterator((Element)root2);
        while (iterator.hasNext()) {
            Map map2;
            String base;
            Object pkg;
            Attr nameNode;
            String name;
            Element element2 = (Element)iterator.next();
            if (!Intrinsics.areEqual((Object)element2.getTagName(), (Object)tagName) || this.manifestMergerSkips(element2) || element2.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name") == null) continue;
            String string2 = name = nameNode.getValue();
            Intrinsics.checkNotNull((Object)string2);
            String string3 = name;
            Intrinsics.checkNotNull((Object)string3);
            int n = StringsKt.lastIndexOf$default((CharSequence)string3, (char)'.', (int)0, (boolean)false, (int)6, null) + 1;
            Intrinsics.checkNotNullExpressionValue((Object)string2.substring(n), (String)"substring(...)");
            Object object = mergedManifest.getDocumentElement().getAttributeNode("package");
            if (object == null || (object = object.getValue()) == null) {
                object = pkg = mainProject.getPackage();
            }
            if (!mainProject.isLibrary() && pkg != null) {
                String string4 = name;
                Intrinsics.checkNotNull((Object)string4);
                if (StringsKt.contains$default((CharSequence)string4, (CharSequence)"${applicationId}", (boolean)false, (int)2, null)) {
                    string4 = name;
                    Intrinsics.checkNotNull((Object)string4);
                    name = StringsKt.replace$default((String)string4, (String)"${applicationId}", (String)pkg, (boolean)false, (int)4, null);
                }
            }
            string3 = name;
            Intrinsics.checkNotNull((Object)string3);
            if (StringsKt.contains$default((CharSequence)string3, (CharSequence)"${", (boolean)false, (int)2, null)) continue;
            if (nameToFull != null) {
                if (nameToFull.containsKey(base) && !Intrinsics.areEqual((Object)name, nameToFull.get(base))) {
                    Node node;
                    String prevName = (String)nameToFull.get(base);
                    Location location = context2.getLocation(nameNode, LocationType.ALL);
                    NodeList siblings = element2.getParentNode().getChildNodes();
                    int n2 = siblings.getLength();
                    for (int i = 0; i < n2 && (node = siblings.item(i)) != element2; ++i) {
                        if (node.getNodeType() != 1) continue;
                        Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
                        Element sibling = (Element)node;
                        if (!Intrinsics.areEqual((Object)sibling.getTagName(), (Object)tagName) || !Intrinsics.areEqual((Object)prevName, (Object)sibling.getAttributeNS("http://schemas.android.com/apk/res/android", "name"))) continue;
                        Attr no = sibling.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
                        Location prevLocation = context2.getLocation(no, LocationType.VALUE);
                        prevLocation.setMessage("Previous " + humanReadableName + " here");
                        location.setSecondary(prevLocation);
                        break;
                    }
                    String message = StringHelper.usLocaleCapitalize((String)humanReadableName) + " name `" + base + "` is not unique (appears in both `" + prevName + "` and `" + name + "`)";
                    Incident incident = new Incident(UNIQUE_PERMISSION, element2, location, message);
                    context2.report(incident);
                    if (context2.isGlobalAnalysis()) {
                        incident.project(context2.getMainProject());
                    }
                }
                map2 = nameToFull;
            } else {
                Map map3;
                Map it = map3 = (Map)new LinkedHashMap();
                boolean bl = false;
                nameToFull = it;
                map2 = map3;
            }
            Map map4 = map2;
            map4.put(base, name);
        }
    }

    private final boolean manifestMergerSkips(Element element) {
        Attr operation = element.getAttributeNodeNS("http://schemas.android.com/tools", "node");
        if (operation != null) {
            String action = operation.getValue();
            Intrinsics.checkNotNull((Object)action);
            if (StringsKt.startsWith$default((String)action, (String)"remove", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)action, (Object)"replace")) {
                return true;
            }
        }
        return false;
    }

    private final boolean hasWearableGmsDependency(LintModelVariant variant) {
        LintModelLibrary lintModelLibrary = variant.getArtifact().findCompileDependency(PLAY_SERVICES_WEARABLE);
        LintModelExternalLibrary lintModelExternalLibrary = lintModelLibrary instanceof LintModelExternalLibrary ? (LintModelExternalLibrary)lintModelLibrary : null;
        if (lintModelExternalLibrary == null) {
            return false;
        }
        LintModelExternalLibrary library2 = lintModelExternalLibrary;
        LintModelMavenName mc = library2.getResolvedCoordinates();
        Version version2 = Version.Companion.parse(mc.getVersion());
        return version2.compareTo(MIN_WEARABLE_GMS_VERSION) >= 0;
    }

    private final void checkMipmapIcon(XmlContext context2, Element element) {
        Attr attr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "icon");
        if (attr == null) {
            return;
        }
        Attr attribute = attr;
        String icon = attribute.getValue();
        Intrinsics.checkNotNull((Object)icon);
        if (StringsKt.startsWith$default((String)icon, (String)"@drawable/", (boolean)false, (int)2, null)) {
            if (Intrinsics.areEqual((Object)"activity", (Object)element.getTagName()) && !Companion.isLaunchableActivity(element)) {
                return;
            }
            if (context2.isEnabled(MIPMAP) && context2.getProject().getApplicableDensities() != null) {
                XmlContext.report$default(context2, MIPMAP, element, context2.getLocation(attribute), "Should use `@mipmap` instead of `@drawable` for launcher icons", null, 16, null);
            }
        }
    }

    private final void checkLabel(XmlContext context2, Element activity) {
        Attr attr = activity.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "label");
        if (attr == null) {
            return;
        }
        Attr labelAttribute = attr;
        Node node = activity.getParentNode();
        Element element = node instanceof Element ? (Element)node : null;
        if (element == null) {
            return;
        }
        Element applicationElement = element;
        if (!Intrinsics.areEqual((Object)applicationElement.getNodeName(), (Object)"application")) {
            return;
        }
        String string2 = applicationElement.getAttributeNS("http://schemas.android.com/apk/res/android", "label");
        if (string2 == null) {
            return;
        }
        String applicationLabel = string2;
        if (Intrinsics.areEqual((Object)labelAttribute.getValue(), (Object)applicationLabel)) {
            LintFix fix2 = this.fix().unset("http://schemas.android.com/apk/res/android", "label").build();
            context2.report(REDUNDANT_LABEL, context2.getLocation(labelAttribute), "Redundant label can be removed", fix2);
        }
    }

    private final boolean isDebugOrTestManifest(XmlContext context2, File manifestFile) {
        LintModelVariant variant = context2.getProject().getBuildVariant();
        if (variant != null) {
            for (LintModelSourceProvider provider : variant.getSourceProviders()) {
                boolean bl;
                block5: {
                    if (!provider.isDebugOnly() && !provider.isTest()) continue;
                    Iterable $this$any$iv = provider.getManifestFiles();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            File it = (File)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it, (Object)manifestFile)) continue;
                            bl = true;
                            break block5;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                return true;
            }
        }
        return false;
    }

    private final void checkDeviceAdmin(XmlContext context2, Element element) {
        boolean requiredIntentFilterFound = false;
        boolean deviceAdmin = false;
        Attr locationNode = null;
        for (Element child : XmlUtils.getSubTags((Node)element)) {
            String name;
            Attr valueNode;
            String tagName = child.getTagName();
            if (Intrinsics.areEqual((Object)tagName, (Object)"intent-filter") && !requiredIntentFilterFound) {
                boolean dataFound = false;
                boolean actionFound = false;
                for (Element filterChild : XmlUtils.getSubTags((Node)child)) {
                    String filterTag = filterChild.getTagName();
                    if (Intrinsics.areEqual((Object)filterTag, (Object)"action")) {
                        String name2 = filterChild.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                        if (!Intrinsics.areEqual((Object)"android.app.action.DEVICE_ADMIN_ENABLED", (Object)name2)) continue;
                        actionFound = true;
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)filterTag, (Object)"data")) continue;
                    dataFound = true;
                }
                if (!actionFound || dataFound) continue;
                requiredIntentFilterFound = true;
                continue;
            }
            if (!Intrinsics.areEqual((Object)tagName, (Object)"meta-data") || (valueNode = child.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name")) == null || !Intrinsics.areEqual((Object)"android.app.device_admin", (Object)(name = valueNode.getValue()))) continue;
            deviceAdmin = true;
            locationNode = valueNode;
        }
        if (deviceAdmin && !requiredIntentFilterFound && context2.isEnabled(DEVICE_ADMIN)) {
            XmlContext.report$default(context2, DEVICE_ADMIN, locationNode, Context.getLocation$default(context2, locationNode, null, 2, null), "You must have an intent filter for action `android.app.action.DEVICE_ADMIN_ENABLED`", null, 16, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getExtraction$lambda$0(Attr it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!Intrinsics.areEqual((Object)it.getName(), (Object)"requireFlags")) return false;
        String string2 = it.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
        if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)"clientSideEncryption", (boolean)false, (int)2, null)) return false;
        return true;
    }

    private static final CharSequence getExtraction$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "    " + it;
    }

    private static final boolean getExtraction$lambda$2$0(List $commentOut, Attr it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (Intrinsics.areEqual((Object)it.getName(), (Object)"requireFlags")) {
            String string2 = it.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
            if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"deviceToDeviceTransfer", (boolean)false, (int)2, null)) {
                Element element = it.getOwnerElement();
                Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getOwnerElement(...)");
                $commentOut.add(element);
            }
        }
        return false;
    }

    @JvmStatic
    public static final boolean isLaunchableActivity(@NotNull Element activity) {
        return Companion.isLaunchableActivity(activity);
    }

    @JvmStatic
    @Nullable
    public static final Attr findLaunchableCategoryNode(@NotNull Element activity) {
        return Companion.findLaunchableCategoryNode(activity);
    }

    static {
        ORDER = Issue.Companion.create("ManifestOrder", "Incorrect order of elements in manifest", "\n                The `<application>` tag should appear after the elements which declare which version you need, \\\n                which features you need, which libraries you need, and so on. In the past there have been subtle \\\n                bugs (such as themes not getting applied correctly) when the `<application>` tag appears before \\\n                some of these other elements, so it's best to order your manifest in the logical dependency \\\n                order.\n                ", Category.CORRECTNESS, 5, Severity.WARNING, IMPLEMENTATION);
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Object object = Severity.FATAL;
        Implementation implementation = IMPLEMENTATION;
        MULTIPLE_USES_SDK = Issue.Companion.create$default(companion, "MultipleUsesSdk", "Multiple `<uses-sdk>` elements in the manifest", "\n                The `<uses-sdk>` element should appear just once; the tools will **not** merge the contents \\\n                of all the elements so if you split up the attributes across multiple elements, only one of \\\n                them will take effect. To fix this, just merge all the attributes from the various elements \\\n                into a single <uses-sdk> element.\n                ", implementation, "https://developer.android.com/guide/topics/manifest/uses-sdk-element.html", category, 6, object, false, null, null, null, 3840, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.FATAL;
        implementation = IMPLEMENTATION;
        WRONG_PARENT = Issue.Companion.create$default(companion, "WrongManifestParent", "Wrong manifest parent", "\n                The `<uses-library>` element should be defined as a direct child of the `<application>` \\\n                tag, not the `<manifest>` tag or an `<activity>` tag. Similarly, a `<uses-sdk>` tag must \\\n                be declared at the root level, and so on. This check looks for incorrect declaration \\\n                locations in the manifest, and complains if an element is found in the wrong place.\n                ", implementation, "https://developer.android.com/guide/topics/manifest/manifest-intro.html", category, 6, object, false, null, null, null, 3840, null);
        DUPLICATE_ACTIVITY = Issue.Companion.create("DuplicateActivity", "Activity registered more than once", "\n                An activity should only be registered once in the manifest. If it is accidentally \\\n                registered more than once, then subtle errors can occur, since attribute declarations \\\n                from the two elements are not merged, so you may accidentally remove previous \\\n                declarations.\n                ", Category.CORRECTNESS, 5, Severity.FATAL, IMPLEMENTATION);
        companion = Issue.Companion;
        category = Category.SECURITY;
        object = IMPLEMENTATION;
        DATA_EXTRACTION_RULES = Issue.Companion.create$default(companion, "DataExtractionRules", "Missing data extraction rules", "\n                Before Android 12, the attributes `android:allowBackup` and `android:fullBackupContent` \\\n                were used to configure all forms of backup, including cloud backups, device-to-device \\\n                transfers and adb backup.\n\n                In Android 12 and higher, these attributes have been deprecated and will only apply \\\n                to cloud backups. You should instead use the attribute `android:dataExtractionRules`, \\\n                specifying an `@xml` resource that configures which files to back up, for cloud backups \\\n                and for device-to-device transfers, separately. If your `minSdkVersion` supports older \\\n                versions, you'll still want to specify an `android:fullBackupContent` resource if the default \\\n                behavior is not right for your app.\n                ", (Implementation)object, "https://developer.android.com/about/versions/12/backup-restore#xml-changes", category, 3, null, false, null, null, null, 3968, null).addMoreInfo("https://goo.gle/DataExtractionRules");
        UNIQUE_PERMISSION = Issue.Companion.create("UniquePermission", "Permission names are not unique", "\n                The unqualified names or your permissions must be unique. The reason for this is that at \\\n                build time, the `aapt` tool will generate a class named `Manifest` which contains a field \\\n                for each of your permissions. These fields are named using your permission unqualified names \\\n                (i.e. the name portion after the last dot).\n\n                If more than one permission maps to the same field name, that field will arbitrarily name \\\n                just one of them.\n                ", Category.CORRECTNESS, 6, Severity.FATAL, IMPLEMENTATION);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.WARNING;
        implementation = IMPLEMENTATION;
        SET_VERSION = Issue.Companion.create$default(companion, "MissingVersion", "Missing application name/version", "\n                You should define the version information for your application.\n\n                `android:versionCode`: An integer value that represents the version of the application code, \\\n                relative to other versions.\n\n                `android:versionName`: A string value that represents the release version of the application \\\n                code, as it should be shown to users.\n                ", implementation, "https://developer.android.com/studio/publish/versioning#appversioning", category, 2, object, false, null, null, null, 3840, null);
        ILLEGAL_REFERENCE = Issue.Companion.create("IllegalResourceRef", "Name and version must be integer or string, not resource", "\n                For the `versionCode` attribute, you have to specify an actual integer literal; you cannot \\\n                use an indirection with a `@dimen/name` resource. Similarly, the `versionName` attribute \\\n                should be an actual string, not a string resource url.\n                ", Category.CORRECTNESS, 8, Severity.WARNING, IMPLEMENTATION);
        DUPLICATE_USES_FEATURE = Issue.Companion.create("DuplicateUsesFeature", "Feature declared more than once", "A given feature should only be declared once in the manifest.", Category.CORRECTNESS, 5, Severity.WARNING, IMPLEMENTATION);
        companion = Issue.Companion;
        category = Category.ICONS;
        object = Severity.WARNING;
        implementation = IMPLEMENTATION;
        APPLICATION_ICON = Issue.Companion.create$default(companion, "MissingApplicationIcon", "Missing application icon", "\n                You should set an icon for the application as whole because there is no default. This \\\n                attribute must be set as a reference to a drawable resource containing the image (for \\\n                example `@drawable/icon`).\n                ", implementation, "https://developer.android.com/studio/publish/preparing#publishing-configure", category, 5, object, false, null, null, null, 3840, null);
        DEVICE_ADMIN = Issue.Companion.create("DeviceAdmin", "Malformed Device Admin", "\n                If you register a broadcast receiver which acts as a device admin, you must also register \\\n                an `<intent-filter>` for the action `android.app.action.DEVICE_ADMIN_ENABLED`, without any \\\n                `<data>`, such that the device admin can be activated/deactivated.\n\n                To do this, add\n                ```xml\n                `<intent-filter>`\n                    `<action android:name=\"android.app.action.DEVICE_ADMIN_ENABLED\" />`\n                `</intent-filter>`\n                ```\n                to your `<receiver>`.\n                ", Category.CORRECTNESS, 7, Severity.WARNING, IMPLEMENTATION);
        MOCK_LOCATION = Issue.Companion.create("MockLocation", "Using mock location provider in production", "\n                Using a mock location provider (by requiring the permission `android.permission.ACCESS_MOCK_LOCATION`) should **only** be done in debug builds (or from tests). In Gradle projects, that means you should only request this permission in a test or debug source set specific manifest file.\n\n                To fix this, create a new manifest file in the debug folder and move the `<uses-permission>` element there. A typical path to a debug manifest override file in a Gradle project is src/debug/AndroidManifest.xml.\n                ", Category.CORRECTNESS, 8, Severity.FATAL, IMPLEMENTATION);
        GRADLE_OVERRIDES = Issue.Companion.create("GradleOverrides", "Value overridden by Gradle build script", "\n                The value of (for example) `minSdkVersion` is only used if it is not specified in the \\\n                `build.gradle` build scripts. When specified in the Gradle build scripts, the manifest \\\n                value is ignored and can be misleading, so should be removed to avoid ambiguity.\n                ", Category.CORRECTNESS, 4, Severity.WARNING, IMPLEMENTATION);
        MIPMAP = Issue.Companion.create("MipmapIcons", "Use Mipmap Launcher Icons", "\n                Launcher icons should be provided in the `mipmap` resource directory. This is the same as \\\n                the `drawable` resource directory, except resources in the `mipmap` directory will not get \\\n                stripped out when creating density-specific APKs.\n\n                In certain cases, the Launcher app may use a higher resolution asset (than would normally \\\n                be computed for the device) to display large app shortcuts. If drawables for densities \\\n                other than the device's resolution have been stripped out, then the app shortcut could \\\n                appear blurry.\n\n                To fix this, move your launcher icons from `drawable-`dpi to `mipmap-`dpi and change \\\n                references from @drawable/ and R.drawable to @mipmap/ and R.mipmap.\n\n                In Android Studio this lint warning has a quickfix to perform this automatically.\n                ", Category.ICONS, 5, Severity.WARNING, IMPLEMENTATION);
        companion = Issue.Companion;
        category = Category.PERFORMANCE;
        object = Severity.FATAL;
        implementation = IMPLEMENTATION;
        WEARABLE_BIND_LISTENER = Issue.Companion.create$default(companion, "WearableBindListener", "Usage of Android Wear BIND_LISTENER is deprecated", "\n                BIND_LISTENER receives all Android Wear events whether the application needs them or not. \\\n                This can be inefficient and cause applications to wake up unnecessarily. With Google Play \\\n                Services 8.2.0 or later it is recommended to use a more efficient combination of manifest \\\n                listeners and api-based live listeners filtered by action, path and/or path prefix.\n                ", implementation, "https://android-developers.googleblog.com/2016/04/deprecation-of-bindlistener.html", category, 6, object, false, null, null, null, 3840, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.WARNING;
        implementation = IMPLEMENTATION;
        APP_INDEXING_SERVICE = Issue.Companion.create$default(companion, "AppIndexingService", "App Indexing Background Services", "\n                Apps targeting Android 8.0 or higher can no longer rely on background services while \\\n                listening for updates to the on-device index. Use a `BroadcastReceiver` for the \\\n                `UPDATE_INDEX` intent to continue supporting indexing in your app.\n                ", implementation, "https://firebase.google.com/docs/app-indexing/android/personal-content#add-a-broadcast-receiver-to-your-app", category, 4, object, false, null, null, null, 3840, null);
        REDUNDANT_LABEL = Issue.Companion.create("RedundantLabel", "Redundant label on activity", "\n                When an activity does not have a label attribute, it will use the one from the application tag. \\\n                Since the application has already specified the same label, the label on this activity can be omitted.\n                ", Category.CORRECTNESS, 5, Severity.WARNING, IMPLEMENTATION);
        MIN_WEARABLE_GMS_VERSION = Version.Companion.parse("8.2.0");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0007J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010 \u001a\u00020!H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020%X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020%X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/android/tools/lint/checks/ManifestDetector$Companion;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "calendar", "Ljava/util/Calendar;", "getCalendar", "()Ljava/util/Calendar;", "setCalendar", "(Ljava/util/Calendar;)V", "ORDER", "Lcom/android/tools/lint/detector/api/Issue;", "MULTIPLE_USES_SDK", "WRONG_PARENT", "DUPLICATE_ACTIVITY", "DATA_EXTRACTION_RULES", "UNIQUE_PERMISSION", "SET_VERSION", "ILLEGAL_REFERENCE", "DUPLICATE_USES_FEATURE", "APPLICATION_ICON", "DEVICE_ADMIN", "MOCK_LOCATION", "GRADLE_OVERRIDES", "MIPMAP", "WEARABLE_BIND_LISTENER", "APP_INDEXING_SERVICE", "REDUNDANT_LABEL", "isLaunchableActivity", "", "activity", "Lorg/w3c/dom/Element;", "findLaunchableCategoryNode", "Lorg/w3c/dom/Attr;", "MOCK_LOCATION_PERMISSION", "", "MIN_WEARABLE_GMS_VERSION", "Lcom/android/ide/common/gradle/Version;", "PLAY_SERVICES_WEARABLE", "ATTR_DATA_EXTRACTION_RULES", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Calendar getCalendar() {
            return calendar;
        }

        public final void setCalendar(@Nullable Calendar calendar) {
            ManifestDetector.calendar = calendar;
        }

        @JvmStatic
        public final boolean isLaunchableActivity(@NotNull Element activity) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            return this.findLaunchableCategoryNode(activity) != null;
        }

        @JvmStatic
        @Nullable
        public final Attr findLaunchableCategoryNode(@NotNull Element activity) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            if (!Intrinsics.areEqual((Object)"activity", (Object)activity.getTagName())) {
                return null;
            }
            Iterator iterator = DomExtensions.iterator((Element)activity);
            while (iterator.hasNext()) {
                Element filter2 = (Element)iterator.next();
                if (!Intrinsics.areEqual((Object)filter2.getTagName(), (Object)"intent-filter")) continue;
                Iterator iterator2 = DomExtensions.iterator((Element)filter2);
                while (iterator2.hasNext()) {
                    Attr attribute;
                    Element category = (Element)iterator2.next();
                    if (!Intrinsics.areEqual((Object)category.getTagName(), (Object)"category") || (attribute = category.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name")) == null || !Intrinsics.areEqual((Object)attribute.getValue(), (Object)"android.intent.category.LAUNCHER")) continue;
                    return attribute;
                }
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

