/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UClass;

public class GetContentDescriptionOverrideDetector
extends Detector
implements SourceCodeScanner {
    public static final Issue ISSUE = Issue.create("GetContentDescriptionOverride", "Overriding `getContentDescription()` on a View", "Overriding `getContentDescription()` may prevent some accessibility services from properly navigating content exposed by your view. Instead, call `setContentDescription()` when the content description needs to be changed.", Category.A11Y, 9, Severity.ERROR, new Implementation(GetContentDescriptionOverrideDetector.class, Scope.JAVA_FILE_SCOPE)).setAndroidSpecific(true);

    @Override
    public List<String> applicableSuperClasses() {
        return Collections.singletonList("android.view.View");
    }

    @Override
    public void visitClass(JavaContext context2, UClass declaration) {
        JavaEvaluator evaluator = context2.getEvaluator();
        for (PsiMethod method : declaration.getJavaPsi().findMethodsByName("getContentDescription", false)) {
            if (evaluator.getParameterCount(method) != 0) continue;
            context2.report(ISSUE, (PsiElement)method, context2.getNameLocation((PsiElement)method), "Overriding `getContentDescription()` on a View is not recommended");
        }
    }
}

