/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.fonts.DownloadableParseResult;
import com.android.ide.common.fonts.FontDetail;
import com.android.ide.common.fonts.FontFamily;
import com.android.ide.common.fonts.FontLoader;
import com.android.ide.common.fonts.FontProvider;
import com.android.ide.common.fonts.FontQueryParserError;
import com.android.ide.common.fonts.MutableFontDetail;
import com.android.ide.common.fonts.QueryResolver;
import com.android.ide.common.gradle.Module;
import com.android.ide.common.gradle.Version;
import com.android.resources.ResourceFolderType;
import com.android.sdklib.AndroidVersion;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.model.LintModelExternalLibrary;
import com.android.tools.lint.model.LintModelLibrary;
import com.android.tools.lint.model.LintModelMavenName;
import com.android.tools.lint.model.LintModelVariant;
import com.android.utils.XmlUtils;
import com.google.common.base.Joiner;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FontDetector
extends ResourceXmlDetector {
    public static final int FIRST_API_VERSION_WITH_DOWNLOADABLE_FONTS_WORK_IN_FRAMEWORK = 28;
    public static final String KEY_ARTIFACT_ID = "artifact";
    public static final String KEY_UNEXPECTED_NAMESPACE = "unexpected-ns";
    public static final String KEY_APP_NAMESPACE = "app-namespace";
    private static final Implementation IMPLEMENTATION = new Implementation(FontDetector.class, Scope.RESOURCE_FILE_SCOPE);
    public static final Issue FONT_VALIDATION = Issue.create("FontValidation", "Validation of font files", "Look for problems in various font files.", Category.CORRECTNESS, 8, Severity.ERROR, IMPLEMENTATION).addMoreInfo("https://developer.android.com/guide/topics/text/downloadable-fonts.html").setAliases(Arrays.asList("FontValidationWarning", "FontValidationError"));
    public static final Module APPSUPPORT_MODULE = new Module("com.android.support", "appcompat-v7");
    private static final Version MIN_APPSUPPORT_VERSION = Version.parse((String)"26.0.0");
    private FontLoader mFontLoader;

    @Override
    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.FONT;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList("font-family", "font");
    }

    @Override
    public void beforeCheckRootProject(Context context2) {
        if (this.mFontLoader == null) {
            this.mFontLoader = FontLoader.getInstance((File)context2.getClient().getSdkHome());
        }
    }

    @Override
    public void visitElement(XmlContext context2, Element element) {
        boolean downloadableFontFile;
        Attr authority = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "fontProviderAuthority");
        Attr query = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "fontProviderQuery");
        Attr androidPackage = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "fontProviderPackage");
        Attr certs = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "fontProviderCerts");
        Attr appAuthority = element.getAttributeNodeNS("http://schemas.android.com/apk/res-auto", "fontProviderAuthority");
        Attr appQuery = element.getAttributeNodeNS("http://schemas.android.com/apk/res-auto", "fontProviderQuery");
        Attr appPackage = element.getAttributeNodeNS("http://schemas.android.com/apk/res-auto", "fontProviderPackage");
        Attr appCerts = element.getAttributeNodeNS("http://schemas.android.com/apk/res-auto", "fontProviderCerts");
        Attr firstAndroidAttribute = Lint.coalesce(authority, query, androidPackage, certs);
        Attr firstAppAttribute = Lint.coalesce(appAuthority, appQuery, appPackage, appCerts);
        List<String> missingAndroidAttributes = FontDetector.findMissingAttributes(authority, query, androidPackage, certs);
        List<String> missingAppAttributes = FontDetector.findMissingAttributes(appAuthority, appQuery, appPackage, appCerts);
        Element fontTag = XmlUtils.getFirstSubTagByName((Node)element, (String)"font");
        boolean bl = downloadableFontFile = Lint.coalesce(firstAndroidAttribute, firstAppAttribute) != null;
        if (downloadableFontFile) {
            FontDetector.checkSupportLibraryVersion(context2, element);
            if (FontDetector.reportMisplacedFontTag(context2, fontTag)) {
                return;
            }
            this.reportUnexpectedNamespace(context2, firstAndroidAttribute, firstAppAttribute);
            FontProvider provider = this.reportUnknownProvider(context2, authority, appAuthority);
            if (provider != null) {
                FontDetector.reportUnknownPackage(context2, androidPackage, appPackage, provider);
                this.reportQueryProblem(context2, query, appQuery, provider);
            }
            this.reportMissingAttribute(context2, firstAndroidAttribute, firstAppAttribute, missingAndroidAttributes, missingAppAttributes, provider);
        }
    }

    private static List<String> findMissingAttributes(Attr authority, Attr query, Attr packageName, Attr certs) {
        if (authority != null && query != null && packageName != null && certs != null) {
            return Collections.emptyList();
        }
        ArrayList<String> missing = new ArrayList<String>();
        if (authority == null) {
            missing.add("fontProviderAuthority");
        }
        if (query == null) {
            missing.add("fontProviderQuery");
        }
        if (packageName == null) {
            missing.add("fontProviderPackage");
        }
        if (certs == null) {
            missing.add("fontProviderCerts");
        }
        return missing;
    }

    private static void checkSupportLibraryVersion(XmlContext context2, Element element) {
        LintModelVariant variant = context2.getProject().getBuildVariant();
        if (variant == null) {
            return;
        }
        LintModelLibrary library2 = variant.getArtifact().findCompileDependency("com.android.support:appcompat-v7");
        if (!(library2 instanceof LintModelExternalLibrary)) {
            return;
        }
        LintModelExternalLibrary extLibrary = (LintModelExternalLibrary)library2;
        LintModelMavenName rc = extLibrary.getResolvedCoordinates();
        Version version2 = Version.parse((String)rc.getVersion());
        if (version2.compareTo(MIN_APPSUPPORT_VERSION) < 0) {
            String message = "Using version " + String.valueOf(version2) + " of the appcompat-v7 library. Required version for using downloadable fonts: " + String.valueOf(MIN_APPSUPPORT_VERSION) + " or higher.";
            LintFix fix2 = LintFix.create().data(KEY_ARTIFACT_ID, "appcompat-v7");
            FontDetector.reportError(context2, element, message, context2.getNameLocation(element), fix2);
        }
    }

    private static boolean reportMisplacedFontTag(XmlContext context2, Element fontTag) {
        if (fontTag == null) {
            return false;
        }
        LintFix fix2 = LintFix.create().replace().with("").range(context2.getLocation(fontTag)).build();
        FontDetector.reportError(context2, fontTag, "A downloadable font cannot have a `<font>` sub tag", context2.getElementLocation(fontTag), fix2);
        return true;
    }

    private void reportUnexpectedNamespace(XmlContext context2, Attr firstAndroidAttribute, Attr firstAppAttribute) {
        if (context2.getProject().getMinSdk() < 28 && firstAndroidAttribute != null) {
            this.reportUnexpectedNamespace(context2, firstAndroidAttribute, true);
        }
        if (firstAppAttribute != null) {
            this.reportUnexpectedNamespace(context2, firstAppAttribute, false);
        }
    }

    private void reportUnexpectedNamespace(XmlContext context2, Attr first, boolean appNamespace) {
        AndroidVersion minSdk = context2.getProject().getMinSdkVersion();
        String message = FontDetector.createUnexpectedAttributeMessage(appNamespace, minSdk);
        LintFix fix2 = LintFix.create().unset(first.getNamespaceURI(), first.getLocalName()).build();
        Incident incident = new Incident(FONT_VALIDATION, message, context2.getLocation(first), first, fix2).overrideSeverity(Severity.WARNING);
        context2.report(incident, this.map().put(KEY_UNEXPECTED_NAMESPACE, appNamespace));
    }

    private static String createUnexpectedAttributeMessage(boolean appNamespace, AndroidVersion minSdk) {
        String formatString = "For `minSdkVersion`=%1$d only `%2$s:` attributes should be used";
        String prefix = appNamespace ? "app" : "android";
        return String.format(Locale.US, formatString, minSdk.getApiLevel(), prefix);
    }

    @Override
    public boolean filterIncident(Context context2, Incident incident, LintMap map2) {
        if (map2.containsKey(KEY_UNEXPECTED_NAMESPACE)) {
            boolean app = map2.getBoolean(KEY_UNEXPECTED_NAMESPACE, false);
            AndroidVersion minSdk = context2.getMainProject().getMinSdkVersion();
            if (minSdk.getApiLevel() >= 28 ? app : !app) {
                return false;
            }
            String message = FontDetector.createUnexpectedAttributeMessage(app, minSdk);
            incident.setMessage(message);
            return true;
        }
        if (map2.containsKey(KEY_APP_NAMESPACE)) {
            boolean app = map2.getBoolean(KEY_APP_NAMESPACE, false);
            AndroidVersion minSdk = context2.getMainProject().getMinSdkVersion();
            if (minSdk.getFeatureLevel() <= 27) {
                return app;
            }
            return !app;
        }
        return false;
    }

    private void reportMissingAttribute(XmlContext context2, Attr firstAndroidAttribute, Attr firstAppAttribute, List<String> missingAndroidAttributes, List<String> missingAppAttributes, FontProvider provider) {
        AndroidVersion minSdk = context2.getProject().getMinSdkVersion();
        if (minSdk.getFeatureLevel() <= 27 && firstAppAttribute != null && !missingAppAttributes.isEmpty()) {
            this.reportMissingAppAttribute(context2, firstAppAttribute, missingAppAttributes, true, provider);
        }
        if (firstAndroidAttribute != null && !missingAndroidAttributes.isEmpty()) {
            this.reportMissingAppAttribute(context2, firstAndroidAttribute, missingAndroidAttributes, false, provider);
        }
    }

    private void reportMissingAppAttribute(XmlContext context2, Attr firstFontAttribute, List<String> missingAttributes, boolean appNamespace, FontProvider provider) {
        String namespaceUri = appNamespace ? "http://schemas.android.com/apk/res-auto" : "http://schemas.android.com/apk/res/android";
        String namespacePrefix = appNamespace ? "app" : "android";
        String message = String.format("Missing required %1$s: %2$s:%3$s", StringUtil.pluralize((String)"attribute", (int)missingAttributes.size()), namespacePrefix, Joiner.on((String)(", " + namespacePrefix + ":")).join(missingAttributes));
        LintFix fix2 = this.makeMissingAttributeFix(missingAttributes, namespaceUri, provider);
        Element element = firstFontAttribute.getOwnerElement();
        Incident incident = new Incident(FONT_VALIDATION, element, context2.getElementLocation(element), message, fix2);
        context2.report(incident, this.map().put(KEY_APP_NAMESPACE, appNamespace));
    }

    private LintFix makeMissingAttributeFix(List<String> missingAttributes, String namespaceUri, FontProvider provider) {
        if (provider == null) {
            provider = this.mFontLoader.findOnlyKnownProvider();
        }
        LintFix.GroupBuilder fix2 = this.fix().composite().name("Set missing attributes");
        for (String missingAttribute : missingAttributes) {
            String value = FontDetector.generateNewValue(missingAttribute, provider);
            if (value == null) {
                fix2.add(this.fix().set().todo(namespaceUri, missingAttribute).build());
                continue;
            }
            fix2.add(this.fix().set(namespaceUri, missingAttribute, value).build());
        }
        return fix2.build();
    }

    private static String generateNewValue(String missingAttribute, FontProvider provider) {
        if (provider == null) {
            return null;
        }
        switch (missingAttribute) {
            case "fontProviderAuthority": {
                return provider.getAuthority();
            }
            case "fontProviderPackage": {
                return provider.getPackageName();
            }
            case "fontProviderCerts": {
                return "@array/" + provider.getCertificateResourceName();
            }
        }
        return null;
    }

    private FontProvider reportUnknownProvider(XmlContext context2, Attr attrAuthority, Attr attrAppAuthority) {
        String authority = attrAuthority != null ? attrAuthority.getValue() : null;
        String appAuthority = attrAppAuthority != null ? attrAppAuthority.getValue() : null;
        FontProvider provider = null;
        if (authority != null) {
            provider = this.reportUnknownProvider(context2, attrAuthority, authority);
        } else if (appAuthority != null) {
            provider = this.reportUnknownProvider(context2, attrAppAuthority, appAuthority);
        }
        return provider;
    }

    private FontProvider reportUnknownProvider(XmlContext context2, Attr attrAuthority, String authority) {
        FontProvider provider = this.mFontLoader.findProvider(authority);
        if (provider != null) {
            return provider;
        }
        LintFix fix2 = null;
        FontProvider onlyKnownProvider = this.mFontLoader.findOnlyKnownProvider();
        if (onlyKnownProvider != null) {
            fix2 = this.fix().name("Replace with " + onlyKnownProvider.getAuthority()).replace().text(authority).with(onlyKnownProvider.getAuthority()).build();
        }
        FontDetector.reportError(context2, attrAuthority, "Unknown font provider authority", context2.getValueLocation(attrAuthority), fix2);
        return null;
    }

    private static void reportUnknownPackage(XmlContext context2, Attr attrAndroidPackage, Attr attrAppPackage, FontProvider provider) {
        String appPackage;
        String androidPackage = attrAndroidPackage != null ? attrAndroidPackage.getValue() : null;
        String string2 = appPackage = attrAppPackage != null ? attrAppPackage.getValue() : null;
        if (androidPackage != null && !androidPackage.equals(provider.getPackageName())) {
            FontDetector.reportUnknownPackage(context2, attrAndroidPackage, androidPackage, provider);
        } else if (appPackage != null && !appPackage.equals(provider.getPackageName())) {
            FontDetector.reportUnknownPackage(context2, attrAppPackage, appPackage, provider);
        }
    }

    private static void reportUnknownPackage(XmlContext context2, Attr attrPackage, String packageName, FontProvider provider) {
        if (provider.getPackageName().equals(packageName)) {
            return;
        }
        LintFix fix2 = LintFix.create().name("Replace with " + provider.getPackageName()).replace().text(packageName).with(provider.getPackageName()).build();
        FontDetector.reportError(context2, attrPackage, "Unexpected font provider package", context2.getValueLocation(attrPackage), fix2);
    }

    private void reportQueryProblem(XmlContext context2, Attr androidQueryAttr, Attr appQueryAttr, FontProvider provider) {
        String appQuery;
        String androidQuery = androidQueryAttr != null ? androidQueryAttr.getValue() : null;
        String string2 = appQuery = appQueryAttr != null ? appQueryAttr.getValue() : null;
        if (androidQuery != null) {
            this.reportQueryProblem(context2, androidQueryAttr, androidQuery, provider);
        } else if (appQuery != null) {
            this.reportQueryProblem(context2, appQueryAttr, appQuery, provider);
        }
    }

    private void reportQueryProblem(XmlContext context2, Attr queryAttr, String query, FontProvider provider) {
        if (query.isEmpty()) {
            LintFix fix2 = this.fix().set().todo(queryAttr.getNamespaceURI(), queryAttr.getLocalName()).build();
            FontDetector.reportError(context2, queryAttr, "Missing provider query", context2.getLocation(queryAttr), fix2);
            return;
        }
        try {
            DownloadableParseResult result2 = QueryResolver.parseDownloadableFont((String)provider.getAuthority(), (String)XmlUtils.fromXmlAttributeValue((String)query));
            if (!this.mFontLoader.fontsLoaded()) {
                return;
            }
            for (String fontName : result2.getFonts().keySet()) {
                FontFamily family = this.mFontLoader.findFont(provider, fontName);
                if (family == null) {
                    FontDetector.reportError(context2, queryAttr, "Unknown font: " + fontName, context2.getValueLocation(queryAttr), null);
                    continue;
                }
                for (MutableFontDetail detail : result2.getFonts().get((Object)fontName)) {
                    FontDetail best = detail.findBestMatch((Collection)family.getFonts());
                    if (best == null || detail.match(best) == 0.0f) continue;
                    LintFix fix3 = null;
                    if (result2.getFonts().size() == 1) {
                        boolean isV11;
                        if (!detail.getExact()) {
                            MutableFontDetail builder = best.toMutableFontDetail();
                            builder.setExact(false);
                            best = new FontDetail(best.getFamily(), builder);
                        }
                        String better = (isV11 = query.startsWith("name=")) ? best.generateQueryV11() : best.generateQueryV12();
                        fix3 = this.fix().name("Replace with closest font: " + better).set(queryAttr.getNamespaceURI(), queryAttr.getLocalName(), better).build();
                    }
                    if (detail.getExact()) {
                        FontDetector.reportError(context2, queryAttr, "No exact match found for: " + fontName, context2.getValueLocation(queryAttr), fix3);
                        continue;
                    }
                    FontDetector.reportWarning(context2, queryAttr, "No exact match found for: " + fontName, context2.getValueLocation(queryAttr), fix3);
                }
            }
        }
        catch (FontQueryParserError ex) {
            FontDetector.reportError(context2, queryAttr, ex.getMessage(), context2.getValueLocation(queryAttr), null);
        }
    }

    private static void reportError(XmlContext context2, Node node, String message, Location location, LintFix fix2) {
        Incident incident = new Incident(FONT_VALIDATION, node, location, message, fix2).overrideSeverity(Severity.ERROR);
        context2.report(incident);
    }

    private static void reportWarning(XmlContext context2, Node node, String message, Location location, LintFix fix2) {
        Incident incident = new Incident(FONT_VALIDATION, node, location, message, fix2).overrideSeverity(Severity.WARNING);
        context2.report(incident);
    }
}

