/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.AndroidXConstants;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.DomExtensions;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/checks/ChildCountDetector;", "Lcom/android/tools/lint/detector/api/LayoutDetector;", "<init>", "()V", "getApplicableElements", "", "", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "Issues", "android.sdktools.lint-checks"})
public final class ChildCountDetector
extends LayoutDetector {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(ChildCountDetector.class, Scope.RESOURCE_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue SCROLLVIEW_ISSUE = Issue.Companion.create("ScrollViewCount", "`ScrollView` can have only one child", "\n            A `ScrollView` can only have one child widget. If you want more children, wrap them \\\n            in a container layout.", Category.CORRECTNESS, 8, Severity.WARNING, IMPLEMENTATION);
    @JvmField
    @NotNull
    public static final Issue ADAPTER_VIEW_ISSUE;

    @Override
    @NotNull
    public Collection<String> getApplicableElements() {
        Object[] objectArray = new String[6];
        objectArray[0] = "ScrollView";
        objectArray[1] = "HorizontalScrollView";
        objectArray[2] = "ListView";
        objectArray[3] = "GridView";
        Intrinsics.checkNotNullExpressionValue((Object)AndroidXConstants.CLASS_NESTED_SCROLL_VIEW.oldName(), (String)"oldName(...)");
        Intrinsics.checkNotNullExpressionValue((Object)AndroidXConstants.CLASS_NESTED_SCROLL_VIEW.newName(), (String)"newName(...)");
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void visitElement(@NotNull XmlContext context2, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        int childCount = 0;
        Iterator iterator = DomExtensions.iterator((Element)element);
        while (iterator.hasNext()) {
            Element child = (Element)iterator.next();
            if (Lint.isLayoutMarkerTag(child)) continue;
            ++childCount;
        }
        String tagName = element.getTagName();
        if (Intrinsics.areEqual((Object)tagName, (Object)"ScrollView") || Intrinsics.areEqual((Object)tagName, (Object)"HorizontalScrollView") || Intrinsics.areEqual((Object)tagName, (Object)AndroidXConstants.CLASS_NESTED_SCROLL_VIEW.oldName()) || Intrinsics.areEqual((Object)tagName, (Object)AndroidXConstants.CLASS_NESTED_SCROLL_VIEW.newName())) {
            if (childCount > 1) {
                XmlContext.report$default(context2, SCROLLVIEW_ISSUE, element, context2.getNameLocation(element), "A scroll view can have only one child", null, 16, null);
            }
        } else if (childCount > 0) {
            XmlContext.report$default(context2, ADAPTER_VIEW_ISSUE, element, context2.getNameLocation(element), "A list/grid should have no children declared in XML", null, 16, null);
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        ADAPTER_VIEW_ISSUE = Issue.Companion.create$default(companion, "AdapterViewChildren", "`AdapterView` cannot have children in XML", "\n            An `AdapterView` such as a `ListView`s must be configured with data from Java code, such as a \\\n            `ListAdapter`.", implementation, "https://developer.android.com/reference/android/widget/AdapterView.html", category, 10, severity, false, null, null, null, 3840, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/checks/ChildCountDetector$Issues;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "SCROLLVIEW_ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "ADAPTER_VIEW_ISSUE", "android.sdktools.lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

