/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.model.LintModelArtifact;
import com.android.tools.lint.model.LintModelArtifactType;
import com.android.tools.lint.model.LintModelDependency;
import com.android.tools.lint.model.LintModelVariant;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\r\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011J\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u000bJ$\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u001e\u0010\u0018\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u00162\u0006\u0010\u0019\u001a\u00020\fH\u0002J\u001e\u0010\u001a\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u00162\u0006\u0010\u0019\u001a\u00020\fH\u0002J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\nH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\"\u0010\b\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/lint/checks/BlockedDependencies;", "", "project", "Lcom/android/tools/lint/detector/api/Project;", "<init>", "(Lcom/android/tools/lint/detector/api/Project;)V", "getProject", "()Lcom/android/tools/lint/detector/api/Project;", "map", "", "", "", "Lcom/android/tools/lint/model/LintModelDependency;", "checkDependency", "groupId", "artifactId", "remove", "", "getForbiddenDependencies", "visitLibraries", "", "stack", "Ljava/util/ArrayDeque;", "libraries", "visitLibrary", "library", "checkLibrary", "isForbiddenDependency", "mavenName", "android.sdktools.lint-checks"})
@SourceDebugExtension(value={"SMAP\nBlockedDependencies.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockedDependencies.kt\ncom/android/tools/lint/checks/BlockedDependencies\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n1#2:119\n1056#3:120\n*S KotlinDebug\n*F\n+ 1 BlockedDependencies.kt\ncom/android/tools/lint/checks/BlockedDependencies\n*L\n63#1:120\n*E\n"})
public final class BlockedDependencies {
    @NotNull
    private final Project project;
    @Nullable
    private Map<String, List<LintModelDependency>> map;

    public BlockedDependencies(@NotNull Project project) {
        block1: {
            LintModelArtifact artifact;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
            LintModelVariant lintModelVariant = this.project.getBuildVariant();
            LintModelArtifact lintModelArtifact = artifact = lintModelVariant != null ? lintModelVariant.getArtifact() : null;
            if ((lintModelArtifact != null ? lintModelArtifact.getType() : null) == LintModelArtifactType.UNIT_TEST) break block1;
            Object object = artifact;
            if (object != null && (object = object.getDependencies()) != null && (object = object.getCompileDependencies()) != null) {
                Object it = object;
                boolean bl = false;
                this.visitLibraries(new ArrayDeque<LintModelDependency>(), it.getRoots());
            }
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final List<LintModelDependency> checkDependency(@NotNull String groupId, @NotNull String artifactId, boolean remove) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Map<String, List<LintModelDependency>> map2 = this.map;
        if (map2 == null) {
            return null;
        }
        Map<String, List<LintModelDependency>> map3 = map2;
        String coordinate = groupId + ":" + artifactId;
        List<LintModelDependency> list2 = map3.get(coordinate);
        if (list2 == null) {
            return null;
        }
        List<LintModelDependency> path = list2;
        if (remove) {
            map3.remove(coordinate);
        }
        return path;
    }

    @NotNull
    public final List<List<LintModelDependency>> getForbiddenDependencies() {
        Map<String, List<LintModelDependency>> map2 = this.map;
        if (map2 == null) {
            return CollectionsKt.emptyList();
        }
        Map<String, List<LintModelDependency>> map3 = map2;
        Iterable $this$sortedBy$iv = CollectionsKt.toMutableList(map3.values());
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                List it = (List)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((LintModelDependency)it.get(0)).getArtifactName());
                it = (List)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((LintModelDependency)it.get(0)).getArtifactName())));
            }
        });
    }

    private final void visitLibraries(ArrayDeque<LintModelDependency> stack, List<? extends LintModelDependency> libraries) {
        for (LintModelDependency lintModelDependency : libraries) {
            this.visitLibrary(stack, lintModelDependency);
        }
    }

    private final void visitLibrary(ArrayDeque<LintModelDependency> stack, LintModelDependency library2) {
        stack.addLast(library2);
        this.checkLibrary(stack, library2);
        this.visitLibraries(stack, library2.getDependencies());
        stack.removeLast();
    }

    private final void checkLibrary(ArrayDeque<LintModelDependency> stack, LintModelDependency library2) {
        block2: {
            if (!this.isForbiddenDependency(library2.getArtifactName())) break block2;
            if (this.map == null) {
                this.map = new HashMap();
            }
            String root2 = stack.getFirst().getArtifactName();
            Map<String, List<LintModelDependency>> map2 = this.map;
            if (map2 != null) {
                List cfr_ignored_0 = map2.put(root2, new ArrayList(stack));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isForbiddenDependency(String mavenName) {
        String string2 = mavenName;
        switch (string2.hashCode()) {
            case 1291429832: {
                if (string2.equals("org.khronos:opengl-api")) return true;
                return false;
            }
            case 1706896089: {
                if (string2.equals("org.apache.httpcomponents:httpclient")) return true;
                return false;
            }
            case 1788496316: {
                if (string2.equals("com.google.android:android")) return true;
                return false;
            }
            case 485891553: {
                if (string2.equals("xerces:xmlParserAPIs")) return true;
                return false;
            }
            case 1908559898: {
                if (string2.equals("xpp3:xpp3")) return true;
                return false;
            }
            case 366134650: {
                if (string2.equals("commons-logging:commons-logging")) return true;
                return false;
            }
            case 1653266864: {
                if (!string2.equals("org.json:json")) return false;
                return true;
            }
        }
        return false;
    }
}

