/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UReferenceExpression;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class AlwaysShowActionDetector
extends ResourceXmlDetector
implements SourceCodeScanner {
    public static final Issue ISSUE = Issue.create("AlwaysShowAction", "Usage of `showAsAction=always`", "Using `showAsAction=\"always\"` in menu XML, or `MenuItem.SHOW_AS_ACTION_ALWAYS` in Java code is usually a deviation from the user interface style guide.Use `ifRoom` or the corresponding `MenuItem.SHOW_AS_ACTION_IF_ROOM` instead.\n\nIf `always` is used sparingly there are usually no problems and behavior is roughly equivalent to `ifRoom` but with preference over other `ifRoom` items. Using it more than twice in the same menu is a bad idea.\n\nThis check looks for menu XML files that contain more than two `always` actions, or some `always` actions and no `ifRoom` actions. In Java code, it looks for projects that contain references to `MenuItem.SHOW_AS_ACTION_ALWAYS` and no references to `MenuItem.SHOW_AS_ACTION_IF_ROOM`.", Category.USABILITY, 3, Severity.WARNING, new Implementation(AlwaysShowActionDetector.class, Scope.JAVA_AND_RESOURCE_FILES, Scope.RESOURCE_FILE_SCOPE));
    private List<Attr> mFileAttributes;
    private boolean mIgnoreFile;
    private List<Location> mAlwaysFields;
    private boolean mHasIfRoomRefs;

    @Override
    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.MENU;
    }

    @Override
    public Collection<String> getApplicableAttributes() {
        return Collections.singletonList("showAsAction");
    }

    @Override
    public void beforeCheckFile(Context context2) {
        this.mFileAttributes = null;
    }

    @Override
    public void afterCheckFile(Context context2) {
        if (this.mIgnoreFile) {
            this.mFileAttributes = null;
            return;
        }
        if (this.mFileAttributes != null) {
            assert (context2 instanceof XmlContext);
            ArrayList<Attr> always = new ArrayList<Attr>();
            ArrayList<Attr> ifRoom = new ArrayList<Attr>();
            block0: for (Attr attribute : this.mFileAttributes) {
                String[] flags;
                String value = attribute.getValue();
                if (value.equals("always")) {
                    always.add(attribute);
                    continue;
                }
                if (value.equals("ifRoom")) {
                    ifRoom.add(attribute);
                    continue;
                }
                if (value.indexOf(124) == -1) continue;
                for (String flag : flags = value.split("\\|")) {
                    if (flag.equals("always")) {
                        always.add(attribute);
                        continue block0;
                    }
                    if (!flag.equals("ifRoom")) continue;
                    ifRoom.add(attribute);
                    continue block0;
                }
            }
            if (!always.isEmpty() && this.mFileAttributes.size() > 1 && (always.size() > 2 || ifRoom.isEmpty())) {
                XmlContext xmlContext = (XmlContext)context2;
                Location location = null;
                for (int i = always.size() - 1; i >= 0; --i) {
                    Location next = location;
                    location = xmlContext.getLocation((Node)always.get(i));
                    if (next == null) continue;
                    location.setSecondary(next);
                }
                if (location != null) {
                    LintFix fix2 = this.fix().replace().pattern("(always)").with("ifRoom").build();
                    context2.report(ISSUE, location, "Prefer \"`ifRoom`\" instead of \"`always`\"", fix2);
                }
            }
        }
    }

    @Override
    public void afterCheckRootProject(Context context2) {
        if (this.mAlwaysFields != null && !this.mHasIfRoomRefs) {
            for (Location location : this.mAlwaysFields) {
                context2.report(ISSUE, location, "Prefer \"`SHOW_AS_ACTION_IF_ROOM`\" instead of \"`SHOW_AS_ACTION_ALWAYS`\"");
            }
        }
    }

    @Override
    public void visitAttribute(XmlContext context2, Attr attribute) {
        if (context2.getDriver().isSuppressed(context2, ISSUE, attribute)) {
            this.mIgnoreFile = true;
            return;
        }
        if (this.mFileAttributes == null) {
            this.mFileAttributes = new ArrayList<Attr>();
        }
        this.mFileAttributes.add(attribute);
    }

    @Override
    public List<String> getApplicableReferenceNames() {
        return Arrays.asList("SHOW_AS_ACTION_IF_ROOM", "SHOW_AS_ACTION_ALWAYS");
    }

    @Override
    public void visitReference(JavaContext context2, UReferenceExpression reference, PsiElement resolved) {
        if (resolved instanceof PsiField && context2.getEvaluator().isMemberInClass((PsiMember)((PsiField)resolved), "android.view.MenuItem")) {
            if ("SHOW_AS_ACTION_ALWAYS".equals(reference.getResolvedName())) {
                if (context2.getDriver().isSuppressed(context2, ISSUE, (UElement)reference)) {
                    return;
                }
                if (this.mAlwaysFields == null) {
                    this.mAlwaysFields = new ArrayList<Location>();
                }
                this.mAlwaysFields.add(context2.getLocation((UElement)reference));
            } else {
                this.mHasIfRoomRefs = true;
            }
        }
    }
}

