/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deploy.proto.Deploy;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.JvmtiErrorCode;
import com.google.common.base.Enums;
import com.google.common.base.Optional;
import java.util.List;

public class InstallerResponseHandler {
    private final boolean canAddFields;

    InstallerResponseHandler(RedefinitionCapability capability) {
        this.canAddFields = capability == RedefinitionCapability.ALLOW_ADD_FIELD;
    }

    public SuccessStatus handle(Deploy.SwapResponse response) throws DeployerException {
        if (response.getStatus() == Deploy.SwapResponse.Status.OK) {
            return SuccessStatus.OK;
        }
        if (response.getStatus() == Deploy.SwapResponse.Status.SWAP_FAILED_BUT_OVERLAY_UPDATED) {
            return SuccessStatus.SWAP_FAILED_BUT_APP_UPDATED;
        }
        if (response.getStatus() == Deploy.SwapResponse.Status.PROCESS_CRASHING) {
            throw DeployerException.processCrashing(response.getExtra());
        }
        if (response.getStatus() == Deploy.SwapResponse.Status.PROCESS_NOT_RESPONDING) {
            throw DeployerException.processNotResponding(response.getExtra());
        }
        if (response.getStatus() == Deploy.SwapResponse.Status.PROCESS_TERMINATED) {
            throw DeployerException.processTerminated(response.getExtra());
        }
        if (response.getStatus() != Deploy.SwapResponse.Status.AGENT_ERROR) {
            throw DeployerException.swapFailed(response.getStatus());
        }
        return this.handleAgentFailures(response.getFailedAgentsList());
    }

    private SuccessStatus handleAgentFailures(List<Deploy.AgentResponse> failedAgents) throws DeployerException {
        if (failedAgents.isEmpty()) {
            return SuccessStatus.OK;
        }
        Deploy.AgentResponse failedAgent = failedAgents.get(0);
        if (failedAgent.getStatus() == Deploy.AgentResponse.Status.SWAP_FAILURE) {
            this.handleAgentSwapFailures(failedAgent.getSwapResponse());
        }
        throw DeployerException.agentFailed(failedAgent.getStatus());
    }

    private SuccessStatus handleAgentSwapFailures(Deploy.AgentSwapResponse failedAgent) throws DeployerException {
        if (failedAgent.getStatus() == Deploy.AgentSwapResponse.Status.CLASS_NOT_FOUND) {
            throw DeployerException.classNotFound(failedAgent.getClassName());
        }
        if (failedAgent.getStatus() == Deploy.AgentSwapResponse.Status.UNSUPPORTED_REINIT || failedAgent.getStatus() == Deploy.AgentSwapResponse.Status.UNSUPPORTED_REINIT_STATIC_PRIMITIVE || failedAgent.getStatus() == Deploy.AgentSwapResponse.Status.UNSUPPORTED_REINIT_STATIC_PRIMITIVE_NOT_CONSTANT || failedAgent.getStatus() == Deploy.AgentSwapResponse.Status.UNSUPPORTED_REINIT_STATIC_OBJECT || failedAgent.getStatus() == Deploy.AgentSwapResponse.Status.UNSUPPORTED_REINIT_STATIC_ARRAY || failedAgent.getStatus() == Deploy.AgentSwapResponse.Status.UNSUPPORTED_REINIT_NON_STATIC_PRIMITIVE || failedAgent.getStatus() == Deploy.AgentSwapResponse.Status.UNSUPPORTED_REINIT_NON_STATIC_OBJECT || failedAgent.getStatus() == Deploy.AgentSwapResponse.Status.UNSUPPORTED_REINIT_NON_STATIC_ARRAY) {
            throw DeployerException.unsupportedVariableReinit(failedAgent.getStatus(), failedAgent.getErrorMsg());
        }
        if (failedAgent.getStatus() == Deploy.AgentSwapResponse.Status.UNSUPPORTED_REINIT_R_CLASS_VALUE_MODIFIED) {
            throw DeployerException.unsupportedRClassReassignment(failedAgent.getStatus(), failedAgent.getErrorMsg());
        }
        if (failedAgent.getStatus() == Deploy.AgentSwapResponse.Status.JVMTI_ERROR) {
            this.handleJvmtiError(failedAgent.getJvmtiError());
        }
        if (failedAgent.getStatus() == Deploy.AgentSwapResponse.Status.LIVE_EDIT_PRIMED_CLASSES) {
            throw DeployerException.swapAfterLeNotSupported();
        }
        throw DeployerException.agentSwapFailed(failedAgent.getStatus());
    }

    private void handleJvmtiError(Deploy.JvmtiError jvmtiError) throws DeployerException {
        if (jvmtiError.getDetailsCount() == 0) {
            Optional errorCode = Enums.getIfPresent(JvmtiErrorCode.class, (String)jvmtiError.getErrorCode());
            throw DeployerException.jvmtiError((JvmtiErrorCode)((Object)errorCode.or((Object)JvmtiErrorCode.UNKNOWN_JVMTI_ERROR)), this.canAddFields);
        }
        Deploy.JvmtiError.Details details = (Deploy.JvmtiError.Details)jvmtiError.getDetailsList().get(0);
        String parentClass = details.getClassName();
        String resType = parentClass.substring(parentClass.lastIndexOf(36) + 1);
        if (details.getType() == Deploy.JvmtiError.Details.Type.FIELD_ADDED) {
            throw DeployerException.addedResources(details.getName(), resType);
        }
        if (details.getType() == Deploy.JvmtiError.Details.Type.FIELD_REMOVED) {
            throw DeployerException.removedResources(details.getName(), resType);
        }
        throw DeployerException.unknownJvmtiError(details.getType().name());
    }

    static enum RedefinitionCapability {
        MOFIFY_CODE_ONLY,
        ALLOW_ADD_FIELD;

    }

    static enum SuccessStatus {
        OK,
        SWAP_FAILED_BUT_APP_UPDATED;

    }
}

