/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.annotations.Trace;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.DexSplitter;
import com.android.tools.deployer.model.DexClass;
import com.android.tools.deployer.model.FileDiff;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;

public class DexComparator {
    @Trace
    public ChangedClasses compare(List<FileDiff> dexDiffs, DexSplitter splitter) throws DeployerException {
        HashMap<String, Long> oldChecksums = new HashMap<String, Long>();
        for (FileDiff diff : dexDiffs) {
            if (diff.status == FileDiff.Status.CREATED) continue;
            Collection<DexClass> klasses = splitter.split(diff.oldFile, null);
            for (DexClass clz2 : klasses) {
                oldChecksums.putIfAbsent(clz2.name, clz2.checksum);
            }
        }
        ArrayList<DexClass> newClasses = new ArrayList<DexClass>();
        ArrayList<DexClass> modifiedClasses = new ArrayList<DexClass>();
        for (FileDiff diff : dexDiffs) {
            Predicate<DexClass> keepCode = clz -> {
                Long oldChecksum = (Long)oldChecksums.get(clz.name);
                return oldChecksum == null || clz.checksum != oldChecksum;
            };
            Collection<DexClass> klasses = splitter.split(diff.newFile, keepCode);
            for (DexClass klass : klasses) {
                if (klass.code == null) {
                    oldChecksums.put(klass.name, null);
                    continue;
                }
                if (oldChecksums.containsKey(klass.name)) {
                    if (oldChecksums.get(klass.name) == null) continue;
                    modifiedClasses.add(klass);
                    continue;
                }
                newClasses.add(klass);
            }
        }
        return new ChangedClasses(newClasses, modifiedClasses);
    }

    public static class ChangedClasses {
        public final List<DexClass> newClasses;
        public final List<DexClass> modifiedClasses;

        public ChangedClasses(List<DexClass> newClasses, List<DexClass> modifiedClasses) {
            this.newClasses = newClasses;
            this.modifiedClasses = modifiedClasses;
        }
    }
}

