/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deploy.proto.Deploy;
import com.android.tools.deployer.AdbClient;
import com.android.tools.deployer.ApkChecker;
import com.android.tools.deployer.ApkDiffer;
import com.android.tools.deployer.ApkEntryExtractor;
import com.android.tools.deployer.ApkInstaller;
import com.android.tools.deployer.ApkPreInstaller;
import com.android.tools.deployer.ApkSwapper;
import com.android.tools.deployer.ApplicationDumper;
import com.android.tools.deployer.CachedDexSplitter;
import com.android.tools.deployer.ClassRedefiner;
import com.android.tools.deployer.D8DexSplitter;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.DeployerOption;
import com.android.tools.deployer.DeploymentCacheDatabase;
import com.android.tools.deployer.DexComparator;
import com.android.tools.deployer.DexSplitter;
import com.android.tools.deployer.InstallOptions;
import com.android.tools.deployer.Installer;
import com.android.tools.deployer.MetricsRecorder;
import com.android.tools.deployer.OptimisticApkInstaller;
import com.android.tools.deployer.OptimisticApkSwapper;
import com.android.tools.deployer.OverlayId;
import com.android.tools.deployer.RootPushApkInstaller;
import com.android.tools.deployer.Sites;
import com.android.tools.deployer.SqlApkFileDatabase;
import com.android.tools.deployer.SwapVerifier;
import com.android.tools.deployer.TempKotlin;
import com.android.tools.deployer.UIService;
import com.android.tools.deployer.model.Apk;
import com.android.tools.deployer.model.App;
import com.android.tools.deployer.model.DeploymentPlan;
import com.android.tools.deployer.tasks.Canceller;
import com.android.tools.deployer.tasks.Task;
import com.android.tools.deployer.tasks.TaskResult;
import com.android.tools.deployer.tasks.TaskRunner;
import com.android.tools.tracer.Trace;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;

public class Deployer {
    public static final TempKotlin TEMP_KOTLIN = new TempKotlin();
    public static final String BASE_DIRECTORY = Sites.deviceStudioFolder();
    public static final String INSTALLER_DIRECTORY = Sites.installerExecutableFolder();
    public static final String INSTALLER_TMP_DIRECTORY = Sites.installerTmpFolder();
    private final AdbClient adb;
    private final SqlApkFileDatabase dexDb;
    private final DeploymentCacheDatabase deployCache;
    private final Installer installer;
    private final TaskRunner runner;
    private final UIService service;
    private final MetricsRecorder metrics;
    private final ILogger logger;
    private final DeployerOption deployOptions;

    public Deployer(AdbClient adb, DeploymentCacheDatabase deployCache, SqlApkFileDatabase dexDb, TaskRunner runner, Installer installer, UIService service, MetricsRecorder metrics, ILogger logger, DeployerOption options) {
        this.adb = adb;
        this.deployCache = deployCache;
        this.dexDb = dexDb;
        this.runner = runner;
        this.installer = installer;
        this.service = service;
        this.metrics = metrics;
        this.logger = logger;
        this.deployOptions = options;
    }

    public Result install(App app, InstallOptions installOptions, InstallMode installMode) throws DeployerException {
        try (Trace ignored = Trace.begin("install");){
            Canceller canceller = installOptions.getCancelChecker();
            String sessionUID = UUID.randomUUID().toString();
            InstallInfo info = this.deployOptions.useRootPushInstall ? this.rootPushInstall(sessionUID, new DeploymentPlan(this.adb.getDevice(), app), installOptions, installMode) : (this.supportsNewPipeline() ? this.optimisticInstall(sessionUID, new DeploymentPlan(this.adb.getDevice(), app), installOptions, installMode) : this.packageManagerInstall(sessionUID, new DeploymentPlan(this.adb.getDevice(), app), installOptions, installMode));
            if (this.deployOptions.skipPostInstallTasks) {
                Result result2 = new Result(info.skippedInstall, false, false, app);
                return result2;
            }
            Task<Boolean> installCoroutineDebugger = null;
            Task<List<Apk>> parsedApksTask = this.runner.create(info.app.getApks());
            if (this.useCoroutineDebugger()) {
                installCoroutineDebugger = this.runner.create(Tasks.INSTALL_COROUTINE_DEBUGGER, list2 -> this.installCoroutineDebugger(app), parsedApksTask);
            }
            CachedDexSplitter splitter = new CachedDexSplitter(this.dexDb, new D8DexSplitter());
            this.runner.create(Tasks.CACHE, splitter::cache, parsedApksTask);
            ApkChecker checker = new ApkChecker(sessionUID, this.logger);
            this.runner.create(Tasks.APK_CHECK, checker::log, parsedApksTask);
            this.runner.runAsync(canceller);
            boolean coroutineDebuggerInstalled = installCoroutineDebugger != null ? installCoroutineDebugger.get() : false;
            Result result3 = new Result(info.skippedInstall, false, coroutineDebuggerInstalled, app);
            return result3;
        }
    }

    private InstallInfo packageManagerInstall(String deploySessionUID, DeploymentPlan plan, InstallOptions installOptions, InstallMode installMode) throws DeployerException {
        this.logger.info("Deploying with package manager for install session %s", new Object[]{deploySessionUID});
        ApkInstaller apkInstaller = new ApkInstaller(this.adb, this.service, this.installer, this.logger);
        boolean skippedInstall = !apkInstaller.install(plan, this.deployOptions, installOptions, installMode, this.metrics.getDeployMetrics());
        return new InstallInfo(skippedInstall, plan.getApp());
    }

    private InstallInfo rootPushInstall(String deploySessionUID, DeploymentPlan plan, InstallOptions installOptions, InstallMode installMode) throws DeployerException {
        this.logger.info("Deploying with root push for install session %s", new Object[]{deploySessionUID});
        Canceller canceller = installOptions.getCancelChecker();
        Task<Boolean> installSuccess = this.runner.create(Tasks.ROOT_PUSH_INSTALL, new RootPushApkInstaller(this.adb, this.installer, this.logger)::install, this.runner.create(plan));
        TaskResult result2 = this.runner.run(canceller);
        result2.getMetrics().forEach(this.metrics::add);
        boolean skippedInstall = false;
        if (!result2.isSuccess() || !installSuccess.get().booleanValue()) {
            this.logger.info("Deploying with package manager for install session %s", new Object[]{deploySessionUID});
            ApkInstaller apkInstaller = new ApkInstaller(this.adb, this.service, this.installer, this.logger);
            skippedInstall = !apkInstaller.install(plan, this.deployOptions, installOptions, installMode, this.metrics.getDeployMetrics());
        }
        return new InstallInfo(skippedInstall, plan.getApp());
    }

    private InstallInfo optimisticInstall(String deploySessionUID, DeploymentPlan plan, InstallOptions installOptions, InstallMode installMode) throws DeployerException {
        Canceller canceller = installOptions.getCancelChecker();
        installMode = installMode == InstallMode.DELTA ? InstallMode.DELTA_NO_SKIP : installMode;
        App app = plan.getApp();
        Task<App> taskApp = this.runner.create(app);
        Task<String> deviceSerial = this.runner.create(this.adb.getSerial());
        Task<String> packageName = this.runner.create(app.getAppId());
        Task<List<Apk>> apks = this.runner.create(app.getApks());
        boolean installSuccess = false;
        if (!this.deployOptions.optimisticInstallSupport.isEmpty()) {
            this.logger.info("Deploying with optimistic install for session %s", new Object[]{deploySessionUID});
            OptimisticApkInstaller apkInstaller = new OptimisticApkInstaller(this.installer, this.adb, this.deployCache, this.metrics, this.deployOptions, this.logger);
            Task<List<String>> userFlags = this.runner.create(installOptions.getUserFlags());
            Task<OverlayId> overlayId = this.runner.create(Tasks.OPTIMISTIC_INSTALL, apkInstaller::install, taskApp, userFlags);
            TaskResult result2 = this.runner.run(canceller);
            installSuccess = result2.isSuccess();
            if (installSuccess) {
                this.runner.create(Tasks.DEPLOY_CACHE_STORE, this.deployCache::store, deviceSerial, packageName, apks, overlayId);
            } else {
                this.logger.info("Optimistic install session %s did not complete: %s", new Object[]{deploySessionUID, result2.getException()});
            }
            result2.getMetrics().forEach(this.metrics::add);
        }
        boolean skippedInstall = false;
        if (!installSuccess) {
            this.logger.info("Deploying with package manager for session %s", new Object[]{deploySessionUID});
            ApkInstaller apkInstaller = new ApkInstaller(this.adb, this.service, this.installer, this.logger);
            skippedInstall = !apkInstaller.install(plan, this.deployOptions, installOptions, installMode, this.metrics.getDeployMetrics());
            this.runner.create(Tasks.DEPLOY_CACHE_STORE, this.deployCache::invalidate, deviceSerial, packageName);
        }
        this.runner.runAsync(canceller);
        return new InstallInfo(skippedInstall, app);
    }

    public Result codeSwap(App app, Map<Integer, ClassRedefiner> debuggerRedefiners, Canceller canceller) throws DeployerException {
        try (Trace ignored = Trace.begin("codeSwap");){
            if (this.supportsNewPipeline()) {
                Result result2 = this.optimisticSwap(app, false, debuggerRedefiners, canceller);
                return result2;
            }
            Result result3 = this.swap(app, false, debuggerRedefiners, canceller);
            return result3;
        }
    }

    public Result fullSwap(App app, Canceller canceller) throws DeployerException {
        try (Trace ignored = Trace.begin("fullSwap");){
            if (this.supportsNewPipeline() && this.deployOptions.useOptimisticResourceSwap) {
                Result result2 = this.optimisticSwap(app, true, (Map<Integer, ClassRedefiner>)ImmutableMap.of(), canceller);
                return result2;
            }
            Result result3 = this.swap(app, true, (Map<Integer, ClassRedefiner>)ImmutableMap.of(), canceller);
            return result3;
        }
    }

    private boolean installCoroutineDebugger(App app) {
        try {
            Deploy.Arch arch = AdbClient.getArchForAbi(this.adb.getAbiForApks(app.getApks()));
            Deploy.InstallCoroutineAgentResponse response = this.installer.installCoroutineAgent(app.getAppId(), arch);
            return response.getStatus() == Deploy.InstallCoroutineAgentResponse.Status.OK;
        }
        catch (Exception e) {
            this.logger.warning(e.getMessage(), new Object[0]);
            return false;
        }
    }

    private boolean useCoroutineDebugger() {
        return this.deployOptions.enableCoroutineDebugger && this.adb.getVersion().isAtLeast(28);
    }

    private Result swap(App app, boolean argRestart, Map<Integer, ClassRedefiner> debuggerRedefiners, Canceller canceller) throws DeployerException {
        if (!this.adb.getVersion().isAtLeast(26)) {
            throw DeployerException.apiNotSupported();
        }
        String deploySessionUID = UUID.randomUUID().toString();
        this.logger.info("Deploy Apply " + (argRestart ? "" : "Code ") + "Session %s", new Object[]{deploySessionUID});
        Task<Boolean> restart2 = this.runner.create(argRestart);
        Task<CachedDexSplitter> splitter = this.runner.create(new CachedDexSplitter(this.dexDb, new D8DexSplitter()));
        Task<List<Apk>> newFiles = this.runner.create(app.getApks());
        Task<ApplicationDumper.Dump> dumps = this.runner.create(Tasks.DUMP, new ApplicationDumper(this.installer)::dump, newFiles);
        Task<List> diffs = this.runner.create(Tasks.DIFF, (dump, newApks) -> new ApkDiffer().diff(dump.apks, (List<Apk>)newApks), dumps, newFiles);
        Task<String> sessionId = this.runner.create(Tasks.PREINSTALL, new ApkPreInstaller(this.adb, this.installer, this.logger)::preinstall, dumps, newFiles, diffs);
        Task<List> dexDiffs = this.runner.create(Tasks.VERIFY, new SwapVerifier()::verify, diffs, restart2);
        Task<DexComparator.ChangedClasses> toSwap = this.runner.create(Tasks.COMPARE, new DexComparator()::compare, dexDiffs, splitter);
        ApkSwapper swapper = new ApkSwapper(this.installer, debuggerRedefiners, argRestart, this.adb, this.logger);
        this.runner.create(Tasks.SWAP, swapper::swap, swapper::error, dumps, sessionId, toSwap);
        TaskResult result2 = this.runner.run(canceller);
        result2.getMetrics().forEach(this.metrics::add);
        if (!result2.isSuccess()) {
            throw result2.getException();
        }
        this.runner.create(Tasks.CACHE, DexSplitter::cache, splitter, newFiles);
        ApkChecker checker = new ApkChecker(deploySessionUID, this.logger);
        this.runner.create(Tasks.APK_CHECK, checker::log, newFiles);
        this.runner.runAsync(canceller);
        boolean skippedInstall = sessionId.get().equals("<SKIPPED-INSTALLATION>");
        return new Result(skippedInstall, false, false, app);
    }

    private Result optimisticSwap(App app, boolean argRestart, Map<Integer, ClassRedefiner> redefiners, Canceller canceller) throws DeployerException {
        if (!this.adb.getVersion().isAtLeast(26)) {
            throw DeployerException.apiNotSupported();
        }
        String deploySessionUID = UUID.randomUUID().toString();
        this.logger.info("Deploy Optimistic Apply " + (argRestart ? "Changes." : "Code Changes.") + " Session %s", new Object[]{deploySessionUID});
        Task<Boolean> restart2 = this.runner.create(argRestart);
        Task<CachedDexSplitter> splitter = this.runner.create(new CachedDexSplitter(this.dexDb, new D8DexSplitter()));
        Task<String> deviceSerial = this.runner.create(this.adb.getSerial());
        Task<List<Apk>> apks = this.runner.create(app.getApks());
        Task<String> packageName = this.runner.create(app.getAppId());
        Task<List> pids = this.runner.create(Tasks.GET_PIDS, this.adb::getPids, packageName);
        Task<Deploy.Arch> arch = this.runner.create(Tasks.GET_ARCH, this.adb::getArch, pids);
        Task<DeploymentCacheDatabase.Entry> speculativeDump = this.runner.create(Tasks.OPTIMISTIC_DUMP, this::dumpWithCache, packageName, deviceSerial, apks);
        Task<List> diffs = this.runner.create(Tasks.DIFF, new ApkDiffer()::specDiff, speculativeDump, apks);
        Predicate<String> filter2 = file -> file.startsWith("res") || file.startsWith("assets");
        Task<Map> extractedFiles = this.runner.create(Tasks.EXTRACT_APK_ENTRIES, new ApkEntryExtractor(filter2)::extractFromDiffs, diffs);
        Task<List> dexDiffs = this.runner.create(Tasks.VERIFY, new SwapVerifier()::verify, apks, diffs, restart2);
        Task<DexComparator.ChangedClasses> changedClasses = this.runner.create(Tasks.COMPARE, new DexComparator()::compare, dexDiffs, splitter);
        OptimisticApkSwapper swapper = new OptimisticApkSwapper(this.installer, redefiners, argRestart, this.deployOptions, this.metrics);
        Task<OptimisticApkSwapper.OverlayUpdate> overlayUpdate = this.runner.create(Tasks.COLLECT_SWAP_DATA, OptimisticApkSwapper.OverlayUpdate::new, speculativeDump, changedClasses, extractedFiles);
        Task<OptimisticApkSwapper.SwapResult> swapResultTask = this.runner.create(Tasks.OPTIMISTIC_SWAP, swapper::optimisticSwap, packageName, pids, arch, overlayUpdate);
        TaskResult result2 = this.runner.run(canceller);
        result2.getMetrics().forEach(this.metrics::add);
        if (!result2.isSuccess()) {
            throw result2.getException();
        }
        this.runner.create(Tasks.CACHE, DexSplitter::cache, splitter, apks);
        this.runner.create(Tasks.DEPLOY_CACHE_STORE, (serial, pkgName, files, swap) -> this.deployCache.store((String)serial, app.getAppId(), app.getApks(), swap.overlayId), deviceSerial, packageName, apks, swapResultTask);
        ApkChecker checker = new ApkChecker(deploySessionUID, this.logger);
        this.runner.create(Tasks.APK_CHECK, checker::log, apks);
        this.runner.runAsync(canceller);
        boolean needsRestart = this.deployOptions.fastRestartOnSwapFail && !swapResultTask.get().hotswapSucceeded;
        return new Result(false, needsRestart, false, app);
    }

    private DeploymentCacheDatabase.Entry dumpWithCache(String packageName, String deviceSerial, List<Apk> apks) throws DeployerException {
        String serial = this.adb.getSerial();
        DeploymentCacheDatabase.Entry entry = this.deployCache.get(serial, packageName);
        if (entry != null && !entry.getOverlayId().isBaseInstall()) {
            return entry;
        }
        ApplicationDumper dumper = new ApplicationDumper(this.installer);
        List<Apk> deviceApks = dumper.dump(apks).apks;
        this.deployCache.store(serial, packageName, deviceApks, new OverlayId(deviceApks));
        return this.deployCache.get(serial, packageName);
    }

    public boolean supportsNewPipeline() {
        return this.deployOptions.useOptimisticSwap && this.adb.getVersion().getApiLevel() >= 30;
    }

    public static enum InstallMode {
        DELTA,
        DELTA_NO_SKIP,
        FULL;

    }

    private static class InstallInfo {
        public final boolean skippedInstall;
        public final App app;

        public InstallInfo(boolean skippedInstall, App app) {
            this.skippedInstall = skippedInstall;
            this.app = app;
        }
    }

    public static class Result {
        public final boolean skippedInstall;
        public final boolean needsRestart;
        public final boolean coroutineDebuggerInstalled;
        public final App app;

        public Result(boolean skippedInstall, boolean needsRestart, boolean coroutineDebuggerInstalled, App app) {
            this.skippedInstall = skippedInstall;
            this.needsRestart = needsRestart;
            this.coroutineDebuggerInstalled = coroutineDebuggerInstalled;
            this.app = app;
        }
    }

    static enum Tasks {
        CACHE,
        DUMP,
        DIFF,
        PREINSTALL,
        VERIFY,
        COMPARE,
        SWAP,
        APK_CHECK,
        PARSE_APP_IDS,
        DEPLOY_CACHE_STORE,
        OPTIMISTIC_DUMP,
        VERIFY_DUMP,
        EXTRACT_APK_ENTRIES,
        COLLECT_SWAP_DATA,
        OPTIMISTIC_SWAP,
        OPTIMISTIC_INSTALL,
        ROOT_PUSH_INSTALL,
        GET_PIDS,
        GET_ARCH,
        COMPUTE_FRESHINSTALL_OID,
        INSTALL_COROUTINE_DEBUGGER;

    }
}

