/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.deviceprovisioner;

import com.android.adblib.AdbLogger;
import com.android.emulator.snapshot.SnapshotOuterClass;
import com.android.sdklib.deviceprovisioner.LocalEmulatorSnapshot;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/sdklib/deviceprovisioner/LocalEmulatorSnapshotReader;", "", "logger", "Lcom/android/adblib/AdbLogger;", "<init>", "(Lcom/android/adblib/AdbLogger;)V", "readSnapshots", "", "Lcom/android/sdklib/deviceprovisioner/LocalEmulatorSnapshot;", "snapshots", "Ljava/nio/file/Path;", "readSnapshot", "snapshotPath", "Companion", "android.sdktools.device-provisioner"})
@SourceDebugExtension(value={"SMAP\nLocalEmulatorSnapshot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalEmulatorSnapshot.kt\ncom/android/sdklib/deviceprovisioner/LocalEmulatorSnapshotReader\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,91:1\n608#2:92\n*S KotlinDebug\n*F\n+ 1 LocalEmulatorSnapshot.kt\ncom/android/sdklib/deviceprovisioner/LocalEmulatorSnapshotReader\n*L\n63#1:92\n*E\n"})
public final class LocalEmulatorSnapshotReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AdbLogger logger;
    @NotNull
    private static final String QUICK_BOOT_SNAPSHOT_NAME = "default_boot";

    public LocalEmulatorSnapshotReader(@NotNull AdbLogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<LocalEmulatorSnapshot> readSnapshots(@NotNull Path snapshots2) {
        Intrinsics.checkNotNullParameter((Object)snapshots2, (String)"snapshots");
        if (!Files.exists(snapshots2, new LinkOption[0])) {
            return CollectionsKt.emptyList();
        }
        try {
            Iterable iterable;
            Path path = snapshots2;
            Closeable closeable = Files.newDirectoryStream(path, "*");
            Throwable throwable = null;
            try {
                void $this$sortedBy$iv;
                iterable = (DirectoryStream)closeable;
                Intrinsics.checkNotNull((Object)iterable);
                Sequence entries = CollectionsKt.asSequence((Iterable)iterable);
                boolean bl = false;
                Sequence sequence2 = SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)entries, LocalEmulatorSnapshotReader::readSnapshots$lambda$0$0), arg_0 -> LocalEmulatorSnapshotReader.readSnapshots$lambda$0$1(this, arg_0));
                boolean $i$f$sortedBy = false;
                iterable = SequencesKt.toList((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        LocalEmulatorSnapshot it = (LocalEmulatorSnapshot)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getName());
                        it = (LocalEmulatorSnapshot)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                    }
                }));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return iterable;
        }
        catch (IOException exception) {
            this.logger.warn(exception, "Reading snapshots from " + snapshots2);
            return CollectionsKt.emptyList();
        }
    }

    @Nullable
    public final LocalEmulatorSnapshot readSnapshot(@NotNull Path snapshotPath) {
        Intrinsics.checkNotNullParameter((Object)snapshotPath, (String)"snapshotPath");
        Path snapshotProtoPath = snapshotPath.resolve("snapshot.pb");
        Intrinsics.checkNotNull((Object)snapshotProtoPath);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(snapshotProtoPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return new LocalEmulatorSnapshot(snapshotPath);
        }
        try {
            LocalEmulatorSnapshot localEmulatorSnapshot;
            SnapshotOuterClass.Snapshot snapshotProto = SnapshotOuterClass.Snapshot.parseFrom((InputStream)Files.newInputStream(snapshotProtoPath, new OpenOption[0]));
            if (snapshotProto.getImagesCount() == 0) {
                localEmulatorSnapshot = null;
            } else {
                String string2 = snapshotProto.getLogicalName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLogicalName(...)");
                if (((CharSequence)string2).length() == 0) {
                    localEmulatorSnapshot = new LocalEmulatorSnapshot(snapshotPath);
                } else {
                    String string3 = snapshotProto.getLogicalName();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getLogicalName(...)");
                    localEmulatorSnapshot = new LocalEmulatorSnapshot(string3, snapshotPath);
                }
            }
            return localEmulatorSnapshot;
        }
        catch (IOException exception) {
            this.logger.warn(exception, "Reading snapshot proto " + snapshotProtoPath);
            return null;
        }
    }

    private static final boolean readSnapshots$lambda$0$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.isDirectory(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && !Intrinsics.areEqual((Object)PathsKt.getName((Path)it), (Object)QUICK_BOOT_SNAPSHOT_NAME);
    }

    private static final LocalEmulatorSnapshot readSnapshots$lambda$0$1(LocalEmulatorSnapshotReader this$0, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.readSnapshot(it);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/sdklib/deviceprovisioner/LocalEmulatorSnapshotReader$Companion;", "", "<init>", "()V", "QUICK_BOOT_SNAPSHOT_NAME", "", "android.sdktools.device-provisioner"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

