/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources.base;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.utils.Base128InputStream;
import com.android.utils.Base128OutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class NamespaceResolver
implements ResourceNamespace.Resolver {
    public static final NamespaceResolver EMPTY = new NamespaceResolver(new String[0]);
    private final String[] prefixesAndUris;

    NamespaceResolver(XmlPullParser parser2) throws XmlPullParserException {
        int namespaceCount = parser2.getNamespaceCount(parser2.getDepth());
        this.prefixesAndUris = new String[namespaceCount * 2];
        int j = this.prefixesAndUris.length;
        for (int i = 0; i < namespaceCount; ++i) {
            this.prefixesAndUris[--j] = parser2.getNamespaceUri(i);
            this.prefixesAndUris[--j] = parser2.getNamespacePrefix(i);
        }
    }

    private NamespaceResolver(String[] prefixesAndUris) {
        this.prefixesAndUris = prefixesAndUris;
    }

    int getNamespaceCount() {
        return this.prefixesAndUris.length / 2;
    }

    public String prefixToUri(String namespacePrefix) {
        for (int i = 0; i < this.prefixesAndUris.length; i += 2) {
            if (!namespacePrefix.equals(this.prefixesAndUris[i])) continue;
            return this.prefixesAndUris[i + 1];
        }
        return null;
    }

    public String uriToPrefix(String namespaceUri) {
        for (int i = 0; i < this.prefixesAndUris.length; i += 2) {
            if (!namespaceUri.equals(this.prefixesAndUris[i + 1])) continue;
            return this.prefixesAndUris[i];
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NamespaceResolver other = (NamespaceResolver)obj;
        return Arrays.equals(this.prefixesAndUris, other.prefixesAndUris);
    }

    public int hashCode() {
        return Arrays.hashCode(this.prefixesAndUris);
    }

    public void serialize(Base128OutputStream stream) throws IOException {
        stream.writeInt(this.getNamespaceCount());
        for (String str : this.prefixesAndUris) {
            stream.writeString(str);
        }
    }

    public static NamespaceResolver deserialize(Base128InputStream stream) throws IOException {
        int n = stream.readInt() * 2;
        String[] prefixesAndUris = new String[n];
        for (int i = 0; i < n; ++i) {
            String s = stream.readString();
            if (s == null) {
                throw Base128InputStream.StreamFormatException.invalidFormat();
            }
            prefixesAndUris[i] = s;
        }
        return new NamespaceResolver(prefixesAndUris);
    }
}

