/*
 * Decompiled with CFR 0.152.
 */
package com.android.jdwptracer;

import com.android.jdwppacket.EventKind;
import com.android.jdwppacket.MessageReader;
import com.android.jdwppacket.SuspendPolicy;
import com.android.jdwppacket.event.CompositeCmd;
import com.android.jdwptracer.CmdSet;
import com.android.jdwptracer.JsonLocation;
import com.android.jdwptracer.Message;
import com.android.jdwptracer.Session;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

class CmdSetEvent
extends CmdSet {
    protected CmdSetEvent() {
        super(64, "EVENT");
        this.add(100, "Compo", CmdSetEvent::parseCmdComposite, CmdSetEvent::parseReplyComposite);
    }

    private static Message parseReplyComposite(MessageReader reader, Session session2) {
        return new Message(reader);
    }

    private static Message parseCmdComposite(MessageReader reader, Session session2) {
        Message message = new Message(reader);
        CompositeCmd cmd = CompositeCmd.parse(reader);
        message.addArg("suspendPolicy", SuspendPolicy.fromID(cmd.getSuspendPolicy()).name());
        message.addArg("numEvents", Integer.toString(cmd.getEvents().size()));
        JsonArray eventsJson = new JsonArray();
        message.addArg("events", (JsonElement)eventsJson);
        for (CompositeCmd.Event event : cmd.getEvents()) {
            JsonObject eventJson = new JsonObject();
            eventsJson.add((JsonElement)eventJson);
            EventKind kind = event.getKind();
            eventJson.addProperty("eventKind", kind.name());
            message.setName(kind.name());
            switch (kind) {
                case CLASS_PREPARE: {
                    CompositeCmd.EventClassPrepare cp = (CompositeCmd.EventClassPrepare)event;
                    eventJson.addProperty("thread", (Number)cp.getThreadID());
                    eventJson.addProperty("refTypeTag", (Number)cp.getTypeTag());
                    eventJson.addProperty("typeID", (Number)cp.getReferenceTypeID());
                    eventJson.addProperty("signature", cp.getSignature());
                    eventJson.addProperty("status", (Number)cp.getStatus());
                    break;
                }
                case BREAKPOINT: {
                    CompositeCmd.EventThreadLocation se = (CompositeCmd.EventThreadLocation)event;
                    eventJson.addProperty("threadID", (Number)se.getThreadID());
                    eventJson.add("location", (JsonElement)JsonLocation.get(se.getLocation()));
                    break;
                }
            }
        }
        if (cmd.getEvents().size() != 1) {
            message.setName("multiple");
        }
        return message;
    }
}

