/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.utils;

import com.android.adblib.AdbLogger;
import com.android.adblib.AdbLoggerFactoryWithCache;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0002H\u0016J\u0014\u0010\u0006\u001a\u00020\u00022\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0016J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/android/adblib/utils/JdkLoggerFactory;", "Lcom/android/adblib/AdbLoggerFactoryWithCache;", "Lcom/android/adblib/utils/JdkLoggerFactory$JdkLogger;", "<init>", "()V", "createRootLogger", "createClassLogger", "cls", "Ljava/lang/Class;", "createCategoryLogger", "category", "", "JdkLogger", "android.sdktools.adblib"})
public final class JdkLoggerFactory
extends AdbLoggerFactoryWithCache<JdkLogger> {
    @Override
    @NotNull
    public JdkLogger createRootLogger() {
        return new JdkLogger("com.android.adblib");
    }

    @Override
    @NotNull
    public JdkLogger createClassLogger(@NotNull Class<?> cls) {
        Intrinsics.checkNotNullParameter(cls, (String)"cls");
        String string2 = cls.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        return new JdkLogger(string2);
    }

    @Override
    @NotNull
    public JdkLogger createCategoryLogger(@NotNull String category) {
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        return new JdkLogger(category);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u000bH\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lcom/android/adblib/utils/JdkLoggerFactory$JdkLogger;", "Lcom/android/adblib/AdbLogger;", "name", "", "<init>", "(Ljava/lang/String;)V", "logger", "Ljava/util/logging/Logger;", "getLogger", "()Ljava/util/logging/Logger;", "minLevel", "Lcom/android/adblib/AdbLogger$Level;", "getMinLevel", "()Lcom/android/adblib/AdbLogger$Level;", "log", "", "level", "message", "exception", "", "mapLevel", "Ljava/util/logging/Level;", "android.sdktools.adblib"})
    public static final class JdkLogger
    extends AdbLogger {
        @NotNull
        private final Logger logger;

        public JdkLogger(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Logger logger = Logger.getLogger(name);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            this.logger = logger;
        }

        @NotNull
        public final Logger getLogger() {
            return this.logger;
        }

        @Override
        @NotNull
        public AdbLogger.Level getMinLevel() {
            return this.logger.isLoggable(Level.ALL) ? AdbLogger.Level.VERBOSE : (this.logger.isLoggable(Level.FINE) ? AdbLogger.Level.DEBUG : (this.logger.isLoggable(Level.INFO) ? AdbLogger.Level.INFO : (this.logger.isLoggable(Level.WARNING) ? AdbLogger.Level.WARN : AdbLogger.Level.ERROR)));
        }

        @Override
        public void log(@NotNull AdbLogger.Level level, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.logger.log(this.mapLevel(level), message);
        }

        @Override
        public void log(@NotNull AdbLogger.Level level, @Nullable Throwable exception, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.logger.log(this.mapLevel(level), exception, () -> JdkLogger.log$lambda$0(message));
        }

        private final Level mapLevel(AdbLogger.Level level) {
            Level level2;
            switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
                case 1: {
                    Level level3 = Level.ALL;
                    level2 = level3;
                    Intrinsics.checkNotNullExpressionValue((Object)level3, (String)"ALL");
                    break;
                }
                case 2: {
                    Level level4 = Level.FINE;
                    level2 = level4;
                    Intrinsics.checkNotNullExpressionValue((Object)level4, (String)"FINE");
                    break;
                }
                case 3: {
                    Level level5 = Level.INFO;
                    level2 = level5;
                    Intrinsics.checkNotNullExpressionValue((Object)level5, (String)"INFO");
                    break;
                }
                case 4: {
                    Level level6 = Level.WARNING;
                    level2 = level6;
                    Intrinsics.checkNotNullExpressionValue((Object)level6, (String)"WARNING");
                    break;
                }
                case 5: {
                    Level level7 = Level.SEVERE;
                    level2 = level7;
                    Intrinsics.checkNotNullExpressionValue((Object)level7, (String)"SEVERE");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return level2;
        }

        private static final String log$lambda$0(String $message) {
            return $message;
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[AdbLogger.Level.values().length];
                try {
                    nArray[AdbLogger.Level.VERBOSE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AdbLogger.Level.DEBUG.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AdbLogger.Level.INFO.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AdbLogger.Level.WARN.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AdbLogger.Level.ERROR.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

