/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.utils;

import com.android.adblib.ShellCollectorCapabilities;
import com.android.adblib.ShellV2Collector;
import com.android.adblib.utils.AdbBufferDecoder;
import com.android.adblib.utils.ResizableBuffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0096@\u00a2\u0006\u0002\u0010\u0014J$\u0010\u0015\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0096@\u00a2\u0006\u0002\u0010\u0018J$\u0010\u0019\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0017H\u0096@\u00a2\u0006\u0002\u0010\u0018J$\u0010\u001b\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0096@\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bj\u0002`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000f\u00a8\u0006 "}, d2={"Lcom/android/adblib/utils/ByteArrayShellCollector;", "Lcom/android/adblib/ShellV2Collector;", "Lcom/android/adblib/utils/ByteArrayShellCollector$CommandResult;", "Lcom/android/adblib/ShellCollectorCapabilities;", "<init>", "()V", "decoder", "Lcom/android/adblib/utils/AdbBufferDecoder;", "stdoutBuffer", "Lcom/android/adblib/utils/ResizableBuffer;", "stderrText", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "isSingleOutput", "", "()Z", "start", "", "collector", "Lkotlinx/coroutines/flow/FlowCollector;", "(Lkotlinx/coroutines/flow/FlowCollector;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "collectStdout", "stdout", "Ljava/nio/ByteBuffer;", "(Lkotlinx/coroutines/flow/FlowCollector;Ljava/nio/ByteBuffer;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "collectStderr", "stderr", "end", "exitCode", "", "(Lkotlinx/coroutines/flow/FlowCollector;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "CommandResult", "android.sdktools.adblib"})
public final class ByteArrayShellCollector
implements ShellV2Collector<CommandResult>,
ShellCollectorCapabilities {
    @NotNull
    private final AdbBufferDecoder decoder = new AdbBufferDecoder(0, null, 3, null);
    @NotNull
    private final ResizableBuffer stdoutBuffer = new ResizableBuffer(0, 0, 3, null);
    @NotNull
    private final StringBuilder stderrText = new StringBuilder();

    @Override
    public boolean isSingleOutput() {
        return true;
    }

    @Override
    @Nullable
    public Object start(@NotNull FlowCollector<? super CommandResult> collector, @NotNull Continuation<? super Unit> $completion) {
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object collectStdout(@NotNull FlowCollector<? super CommandResult> collector, @NotNull ByteBuffer stdout2, @NotNull Continuation<? super Unit> $completion) {
        this.stdoutBuffer.appendBytes(stdout2);
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object collectStderr(@NotNull FlowCollector<? super CommandResult> collector, @NotNull ByteBuffer stderr2, @NotNull Continuation<? super Unit> $completion) {
        this.decoder.decodeBuffer(stderr2, (Function1<? super CharBuffer, Unit>)((Function1)arg_0 -> ByteArrayShellCollector.collectStderr$lambda$0(this, arg_0)));
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object end(@NotNull FlowCollector<? super CommandResult> collector, int exitCode2, @NotNull Continuation<? super Unit> $completion) {
        ByteBuffer writeBuffer2 = this.stdoutBuffer.forChannelWrite();
        byte[] array = new byte[writeBuffer2.limit()];
        writeBuffer2.get(array);
        String string2 = this.stderrText.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        Object object = collector.emit((Object)new CommandResult(array, string2, exitCode2), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final Unit collectStderr$lambda$0(ByteArrayShellCollector this$0, CharBuffer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.stderrText.append(it);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/android/adblib/utils/ByteArrayShellCollector$CommandResult;", "", "stdout", "", "stderr", "", "exitCode", "", "<init>", "([BLjava/lang/String;I)V", "getStdout", "()[B", "getStderr", "()Ljava/lang/String;", "getExitCode", "()I", "android.sdktools.adblib"})
    public static final class CommandResult {
        @NotNull
        private final byte[] stdout;
        @NotNull
        private final String stderr;
        private final int exitCode;

        public CommandResult(@NotNull byte[] stdout2, @NotNull String stderr2, int exitCode2) {
            Intrinsics.checkNotNullParameter((Object)stdout2, (String)"stdout");
            Intrinsics.checkNotNullParameter((Object)stderr2, (String)"stderr");
            this.stdout = stdout2;
            this.stderr = stderr2;
            this.exitCode = exitCode2;
        }

        @NotNull
        public final byte[] getStdout() {
            return this.stdout;
        }

        @NotNull
        public final String getStderr() {
            return this.stderr;
        }

        public final int getExitCode() {
            return this.exitCode;
        }
    }
}

