/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.utils;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0018H\u0002J\u0018\u0010\u001c\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\tH\u0002J\u000e\u0010\u001e\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u000f2\b\b\u0002\u0010!\u001a\u00020\u0018J\u0006\u0010\"\u001a\u00020#J\u0016\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u000fJ\u000e\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020)R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/android/adblib/utils/AdbProtocolUtils;", "", "<init>", "()V", "ADB_CHARSET", "Ljava/nio/charset/Charset;", "getADB_CHARSET", "()Ljava/nio/charset/Charset;", "ADB_NEW_LINE", "", "printableCharactersRegex", "Lkotlin/text/Regex;", "isOkay", "", "buffer", "Ljava/nio/ByteBuffer;", "isFail", "isData", "isDone", "isStat", "isSta2", "isDent", "isDnt2", "encodeLengthPrefix", "", "length", "digitToHexValue", "digit", "is4Letters", "letters", "byteBufferToString", "bufferToByteDumpString", "status", "maxCount", "createDecoder", "Ljava/nio/charset/CharsetDecoder;", "copyBufferContents", "srcBuffer", "dstBuffer", "convertFileTimeToEpochSeconds", "fileTime", "Ljava/nio/file/attribute/FileTime;", "android.sdktools.adblib"})
public final class AdbProtocolUtils {
    @NotNull
    public static final AdbProtocolUtils INSTANCE = new AdbProtocolUtils();
    @NotNull
    private static final Charset ADB_CHARSET;
    @NotNull
    public static final String ADB_NEW_LINE = "\n";
    @NotNull
    private static final Regex printableCharactersRegex;

    private AdbProtocolUtils() {
    }

    @NotNull
    public final Charset getADB_CHARSET() {
        return ADB_CHARSET;
    }

    public final boolean isOkay(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        return this.is4Letters(buffer, "OKAY");
    }

    public final boolean isFail(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        return this.is4Letters(buffer, "FAIL");
    }

    public final boolean isData(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        return this.is4Letters(buffer, "DATA");
    }

    public final boolean isDone(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        return this.is4Letters(buffer, "DONE");
    }

    public final boolean isStat(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        return this.is4Letters(buffer, "STAT");
    }

    public final boolean isSta2(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        return this.is4Letters(buffer, "STA2");
    }

    public final boolean isDent(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        return this.is4Letters(buffer, "DENT");
    }

    public final boolean isDnt2(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        return this.is4Letters(buffer, "DNT2");
    }

    public final int encodeLengthPrefix(int length) {
        if (!(0 <= length ? length < 65536 : false)) {
            throw new IllegalArgumentException("ADB length values are limited to " + new IntRange(0, 65535));
        }
        return (this.digitToHexValue((length & 0xF000) >> 12) << 24) + (this.digitToHexValue((length & 0xF00) >> 8) << 16) + (this.digitToHexValue((length & 0xF0) >> 4) << 8) + this.digitToHexValue(length & 0xF);
    }

    private final int digitToHexValue(int digit) {
        int n = digit;
        return (0 <= n ? n < 10 : false) ? 48 + digit : 65 + digit - 10;
    }

    private final boolean is4Letters(ByteBuffer buffer, String letters) {
        if (buffer.remaining() < letters.length()) {
            return false;
        }
        return buffer.get(0 + buffer.position()) == (byte)letters.charAt(0) && buffer.get(1 + buffer.position()) == (byte)letters.charAt(1) && buffer.get(2 + buffer.position()) == (byte)letters.charAt(2) && buffer.get(3 + buffer.position()) == (byte)letters.charAt(3);
    }

    @NotNull
    public final String byteBufferToString(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int position = buffer.position();
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        buffer.position(position);
        return new String(bytes, ADB_CHARSET);
    }

    @NotNull
    public final String bufferToByteDumpString(@NotNull ByteBuffer status2, int maxCount) {
        Intrinsics.checkNotNullParameter((Object)status2, (String)"status");
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        int position = status2.position();
        int n = Math.min(status2.remaining(), maxCount);
        for (int i = 0; i < n; ++i) {
            byte statusByte = status2.get(i + position);
            String string2 = "%02x";
            Object[] objectArray = new Object[]{statusByte};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            sb1.append(string3);
            string2 = "%c";
            objectArray = new Object[]{Character.valueOf((char)statusByte)};
            String string4 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
            sb2.append(string4);
        }
        String overflow = status2.remaining() > maxCount ? " [truncated]" : "";
        String string5 = sb2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
        CharSequence charSequence = string5;
        Regex regex = printableCharactersRegex;
        String string6 = ".";
        return sb1 + " " + regex.replace(charSequence, string6) + overflow;
    }

    public static /* synthetic */ String bufferToByteDumpString$default(AdbProtocolUtils adbProtocolUtils, ByteBuffer byteBuffer, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 24;
        }
        return adbProtocolUtils.bufferToByteDumpString(byteBuffer, n);
    }

    @NotNull
    public final CharsetDecoder createDecoder() {
        CharsetDecoder charsetDecoder = ADB_CHARSET.newDecoder();
        Intrinsics.checkNotNullExpressionValue((Object)charsetDecoder, (String)"newDecoder(...)");
        return charsetDecoder;
    }

    /*
     * WARNING - void declaration
     */
    public final int copyBufferContents(@NotNull ByteBuffer srcBuffer, @NotNull ByteBuffer dstBuffer) {
        int n;
        Intrinsics.checkNotNullParameter((Object)srcBuffer, (String)"srcBuffer");
        Intrinsics.checkNotNullParameter((Object)dstBuffer, (String)"dstBuffer");
        if (dstBuffer.remaining() > srcBuffer.remaining()) {
            int count = srcBuffer.remaining();
            dstBuffer.put(srcBuffer);
            n = count;
        } else {
            void var3_4;
            int count = dstBuffer.remaining();
            if (count > 0) {
                int savedLimit = srcBuffer.limit();
                srcBuffer.limit(srcBuffer.position() + count);
                dstBuffer.put(srcBuffer);
                srcBuffer.limit(savedLimit);
            }
            n = var3_4;
        }
        return n;
    }

    public final int convertFileTimeToEpochSeconds(@NotNull FileTime fileTime) {
        Intrinsics.checkNotNullParameter((Object)fileTime, (String)"fileTime");
        return (int)(fileTime.toMillis() / (long)1000);
    }

    static {
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        ADB_CHARSET = charset;
        printableCharactersRegex = new Regex("\\p{C}");
    }
}

