/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.utils;

import com.android.adblib.utils.AdbProtocolUtils;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000f0\u0012J,\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000f0\u0012H\u0002J\u001c\u0010\u0015\u001a\u00020\u000f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000f0\u0012H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/adblib/utils/AdbBufferDecoder;", "", "bufferCapacity", "", "charset", "Ljava/nio/charset/Charset;", "<init>", "(ILjava/nio/charset/Charset;)V", "decoder", "Ljava/nio/charset/CharsetDecoder;", "charBuffer", "Ljava/nio/CharBuffer;", "leftoverBuffer", "Ljava/nio/ByteBuffer;", "decodeBuffer", "", "buffer", "processor", "Lkotlin/Function1;", "decodeLeftoverBuffer", "leftovers", "flushCharBuffer", "android.sdktools.adblib"})
public final class AdbBufferDecoder {
    @NotNull
    private final CharsetDecoder decoder;
    @NotNull
    private final CharBuffer charBuffer;
    @Nullable
    private ByteBuffer leftoverBuffer;

    public AdbBufferDecoder(int bufferCapacity, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        CharsetDecoder charsetDecoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith("?");
        Intrinsics.checkNotNullExpressionValue((Object)charsetDecoder, (String)"replaceWith(...)");
        this.decoder = charsetDecoder;
        CharBuffer charBuffer = CharBuffer.allocate(bufferCapacity);
        Intrinsics.checkNotNullExpressionValue((Object)charBuffer, (String)"allocate(...)");
        this.charBuffer = charBuffer;
    }

    public /* synthetic */ AdbBufferDecoder(int n, Charset charset, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 256;
        }
        if ((n2 & 2) != 0) {
            charset = AdbProtocolUtils.INSTANCE.getADB_CHARSET();
        }
        this(n, charset);
    }

    public final void decodeBuffer(@NotNull ByteBuffer buffer, @NotNull Function1<? super CharBuffer, Unit> processor) {
        CoderResult result2;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        ByteBuffer byteBuffer = this.leftoverBuffer;
        if (byteBuffer != null) {
            ByteBuffer byteBuffer2;
            ByteBuffer $this$decodeBuffer_u24lambda_u240 = byteBuffer2 = byteBuffer;
            boolean bl = false;
            this.decodeLeftoverBuffer($this$decodeBuffer_u24lambda_u240, buffer, processor);
        }
        while (true) {
            result2 = this.decoder.decode(buffer, this.charBuffer, false);
            if (result2.isMalformed() || result2.isUnmappable()) continue;
            if (!result2.isOverflow()) break;
            this.flushCharBuffer(processor);
        }
        if (result2.isUnderflow()) {
            this.flushCharBuffer(processor);
            if (buffer.hasRemaining()) {
                boolean bl;
                ByteBuffer byteBuffer3 = this.leftoverBuffer = ByteBuffer.allocate(10);
                if (byteBuffer3 != null) {
                    byteBuffer3.put(buffer);
                }
                boolean bl2 = bl = !buffer.hasRemaining();
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
            }
        } else {
            throw new IllegalStateException();
        }
    }

    private final void decodeLeftoverBuffer(ByteBuffer leftovers, ByteBuffer buffer, Function1<? super CharBuffer, Unit> processor) {
        if (leftovers.position() == 0) {
            return;
        }
        this.flushCharBuffer(processor);
        while (buffer.hasRemaining()) {
            boolean bl;
            leftovers.put(buffer.get());
            int count = leftovers.position();
            leftovers.flip();
            CoderResult result2 = this.decoder.decode(leftovers, this.charBuffer, false);
            if (result2.isMalformed()) {
                bl = true;
            } else if (result2.isUnmappable()) {
                bl = true;
            } else {
                if (result2.isOverflow()) {
                    throw new IllegalStateException();
                }
                if (result2.isUnderflow()) {
                    bl = !leftovers.hasRemaining();
                } else {
                    throw new IllegalStateException();
                }
            }
            boolean done = bl;
            if (done) {
                boolean bl2;
                boolean bl3 = bl2 = !leftovers.hasRemaining();
                if (_Assertions.ENABLED && !bl2) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                leftovers.clear();
                break;
            }
            leftovers.clear();
            leftovers.position(count);
        }
    }

    private final void flushCharBuffer(Function1<? super CharBuffer, Unit> processor) {
        if (this.charBuffer.position() > 0) {
            this.charBuffer.flip();
            processor.invoke((Object)this.charBuffer);
        }
        this.charBuffer.clear();
    }

    public AdbBufferDecoder() {
        this(0, null, 3, null);
    }
}

