/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.impl;

import com.android.adblib.AdbHostServices;
import com.android.adblib.DeviceInfo;
import com.android.adblib.ListWithErrors;
import com.android.adblib.impl.DeviceListParser;
import com.android.adblib.impl.DeviceListParserKt;
import com.android.adblib.utils.AdbProtocolUtils;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KFunction;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\"\u0010\u000e\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000b2\u0006\u0010\u0011\u001a\u00020\u0012J\"\u0010\u000e\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J&\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J&\u0010\u001b\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lcom/android/adblib/impl/DeviceListTextParser;", "Lcom/android/adblib/impl/DeviceListParser;", "format", "Lcom/android/adblib/AdbHostServices$DeviceInfoFormat;", "<init>", "(Lcom/android/adblib/AdbHostServices$DeviceInfoFormat;)V", "getFormat", "()Lcom/android/adblib/AdbHostServices$DeviceInfoFormat;", "parse", "Lcom/android/adblib/ListWithErrors;", "Lcom/android/adblib/DeviceInfo;", "Lcom/android/adblib/DeviceList;", "buffer", "Ljava/nio/ByteBuffer;", "parserWorker", "oneLineParser", "Lcom/android/adblib/impl/DeviceListTextParser$OneLineParser;", "responseText", "", "parseOneShortFormatLine", "", "result", "Lcom/android/adblib/ListWithErrors$Builder;", "lineIndex", "", "lineText", "", "parseOneLongFormatLine", "OneLineParser", "android.sdktools.adblib"})
public final class DeviceListTextParser
extends DeviceListParser {
    @NotNull
    private final AdbHostServices.DeviceInfoFormat format;

    public DeviceListTextParser(@NotNull AdbHostServices.DeviceInfoFormat format) {
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        this.format = format;
    }

    @NotNull
    public final AdbHostServices.DeviceInfoFormat getFormat() {
        return this.format;
    }

    @Override
    @NotNull
    public ListWithErrors<DeviceInfo> parse(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        KFunction parser2 = switch (WhenMappings.$EnumSwitchMapping$0[this.format.ordinal()]) {
            case 1 -> (KFunction)new Function3<ListWithErrors.Builder<DeviceInfo>, Integer, CharSequence, Unit>((Object)this){

                public final void invoke(ListWithErrors.Builder<DeviceInfo> p0, int p1, CharSequence p2) {
                    Intrinsics.checkNotNullParameter(p0, (String)"p0");
                    Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                    DeviceListTextParser.access$parseOneShortFormatLine((DeviceListTextParser)this.receiver, p0, p1, p2);
                }
            };
            case 2 -> (KFunction)new Function3<ListWithErrors.Builder<DeviceInfo>, Integer, CharSequence, Unit>((Object)this){

                public final void invoke(ListWithErrors.Builder<DeviceInfo> p0, int p1, CharSequence p2) {
                    Intrinsics.checkNotNullParameter(p0, (String)"p0");
                    Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                    DeviceListTextParser.access$parseOneLongFormatLine((DeviceListTextParser)this.receiver, p0, p1, p2);
                }
            };
            default -> throw new IllegalStateException("Unsupported format: " + this.format);
        };
        return this.parserWorker(buffer, new OneLineParser((Function3)parser2){
            private final /* synthetic */ Function3 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void call(ListWithErrors.Builder result2, int lineIndex, CharSequence lineText) {
                this.function.invoke((Object)result2, (Object)lineIndex, (Object)lineText);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)this.function;
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof OneLineParser ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        });
    }

    private final ListWithErrors<DeviceInfo> parserWorker(ByteBuffer buffer, OneLineParser oneLineParser) {
        return this.parserWorker(AdbProtocolUtils.INSTANCE.byteBufferToString(buffer), oneLineParser);
    }

    @NotNull
    public final ListWithErrors<DeviceInfo> parse(@NotNull String responseText) {
        Intrinsics.checkNotNullParameter((Object)responseText, (String)"responseText");
        KFunction parser2 = switch (WhenMappings.$EnumSwitchMapping$0[this.format.ordinal()]) {
            case 1 -> (KFunction)new Function3<ListWithErrors.Builder<DeviceInfo>, Integer, CharSequence, Unit>((Object)this){

                public final void invoke(ListWithErrors.Builder<DeviceInfo> p0, int p1, CharSequence p2) {
                    Intrinsics.checkNotNullParameter(p0, (String)"p0");
                    Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                    DeviceListTextParser.access$parseOneShortFormatLine((DeviceListTextParser)this.receiver, p0, p1, p2);
                }
            };
            case 2 -> (KFunction)new Function3<ListWithErrors.Builder<DeviceInfo>, Integer, CharSequence, Unit>((Object)this){

                public final void invoke(ListWithErrors.Builder<DeviceInfo> p0, int p1, CharSequence p2) {
                    Intrinsics.checkNotNullParameter(p0, (String)"p0");
                    Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                    DeviceListTextParser.access$parseOneLongFormatLine((DeviceListTextParser)this.receiver, p0, p1, p2);
                }
            };
            default -> throw new IllegalStateException("Unsupported format: " + this.format);
        };
        return this.parserWorker(responseText, new /* invalid duplicate definition of identical inner class */);
    }

    private final ListWithErrors<DeviceInfo> parserWorker(String responseText, OneLineParser oneLineParser) {
        ListWithErrors.Builder<DeviceInfo> result2 = new ListWithErrors.Builder<DeviceInfo>();
        if (((CharSequence)responseText).length() == 0) {
            return result2.build();
        }
        Object object = new String[]{"\n"};
        List lines = StringsKt.split$default((CharSequence)responseText, (String[])object, (boolean)false, (int)0, (int)6, null);
        object = ((Iterable)lines).iterator();
        int n = 0;
        while (object.hasNext()) {
            int lineIndex = n++;
            String line = (String)object.next();
            if (!(((CharSequence)line).length() > 0)) continue;
            oneLineParser.call(result2, lineIndex, line);
        }
        return result2.build();
    }

    private final void parseOneShortFormatLine(ListWithErrors.Builder<DeviceInfo> result2, int lineIndex, CharSequence lineText) {
        Matcher matcher = DeviceListParserKt.access$getSHORT_LINE_PATTERN$p().matcher(lineText);
        if (!matcher.matches()) {
            result2.addError("Device line format is not recognized", lineIndex, ((Object)lineText).toString());
            return;
        }
        String serialNumber = matcher.group(1);
        if (serialNumber == null || ((CharSequence)serialNumber).length() == 0) {
            result2.addError("Device serial number is empty", lineIndex, lineText);
            return;
        }
        String deviceState = matcher.group(2);
        if (deviceState == null || ((CharSequence)deviceState).length() == 0) {
            result2.addError("Device state is empty", lineIndex, lineText);
            return;
        }
        result2.addEntry(DeviceInfo.Companion.fromParserValues$android_sdktools_adblib$default(DeviceInfo.Companion, serialNumber, deviceState, null, null, null, null, null, null, null, null, 1020, null));
    }

    private final void parseOneLongFormatLine(ListWithErrors.Builder<DeviceInfo> result2, int lineIndex, CharSequence lineText) {
        Matcher matcher = DeviceListParserKt.access$getLONG_LINE_PATTERN$p().matcher(lineText);
        if (!matcher.matches()) {
            result2.addError("Device line format is not recognized", lineIndex, lineText);
            return;
        }
        String serialNumber = matcher.group(1);
        if (serialNumber == null || ((CharSequence)serialNumber).length() == 0) {
            result2.addError("Device serial number is empty", lineIndex, lineText);
            return;
        }
        String deviceState = matcher.group(2);
        if (deviceState == null || ((CharSequence)deviceState).length() == 0) {
            result2.addError("Device state is empty", lineIndex, lineText);
            return;
        }
        String product2 = null;
        String model = null;
        String device2 = null;
        String transportId = null;
        Map moreFields = new LinkedHashMap();
        Matcher matcherFields = DeviceListParserKt.access$getONE_FIELD_PATTERN$p().matcher(lineText);
        block12: while (matcherFields.find()) {
            String value;
            String name;
            block20: {
                name = matcherFields.group(1);
                value = matcherFields.group(2);
                String string2 = name;
                if (string2 == null) break block20;
                int n = -1;
                switch (string2.hashCode()) {
                    case -309474065: {
                        if (string2.equals("product")) {
                            n = 1;
                        }
                        break;
                    }
                    case -1571176975: {
                        if (string2.equals("transport_id")) {
                            n = 2;
                        }
                        break;
                    }
                    case 104069929: {
                        if (string2.equals("model")) {
                            n = 3;
                        }
                        break;
                    }
                    case -1335157162: {
                        if (string2.equals("device")) {
                            n = 4;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 1: {
                        product2 = value;
                        continue block12;
                    }
                    case 3: {
                        model = value;
                        continue block12;
                    }
                    case 4: {
                        device2 = value;
                        continue block12;
                    }
                    case 2: {
                        transportId = value;
                        continue block12;
                    }
                }
            }
            moreFields.put(name, value);
        }
        DeviceInfo deviceInfo = DeviceInfo.Companion.fromParserValues$android_sdktools_adblib$default(DeviceInfo.Companion, serialNumber, deviceState, product2, model, device2, transportId, null, null, null, moreFields.isEmpty() ? MapsKt.emptyMap() : moreFields, 448, null);
        result2.addEntry(deviceInfo);
    }

    public static final /* synthetic */ void access$parseOneShortFormatLine(DeviceListTextParser $this, ListWithErrors.Builder result2, int lineIndex, CharSequence lineText) {
        $this.parseOneShortFormatLine(result2, lineIndex, lineText);
    }

    public static final /* synthetic */ void access$parseOneLongFormatLine(DeviceListTextParser $this, ListWithErrors.Builder result2, int lineIndex, CharSequence lineText) {
        $this.parseOneLongFormatLine(result2, lineIndex, lineText);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0000\b\u00e0\u0080\u0001\u0018\u00002\u00020\u0001J&\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&\u00a8\u0006\u000b\u00c0\u0006\u0003"}, d2={"Lcom/android/adblib/impl/DeviceListTextParser$OneLineParser;", "", "call", "", "result", "Lcom/android/adblib/ListWithErrors$Builder;", "Lcom/android/adblib/DeviceInfo;", "lineIndex", "", "lineText", "", "android.sdktools.adblib"})
    public static interface OneLineParser {
        public void call(@NotNull ListWithErrors.Builder<DeviceInfo> var1, int var2, @NotNull CharSequence var3);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AdbHostServices.DeviceInfoFormat.values().length];
            try {
                nArray[AdbHostServices.DeviceInfoFormat.SHORT_FORMAT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AdbHostServices.DeviceInfoFormat.LONG_FORMAT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

