/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.impl;

import com.android.adblib.AppProcessEntry;
import com.android.adblib.InstructionSet;
import com.android.server.adb.protos.AppProcessesProto;
import com.google.protobuf.ProtocolStringList;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/android/adblib/impl/AppProcessEntryListParser;", "", "<init>", "()V", "parse", "", "Lcom/android/adblib/AppProcessEntry;", "buffer", "Ljava/nio/ByteBuffer;", "android.sdktools.adblib"})
@SourceDebugExtension(value={"SMAP\nAppProcessEntryListParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppProcessEntryListParser.kt\ncom/android/adblib/impl/AppProcessEntryListParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n1869#2,2:69\n*S KotlinDebug\n*F\n+ 1 AppProcessEntryListParser.kt\ncom/android/adblib/impl/AppProcessEntryListParser\n*L\n37#1:69,2\n*E\n"})
public final class AppProcessEntryListParser {
    @NotNull
    public final List<AppProcessEntry> parse(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        List result2 = new ArrayList();
        if (!buffer.hasRemaining()) {
            return result2;
        }
        AppProcessesProto.AppProcesses appProcesses = AppProcessesProto.AppProcesses.parseFrom((ByteBuffer)buffer);
        List list2 = appProcesses.getProcessList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getProcessList(...)");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List list3;
            AppProcessesProto.ProcessEntry it = (AppProcessesProto.ProcessEntry)element$iv;
            boolean bl = false;
            int n = (int)it.getPid();
            boolean bl2 = it.getDebuggable();
            boolean bl3 = it.getProfileable();
            String string2 = it.getArchitecture();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getArchitecture(...)");
            InstructionSet instructionSet = InstructionSet.Companion.fromString(string2);
            Long l = it.hasUserId() ? Long.valueOf(it.getUserId()) : null;
            String string3 = it.hasProcessName() ? it.getProcessName() : null;
            if (it.hasUserId()) {
                ProtocolStringList protocolStringList = it.getPackageNamesList();
                Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"getPackageNamesList(...)");
                list3 = CollectionsKt.toList((Iterable)((Iterable)protocolStringList));
            } else {
                list3 = null;
            }
            result2.add(new AppProcessEntry(n, bl2, bl3, instructionSet, l, string3, list3, it.hasWaitingForDebugger() ? Boolean.valueOf(it.getWaitingForDebugger()) : null, it.hasUid() ? Long.valueOf(it.getUid()) : null));
        }
        return result2;
    }
}

