/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.jetbrains.cidr.lang.workspace.compiler.ClangFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.Command;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompilerInfoQueryBuilderKt;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompilerUtilsKt;
import com.jetbrains.cidr.lang.workspace.compiler.GCCFeatureChecks;
import com.jetbrains.cidr.lang.workspace.compiler.GCCPreprocessorCondition;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fH\u0007J\u001c\u0010\u0011\u001a\u00020\n2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000f0\u0013H\u0007J$\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0007J\u001a\u0010\u0015\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0007J\u0018\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u0018H\u0007J\b\u0010 \u001a\u00020\nH\u0002J\b\u0010!\u001a\u00020\nH\u0002J%\u0010\"\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001a2\u000b\u0010#\u001a\u00070\u000f\u00a2\u0006\u0002\b$2\u0006\u0010%\u001a\u00020\fH\u0002J\u0018\u0010&\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u0014H\u0002J\b\u0010(\u001a\u00020\nH\u0002J\u0018\u0010)\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020\u001cH\u0002J \u0010+\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u000fH\u0002J\u0010\u0010.\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001aH\u0002J\u0010\u0010/\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001aH\u0002R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/jetbrains/cidr/lang/workspace/compiler/GCCCompilerInfoQueryBuilder;", "", "myResult", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "<init>", "(Ljava/lang/StringBuilder;)V", "nextHelperDefineId", "", "appendCompilerInfoQueries", "", "needsFileNameDefine", "", "appendLanguageStandardQuery", "macro", "", "isCPP", "appendTypeSizeQueries", "typeSizes", "", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$TypeSize;", "appendHasBuiltinQuery", "builtin", "feature", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$Feature;", "fallbackCondition", "Lcom/jetbrains/cidr/lang/workspace/compiler/GCCPreprocessorCondition;", "trait", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$TypeTrait;", "appendSetFeatureCommand", "condition", "cidrFeature", "collectGCCFeatures", "collectClangFeatures", "appendBuiltinQuery", "emulationMacroName", "Lorg/jetbrains/annotations/NonNls;", "supported", "appendTypeSizeQuery", "type", "appendFileNameDefinition", "appendSetTypeTraitCommand", "typeTrait", "doAppendBranch", "trueText", "falseText", "appendPotentialDefinesIfs", "appendPotentialDefinesEndifs", "intellij.cidr.projectModel"})
@SourceDebugExtension(value={"SMAP\nGCCCompilerInfoQueryBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GCCCompilerInfoQueryBuilder.kt\ncom/jetbrains/cidr/lang/workspace/compiler/GCCCompilerInfoQueryBuilder\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,347:1\n216#2,2:348\n1869#3,2:350\n1869#3,2:352\n1869#3,2:354\n1869#3,2:356\n1869#3,2:358\n1869#3,2:360\n1869#3,2:362\n*S KotlinDebug\n*F\n+ 1 GCCCompilerInfoQueryBuilder.kt\ncom/jetbrains/cidr/lang/workspace/compiler/GCCCompilerInfoQueryBuilder\n*L\n130#1:348,2\n181#1:350,2\n195#1:352,2\n205#1:354,2\n209#1:356,2\n213#1:358,2\n217#1:360,2\n223#1:362,2\n*E\n"})
public final class GCCCompilerInfoQueryBuilder {
    @NotNull
    private final StringBuilder myResult;
    private int nextHelperDefineId;

    public GCCCompilerInfoQueryBuilder(@NotNull StringBuilder myResult) {
        Intrinsics.checkNotNullParameter((Object)myResult, (String)"myResult");
        this.myResult = myResult;
    }

    public final void appendCompilerInfoQueries(boolean needsFileNameDefine) {
        this.appendLanguageStandardQuery("__STDC_VERSION__", false);
        this.appendLanguageStandardQuery("__cplusplus", true);
        if (needsFileNameDefine) {
            this.appendFileNameDefinition();
        }
        this.appendSetFeatureCommand(GCCPreprocessorCondition.Companion.defined("__has_builtin"), OCCompilerFeatures.Feature.HAS_BUILTIN);
        this.appendSetFeatureCommand(GCCPreprocessorCondition.Companion.defined("__has_feature"), OCCompilerFeatures.Feature.HAS_FEATURE);
        this.appendSetFeatureCommand(GCCPreprocessorCondition.Companion.defined("__has_extension"), OCCompilerFeatures.Feature.HAS_EXTENSION);
        this.appendSetFeatureCommand(GCCPreprocessorCondition.Companion.defined("__has_include_next"), OCCompilerFeatures.Feature.HAS_HAS_INCLUDE_NEXT);
        this.appendBuiltinQuery(GCCPreprocessorCondition.Companion.defined("__has_include"), "__CIDR_builtin__has_include", true);
        this.appendBuiltinQuery(GCCPreprocessorCondition.Companion.defined("__has_cpp_attribute"), "__CIDR_builtin__has_cpp_attribute", true);
        this.appendSetFeatureCommand(GCCPreprocessorCondition.Companion.safe("!defined(__cplusplus) && __STDC_VERSION__ <= 199409L"), OCCompilerFeatures.Feature.C_VARIABLE_DECLARATION_RULES_ARE_C89_COMPATIBLE);
        this.myResult.append("#if __clang__").append('\n');
        this.collectClangFeatures();
        this.myResult.append("#else").append('\n');
        this.collectGCCFeatures();
        this.myResult.append("#endif").append('\n');
        GCCCompilerInfoQueryBuilder.appendHasBuiltinQuery$default(this, "__builtin_bit_cast", OCCompilerFeatures.Feature.BUILTIN_BIT_CAST, null, 4, null);
        GCCCompilerInfoQueryBuilder.appendHasBuiltinQuery$default(this, "__builtin_source_location", OCCompilerFeatures.Feature.BUILTIN_SOURCE_LOCATION, null, 4, null);
        this.appendHasBuiltinQuery("__builtin_is_constant_evaluated", OCCompilerFeatures.Feature.CXX_BUILTIN_IS_CONSTANT_EVALUATED, GCCPreprocessorCondition.Companion.safe("__CIDR_GCC_VERSION >= 90100"));
        this.appendTypeSizeQueries(GCCFeatureChecks.INSTANCE.getTYPE_SIZES());
        for (OCCompilerFeatures.TypeTrait trait : EntriesMappings.entries$0) {
            GCCPreprocessorCondition fallbackCondition = switch (WhenMappings.$EnumSwitchMapping$0[trait.ordinal()]) {
                case 1 -> GCCPreprocessorCondition.Companion.safe("__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 80100");
                case 2 -> GCCPreprocessorCondition.Companion.safe("__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 100100");
                case 3, 4 -> GCCPreprocessorCondition.Companion.safe("defined(__cplusplus) && __CIDR_GCC_VERSION >= 130100");
                default -> null;
            };
            this.appendHasBuiltinQuery(trait, fallbackCondition);
        }
    }

    @VisibleForTesting
    public final void appendLanguageStandardQuery(@NotNull String macro, boolean isCPP) {
        Intrinsics.checkNotNullParameter((Object)macro, (String)"macro");
        String standardKey = isCPP ? "STANDARD_CPP" : "STANDARD_C";
        this.myResult.append("#if defined(" + macro + ")").append('\n');
        this.myResult.append(GCCCompilerInfoQueryBuilderKt.access$buildCommand(Command.SET_LANGUAGE_STANDARD, standardKey, macro)).append('\n');
        this.myResult.append("#endif").append('\n');
    }

    @VisibleForTesting
    public final void appendTypeSizeQueries(@NotNull Map<OCCompilerFeatures.TypeSize, String> typeSizes) {
        Intrinsics.checkNotNullParameter(typeSizes, (String)"typeSizes");
        for (Map.Entry<OCCompilerFeatures.TypeSize, String> entry : typeSizes.entrySet()) {
            OCCompilerFeatures.TypeSize macro = entry.getKey();
            String type = entry.getValue();
            this.appendTypeSizeQuery(type, macro);
        }
    }

    @VisibleForTesting
    public final void appendHasBuiltinQuery(@NotNull String builtin, @NotNull OCCompilerFeatures.Feature feature, @Nullable GCCPreprocessorCondition fallbackCondition) {
        Intrinsics.checkNotNullParameter((Object)builtin, (String)"builtin");
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        this.myResult.append("#if defined(__has_builtin)").append('\n');
        this.appendSetFeatureCommand(GCCPreprocessorCondition.Companion.hasBuiltin(builtin), feature);
        if (fallbackCondition != null) {
            this.myResult.append("#else").append('\n');
            this.appendSetFeatureCommand(fallbackCondition, feature);
        }
        this.myResult.append("#endif").append('\n');
    }

    public static /* synthetic */ void appendHasBuiltinQuery$default(GCCCompilerInfoQueryBuilder gCCCompilerInfoQueryBuilder, String string, OCCompilerFeatures.Feature feature, GCCPreprocessorCondition gCCPreprocessorCondition, int n, Object object) {
        if ((n & 4) != 0) {
            gCCPreprocessorCondition = null;
        }
        gCCCompilerInfoQueryBuilder.appendHasBuiltinQuery(string, feature, gCCPreprocessorCondition);
    }

    @VisibleForTesting
    public final void appendHasBuiltinQuery(@NotNull OCCompilerFeatures.TypeTrait trait, @Nullable GCCPreprocessorCondition fallbackCondition) {
        Intrinsics.checkNotNullParameter((Object)trait, (String)"trait");
        this.myResult.append("#if defined(__has_builtin)").append('\n');
        String string = trait.getSpelling();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSpelling(...)");
        this.appendSetTypeTraitCommand(GCCPreprocessorCondition.Companion.hasBuiltin(string), trait);
        if (fallbackCondition != null) {
            this.myResult.append("#else").append('\n');
            this.appendSetTypeTraitCommand(fallbackCondition, trait);
        }
        this.myResult.append("#endif").append('\n');
    }

    @VisibleForTesting
    public final void appendSetFeatureCommand(@NotNull GCCPreprocessorCondition condition, @NotNull OCCompilerFeatures.Feature cidrFeature) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Intrinsics.checkNotNullParameter((Object)cidrFeature, (String)"cidrFeature");
        Object trueText = GCCCompilerInfoQueryBuilderKt.access$buildCommand(Command.SET_FEATURE, cidrFeature.name(), "1");
        if (cidrFeature == OCCompilerFeatures.Feature.OBJC_BOOL) {
            char c = '\"';
            String string = "((BOOL)0)";
            String string2 = GCCCompilerInfoQueryBuilderKt.access$buildCommand(Command.ADD_DEFINITION, "__objc_no", c + string + "\"");
            c = '\"';
            string = "((BOOL)1)";
            trueText = (String)trueText + "\n" + string2 + "\n" + GCCCompilerInfoQueryBuilderKt.access$buildCommand(Command.ADD_DEFINITION, "__objc_yes", c + string + "\"");
        }
        String falseText = GCCCompilerInfoQueryBuilderKt.access$buildCommand(Command.SET_FEATURE, cidrFeature.name(), "0");
        this.doAppendBranch(condition, (String)trueText, falseText);
    }

    private final void collectGCCFeatures() {
        this.myResult.append("#define __CIDR_GCC_VERSION (__GNUC__ * 10000 + __GNUC_MINOR__ * 100 + __GNUC_PATCHLEVEL__)").append('\n');
        Map<OCCompilerFeatures.Feature, String> $this$forEach$iv = GCCFeatureChecks.INSTANCE.getDEFAULT_CHECKS();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<OCCompilerFeatures.Feature, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<OCCompilerFeatures.Feature, String> element$iv;
            Map.Entry<OCCompilerFeatures.Feature, String> entry = element$iv = iterator.next();
            boolean bl = false;
            OCCompilerFeatures.Feature feature = entry.getKey();
            String check = entry.getValue();
            this.appendSetFeatureCommand(GCCPreprocessorCondition.Companion.safe(check), feature);
        }
        this.appendSetFeatureCommand(GCCPreprocessorCondition.Companion.safe("__cplusplus >= 202402L || __CIDR_GCC_VERSION >= 130100 || __cpp_constexpr >= 201304L"), OCCompilerFeatures.Feature.CXX_CONSTEXPR_VOID);
    }

    private final void collectClangFeatures() {
        String it;
        this.myResult.append("#if !(defined (__has_extension)) && defined(__has_feature)\n  #define __has_extension __has_feature\n#endif\n#if !defined(__has_attribute)\n  #define __has_attribute(x) 0\n#endif\n#if !defined(__has_builtin)\n  #define __has_builtin(x) 0\n#endif\n#if !defined(__is_identifier)\n  #define __is_identifier(x) 1\n#endif\n#if !__has_builtin(__is_target_arch)\n  #define __is_target_arch(x) 0\n#endif\n#if !__has_builtin(__is_target_vendor)\n  #define __is_target_vendor(x) 0\n#endif\n#if !__has_builtin(__is_target_os)\n  #define __is_target_os(x) 0\n#endif\n#if !__has_builtin(__is_target_variant_os)\n  #define __is_target_variant_os(x) 0\n#endif\n#if !__has_builtin(__is_target_environment)\n  #define __is_target_environment(x) 0\n#endif\n#if !__has_builtin(__is_target_variant_environment)\n  #define __is_target_variant_environment(x) 0\n#endif").append('\n');
        Collection<String> collection = ClangFeatures.getAllFeatures();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getAllFeatures(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            boolean supported = !ClangFeatures.getUnsupportedClangFeatures().contains(it);
            Intrinsics.checkNotNull((Object)it);
            GCCPreprocessorCondition featureCondition = GCCPreprocessorCondition.Companion.hasFeature(it);
            GCCPreprocessorCondition extensionCondition = GCCPreprocessorCondition.Companion.hasExtension(it);
            this.appendBuiltinQuery(featureCondition, GCCCompilerUtilsKt.clangFeatureMacro(it), supported);
            this.appendBuiltinQuery(extensionCondition, GCCCompilerUtilsKt.clangExtensionMacro(it), supported);
            OCCompilerFeatures.Feature cidrFeature = ClangFeatures.getFeatureForClangId(it);
            if (cidrFeature == null) continue;
            this.appendSetFeatureCommand(GCCPreprocessorCondition.Companion.or(featureCondition, extensionCondition), cidrFeature);
        }
        Collection<String> collection2 = ClangFeatures.getAllBuiltins();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"getAllBuiltins(...)");
        $this$forEach$iv = collection2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            GCCPreprocessorCondition condition = GCCPreprocessorCondition.Companion.hasBuiltin(it);
            this.appendBuiltinQuery(condition, GCCCompilerUtilsKt.clangBuiltinMacro(it), true);
            OCCompilerFeatures.Feature cidrFeature = ClangFeatures.getFeatureForClangId(it);
            if (cidrFeature == null) continue;
            this.appendSetFeatureCommand(condition, cidrFeature);
        }
        Collection<String> collection3 = ClangFeatures.getAllAttributes();
        Intrinsics.checkNotNullExpressionValue(collection3, (String)"getAllAttributes(...)");
        $this$forEach$iv = collection3;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this.appendBuiltinQuery(GCCPreprocessorCondition.Companion.hasAttribute(it), GCCCompilerUtilsKt.clangAttributeMacro(it), true);
        }
        Set<String> set = ClangFeatures.getAllTargetArchs();
        Intrinsics.checkNotNullExpressionValue(set, (String)"getAllTargetArchs(...)");
        $this$forEach$iv = set;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this.appendBuiltinQuery(GCCPreprocessorCondition.Companion.function("__is_target_arch", it), GCCCompilerUtilsKt.clangTargetArchMacro(it), true);
        }
        Set<String> set2 = ClangFeatures.getAllTargetVendors();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"getAllTargetVendors(...)");
        $this$forEach$iv = set2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this.appendBuiltinQuery(GCCPreprocessorCondition.Companion.function("__is_target_vendor", it), GCCCompilerUtilsKt.clangTargetVendorMacro(it), true);
        }
        Set<String> set3 = ClangFeatures.getAllTargetOss();
        Intrinsics.checkNotNullExpressionValue(set3, (String)"getAllTargetOss(...)");
        $this$forEach$iv = set3;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this.appendBuiltinQuery(GCCPreprocessorCondition.Companion.function("__is_target_os", it), GCCCompilerUtilsKt.clangTargetOsMacro(it), true);
            this.appendBuiltinQuery(GCCPreprocessorCondition.Companion.function("__is_target_variant_os", it), GCCCompilerUtilsKt.clangTargetVariantOsMacro(it), true);
        }
        Set<String> set4 = ClangFeatures.getAllTargetEnvironemts();
        Intrinsics.checkNotNullExpressionValue(set4, (String)"getAllTargetEnvironemts(...)");
        $this$forEach$iv = set4;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this.appendBuiltinQuery(GCCPreprocessorCondition.Companion.function("__is_target_environment", it), GCCCompilerUtilsKt.clangTargetEnvironmentMacro(it), true);
            this.appendBuiltinQuery(GCCPreprocessorCondition.Companion.function("__is_target_variant_environment", it), GCCCompilerUtilsKt.clangTargetVariantEnvironmentMacro(it), true);
        }
        this.appendSetFeatureCommand(GCCPreprocessorCondition.Companion.safe("!__is_identifier(__auto_type)"), OCCompilerFeatures.Feature.GCC_AUTO_TYPE);
        this.appendSetFeatureCommand(GCCPreprocessorCondition.Companion.defined("__cpp_concepts"), OCCompilerFeatures.Feature.CXX_CONCEPTS);
    }

    private final void appendBuiltinQuery(GCCPreprocessorCondition condition, String emulationMacroName, boolean supported) {
        String falseText = GCCCompilerInfoQueryBuilderKt.access$buildCommand(Command.ADD_DEFINITION, emulationMacroName, "0");
        if (supported) {
            String trueText = GCCCompilerInfoQueryBuilderKt.access$buildCommand(Command.ADD_DEFINITION, emulationMacroName, "1");
            this.doAppendBranch(condition, trueText, falseText);
        } else {
            this.myResult.append(falseText).append('\n');
        }
    }

    private final void appendTypeSizeQuery(String macro, OCCompilerFeatures.TypeSize type) {
        this.myResult.append("#if defined(" + macro + ")").append('\n');
        this.myResult.append(GCCCompilerInfoQueryBuilderKt.access$buildCommand(Command.SET_TYPE_SIZE, type.name(), macro)).append('\n');
        this.myResult.append("#endif").append('\n');
    }

    private final void appendFileNameDefinition() {
        this.myResult.append("#ifdef __FILE_NAME__").append('\n');
        this.myResult.append(GCCCompilerInfoQueryBuilderKt.access$buildCommand(Command.ADD_DEFINITION, "__CIDR_macro__FILE_NAME__", "\"_file_name_short_\"")).append('\n');
        this.myResult.append("#endif").append('\n');
    }

    private final void appendSetTypeTraitCommand(GCCPreprocessorCondition condition, OCCompilerFeatures.TypeTrait typeTrait) {
        String trueText = GCCCompilerInfoQueryBuilderKt.access$buildCommand(Command.SET_TYPE_TRAIT, typeTrait.name(), "1");
        String falseText = GCCCompilerInfoQueryBuilderKt.access$buildCommand(Command.SET_TYPE_TRAIT, typeTrait.name(), "0");
        this.doAppendBranch(condition, trueText, falseText);
    }

    private final void doAppendBranch(GCCPreprocessorCondition condition, String trueText, String falseText) {
        String helperDefine = "__CIDR_HELPER_DEFINE_" + this.nextHelperDefineId;
        ++this.nextHelperDefineId;
        this.appendPotentialDefinesIfs(condition);
        this.myResult.append("#if " + condition.getText()).append('\n');
        this.myResult.append("#define " + helperDefine).append('\n');
        this.myResult.append("#endif").append('\n');
        this.appendPotentialDefinesEndifs(condition);
        this.myResult.append("#if defined(" + helperDefine + ")").append('\n');
        this.myResult.append(trueText).append('\n');
        this.myResult.append("#else").append('\n');
        this.myResult.append(falseText).append('\n');
        this.myResult.append("#endif").append('\n');
    }

    private final void appendPotentialDefinesIfs(GCCPreprocessorCondition condition) {
        for (String potentialDefine : condition.getPotentialDefines()) {
            if (GCCCompilerInfoQueryBuilderKt.access$isSafe(potentialDefine)) continue;
            this.myResult.append("#if !defined(" + potentialDefine + ")").append('\n');
        }
    }

    private final void appendPotentialDefinesEndifs(GCCPreprocessorCondition condition) {
        for (String potentialDefine : condition.getPotentialDefines()) {
            if (GCCCompilerInfoQueryBuilderKt.access$isSafe(potentialDefine)) continue;
            this.myResult.append("#endif\n");
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<OCCompilerFeatures.TypeTrait> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])OCCompilerFeatures.TypeTrait.values());
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OCCompilerFeatures.TypeTrait.values().length];
            try {
                nArray[OCCompilerFeatures.TypeTrait.INTEGER_PACK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCCompilerFeatures.TypeTrait.IS_SAME.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCCompilerFeatures.TypeTrait.IS_CONVERTIBLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCCompilerFeatures.TypeTrait.IS_NOTHROW_CONVERTIBLE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

