/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.toolchains;

import com.intellij.execution.CommandLineUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.EscapeUtil;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.toolchains.OSType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrSwitchBuilder {
    private final List<String> myArgs = new ArrayList<String>();
    private final OSType myType;

    public CidrSwitchBuilder(OSType type) {
        this.myType = type;
    }

    public CidrSwitchBuilder() {
        this(OSType.getCurrent());
    }

    public OSType getOSType() {
        return this.myType;
    }

    @NotNull
    public CidrSwitchBuilder addSingleRaw(@NonNls @Nullable String rawArg) {
        if (rawArg != null) {
            this.myArgs.add(rawArg);
        }
        CidrSwitchBuilder cidrSwitchBuilder = this;
        if (cidrSwitchBuilder == null) {
            CidrSwitchBuilder.$$$reportNull$$$0(0);
        }
        return cidrSwitchBuilder;
    }

    @NotNull
    public CidrSwitchBuilder addAllRaw(@NotNull List<String> rawArgs) {
        if (rawArgs == null) {
            CidrSwitchBuilder.$$$reportNull$$$0(1);
        }
        this.myArgs.addAll(rawArgs);
        CidrSwitchBuilder cidrSwitchBuilder = this;
        if (cidrSwitchBuilder == null) {
            CidrSwitchBuilder.$$$reportNull$$$0(2);
        }
        return cidrSwitchBuilder;
    }

    public CidrSwitchBuilder parseAndAdd(@Nullable String args, @NotNull CidrCompilerSwitches.Format format) {
        if (format == null) {
            CidrSwitchBuilder.$$$reportNull$$$0(3);
        }
        if (args != null) {
            this.myArgs.addAll(CidrSwitchBuilder.parseArgs(args, format));
        }
        return this;
    }

    @NotNull
    public CidrSwitchBuilder addAll(@Nullable CidrCompilerSwitches switches) {
        if (switches != null) {
            this.myArgs.addAll(switches.getList(CidrCompilerSwitches.Format.RAW));
        }
        CidrSwitchBuilder cidrSwitchBuilder = this;
        if (cidrSwitchBuilder == null) {
            CidrSwitchBuilder.$$$reportNull$$$0(4);
        }
        return cidrSwitchBuilder;
    }

    @NotNull
    public List<String> getArgs() {
        List<String> list = Collections.unmodifiableList(this.myArgs);
        if (list == null) {
            CidrSwitchBuilder.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public CidrCompilerSwitches build() {
        return new CidrCompilerSwitches(new ArrayList<String>(this.myArgs));
    }

    @NotNull
    public static List<String> parseArgs(@NotNull String options, @NotNull CidrCompilerSwitches.Format format) {
        if (options == null) {
            CidrSwitchBuilder.$$$reportNull$$$0(6);
        }
        if (format == null) {
            CidrSwitchBuilder.$$$reportNull$$$0(7);
        }
        if (format == CidrCompilerSwitches.Format.RAW) {
            throw new IllegalArgumentException("RAW format cannot be correctly parsed into multiple arguments, you probably meant something else");
        }
        if (format == CidrCompilerSwitches.Format.GNU_MAKEFILES || format == CidrCompilerSwitches.Format.MINGW_MAKEFILES || format == CidrCompilerSwitches.Format.NMAKE_MAKEFILES) {
            options = CidrSwitchBuilder.preprocessForMakefiles(options, format);
        }
        if (format == CidrCompilerSwitches.Format.BASH_SHELL || format == CidrCompilerSwitches.Format.GCC_RESPONSE_FILE || format == CidrCompilerSwitches.Format.GNU_MAKEFILES || format == CidrCompilerSwitches.Format.MINGW_MAKEFILES) {
            List<String> list = CidrSwitchBuilder.parseGNU(options, format);
            if (list == null) {
                CidrSwitchBuilder.$$$reportNull$$$0(8);
            }
            return list;
        }
        if (format == CidrCompilerSwitches.Format.WINDOWS_SHELL || format == CidrCompilerSwitches.Format.MSVC_RESPONSE_FILE || format == CidrCompilerSwitches.Format.NMAKE_MAKEFILES) {
            List<String> list = CidrSwitchBuilder.parseWindows(options, format);
            if (list == null) {
                CidrSwitchBuilder.$$$reportNull$$$0(9);
            }
            return list;
        }
        throw new IllegalArgumentException(String.valueOf((Object)format) + " is not supported yet");
    }

    @NotNull
    public static String convertSingleRawArgTo(@NotNull String rawArg, @NotNull CidrCompilerSwitches.Format format) {
        if (rawArg == null) {
            CidrSwitchBuilder.$$$reportNull$$$0(10);
        }
        if (format == null) {
            CidrSwitchBuilder.$$$reportNull$$$0(11);
        }
        if (format == CidrCompilerSwitches.Format.RAW) {
            String string = rawArg;
            if (string == null) {
                CidrSwitchBuilder.$$$reportNull$$$0(12);
            }
            return string;
        }
        if (format == CidrCompilerSwitches.Format.BASH_SHELL || format == CidrCompilerSwitches.Format.GCC_RESPONSE_FILE || format == CidrCompilerSwitches.Format.GNU_MAKEFILES || format == CidrCompilerSwitches.Format.MINGW_MAKEFILES) {
            String string = EscapeUtil.escapeGNU((String)rawArg, (format != CidrCompilerSwitches.Format.GCC_RESPONSE_FILE ? 1 : 0) != 0);
            if (string == null) {
                CidrSwitchBuilder.$$$reportNull$$$0(13);
            }
            return string;
        }
        if (format == CidrCompilerSwitches.Format.WINDOWS_SHELL || format == CidrCompilerSwitches.Format.MSVC_RESPONSE_FILE || format == CidrCompilerSwitches.Format.NMAKE_MAKEFILES) {
            return CidrSwitchBuilder.convertToWindows(rawArg, format);
        }
        throw new IllegalArgumentException(String.valueOf((Object)format) + " is not supported yet");
    }

    @NotNull
    private static String preprocessForMakefiles(@NotNull String options, @NotNull CidrCompilerSwitches.Format format) {
        char c;
        int i;
        if (options == null) {
            CidrSwitchBuilder.$$$reportNull$$$0(14);
        }
        if (format == null) {
            CidrSwitchBuilder.$$$reportNull$$$0(15);
        }
        if (StringUtil.indexOfAny((String)options, (String)"$#") == -1) {
            String string = options;
            if (string == null) {
                CidrSwitchBuilder.$$$reportNull$$$0(16);
            }
            return string;
        }
        int length = options.length();
        StringBuilder builder = new StringBuilder(length);
        char escape = format == CidrCompilerSwitches.Format.NMAKE_MAKEFILES ? (char)'^' : '\\';
        for (i = 0; i < length; ++i) {
            c = options.charAt(i);
            if (c == escape && i < length - 1 && options.charAt(i + 1) == '#') {
                ++i;
                c = '#';
            } else if (c == '#') break;
            builder.append(c);
        }
        options = builder.toString();
        length = options.length();
        builder.setLength(0);
        for (i = 0; i < length; ++i) {
            c = options.charAt(i);
            if (c == '$') {
                if (i == length - 1) continue;
                if ((c = options.charAt(++i)) == '(' || c == '{') {
                    int closing;
                    int n = closing = c == '(' ? 41 : 125;
                    while (i < length - 1 && c != closing) {
                        c = options.charAt(++i);
                    }
                    continue;
                }
                if (c != '$') continue;
            }
            builder.append(c);
        }
        String string = builder.toString();
        if (string == null) {
            CidrSwitchBuilder.$$$reportNull$$$0(17);
        }
        return string;
    }

    public static List<String> parseGNU(@NotNull String options, @NotNull CidrCompilerSwitches.Format format) {
        if (options == null) {
            CidrSwitchBuilder.$$$reportNull$$$0(18);
        }
        if (format == null) {
            CidrSwitchBuilder.$$$reportNull$$$0(19);
        }
        boolean isShell = format == CidrCompilerSwitches.Format.BASH_SHELL || format == CidrCompilerSwitches.Format.GNU_MAKEFILES || format == CidrCompilerSwitches.Format.MINGW_MAKEFILES;
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean[] mayHaveEmptyArg = new boolean[]{false};
        Runnable flush = () -> {
            if (!current.isEmpty() || mayHaveEmptyArg[0]) {
                result.add(current.toString());
            }
            current.setLength(0);
            mayHaveEmptyArg[0] = false;
        };
        char inQuotes = '\u0000';
        int length = options.length();
        for (int i = 0; i < length; ++i) {
            char c = options.charAt(i);
            if (isShell && c == '$' && i < length - 1 && options.charAt(i + 1) == '\'') {
                char cc;
                StringBuilder ansi = new StringBuilder();
                int j = i + 1;
                ++j;
                while (j < length && ((cc = options.charAt(j)) != '\'' || options.charAt(j - 1) == '\\')) {
                    ansi.append(cc);
                    ++j;
                }
                current.append(EscapeUtil.unescapeAnsiStringCharacters((String)ansi.toString()));
                mayHaveEmptyArg[0] = true;
                i = j;
                continue;
            }
            if (!(c != '\\' || isShell && inQuotes == '\'')) {
                boolean consumeEscapeChar;
                if (i == length - 1 || (c = options.charAt(++i)) == '\n' && (isShell || format == CidrCompilerSwitches.Format.GCC_RESPONSE_FILE && inQuotes == '\u0000')) continue;
                if (format == CidrCompilerSwitches.Format.GCC_RESPONSE_FILE) {
                    consumeEscapeChar = true;
                } else if (format == CidrCompilerSwitches.Format.MINGW_MAKEFILES) {
                    consumeEscapeChar = "\"$`\n".indexOf(c) != -1 || inQuotes == '\u0000' && " \\'{}[]()<>#|^&*;?`".indexOf(c) != -1 || inQuotes != '\u0000' && c == '\\' && i < length - 1 && "\"\n".indexOf(options.charAt(i + 1)) != -1;
                } else {
                    boolean bl = consumeEscapeChar = inQuotes == '\u0000' || isShell && "\\\"$`\n".indexOf(c) != -1;
                }
                if (!consumeEscapeChar) {
                    current.append('\\');
                }
            } else {
                if (inQuotes != '\u0000' && c == inQuotes) {
                    inQuotes = '\u0000';
                    continue;
                }
                if (inQuotes == '\u0000' && (c == '\"' || c == '\'')) {
                    inQuotes = c;
                    mayHaveEmptyArg[0] = true;
                    continue;
                }
                if (inQuotes == '\u0000' && " \t\n\r\f".indexOf(c) != -1) {
                    flush.run();
                    continue;
                }
            }
            current.append(c);
        }
        flush.run();
        return result;
    }

    private static List<String> parseWindows(@NotNull String options, @NotNull CidrCompilerSwitches.Format format) {
        if (options == null) {
            CidrSwitchBuilder.$$$reportNull$$$0(20);
        }
        if (format == null) {
            CidrSwitchBuilder.$$$reportNull$$$0(21);
        }
        boolean isShell = format == CidrCompilerSwitches.Format.WINDOWS_SHELL || format == CidrCompilerSwitches.Format.NMAKE_MAKEFILES;
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean[] quotedArg = new boolean[]{false};
        Runnable flush = () -> {
            String toAdd = current.toString();
            if (!quotedArg[0]) {
                toAdd = StringUtil.trimTrailing((String)toAdd);
            }
            if (!toAdd.isEmpty() || quotedArg[0]) {
                result.add(toAdd);
            }
            current.setLength(0);
            quotedArg[0] = false;
        };
        boolean inQuotes = false;
        boolean escaped = false;
        int length = options.length();
        for (int i = 0; i < length; ++i) {
            char c = options.charAt(i);
            boolean wasEscaped = escaped;
            escaped = false;
            if (c == '\\') {
                int count = 0;
                while (i < length - 1 && c == '\\') {
                    ++count;
                    c = options.charAt(++i);
                }
                if (c == '\"') {
                    if (count % 2 == 1) {
                        current.append(StringUtil.repeatSymbol((char)'\\', (int)((count + 1) / 2 - 1)));
                        current.append('\"');
                        continue;
                    }
                    current.append(StringUtil.repeatSymbol((char)'\\', (int)(count / 2)));
                } else {
                    current.append(StringUtil.repeatSymbol((char)'\\', (int)count));
                }
                wasEscaped = false;
            }
            if (c == '\"') {
                if (inQuotes) {
                    if (format == CidrCompilerSwitches.Format.MSVC_RESPONSE_FILE && i < length - 1 && options.charAt(i + 1) == '\"') {
                        ++i;
                        current.append(c);
                    }
                    inQuotes = false;
                    continue;
                }
                if (isShell && i > 0 && options.charAt(i - 1) == '\"') {
                    current.append(c);
                }
                inQuotes = true;
                quotedArg[0] = true;
                continue;
            }
            if (isShell && !inQuotes && c == '^' && !wasEscaped) {
                escaped = true;
                continue;
            }
            if (c == '\n' || c == '\r') {
                boolean shouldWriteOELs;
                boolean bl = shouldWriteOELs = format == CidrCompilerSwitches.Format.NMAKE_MAKEFILES && wasEscaped;
                if (shouldWriteOELs) {
                    current.append(c);
                }
                if (c == '\r' && i < length - 1 && options.charAt(i + 1) == '\n') {
                    ++i;
                    if (shouldWriteOELs) {
                        current.append(options.charAt(i));
                    }
                }
                if (shouldWriteOELs) continue;
                if (wasEscaped) {
                    escaped = true;
                    continue;
                }
                flush.run();
                continue;
            }
            if (!inQuotes && " \t\f".indexOf(c) != -1) {
                flush.run();
                continue;
            }
            current.append(c);
        }
        flush.run();
        return result;
    }

    @NotNull
    private static String convertToWindows(String arg, CidrCompilerSwitches.Format format) {
        String string = CommandLineUtil.escapeParameterOnWindows((String)arg, (format == CidrCompilerSwitches.Format.WINDOWS_SHELL || format == CidrCompilerSwitches.Format.NMAKE_MAKEFILES ? 1 : 0) != 0);
        if (string == null) {
            CidrSwitchBuilder.$$$reportNull$$$0(22);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 6, 7, 10, 11, 14, 15, 18, 19, 20, 21 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/toolchains/CidrSwitchBuilder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawArgs";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 15: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 6: 
            case 14: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawArg";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "addSingleRaw";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/toolchains/CidrSwitchBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "addAllRaw";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "addAll";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgs";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "parseArgs";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "convertSingleRawArgTo";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "preprocessForMakefiles";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToWindows";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addAllRaw";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseAndAdd";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseArgs";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "convertSingleRawArgTo";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "preprocessForMakefiles";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "parseGNU";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "parseWindows";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 6, 7, 10, 11, 14, 15, 18, 19, 20, 21 -> new IllegalArgumentException(string);
        };
    }
}

