/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.pixelprobe.util;

import com.android.tools.pixelprobe.ColorMode;
import com.android.tools.pixelprobe.color.Colors;
import com.android.tools.pixelprobe.color.CsIndexColorModel;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ByteLookupTable;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DirectColorModel;
import java.awt.image.LookupOp;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public final class Images {
    private static final Map<LutKey, BufferedImageOp> lookupTables = new HashMap<LutKey, BufferedImageOp>();
    private static final ReentrantLock lookupTablesLock = new ReentrantLock();

    private Images() {
    }

    public static BufferedImage create(int width, int height, ColorMode colorMode, int channels, ColorSpace colorSpace, int depth) {
        WritableRaster raster;
        ColorModel colorModel;
        Type type = Images.getImageType(channels, colorMode, depth);
        switch (type.ordinal()) {
            case 0: {
                if (colorSpace == null || colorSpace.getType() != 5) {
                    colorSpace = ColorSpace.getInstance(1000);
                }
                colorModel = new DirectColorModel(colorSpace, 24, 0xFF0000, 65280, 255, 0, false, Images.getTransferType(24));
                raster = colorModel.createCompatibleWritableRaster(width, height);
                break;
            }
            case 1: {
                if (colorSpace == null || colorSpace.getType() != 5) {
                    colorSpace = ColorSpace.getInstance(1000);
                }
                colorModel = new DirectColorModel(colorSpace, 32, 0xFF0000, 65280, 255, -16777216, false, Images.getTransferType(32));
                raster = colorModel.createCompatibleWritableRaster(width, height);
                break;
            }
            case 2: {
                if (colorSpace == null || colorSpace.getType() != 6) {
                    colorSpace = ColorSpace.getInstance(1003);
                }
                colorModel = new ComponentColorModel(colorSpace, new int[]{8}, false, false, 1, 0);
                raster = colorModel.createCompatibleWritableRaster(width, height);
                break;
            }
            case 3: {
                if (colorSpace == null || colorSpace.getType() != 6) {
                    colorSpace = ColorSpace.getInstance(1003);
                }
                colorModel = new ComponentColorModel(colorSpace, new int[]{8, 8}, true, false, 3, 0);
                raster = colorModel.createCompatibleWritableRaster(width, height);
                break;
            }
            case 4: {
                if (colorSpace == null || colorSpace.getType() != 9) {
                    colorSpace = Colors.getCmykColorSpace();
                }
                colorModel = new ComponentColorModel(colorSpace, new int[]{8, 8, 8, 8}, false, false, 1, 0);
                raster = Raster.createInterleavedRaster(0, width, height, width * 4, 4, new int[]{0, 1, 2, 3}, null);
                break;
            }
            case 5: {
                if (colorSpace == null || colorSpace.getType() != 9) {
                    colorSpace = Colors.getCmykColorSpace();
                }
                colorModel = new ComponentColorModel(colorSpace, new int[]{8, 8, 8, 8, 8}, true, false, 3, 0);
                raster = Raster.createInterleavedRaster(0, width, height, width * 5, 5, new int[]{1, 2, 3, 4, 0}, null);
                break;
            }
            case 6: {
                if (colorSpace == null || colorSpace.getType() != 1) {
                    colorSpace = Colors.getLabColorSpace();
                }
                colorModel = new ComponentColorModel(colorSpace, new int[]{8, 8, 8}, false, false, 1, 0);
                raster = Raster.createInterleavedRaster(0, width, height, width * 3, 3, new int[]{0, 1, 2}, null);
                break;
            }
            case 7: {
                if (colorSpace == null || colorSpace.getType() != 1) {
                    colorSpace = Colors.getLabColorSpace();
                }
                colorModel = new ComponentColorModel(colorSpace, new int[]{8, 8, 8, 8}, true, false, 3, 0);
                raster = Raster.createInterleavedRaster(0, width, height, width * 4, 4, new int[]{0, 1, 2, 3}, null);
                break;
            }
            case 8: {
                if (colorSpace == null || colorSpace.getType() != 5) {
                    colorSpace = ColorSpace.getInstance(1000);
                }
                colorModel = new ComponentColorModel(colorSpace, new int[]{32, 32, 32}, false, false, 1, 4);
                raster = colorModel.createCompatibleWritableRaster(width, height);
                break;
            }
            case 9: {
                if (colorSpace == null || colorSpace.getType() != 5) {
                    colorSpace = ColorSpace.getInstance(1000);
                }
                colorModel = new ComponentColorModel(colorSpace, new int[]{32, 32, 32, 32}, true, false, 3, 4);
                raster = colorModel.createCompatibleWritableRaster(width, height);
                break;
            }
            case 10: {
                if (colorSpace == null || colorSpace.getType() != 6) {
                    colorSpace = ColorSpace.getInstance(1003);
                }
                colorModel = new ComponentColorModel(colorSpace, new int[]{32}, false, false, 1, 4);
                raster = colorModel.createCompatibleWritableRaster(width, height);
                break;
            }
            case 11: {
                if (colorSpace == null || colorSpace.getType() != 6) {
                    colorSpace = ColorSpace.getInstance(1003);
                }
                colorModel = new ComponentColorModel(colorSpace, new int[]{32, 32}, true, false, 3, 4);
                raster = colorModel.createCompatibleWritableRaster(width, height);
                break;
            }
            default: {
                throw new RuntimeException("Unknown image type, color mode = " + (Object)((Object)colorMode) + ", channels = " + channels);
            }
        }
        return new BufferedImage(colorModel, raster, colorModel.isAlphaPremultiplied(), null);
    }

    private static int getTransferType(int bits) {
        if (bits <= 8) {
            return 0;
        }
        if (bits <= 16) {
            return 1;
        }
        if (bits <= 32) {
            return 3;
        }
        return 32;
    }

    public static void decodeChannelRLE(byte[] data, int offset, int channel, BufferedImage image) {
        WritableRaster raster = image.getRaster();
        int width = image.getWidth();
        int height = image.getHeight();
        int band = Images.getBand(channel, image.getColorModel());
        Images.decodeRLEChannel(data, offset, width, height, raster, band);
    }

    public static BufferedImage decodeRLE(byte[] data, int offset, int width, int height, ColorMode colorMode, int channels, ColorSpace colorSpace, int depth) {
        BufferedImage image = Images.create(width, height, colorMode, channels, colorSpace, depth);
        WritableRaster raster = image.getRaster();
        for (int c = 0; c < channels; ++c) {
            offset += Images.decodeRLEChannel(data, offset, width, height, raster, c);
        }
        return image;
    }

    public static void decodeChannelRaw(byte[] data, int offset, int channel, BufferedImage image, int depth) {
        int width = image.getWidth();
        int height = image.getHeight();
        int band = Images.getBand(channel, image.getColorModel());
        Images.decodeRawChannel(data, offset, width, height, depth, image, band);
    }

    public static BufferedImage decodeRaw(byte[] data, int offset, int width, int height, ColorMode colorMode, int channels, ColorSpace colorSpace, int depth) {
        BufferedImage image = Images.create(width, height, colorMode, channels, colorSpace, depth);
        for (int c = 0; c < channels; ++c) {
            offset += Images.decodeRawChannel(data, offset, width, height, depth, image, c);
        }
        return image;
    }

    private static boolean shouldCompress(ColorSpace colorSpace) {
        int type = colorSpace.getType();
        return type == 9 || type == 1;
    }

    public static BufferedImage decodeIndexedRaw(byte[] data, int offset, int width, int height, ColorMode colorMode, ColorSpace colorSpace, int size, byte[] map, int transparency) {
        CsIndexColorModel colorModel = null;
        switch (colorMode) {
            case BITMAP: {
                colorModel = CsIndexColorModel.createInvertedBitmap();
                break;
            }
            case INDEXED: {
                if (colorSpace == null) {
                    colorSpace = ColorSpace.getInstance(1000);
                }
                colorModel = CsIndexColorModel.createIndexed(size, map, transparency, colorSpace);
                break;
            }
        }
        WritableRaster raster = ((ColorModel)colorModel).createCompatibleWritableRaster(width, height);
        BufferedImage image = new BufferedImage(colorModel, raster, colorModel.isAlphaPremultiplied(), null);
        if (colorMode == ColorMode.INDEXED) {
            raster.setDataElements(0, 0, width, height, data);
        } else if (colorMode == ColorMode.BITMAP) {
            DataBuffer buffer = raster.getDataBuffer();
            int pos = offset;
            int dst = 0;
            while (pos < data.length) {
                buffer.setElem(dst, data[pos]);
                ++pos;
                ++dst;
            }
        }
        return image;
    }

    public static BufferedImage decodeIndexedRLE(byte[] data, int offset, int width, int height, ColorMode colorMode, ColorSpace colorSpace, int size, byte[] map, int transparency) {
        CsIndexColorModel colorModel = null;
        switch (colorMode) {
            case BITMAP: {
                colorModel = CsIndexColorModel.createInvertedBitmap();
                break;
            }
            case INDEXED: {
                if (colorSpace == null) {
                    colorSpace = ColorSpace.getInstance(1000);
                }
                colorModel = CsIndexColorModel.createIndexed(size, map, transparency, colorSpace);
                break;
            }
        }
        WritableRaster raster = ((ColorModel)colorModel).createCompatibleWritableRaster(width, height);
        BufferedImage image = new BufferedImage(colorModel, raster, colorModel.isAlphaPremultiplied(), null);
        Images.decodeRLEChannel(data, offset, width, height, raster, 0);
        return image;
    }

    private static int decodeRawChannel(byte[] data, int offset, int width, int height, int depth, BufferedImage image, int band) {
        WritableRaster raster = image.getRaster();
        int pos = offset;
        switch (depth) {
            case 8: {
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        raster.setSample(x, y, band, data[pos++] & 0xFF);
                    }
                }
                break;
            }
            case 16: {
                if (Images.shouldCompress(image.getColorModel().getColorSpace())) {
                    for (int y = 0; y < height; ++y) {
                        for (int x = 0; x < width; ++x) {
                            int d = (data[pos++] & 0xFF) << 8 | data[pos++] & 0xFF;
                            raster.setSample(x, y, band, (int)((float)d / 65535.0f * 255.0f) & 0xFF);
                        }
                    }
                } else {
                    for (int y = 0; y < height; ++y) {
                        for (int x = 0; x < width; ++x) {
                            int d = (data[pos++] & 0xFF) << 8 | data[pos++] & 0xFF;
                            raster.setSample(x, y, band, (float)d / 65535.0f);
                        }
                    }
                }
                break;
            }
            case 32: {
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        int d = (data[pos++] & 0xFF) << 24 | (data[pos++] & 0xFF) << 16 | (data[pos++] & 0xFF) << 8 | data[pos++] & 0xFF;
                        raster.setSample(x, y, band, Colors.toneMappingACES(Float.intBitsToFloat(d)));
                    }
                }
                break;
            }
        }
        return pos - offset;
    }

    private static int decodeRLEChannel(byte[] data, int offset, int width, int height, WritableRaster raster, int band) {
        int pos = offset;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                int runCount;
                byte packetInfo;
                if ((packetInfo = data[pos++]) < 0) {
                    runCount = -packetInfo + 1;
                    int value = data[pos++] & 0xFF;
                    int i = 0;
                    while (i < runCount) {
                        raster.setSample(x, y, band, value);
                        ++i;
                        ++x;
                    }
                    continue;
                }
                runCount = packetInfo + 1;
                int i = 0;
                while (i < runCount) {
                    raster.setSample(x, y, band, data[pos++] & 0xFF);
                    ++i;
                    ++x;
                }
            }
        }
        return pos - offset;
    }

    private static int getBand(int channel, ColorModel colorModel) {
        switch (channel) {
            case -1: {
                return colorModel.getNumComponents() - 1;
            }
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
        }
        throw new IllegalArgumentException("The channel index must be <= 3, not " + channel);
    }

    private static Type getImageType(int channels, ColorMode colorMode, int depth) {
        switch (colorMode) {
            case BITMAP: {
                break;
            }
            case GRAYSCALE: {
                switch (channels) {
                    case 1: {
                        return depth > 8 ? Type.FLOAT_GRAY : Type.BYTE_GRAY;
                    }
                    case 2: {
                        return depth > 8 ? Type.FLOAT_ALPHA_GRAY : Type.BYTE_ALPHA_GRAY;
                    }
                }
                throw new IllegalArgumentException("The Grayscale channels count must be 1 or 2");
            }
            case INDEXED: {
                break;
            }
            case RGB: {
                switch (channels) {
                    case 3: {
                        return depth > 8 ? Type.FLOAT_RGB : Type.INT_RGB;
                    }
                    case 4: {
                        return depth > 8 ? Type.FLOAT_ALPHA_RGB : Type.INT_ALPHA_RGB;
                    }
                }
                throw new IllegalArgumentException("The RGB channels count must be 3 or 4");
            }
            case CMYK: {
                switch (channels) {
                    case 4: {
                        return Type.BYTE_CMYK;
                    }
                    case 5: {
                        return Type.BYTE_ALPHA_CMYK;
                    }
                }
                throw new IllegalArgumentException("The CMYK channels count must be 4 or 5");
            }
            case UNKNOWN: 
            case NONE: 
            case MULTI_CHANNEL: {
                break;
            }
            case DUOTONE: {
                switch (channels) {
                    case 1: {
                        return Type.BYTE_GRAY;
                    }
                    case 2: {
                        return Type.BYTE_ALPHA_GRAY;
                    }
                }
                throw new IllegalArgumentException("The Duotone channels count must be 1 or 2");
            }
            case LAB: {
                switch (channels) {
                    case 3: {
                        return Type.BYTE_LAB;
                    }
                    case 4: {
                        return Type.BYTE_ALPHA_LAB;
                    }
                }
                throw new IllegalArgumentException("The LAB channels count must be 3 or 4");
            }
        }
        throw new IllegalArgumentException("Unsupported color mode/channels count: " + (Object)((Object)colorMode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage invert(BufferedImage image) {
        BufferedImageOp imageOp;
        ColorModel colorModel = image.getColorModel();
        LutKey key = new LutKey(colorModel.getNumComponents(), colorModel.hasAlpha());
        lookupTablesLock.lock();
        try {
            imageOp = lookupTables.get(key);
            if (imageOp == null) {
                int i;
                int numColorComponents = colorModel.getNumColorComponents();
                byte[][] lut = new byte[key.componentCount][256];
                for (int j = 0; j < numColorComponents; ++j) {
                    for (i = 0; i < 256; ++i) {
                        lut[j][i] = (byte)(255 - i);
                    }
                }
                if (key.hasAlpha) {
                    int a = key.componentCount - 1;
                    for (i = 0; i < 256; ++i) {
                        lut[a][i] = (byte)i;
                    }
                }
                imageOp = new LookupOp(new ByteLookupTable(0, lut), null);
                lookupTables.put(key, imageOp);
            }
        }
        finally {
            lookupTablesLock.unlock();
        }
        return imageOp.filter(image, null);
    }

    public static boolean isColorSpace_sRGB(BufferedImage image) {
        ColorModel colorModel = image.getColorModel();
        ColorSpace colorSpace = colorModel.getColorSpace();
        if (colorSpace == null) {
            return true;
        }
        if (colorSpace.getType() == 5) {
            if (colorSpace.isCS_sRGB()) {
                return true;
            }
            ColorSpace sRGB = ColorSpace.getInstance(1000);
            return Colors.getIccProfileDescription(sRGB).equals(Colors.getIccProfileDescription(colorSpace));
        }
        return false;
    }

    public static BufferedImage copyTo_sRGB(BufferedImage image) {
        ColorConvertOp op = new ColorConvertOp(ColorSpace.getInstance(1000), new RenderingHints(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY));
        return op.filter(image, null);
    }

    static enum Type {
        INT_RGB,
        INT_ALPHA_RGB,
        BYTE_GRAY,
        BYTE_ALPHA_GRAY,
        BYTE_CMYK,
        BYTE_ALPHA_CMYK,
        BYTE_LAB,
        BYTE_ALPHA_LAB,
        FLOAT_RGB,
        FLOAT_ALPHA_RGB,
        FLOAT_GRAY,
        FLOAT_ALPHA_GRAY;

    }

    private static final class LutKey {
        int componentCount;
        boolean hasAlpha;

        LutKey(int componentCount, boolean hasAlpha) {
            this.componentCount = componentCount;
            this.hasAlpha = hasAlpha;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LutKey lutKey = (LutKey)o;
            if (this.componentCount != lutKey.componentCount) {
                return false;
            }
            return this.hasAlpha == lutKey.hasAlpha;
        }

        public int hashCode() {
            int result = this.componentCount;
            result = 31 * result + (this.hasAlpha ? 1 : 0);
            return result;
        }
    }
}

