/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.pixelprobe.color;

import java.awt.color.ColorSpace;

public class CieLabColorSpace
extends ColorSpace {
    private static final double[] WHITE_POINT_D50 = new double[]{0.964212, 1.0, 0.825188};
    private static final ColorSpace sRGB = ColorSpace.getInstance(1000);

    private CieLabColorSpace() {
        super(1, 3);
    }

    public static CieLabColorSpace getInstance() {
        return InstanceHolder.CIELab;
    }

    @Override
    public float getMinValue(int component) {
        return component == 0 ? 0.0f : -128.0f;
    }

    @Override
    public float getMaxValue(int component) {
        return component == 0 ? 100.0f : 127.0f;
    }

    @Override
    public float[] toRGB(float[] lab) {
        return sRGB.fromCIEXYZ(this.toCIEXYZ(lab));
    }

    @Override
    public float[] fromRGB(float[] rgb) {
        return this.fromCIEXYZ(sRGB.toCIEXYZ(rgb));
    }

    @Override
    public float[] toCIEXYZ(float[] lab) {
        double fy = ((double)lab[0] + 16.0) / 116.0;
        double fx = fy + (double)lab[1] / 500.0;
        double fz = fy - (double)lab[2] / 200.0;
        double X = fx > 0.20689655172413793 ? fx * fx * fx : 0.12841854934601665 * (fx - 0.13793103448275862);
        double Y = fy > 0.20689655172413793 ? fy * fy * fy : 0.12841854934601665 * (fy - 0.13793103448275862);
        double Z = fz > 0.20689655172413793 ? fz * fz * fz : 0.12841854934601665 * (fz - 0.13793103448275862);
        float[] xyz = new float[lab.length];
        xyz[0] = CieLabColorSpace.clamp((float)(X * WHITE_POINT_D50[0]), 0.0f, 2.0f);
        xyz[1] = CieLabColorSpace.clamp((float)(Y * WHITE_POINT_D50[1]));
        xyz[2] = CieLabColorSpace.clamp((float)(Z * WHITE_POINT_D50[2]));
        return xyz;
    }

    @Override
    public float[] fromCIEXYZ(float[] xyz) {
        double X = (double)xyz[0] / WHITE_POINT_D50[0];
        double Y = (double)xyz[1] / WHITE_POINT_D50[1];
        double Z = (double)xyz[2] / WHITE_POINT_D50[2];
        double fx = X > 0.008856451679035631 ? Math.cbrt(X) : 7.787037037037037 * X + 0.13793103448275862;
        double fy = Y > 0.008856451679035631 ? Math.cbrt(Y) : 7.787037037037037 * Y + 0.13793103448275862;
        double fz = Z > 0.008856451679035631 ? Math.cbrt(Z) : 7.787037037037037 * Z + 0.13793103448275862;
        double L = 116.0 * fy - 16.0;
        double a = 500.0 * (fx - fy);
        double b = 200.0 * (fy - fz);
        float[] lab = new float[xyz.length];
        lab[0] = (float)L;
        lab[1] = (float)a;
        lab[2] = (float)b;
        return lab;
    }

    private static float clamp(float v) {
        return Math.max(0.0f, Math.min(v, 1.0f));
    }

    private static float clamp(float v, float min, float max) {
        return Math.max(min, Math.min(v, max));
    }

    private static final class InstanceHolder {
        static final CieLabColorSpace CIELab = new CieLabColorSpace();

        private InstanceHolder() {
        }
    }
}

