/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.avd;

import com.android.repository.Revision;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.targets.SystemImage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ&\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/sdklib/internal/avd/SystemImageUpdateDependency;", "", "featureLevel", "", "tag", "Lcom/android/sdklib/repository/IdDisplay;", "requiredMajorRevision", "<init>", "(ILcom/android/sdklib/repository/IdDisplay;I)V", "updateRequired", "", "image", "Lcom/android/sdklib/repository/targets/SystemImage;", "abiType", "", "revision", "Lcom/android/repository/Revision;", "android.sdktools.sdklib"})
final class SystemImageUpdateDependency {
    private final int featureLevel;
    @NotNull
    private final IdDisplay tag;
    private final int requiredMajorRevision;

    public SystemImageUpdateDependency(int featureLevel, @NotNull IdDisplay tag, int requiredMajorRevision) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.featureLevel = featureLevel;
        this.tag = tag;
        this.requiredMajorRevision = requiredMajorRevision;
    }

    public final boolean updateRequired(@NotNull SystemImage image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        String string = image.getPrimaryAbiType();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPrimaryAbiType(...)");
        int n = image.getAndroidVersion().getFeatureLevel();
        IdDisplay idDisplay = image.getTag();
        Intrinsics.checkNotNullExpressionValue((Object)idDisplay, (String)"getTag(...)");
        Revision revision = image.getRevision();
        Intrinsics.checkNotNullExpressionValue((Object)revision, (String)"getRevision(...)");
        return this.updateRequired(string, n, idDisplay, revision);
    }

    public final boolean updateRequired(@NotNull String abiType, int featureLevel, @NotNull IdDisplay tag, @NotNull Revision revision) {
        Intrinsics.checkNotNullParameter((Object)abiType, (String)"abiType");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)revision, (String)"revision");
        Abi abi = Abi.getEnum(abiType);
        boolean isAvdIntel = abi == Abi.X86 || abi == Abi.X86_64;
        return isAvdIntel && featureLevel == this.featureLevel && Intrinsics.areEqual((Object)this.tag, (Object)tag) && revision.getMajor() < this.requiredMajorRevision;
    }
}

