/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib;

import com.android.repository.Revision;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoPackage;
import com.android.repository.impl.meta.Archive;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.SystemImageTags;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

public final class RemoteSystemImage
implements ISystemImage {
    private final RemotePackage remotePackage;
    private final ImmutableList<IdDisplay> tags;
    private final IdDisplay vendor;
    private final List<String> abis;
    private final List<String> translatedAbis;
    private final AndroidVersion androidVersion;

    public RemoteSystemImage(RemotePackage p) {
        IdDisplay vendor = null;
        DetailsTypes.ApiDetailsType details = (DetailsTypes.ApiDetailsType)p.getTypeDetails();
        if (details instanceof DetailsTypes.AddonDetailsType) {
            vendor = ((DetailsTypes.AddonDetailsType)details).getVendor();
        }
        if (details instanceof DetailsTypes.SysImgDetailsType) {
            vendor = ((DetailsTypes.SysImgDetailsType)details).getVendor();
        }
        this.remotePackage = p;
        this.tags = SystemImageTags.getTags((RepoPackage)p);
        this.vendor = vendor;
        this.abis = details.getAbis();
        this.translatedAbis = details.getTranslatedAbis();
        this.androidVersion = details.getAndroidVersion();
    }

    @Override
    public Path getLocation() {
        assert (false) : "Can't get location for remote image";
        return Paths.get("", new String[0]);
    }

    @Override
    public List<IdDisplay> getTags() {
        return this.tags;
    }

    @Override
    public IdDisplay getAddonVendor() {
        return this.vendor;
    }

    @Override
    public String getPrimaryAbiType() {
        return this.abis.get(0);
    }

    @Override
    public List<String> getAbiTypes() {
        return this.abis;
    }

    @Override
    public List<String> getTranslatedAbiTypes() {
        return this.translatedAbis;
    }

    @Override
    public List<Path> getSkins() {
        return ImmutableList.of();
    }

    @Override
    public Revision getRevision() {
        return this.remotePackage.getVersion();
    }

    @Override
    public AndroidVersion getAndroidVersion() {
        return this.androidVersion;
    }

    @Override
    public RepoPackage getPackage() {
        return this.remotePackage;
    }

    @Override
    public boolean obsolete() {
        return this.remotePackage.obsolete();
    }

    public int hashCode() {
        return this.remotePackage.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof RemoteSystemImage)) {
            return false;
        }
        RemoteSystemImage other = (RemoteSystemImage)o;
        return this.remotePackage.equals((Object)other.remotePackage);
    }

    public String toString() {
        Archive archive = this.remotePackage.getArchive();
        if (archive == null) {
            return this.remotePackage.getDisplayName();
        }
        return this.remotePackage.getDisplayName() + " (" + new Storage(archive.getComplete().getSize()).toUiString() + ')';
    }
}

