/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils.concurrency;

import com.google.common.collect.EvictingQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\fH\u0016J\b\u0010\u0013\u001a\u00020\u000eH\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0010H\u0016J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/utils/concurrency/EvictingExecutor;", "Ljava/util/concurrent/AbstractExecutorService;", "delegateExecutor", "Ljava/util/concurrent/ExecutorService;", "maxQueueingTasks", "", "<init>", "(Ljava/util/concurrent/ExecutorService;I)V", "evictingQueueLock", "Ljava/util/concurrent/locks/ReentrantLock;", "evictingQueue", "Ljava/util/Queue;", "Ljava/lang/Runnable;", "queueProcessor", "", "isTerminated", "", "execute", "command", "shutdown", "shutdownNow", "", "isShutdown", "awaitTermination", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "android.sdktools.common"})
public final class EvictingExecutor
extends AbstractExecutorService {
    @NotNull
    private final ExecutorService delegateExecutor;
    @NotNull
    private final ReentrantLock evictingQueueLock;
    @NotNull
    private final Queue<Runnable> evictingQueue;

    public EvictingExecutor(@NotNull ExecutorService delegateExecutor, int maxQueueingTasks) {
        Intrinsics.checkNotNullParameter((Object)delegateExecutor, (String)"delegateExecutor");
        this.delegateExecutor = delegateExecutor;
        this.evictingQueueLock = new ReentrantLock();
        EvictingQueue evictingQueue = EvictingQueue.create((int)maxQueueingTasks);
        Intrinsics.checkNotNullExpressionValue((Object)evictingQueue, (String)"create(...)");
        this.evictingQueue = (Queue)evictingQueue;
    }

    public /* synthetic */ EvictingExecutor(ExecutorService executorService, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        this(executorService, n);
    }

    private final void queueProcessor() {
        this.delegateExecutor.execute(() -> EvictingExecutor.queueProcessor$lambda$0(this));
    }

    @Override
    public boolean isTerminated() {
        return this.delegateExecutor.isTerminated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(@NotNull Runnable command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        if (this.delegateExecutor.isTerminated()) {
            return;
        }
        Lock lock = this.evictingQueueLock;
        lock.lock();
        try {
            boolean bl = false;
            int before = this.evictingQueue.size();
            this.evictingQueue.offer(command);
            if (before != this.evictingQueue.size()) {
                this.queueProcessor();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void shutdown() {
        this.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        List pendingRunnables = new ArrayList();
        Object object = this.evictingQueueLock;
        object.lock();
        try {
            boolean bl = false;
            bl = CollectionsKt.removeAll((Iterable)this.evictingQueue, arg_0 -> EvictingExecutor.shutdownNow$lambda$0$0(pendingRunnables, arg_0));
        }
        finally {
            object.unlock();
        }
        Object $this$shutdownNow_u24lambda_u241 = object = pendingRunnables;
        boolean bl = false;
        List<Runnable> list = this.delegateExecutor.shutdownNow();
        Intrinsics.checkNotNullExpressionValue(list, (String)"shutdownNow(...)");
        $this$shutdownNow_u24lambda_u241.addAll((Collection)list);
        return object;
    }

    @Override
    public boolean isShutdown() {
        return this.delegateExecutor.isShutdown();
    }

    @Override
    public boolean awaitTermination(long timeout, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        return this.delegateExecutor.awaitTermination(timeout, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void queueProcessor$lambda$0(EvictingExecutor this$0) {
        Object object;
        try {
            Runnable $i$a$-withLock-EvictingExecutor$queueProcessor$1$runnable$22;
            object = this$0.evictingQueueLock;
            object.lock();
            try {
                boolean $i$a$-withLock-EvictingExecutor$queueProcessor$1$runnable$22 = false;
                $i$a$-withLock-EvictingExecutor$queueProcessor$1$runnable$22 = this$0.evictingQueue.remove();
            }
            finally {
                object.unlock();
            }
            object = $i$a$-withLock-EvictingExecutor$queueProcessor$1$runnable$22;
        }
        catch (NoSuchElementException e) {
            return;
        }
        Object runnable = object;
        runnable.run();
    }

    private static final boolean shutdownNow$lambda$0$0(List $pendingRunnables, Runnable it) {
        Intrinsics.checkNotNull((Object)it);
        return $pendingRunnables.add(it);
    }
}

