/*
 * Decompiled with CFR 0.152.
 */
package com.android.support;

import com.android.support.InvalidDataException;
import com.android.support.MigrationParserVisitor;
import com.android.utils.XmlUtils;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"ROOT_ELEMENT", "", "MIGRATE_ENTRY_NAME", "ATTR_OLD_NAME", "ATTR_NEW_NAME", "ATTR_TYPE", "TYPE_CLASS", "TYPE_PACKAGE", "MIGRATE_DEPENDENCY_NAME", "ATTR_OLD_GROUP_NAME", "ATTR_OLD_ARTIFACT_NAME", "ATTR_NEW_GROUP_NAME", "ATTR_NEW_ARTIFACT_NAME", "ATTR_NEW_BASE_VERSION_NAME", "UPGRADE_DEPENDENCY_NAME", "ATTR_GROUP_NAME", "ATTR_ARTIFACT_NAME", "parseMigrationFile", "", "visitor", "Lcom/android/support/MigrationParserVisitor;", "android.sdktools.common"})
@SourceDebugExtension(value={"SMAP\nAndroidxMigrationParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidxMigrationParser.kt\ncom/android/support/AndroidxMigrationParserKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n1869#2,2:100\n*S KotlinDebug\n*F\n+ 1 AndroidxMigrationParser.kt\ncom/android/support/AndroidxMigrationParserKt\n*L\n67#1:100,2\n*E\n"})
public final class AndroidxMigrationParserKt {
    @NotNull
    private static final String ROOT_ELEMENT = "migration-map";
    @NotNull
    private static final String MIGRATE_ENTRY_NAME = "migrate";
    @NotNull
    private static final String ATTR_OLD_NAME = "old-name";
    @NotNull
    private static final String ATTR_NEW_NAME = "new-name";
    @NotNull
    private static final String ATTR_TYPE = "type";
    @NotNull
    private static final String TYPE_CLASS = "CLASS";
    @NotNull
    private static final String TYPE_PACKAGE = "PACKAGE";
    @NotNull
    private static final String MIGRATE_DEPENDENCY_NAME = "migrate-dependency";
    @NotNull
    private static final String ATTR_OLD_GROUP_NAME = "old-group-name";
    @NotNull
    private static final String ATTR_OLD_ARTIFACT_NAME = "old-artifact-name";
    @NotNull
    private static final String ATTR_NEW_GROUP_NAME = "new-group-name";
    @NotNull
    private static final String ATTR_NEW_ARTIFACT_NAME = "new-artifact-name";
    @NotNull
    private static final String ATTR_NEW_BASE_VERSION_NAME = "base-version";
    @NotNull
    private static final String UPGRADE_DEPENDENCY_NAME = "upgrade-dependency";
    @NotNull
    private static final String ATTR_GROUP_NAME = "group-name";
    @NotNull
    private static final String ATTR_ARTIFACT_NAME = "artifact-name";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void parseMigrationFile(@NotNull MigrationParserVisitor visitor) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        InputStream inputStream = MigrationParserVisitor.class.getResourceAsStream("migrateToAndroidx/migration.xml");
        Intrinsics.checkNotNull((Object)inputStream);
        InputStream stream = inputStream;
        Closeable closeable = stream;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            Document document = XmlUtils.parseDocument(new InputStreamReader(stream), false);
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parseDocument(...)");
            Document document2 = document;
            Element root = document2.getDocumentElement();
            if (!Intrinsics.areEqual((Object)ROOT_ELEMENT, (Object)root.getNodeName())) {
                throw new InvalidDataException("Migration file does not start with <migration-map>");
            }
            Iterable<Element> iterable = XmlUtils.getSubTags(root);
            Intrinsics.checkNotNullExpressionValue(iterable, (String)"getSubTags(...)");
            Iterable<Element> $this$forEach$iv = iterable;
            boolean $i$f$forEach = false;
            Iterator<Element> iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Element element$iv;
                Element node = element$iv = iterator2.next();
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)node.getNodeName(), (Object)MIGRATE_ENTRY_NAME)) {
                    String oldName = node.getAttribute(ATTR_OLD_NAME);
                    String newName = node.getAttribute(ATTR_NEW_NAME);
                    String type = node.getAttribute(ATTR_TYPE);
                    String string = type;
                    if (Intrinsics.areEqual((Object)string, (Object)TYPE_PACKAGE)) {
                        Intrinsics.checkNotNull((Object)oldName);
                        Intrinsics.checkNotNull((Object)newName);
                        visitor.visitPackage(oldName, newName);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)string, (Object)TYPE_CLASS)) {
                        Intrinsics.checkNotNull((Object)oldName);
                        Intrinsics.checkNotNull((Object)newName);
                        visitor.visitClass(oldName, newName);
                        continue;
                    }
                    throw new InvalidDataException("Invalid type " + type);
                }
                if (Intrinsics.areEqual((Object)node.getNodeName(), (Object)MIGRATE_DEPENDENCY_NAME)) {
                    String oldGroupName = node.getAttribute(ATTR_OLD_GROUP_NAME);
                    String oldArtifactName = node.getAttribute(ATTR_OLD_ARTIFACT_NAME);
                    String newGroupName = node.getAttribute(ATTR_NEW_GROUP_NAME);
                    String newArtifactName = node.getAttribute(ATTR_NEW_ARTIFACT_NAME);
                    String newBaseVersion = node.getAttribute(ATTR_NEW_BASE_VERSION_NAME);
                    Intrinsics.checkNotNull((Object)oldGroupName);
                    Intrinsics.checkNotNull((Object)oldArtifactName);
                    Intrinsics.checkNotNull((Object)newGroupName);
                    Intrinsics.checkNotNull((Object)newArtifactName);
                    Intrinsics.checkNotNull((Object)newBaseVersion);
                    visitor.visitGradleCoordinate(oldGroupName, oldArtifactName, newGroupName, newArtifactName, newBaseVersion);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)node.getNodeName(), (Object)UPGRADE_DEPENDENCY_NAME)) continue;
                String groupName = node.getAttribute(ATTR_GROUP_NAME);
                String artifactName = node.getAttribute(ATTR_ARTIFACT_NAME);
                String baseVersion = node.getAttribute(ATTR_NEW_BASE_VERSION_NAME);
                Intrinsics.checkNotNull((Object)groupName);
                Intrinsics.checkNotNull((Object)artifactName);
                Intrinsics.checkNotNull((Object)baseVersion);
                visitor.visitGradleCoordinateUpgrade(groupName, artifactName, baseVersion);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

