/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model.trackgroup;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.DragAndDropModelListElement;
import com.android.tools.adtui.model.TooltipModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrackModel<M, R extends Enum>
implements DragAndDropModelListElement {
    private final M myDataModel;
    private final R myRendererType;
    @NotNull
    private final String myTitle;
    @Nullable
    private final String myTitleTooltip;
    private final boolean myHideHeader;
    private final int myId;
    private final boolean myIsCollapsible;
    private boolean myIsCollapsed;
    private final boolean myIsDragEnabled;
    @NotNull
    private final AspectModel<Aspect> myAspectModel = new AspectModel();
    @Nullable
    private TooltipModel myActiveTooltipModel;

    private TrackModel(@NotNull Builder<M, R> builder) {
        this.myDataModel = builder.myDataModel;
        this.myRendererType = builder.myRendererType;
        this.myTitle = builder.myTitle;
        this.myTitleTooltip = builder.myTitleTooltip;
        this.myHideHeader = builder.myHideHeader;
        this.myIsCollapsible = builder.myIsCollapsible;
        this.myIsCollapsed = builder.myIsCollapsed;
        this.myIsDragEnabled = builder.myIsDragEnabled;
        this.myId = builder.myId;
        this.myActiveTooltipModel = builder.myDefaultTooltipModel;
    }

    @NotNull
    public M getDataModel() {
        return this.myDataModel;
    }

    @NotNull
    public R getRendererType() {
        return this.myRendererType;
    }

    @NotNull
    public String getTitle() {
        return this.myTitle;
    }

    @Nullable
    public String getTitleTooltip() {
        return this.myTitleTooltip;
    }

    public boolean getHideHeader() {
        return this.myHideHeader;
    }

    @Override
    public int getId() {
        return this.myId;
    }

    @Nullable
    public TooltipModel getActiveTooltipModel() {
        return this.myActiveTooltipModel;
    }

    public void setActiveTooltipModel(@Nullable TooltipModel tooltipModel) {
        this.myActiveTooltipModel = tooltipModel;
    }

    public void setCollapsed(boolean collapsed) {
        if (this.myIsCollapsible && this.myIsCollapsed != collapsed) {
            this.myIsCollapsed = collapsed;
            this.myAspectModel.changed(Aspect.COLLAPSE_CHANGE);
        }
    }

    public boolean isCollapsed() {
        return this.myIsCollapsed;
    }

    public boolean isCollapsible() {
        return this.myIsCollapsible;
    }

    public boolean isDragEnabled() {
        return this.myIsDragEnabled;
    }

    @NotNull
    public AspectModel<Aspect> getAspectModel() {
        return this.myAspectModel;
    }

    public static <M, R extends Enum> Builder<M, R> newBuilder(@NotNull M dataModel, @NotNull R rendererType, @NotNull String title) {
        return new Builder<M, R>(dataModel, rendererType, title);
    }

    public static class Builder<M, R extends Enum> {
        private final M myDataModel;
        private final R myRendererType;
        private final String myTitle;
        private boolean myHideHeader;
        private boolean myIsCollapsed;
        private boolean myIsCollapsible;
        private boolean myIsDragEnabled = true;
        private int myId;
        private TooltipModel myDefaultTooltipModel;
        private String myTitleTooltip;

        private Builder(@NotNull M dataModel, @NotNull R rendererType, @NotNull String title) {
            this.myDataModel = dataModel;
            this.myRendererType = rendererType;
            this.myTitle = title;
            this.myHideHeader = false;
            this.myIsCollapsed = false;
            this.myIsCollapsible = false;
            this.myId = -1;
            this.myDefaultTooltipModel = null;
            this.myTitleTooltip = null;
        }

        @NotNull
        public Builder<M, R> setTitleTooltip(@Nullable String titleTooltip) {
            this.myTitleTooltip = titleTooltip;
            return this;
        }

        @NotNull
        public Builder<M, R> setHideHeader(boolean hideHeader) {
            this.myHideHeader = hideHeader;
            return this;
        }

        @NotNull
        public Builder<M, R> setCollapsed(boolean collapsed) {
            this.myIsCollapsed = collapsed;
            return this;
        }

        @NotNull
        public Builder<M, R> setCollapsible(boolean collapsible) {
            this.myIsCollapsible = collapsible;
            return this;
        }

        @NotNull
        public Builder<M, R> setDragEnabled(boolean enabled) {
            this.myIsDragEnabled = enabled;
            return this;
        }

        @NotNull
        protected Builder<M, R> setId(int id) {
            this.myId = id;
            return this;
        }

        @NotNull
        public Builder<M, R> setDefaultTooltipModel(TooltipModel defaultTooltipModel) {
            this.myDefaultTooltipModel = defaultTooltipModel;
            return this;
        }

        @NotNull
        public TrackModel<M, R> build() {
            return new TrackModel(this);
        }
    }

    public static enum Aspect {
        COLLAPSE_CHANGE;

    }
}

