/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model.formatter;

import com.intellij.util.text.DateFormatUtil;
import java.text.DecimalFormat;
import java.util.concurrent.TimeUnit;

public class TimeFormatter {
    public static String getFullClockString(long micro) {
        micro = Math.max(0L, micro);
        long milli = TimeUnit.MICROSECONDS.toMillis(micro) % TimeUnit.SECONDS.toMillis(1L);
        long sec = TimeUnit.MICROSECONDS.toSeconds(micro) % TimeUnit.MINUTES.toSeconds(1L);
        long min = TimeUnit.MICROSECONDS.toMinutes(micro) % TimeUnit.HOURS.toMinutes(1L);
        long hour = TimeUnit.MICROSECONDS.toHours(micro);
        return String.format("%02d:%02d:%02d.%03d", hour, min, sec, milli);
    }

    public static String getSemiSimplifiedClockString(long micro) {
        String result = TimeFormatter.getFullClockString(micro = Math.max(0L, micro));
        return result.startsWith("00:00:") ? result.substring(3) : result;
    }

    public static String getSimplifiedClockString(long micro) {
        String result = TimeFormatter.getFullClockString(micro);
        int index = result.startsWith("00:") ? (result.substring(3, 6).equals("00:") ? 6 : 3) : 0;
        return result.substring(index);
    }

    public static String getSingleUnitDurationString(long micro) {
        micro = Math.max(0L, micro);
        String[] units = new String[]{"\u03bcs", "ms", "s", "m", "h"};
        float[] multipliers = new float[]{1.0f, TimeUnit.MILLISECONDS.toMicros(1L), TimeUnit.SECONDS.toMicros(1L), TimeUnit.MINUTES.toMicros(1L), TimeUnit.HOURS.toMicros(1L)};
        double value = micro;
        String unit = units[0];
        for (int i = units.length - 1; i >= 0; --i) {
            if (!((float)micro / multipliers[i] >= 1.0f)) continue;
            value = (float)micro / multipliers[i];
            unit = units[i];
            break;
        }
        return new DecimalFormat("###.##").format(value) + " " + unit;
    }

    public static String getMultiUnitDurationString(long micro) {
        micro = Math.max(0L, micro);
        long sec = TimeUnit.MICROSECONDS.toSeconds(micro) % TimeUnit.MINUTES.toSeconds(1L);
        long min = TimeUnit.MICROSECONDS.toMinutes(micro) % TimeUnit.HOURS.toMinutes(1L);
        long hour = TimeUnit.MICROSECONDS.toHours(micro);
        StringBuilder builder = new StringBuilder();
        if (hour > 0L) {
            builder.append(hour);
            builder.append(" ");
            builder.append(hour == 1L ? "hr " : "hrs ");
        }
        if (min > 0L) {
            builder.append(min);
            builder.append(" min ");
        }
        if (sec > 0L || hour == 0L && min == 0L) {
            builder.append(sec);
            builder.append(" sec");
        }
        return builder.toString().trim();
    }

    public static String getLocalizedTime(long milli) {
        return DateFormatUtil.formatTime((long)milli);
    }

    public static String getLocalizedDateTime(long milli) {
        return DateFormatUtil.formatDateTime((long)milli);
    }
}

