/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.ConfigurableDurationData;
import com.android.tools.adtui.model.DurationDataModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangeSelectionListener;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SeriesData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RangeSelectionModel
extends AspectModel<Aspect> {
    @NotNull
    private final Range mySelectionRange;
    @NotNull
    private final Range myViewRange;
    @NotNull
    private final Range myPreviousSelectionRange;
    @NotNull
    private final List<RangeSelectionListener> myListeners = new ArrayList<RangeSelectionListener>();
    @NotNull
    private final List<DurationDataModel<? extends ConfigurableDurationData>> myConstraints;
    private boolean mySelectionEnabled;
    private boolean myIsUpdating;
    private boolean myPostponeSelectionEvent;
    @Nullable
    private Consumer<RangeSelectionListener> myEventToFire;

    public RangeSelectionModel(@NotNull Range selectionRange, @NotNull Range viewRange) {
        this.mySelectionRange = selectionRange;
        this.myViewRange = viewRange;
        this.myPreviousSelectionRange = new Range(this.mySelectionRange);
        this.mySelectionEnabled = true;
        this.mySelectionRange.addDependency(this).onChange(Range.Aspect.RANGE, this::selectionChanged);
        this.myConstraints = new ArrayList<DurationDataModel<? extends ConfigurableDurationData>>();
    }

    public void addConstraint(@Nullable DurationDataModel<? extends ConfigurableDurationData> constraints) {
        this.myConstraints.add(constraints);
    }

    public void addListener(RangeSelectionListener listener2) {
        this.myListeners.add(listener2);
    }

    public void clearListeners() {
        this.myListeners.clear();
    }

    private void fireListeners() {
        if (this.myIsUpdating) {
            this.myPostponeSelectionEvent = true;
            return;
        }
        if (this.myEventToFire != null) {
            new ArrayList<RangeSelectionListener>(this.myListeners).forEach(this.myEventToFire);
            this.myEventToFire = null;
        }
    }

    private void notifyEvent(@NotNull Consumer<RangeSelectionListener> event) {
        this.myEventToFire = event;
        this.fireListeners();
    }

    private void selectionChanged() {
        this.changed(Aspect.SELECTION);
        if (this.mySelectionRange.isEmpty()) {
            this.notifyEvent(RangeSelectionListener::selectionCleared);
        } else if (this.myPreviousSelectionRange.isEmpty()) {
            this.notifyEvent(RangeSelectionListener::selectionCreated);
        }
        this.myPreviousSelectionRange.set(this.mySelectionRange);
    }

    public void beginUpdate() {
        this.myIsUpdating = true;
    }

    public void endUpdate() {
        if (this.myIsUpdating) {
            this.myIsUpdating = false;
            if (this.myPostponeSelectionEvent) {
                this.myPostponeSelectionEvent = false;
                this.fireListeners();
            }
        }
    }

    public void clear() {
        if (!this.mySelectionEnabled) {
            return;
        }
        this.mySelectionRange.clear();
    }

    public void set(double min, double max) {
        if (!this.mySelectionEnabled) {
            return;
        }
        if (this.myConstraints.isEmpty()) {
            this.mySelectionRange.set(min, max);
            return;
        }
        Range proposedRange = new Range(min, max);
        ConstrainedRangeResult result = this.getConstrainedRange(proposedRange);
        if (result == null) {
            this.mySelectionRange.clear();
            this.notifyEvent(RangeSelectionListener::selectionCreationFailure);
        } else {
            Range finalRange;
            Range range = finalRange = result.getData() != null && result.getData().canSelectPartialRange() ? result.getRange().getIntersection(proposedRange) : result.getRange();
            if (!this.mySelectionRange.isSameAs(finalRange)) {
                this.myPreviousSelectionRange.clear();
                this.mySelectionRange.set(finalRange);
            }
        }
    }

    @Nullable
    private ConstrainedRangeResult getConstrainedRange(@NotNull Range proposedRange) {
        if (this.myConstraints.isEmpty()) {
            return new ConstrainedRangeResult(proposedRange, null);
        }
        boolean found = false;
        ConstrainedRangeResult result = null;
        for (DurationDataModel<? extends ConfigurableDurationData> constraint : this.myConstraints) {
            RangedSeries<? extends ConfigurableDurationData> series = constraint.getSeries();
            List<SeriesData<? extends ConfigurableDurationData>> constraints = series.getSeriesForRange(proposedRange);
            for (SeriesData<? extends ConfigurableDurationData> data : constraints) {
                long dataMax;
                Range r;
                long duration = ((ConfigurableDurationData)data.value).getDurationUs();
                if (duration == Long.MAX_VALUE && !((ConfigurableDurationData)data.value).getSelectableWhenMaxDuration() || !(r = new Range(data.x, dataMax = duration == Long.MAX_VALUE ? duration : data.x + duration)).intersectsWith(proposedRange)) continue;
                result = new ConstrainedRangeResult(r, (ConfigurableDurationData)data.value);
                if (!r.intersectsWith(this.mySelectionRange)) continue;
                found = true;
                break;
            }
            if (!found) continue;
            break;
        }
        return result;
    }

    public boolean canSelectRange(@NotNull Range testRange) {
        ConstrainedRangeResult result = this.getConstrainedRange(testRange);
        return result != null;
    }

    @NotNull
    public Range getSelectionRange() {
        return this.mySelectionRange;
    }

    @NotNull
    public Range getViewRange() {
        return this.myViewRange;
    }

    public void setSelectionEnabled(boolean enabled) {
        this.mySelectionEnabled = enabled;
    }

    public boolean isSelectionEnabled() {
        return this.mySelectionEnabled;
    }

    public static enum Aspect {
        SELECTION;

    }

    private static class ConstrainedRangeResult {
        @NotNull
        private final Range myRange;
        ConfigurableDurationData myData;

        @NotNull
        public Range getRange() {
            return this.myRange;
        }

        @Nullable
        public ConfigurableDurationData getData() {
            return this.myData;
        }

        ConstrainedRangeResult(@NotNull Range range, @Nullable ConfigurableDurationData data) {
            this.myRange = range;
            this.myData = data;
        }
    }
}

