/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import org.jetbrains.annotations.NotNull;

public final class ConditionalEnumComboBoxModel<E extends Enum<E>>
extends AbstractListModel<E>
implements ComboBoxModel<E> {
    private List<E> myList;
    private E mySelected;
    @NotNull
    Class<E> myEnumClass;
    @NotNull
    private final Predicate<E> myConditional;

    public ConditionalEnumComboBoxModel(@NotNull Class<E> enumClass, @NotNull Predicate<E> conditional) {
        this.myConditional = conditional;
        this.myEnumClass = enumClass;
        this.update();
    }

    @NotNull
    private List<E> createEnumSet() {
        EnumSet<E> set = EnumSet.allOf(this.myEnumClass);
        set.removeIf(this.myConditional.negate());
        return new ArrayList<E>(set);
    }

    public void update() {
        this.myList = this.createEnumSet();
        this.mySelected = this.myList.isEmpty() ? null : (Enum)this.myList.get(0);
        this.fireContentsChanged(this, 0, this.getSize());
    }

    @Override
    public int getSize() {
        return this.myList.size();
    }

    @Override
    public E getElementAt(int index) {
        return (E)((Enum)this.myList.get(index));
    }

    @Override
    public void setSelectedItem(Object item) {
        Enum e = (Enum)item;
        this.setSelectedItem((E)e);
    }

    @Override
    public void setSelectedItem(E item) {
        this.mySelected = item;
        this.fireContentsChanged(this, 0, this.getSize());
    }

    @Override
    public E getSelectedItem() {
        return this.mySelected;
    }
}

