/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.AnimatedComponent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class TooltipComponent
extends AnimatedComponent {
    private static final int BORDER_SIZE = 10;
    private static final int[] DROPSHADOW_ALPHAS = new int[]{40, 30, 20, 10};
    @NotNull
    private final JComponent myTooltipContent;
    @NotNull
    private final JComponent myOwner;
    @NotNull
    private final JComponent myParent;
    @NotNull
    private final Supplier<Boolean> myIsOwnerDisplayable;
    @Nullable
    private final Supplier<Boolean> myDefaultVisibilityOverride;
    @NotNull
    private final Dimension myAntiFlapSize = new Dimension(0, 0);
    private final boolean myEnableAntiFlap;
    @Nullable
    private Point myLastPoint;
    @Nullable
    private Dimension myLastSize;
    private final ComponentListener myParentListener;

    private TooltipComponent(@NotNull Builder builder) {
        this.myTooltipContent = builder.myTooltipContent;
        this.myOwner = builder.myOwner;
        this.myParent = builder.myParent;
        this.myIsOwnerDisplayable = builder.myIsOwnerDisplayable;
        this.myDefaultVisibilityOverride = builder.myDefaultVisibilityOverride;
        this.myEnableAntiFlap = builder.myEnableAntiFlap;
        this.myParentListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TooltipComponent.this.resetBounds();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                TooltipComponent.this.resetBounds();
            }
        };
        this.add(this.myTooltipContent);
        this.setVisible(false);
        this.resetBounds();
        this.myOwner.addHierarchyListener(event -> SwingUtilities.invokeLater(() -> {
            if (!this.myIsOwnerDisplayable.get().booleanValue()) {
                this.removeFromParent();
            }
        }));
    }

    private void removeFromParent() {
        this.setVisible(false);
        Container parent = this.getParent();
        if (parent != null) {
            parent.removeComponentListener(this.myParentListener);
            parent.remove(this);
        }
    }

    private void resetBounds() {
        if (this.myParent.getWidth() != this.getWidth() || this.myParent.getHeight() != this.getHeight()) {
            this.setBounds(0, 0, this.myParent.getWidth(), this.myParent.getHeight());
        }
    }

    @NotNull
    private static Dimension max(@NotNull Dimension a, @NotNull Dimension b) {
        return new Dimension(Math.max(a.width, b.width), Math.max(a.height, b.height));
    }

    @Override
    public void doLayout() {
        Dimension size = this.getPreferredSize();
        this.myAntiFlapSize.setSize(size.width, 0);
        this.myTooltipContent.setSize(size);
        super.doLayout();
    }

    public void registerListenersOn(@NotNull Component component) {
        MouseAdapter adapter2 = new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                this.handleMove(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                this.handleMove(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                TooltipComponent.this.myAntiFlapSize.setSize(0, 0);
                TooltipComponent.this.myTooltipContent.setSize(0, 0);
                TooltipComponent.this.myParent.addComponentListener(TooltipComponent.this.myParentListener);
                TooltipComponent.this.resetBounds();
                TooltipComponent.this.myParent.add((Component)TooltipComponent.this, JLayeredPane.POPUP_LAYER);
                TooltipComponent.this.myLastPoint = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), TooltipComponent.this);
                TooltipComponent.this.setVisible(TooltipComponent.this.myDefaultVisibilityOverride == null ? true : TooltipComponent.this.myDefaultVisibilityOverride.get());
                TooltipComponent.this.revalidate();
                TooltipComponent.this.myLastSize = TooltipComponent.this.myTooltipContent.getPreferredSize();
                TooltipComponent.this.repaintIfVisible(TooltipComponent.this.myLastSize);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                TooltipComponent.this.repaintLastPoint(TooltipComponent.this.myLastSize);
                TooltipComponent.this.myAntiFlapSize.setSize(0, 0);
                TooltipComponent.this.myTooltipContent.setSize(0, 0);
                TooltipComponent.this.removeFromParent();
                TooltipComponent.this.setVisible(false);
                TooltipComponent.this.myLastPoint = null;
                TooltipComponent.this.myLastSize = null;
            }

            private void handleMove(MouseEvent e) {
                Point nextPoint = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), TooltipComponent.this);
                if (TooltipComponent.this.myLastPoint != null && TooltipComponent.this.myLastPoint.equals(nextPoint)) {
                    return;
                }
                TooltipComponent.this.repaintIfVisible(TooltipComponent.this.myTooltipContent.getSize());
                TooltipComponent.this.myLastPoint = nextPoint;
                if (!TooltipComponent.this.isVisible()) {
                    TooltipComponent.this.myAntiFlapSize.setSize(0, 0);
                }
                if (!TooltipComponent.this.myTooltipContent.getPreferredSize().equals(TooltipComponent.this.myTooltipContent.getBounds().getSize())) {
                    TooltipComponent.this.revalidate();
                }
                TooltipComponent.this.myLastSize = TooltipComponent.this.myTooltipContent.getPreferredSize();
                TooltipComponent.this.repaintIfVisible(TooltipComponent.this.myLastSize);
            }
        };
        component.addMouseMotionListener(adapter2);
        component.addMouseListener(adapter2);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = TooltipComponent.max(this.myTooltipContent.getPreferredSize(), this.myTooltipContent.getMinimumSize());
        if (this.myEnableAntiFlap) {
            return TooltipComponent.max(preferredSize, this.myAntiFlapSize);
        }
        return preferredSize;
    }

    @Override
    protected void draw(Graphics2D g, Dimension dim) {
        if (!this.isVisible() || !this.myTooltipContent.isVisible()) {
            return;
        }
        Container parent = this.getParent();
        if (parent == null) {
            return;
        }
        assert (this.myLastPoint != null);
        Dimension preferredSize = this.getPreferredSize();
        Point paintLocation = this.getPaintLocation(parent.getSize(), this.myLastPoint, preferredSize);
        this.myTooltipContent.setLocation(paintLocation.x, paintLocation.y);
        g.setColor(Color.WHITE);
        g.fillRect(paintLocation.x, paintLocation.y, preferredSize.width, preferredSize.height);
        g.setStroke(new BasicStroke(1.0f));
        RoundRectangle2D.Float rect = new RoundRectangle2D.Float();
        for (int i = 1; i <= DROPSHADOW_ALPHAS.length; ++i) {
            g.setColor(new Color(0, 0, 0, DROPSHADOW_ALPHAS[i - 1]));
            rect.setRoundRect(paintLocation.x - i, paintLocation.y - i, preferredSize.width + i * 2 - 1, preferredSize.height + i * 2 - 1, i * 2, i * 2);
            g.draw(rect);
        }
    }

    @NotNull
    private Point getPaintLocation(@NotNull Dimension parentSize, @NotNull Point lastPoint, @NotNull Dimension preferredSize) {
        int x = Math.max(Math.min(lastPoint.x + 5, parentSize.width - preferredSize.width - 5), 10);
        int y = Math.max(Math.min(lastPoint.y + 5, parentSize.height - preferredSize.height - 5), 10);
        return new Point(x, y);
    }

    public void repaintIfVisible(@NotNull Dimension contentDimension) {
        if (this.isVisible() && contentDimension.width > 0 && contentDimension.height > 0) {
            this.repaintLastPoint(contentDimension);
        }
    }

    private void repaintLastPoint(@Nullable Dimension repaintDimension) {
        if (this.myLastPoint == null) {
            return;
        }
        Container parent = this.getParent();
        if (parent == null) {
            return;
        }
        Dimension preferredSize = repaintDimension == null ? this.getPreferredSize() : repaintDimension;
        Point paintLocation = this.getPaintLocation(parent.getSize(), this.myLastPoint, preferredSize);
        this.opaqueRepaint(paintLocation.x - DROPSHADOW_ALPHAS.length, paintLocation.y - DROPSHADOW_ALPHAS.length, preferredSize.width + 2 * DROPSHADOW_ALPHAS.length + 1, preferredSize.height + 2 * DROPSHADOW_ALPHAS.length + 1);
    }

    public static class Builder {
        @NotNull
        private final JComponent myTooltipContent;
        @NotNull
        private final JComponent myOwner;
        @NotNull
        private final JComponent myParent;
        @NotNull
        private Supplier<Boolean> myIsOwnerDisplayable;
        @Nullable
        private Supplier<Boolean> myDefaultVisibilityOverride;
        private boolean myEnableAntiFlap;

        public Builder(@NotNull JComponent tooltipContent, @NotNull JComponent owner, @NotNull JComponent parent) {
            this.myTooltipContent = tooltipContent;
            this.myOwner = owner;
            this.myParent = parent;
            this.myIsOwnerDisplayable = this.myOwner::isDisplayable;
            this.myEnableAntiFlap = true;
        }

        @TestOnly
        @NotNull
        public Builder setIsOwnerDisplayable(@NotNull Supplier<Boolean> isOwnerDisplayable) {
            this.myIsOwnerDisplayable = isOwnerDisplayable;
            return this;
        }

        @NotNull
        public Builder setDefaultVisibilityOverride(@NotNull Supplier<Boolean> defaultVisibilityOverride) {
            this.myDefaultVisibilityOverride = defaultVisibilityOverride;
            return this;
        }

        public Builder setEnableAntiFlap(boolean enableAntiFlap) {
            this.myEnableAntiFlap = enableAntiFlap;
            return this;
        }

        @NotNull
        public TooltipComponent build() {
            return new TooltipComponent(this);
        }
    }
}

