/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.HtmlLabel;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.StyleSheetUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000-\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0005\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u000f\u001a\u00020\bH\u0016R\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/adtui/HtmlLabel;", "Ljavax/swing/JEditorPane;", "<init>", "()V", "defaultHyperlinkListener", "com/android/tools/adtui/HtmlLabel$defaultHyperlinkListener$1", "Lcom/android/tools/adtui/HtmlLabel$defaultHyperlinkListener$1;", "addHyperlinkListener", "", "listener", "Ljavax/swing/event/HyperlinkListener;", "disableDefaultLinkHandling", "", "getMaximumSize", "Ljava/awt/Dimension;", "updateUI", "Companion", "intellij.android.adt.ui"})
public final class HtmlLabel
extends JEditorPane {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final defaultHyperlinkListener.1 defaultHyperlinkListener = new HyperlinkAdapter(){

        protected void hyperlinkActivated(HyperlinkEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (Intrinsics.areEqual((Object)event.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
                String uri = event.getDescription();
                try {
                    BrowserLauncher.Companion.getInstance().browse(new URI(uri));
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }
    };

    public HtmlLabel() {
        this.addHyperlinkListener((HyperlinkListener)((Object)this.defaultHyperlinkListener));
    }

    @Override
    public void addHyperlinkListener(@Nullable HyperlinkListener listener2) {
        if (listener2 == null) {
            return;
        }
        this.removeHyperlinkListener((HyperlinkListener)((Object)this.defaultHyperlinkListener));
        super.addHyperlinkListener(listener2);
    }

    public final void addHyperlinkListener(@NotNull HyperlinkListener listener2, boolean disableDefaultLinkHandling) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        if (disableDefaultLinkHandling) {
            this.removeHyperlinkListener((HyperlinkListener)((Object)this.defaultHyperlinkListener));
        }
        super.addHyperlinkListener(listener2);
    }

    @Override
    @Nullable
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        Font font = this.getFont();
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
        Color color = this.getForeground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getForeground(...)");
        StyleSheet newCss = HtmlLabel.Companion.createCss(font, color);
        HTMLEditorKit kit = HTMLEditorKitBuilder.Companion.simple();
        kit.setStyleSheet(newCss);
        String oldText = this.getText();
        this.setEditorKit(kit);
        this.setText(oldText);
    }

    @JvmStatic
    public static final void setUpAsHtmlLabel(@NotNull JEditorPane editorPane) {
        Companion.setUpAsHtmlLabel(editorPane);
    }

    @JvmStatic
    public static final void setUpAsHtmlLabel(@NotNull JEditorPane editorPane, @NotNull Font font) {
        Companion.setUpAsHtmlLabel(editorPane, font);
    }

    @JvmStatic
    public static final void setUpAsHtmlLabel(@NotNull JEditorPane editorPane, @NotNull Font font, @NotNull Color foreground) {
        Companion.setUpAsHtmlLabel(editorPane, font, foreground);
    }

    public static final /* synthetic */ defaultHyperlinkListener.1 access$getDefaultHyperlinkListener$p(HtmlLabel $this) {
        return $this.defaultHyperlinkListener;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001c\u0010\f\u001a\u00020\u0005*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/adtui/HtmlLabel$Companion;", "", "<init>", "()V", "setUpAsHtmlLabel", "", "editorPane", "Ljavax/swing/JEditorPane;", "font", "Ljava/awt/Font;", "foreground", "Ljava/awt/Color;", "addCss", "createCss", "Ljavax/swing/text/html/StyleSheet;", "intellij.android.adt.ui"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void setUpAsHtmlLabel(@NotNull JEditorPane editorPane) {
            Intrinsics.checkNotNullParameter((Object)editorPane, (String)"editorPane");
            this.setUpAsHtmlLabel(editorPane, StartupUiUtil.getLabelFont());
        }

        @JvmStatic
        public final void setUpAsHtmlLabel(@NotNull JEditorPane editorPane, @NotNull Font font) {
            Intrinsics.checkNotNullParameter((Object)editorPane, (String)"editorPane");
            Intrinsics.checkNotNullParameter((Object)font, (String)"font");
            Color color = editorPane.getForeground();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getForeground(...)");
            this.setUpAsHtmlLabel(editorPane, font, color);
        }

        @JvmStatic
        public final void setUpAsHtmlLabel(@NotNull JEditorPane editorPane, @NotNull Font font, @NotNull Color foreground) {
            Intrinsics.checkNotNullParameter((Object)editorPane, (String)"editorPane");
            Intrinsics.checkNotNullParameter((Object)font, (String)"font");
            Intrinsics.checkNotNullParameter((Object)foreground, (String)"foreground");
            editorPane.setEditable(false);
            editorPane.setOpaque(false);
            editorPane.putClientProperty("JEditorPane.honorDisplayProperties", true);
            this.addCss(editorPane, font, foreground);
        }

        /*
         * Unable to fully structure code
         */
        private final void addCss(JEditorPane $this$addCss, Font font, Color foreground) {
            if (!($this$addCss instanceof HtmlLabel)) ** GOTO lbl-1000
            v0 = ((HtmlLabel)$this$addCss).getHyperlinkListeners();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getHyperlinkListeners(...)");
            if (ArraysKt.contains((Object[])v0, (Object)HtmlLabel.access$getDefaultHyperlinkListener$p((HtmlLabel)$this$addCss))) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            preserveDefaultHtmlLabelListener = v1;
            kit = HTMLEditorKitBuilder.Companion.simple();
            kit.setStyleSheet(this.createCss(font, foreground));
            $this$addCss.setEditorKit(kit);
            if (preserveDefaultHtmlLabelListener) {
                ((HtmlLabel)$this$addCss).addHyperlinkListener((HyperlinkListener)HtmlLabel.access$getDefaultHyperlinkListener$p((HtmlLabel)$this$addCss));
            }
        }

        private final StyleSheet createCss(Font font, Color foreground) {
            StyleSheet styleSheet;
            StyleSheet $this$createCss_u24lambda_u240 = styleSheet = StyleSheetUtil.getDefaultStyleSheet();
            boolean bl = false;
            String linkColor = "#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.Foreground.ENABLED);
            $this$createCss_u24lambda_u240.addRule(StringsKt.trimMargin$default((String)("\n        |body {\n        |  font-family: " + font.getFamily() + ";\n        |  font-size: " + font.getSize() + "pt;\n        |  color: " + ColorUtil.toHtmlColor((Color)foreground) + ";\n        |}\n        |ol {\n        |  padding-left: 0px;\n        |  margin-left: 35px;\n        |  margin-top: 0px;\n        |}\n        |ol li {\n        |  margin-left: 0px;\n        |  padding-left: 0px;\n        |  list-style-type: decimal;\n        |}\n        |a {\n        |  color: " + linkColor + ";\n        |  text-decoration: none;\n        |}\n        "), null, (int)1, null));
            return styleSheet;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

