/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.model.DragAndDropListModel;
import com.android.tools.adtui.model.DragAndDropModelListElement;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragSource;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.TransferHandler;

public final class DragAndDropListTransferHandler
extends TransferHandler {
    @Override
    protected Transferable createTransferable(JComponent c) {
        final JList source = (JList)c;
        c.getRootPane().getGlassPane().setVisible(true);
        return new Transferable(){

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                ObjectDataFlavor flavor = new ObjectDataFlavor((DragAndDropModelListElement)source.getSelectedValue());
                return new DataFlavor[]{flavor};
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return flavor instanceof ObjectDataFlavor;
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
                if (this.isDataFlavorSupported(flavor)) {
                    return ((ObjectDataFlavor)flavor).getObject();
                }
                throw new UnsupportedFlavorException(flavor);
            }
        };
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport info) {
        return info.isDrop() && info.isDataFlavorSupported(info.getDataFlavors()[0]);
    }

    @Override
    public int getSourceActions(JComponent c) {
        Component glassPane = c.getRootPane().getGlassPane();
        glassPane.setCursor(DragSource.DefaultMoveDrop);
        return 2;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport info) {
        JList target = (JList)info.getComponent();
        target.getRootPane().getGlassPane().setVisible(false);
        boolean dropLocationIsJListDropLocation = info.getDropLocation() instanceof JList.DropLocation;
        boolean modeIsDragAndDropListModel = target.getModel() instanceof DragAndDropListModel;
        if (!dropLocationIsJListDropLocation || !modeIsDragAndDropListModel) {
            return false;
        }
        JList.DropLocation dropLocation = (JList.DropLocation)info.getDropLocation();
        DragAndDropListModel model2 = (DragAndDropListModel)target.getModel();
        DragAndDropModelListElement sourceObject = ((ObjectDataFlavor)info.getDataFlavors()[0]).getObject();
        int max = model2.getSize();
        int index = dropLocation.getIndex();
        index = index < 0 ? max : index;
        index = Math.min(index, max);
        model2.moveElementTo(sourceObject, index);
        return true;
    }

    private static final class ObjectDataFlavor
    extends DataFlavor {
        DragAndDropModelListElement myObject;

        public ObjectDataFlavor() {
        }

        public ObjectDataFlavor(DragAndDropModelListElement object) {
            super("application/x-java-jvm-local-objectref;class=" + ObjectDataFlavor.class.getName(), null);
            this.myObject = object;
        }

        public DragAndDropModelListElement getObject() {
            return this.myObject;
        }
    }
}

