/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.visuallint.analyzers;

import android.view.ViewGroup;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.configurations.Configuration;
import com.android.tools.rendering.RenderResult;
import com.android.tools.visuallint.VisualLintAnalyzer;
import com.android.tools.visuallint.VisualLintErrorType;
import com.android.utils.HtmlBuilder;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0011H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/visuallint/analyzers/WearMarginAnalyzer;", "Lcom/android/tools/visuallint/VisualLintAnalyzer;", "<init>", "()V", "type", "Lcom/android/tools/visuallint/VisualLintErrorType;", "getType", "()Lcom/android/tools/visuallint/VisualLintErrorType;", "findIssues", "", "Lcom/android/tools/visuallint/VisualLintAnalyzer$VisualLintIssueContent;", "renderResult", "Lcom/android/tools/rendering/RenderResult;", "configuration", "Lcom/android/tools/configurations/Configuration;", "createIssueContent", "view", "Lcom/android/ide/common/rendering/api/ViewInfo;", "isRelevant", "", "ViewWithParentBounds", "intellij.android.visual-lint"})
@SourceDebugExtension(value={"SMAP\nWearMarginAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WearMarginAnalyzer.kt\ncom/android/tools/visuallint/analyzers/WearMarginAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n1869#2,2:110\n1869#2,2:112\n*S KotlinDebug\n*F\n+ 1 WearMarginAnalyzer.kt\ncom/android/tools/visuallint/analyzers/WearMarginAnalyzer\n*L\n49#1:110,2\n64#1:112,2\n*E\n"})
public final class WearMarginAnalyzer
extends VisualLintAnalyzer {
    @NotNull
    public static final WearMarginAnalyzer INSTANCE = new WearMarginAnalyzer();

    private WearMarginAnalyzer() {
    }

    @Override
    @NotNull
    public VisualLintErrorType getType() {
        return VisualLintErrorType.WEAR_MARGIN;
    }

    @Override
    @NotNull
    public List<VisualLintAnalyzer.VisualLintIssueContent> findIssues(@NotNull RenderResult renderResult, @NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)renderResult, (String)"renderResult");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        List issues = new ArrayList();
        ArrayDeque viewsToAnalyze = new ArrayDeque();
        State state = configuration.getDeviceState();
        if (state == null || (state = state.getOrientation()) == null) {
            return issues;
        }
        State orientation = state;
        Object object = configuration.getDevice();
        if (object == null || (object = object.getScreenSize((ScreenOrientation)orientation)) == null) {
            return issues;
        }
        int width = object.width;
        Device device = configuration.getDevice();
        boolean isRound = device != null ? device.isScreenRound() : false;
        double minPercent = isRound ? 0.052 : 0.025;
        double minLeft = minPercent * (double)width;
        double maxRight = (double)width - minLeft;
        ImmutableList immutableList = renderResult.getRootViews();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"getRootViews(...)");
        Iterable $this$forEach$iv = (Iterable)immutableList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ViewInfo it = (ViewInfo)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            viewsToAnalyze.add((Object)new ViewWithParentBounds(it, 0, width));
        }
        while (!((Collection)viewsToAnalyze).isEmpty()) {
            ViewWithParentBounds viewWithParentBounds = (ViewWithParentBounds)viewsToAnalyze.removeLast();
            int absoluteParentLeft = viewWithParentBounds.getAbsoluteParentLeft();
            int absoluteParentRight = viewWithParentBounds.getAbsoluteParentRight();
            if ((double)absoluteParentLeft >= minLeft && (double)absoluteParentRight <= maxRight) continue;
            ViewInfo view = viewWithParentBounds.getView();
            int absoluteViewLeft = view.getLeft() + absoluteParentLeft;
            int absoluteViewRight = view.getRight() + absoluteParentLeft;
            if (!((double)absoluteViewLeft < minLeft) && !((double)absoluteViewRight > maxRight)) continue;
            if (this.isRelevant(view)) {
                issues.add(this.createIssueContent(view));
                continue;
            }
            List list = view.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
            Iterable $this$forEach$iv2 = list;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                ViewInfo it = (ViewInfo)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                viewsToAnalyze.add((Object)new ViewWithParentBounds(it, absoluteViewLeft, absoluteViewRight));
            }
        }
        return issues;
    }

    private final VisualLintAnalyzer.VisualLintIssueContent createIssueContent(ViewInfo view) {
        String summary = "The view " + VisualLintAnalyzer.Companion.nameWithId(view) + " is too close to the side of the device";
        String simpleName = VisualLintAnalyzer.Companion.simpleName(view);
        Function1 provider = arg_0 -> WearMarginAnalyzer.createIssueContent$lambda$0(simpleName, arg_0);
        return new VisualLintAnalyzer.VisualLintIssueContent(view, summary, null, provider, 4, null);
    }

    private final boolean isRelevant(ViewInfo $this$isRelevant) {
        return $this$isRelevant.getAccessibilityObject() != null ? !Intrinsics.areEqual((Object)$this$isRelevant.getClassName(), (Object)"android.view.View") && !Intrinsics.areEqual((Object)$this$isRelevant.getClassName(), (Object)"androidx.compose.ui.platform.ComposeView") : !($this$isRelevant.getViewObject() instanceof ViewGroup);
    }

    private static final HtmlBuilder createIssueContent$lambda$0(String $simpleName, int count) {
        return new HtmlBuilder().add("In " + VisualLintAnalyzer.Companion.previewConfigurations(count) + ", the view " + $simpleName + " is closer to the side of the device than the recommended amount.").newline().add("It is recommended that, for Wear OS layouts, margins should be at least 2.5% for square devices, and 5.2% for round devices.");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/visuallint/analyzers/WearMarginAnalyzer$ViewWithParentBounds;", "", "view", "Lcom/android/ide/common/rendering/api/ViewInfo;", "absoluteParentLeft", "", "absoluteParentRight", "<init>", "(Lcom/android/ide/common/rendering/api/ViewInfo;II)V", "getView", "()Lcom/android/ide/common/rendering/api/ViewInfo;", "getAbsoluteParentLeft", "()I", "getAbsoluteParentRight", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.android.visual-lint"})
    private static final class ViewWithParentBounds {
        @NotNull
        private final ViewInfo view;
        private final int absoluteParentLeft;
        private final int absoluteParentRight;

        public ViewWithParentBounds(@NotNull ViewInfo view, int absoluteParentLeft, int absoluteParentRight) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            this.view = view;
            this.absoluteParentLeft = absoluteParentLeft;
            this.absoluteParentRight = absoluteParentRight;
        }

        @NotNull
        public final ViewInfo getView() {
            return this.view;
        }

        public final int getAbsoluteParentLeft() {
            return this.absoluteParentLeft;
        }

        public final int getAbsoluteParentRight() {
            return this.absoluteParentRight;
        }

        @NotNull
        public final ViewInfo component1() {
            return this.view;
        }

        public final int component2() {
            return this.absoluteParentLeft;
        }

        public final int component3() {
            return this.absoluteParentRight;
        }

        @NotNull
        public final ViewWithParentBounds copy(@NotNull ViewInfo view, int absoluteParentLeft, int absoluteParentRight) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            return new ViewWithParentBounds(view, absoluteParentLeft, absoluteParentRight);
        }

        public static /* synthetic */ ViewWithParentBounds copy$default(ViewWithParentBounds viewWithParentBounds, ViewInfo viewInfo, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                viewInfo = viewWithParentBounds.view;
            }
            if ((n3 & 2) != 0) {
                n = viewWithParentBounds.absoluteParentLeft;
            }
            if ((n3 & 4) != 0) {
                n2 = viewWithParentBounds.absoluteParentRight;
            }
            return viewWithParentBounds.copy(viewInfo, n, n2);
        }

        @NotNull
        public String toString() {
            return "ViewWithParentBounds(view=" + this.view + ", absoluteParentLeft=" + this.absoluteParentLeft + ", absoluteParentRight=" + this.absoluteParentRight + ")";
        }

        public int hashCode() {
            int result = this.view.hashCode();
            result = result * 31 + Integer.hashCode(this.absoluteParentLeft);
            result = result * 31 + Integer.hashCode(this.absoluteParentRight);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ViewWithParentBounds)) {
                return false;
            }
            ViewWithParentBounds viewWithParentBounds = (ViewWithParentBounds)other;
            if (!Intrinsics.areEqual((Object)this.view, (Object)viewWithParentBounds.view)) {
                return false;
            }
            if (this.absoluteParentLeft != viewWithParentBounds.absoluteParentLeft) {
                return false;
            }
            return this.absoluteParentRight == viewWithParentBounds.absoluteParentRight;
        }
    }
}

