/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.visuallint.analyzers;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.devices.State;
import com.android.tools.configurations.Configuration;
import com.android.tools.rendering.RenderResult;
import com.android.tools.visuallint.VisualLintAnalyzer;
import com.android.tools.visuallint.VisualLintErrorType;
import com.android.utils.HtmlBuilder;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/visuallint/analyzers/BottomAppBarAnalyzer;", "Lcom/android/tools/visuallint/VisualLintAnalyzer;", "<init>", "()V", "type", "Lcom/android/tools/visuallint/VisualLintErrorType;", "getType", "()Lcom/android/tools/visuallint/VisualLintErrorType;", "findIssues", "", "Lcom/android/tools/visuallint/VisualLintAnalyzer$VisualLintIssueContent;", "renderResult", "Lcom/android/tools/rendering/RenderResult;", "configuration", "Lcom/android/tools/configurations/Configuration;", "createIssueContent", "view", "Lcom/android/ide/common/rendering/api/ViewInfo;", "intellij.android.visual-lint"})
@SourceDebugExtension(value={"SMAP\nBottomAppBarAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BottomAppBarAnalyzer.kt\ncom/android/tools/visuallint/analyzers/BottomAppBarAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1869#2,2:83\n*S KotlinDebug\n*F\n+ 1 BottomAppBarAnalyzer.kt\ncom/android/tools/visuallint/analyzers/BottomAppBarAnalyzer\n*L\n52#1:83,2\n*E\n"})
public final class BottomAppBarAnalyzer
extends VisualLintAnalyzer {
    @NotNull
    public static final BottomAppBarAnalyzer INSTANCE = new BottomAppBarAnalyzer();

    private BottomAppBarAnalyzer() {
    }

    @Override
    @NotNull
    public VisualLintErrorType getType() {
        return VisualLintErrorType.BOTTOM_APP_BAR;
    }

    @Override
    @NotNull
    public List<VisualLintAnalyzer.VisualLintIssueContent> findIssues(@NotNull RenderResult renderResult, @NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)renderResult, (String)"renderResult");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        List issues = new ArrayList();
        State state = configuration.getDeviceState();
        if (state == null || (state = state.getOrientation()) == null) {
            return issues;
        }
        State orientation = state;
        Object object = configuration.getDevice();
        if (object == null || (object = object.getScreenSize((ScreenOrientation)orientation)) == null) {
            return issues;
        }
        Object dimension = object;
        int width = VisualLintAnalyzer.Companion.pxToDp(configuration, dimension.width);
        int height = VisualLintAnalyzer.Companion.pxToDp(configuration, dimension.height);
        if (width > 600 && height > 360) {
            ImmutableList immutableList = renderResult.getRootViews();
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"getRootViews(...)");
            ArrayDeque viewsToAnalyze = new ArrayDeque((Collection)immutableList);
            while (!((Collection)viewsToAnalyze).isEmpty()) {
                ViewInfo view = (ViewInfo)viewsToAnalyze.removeLast();
                List list = view.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ViewInfo it = (ViewInfo)element$iv;
                    boolean bl = false;
                    viewsToAnalyze.addLast((Object)it);
                }
                if (!Intrinsics.areEqual((Object)view.getClassName(), (Object)"com.google.android.material.bottomappbar.BottomAppBar")) continue;
                Intrinsics.checkNotNull((Object)view);
                issues.add(this.createIssueContent(view));
            }
        }
        return issues;
    }

    private final VisualLintAnalyzer.VisualLintIssueContent createIssueContent(ViewInfo view) {
        Function1 content = BottomAppBarAnalyzer::createIssueContent$lambda$0;
        return new VisualLintAnalyzer.VisualLintIssueContent(view, "Bottom app bars are only recommended for compact screens", null, content, 4, null);
    }

    private static final HtmlBuilder createIssueContent$lambda$0(int count) {
        return new HtmlBuilder().add("Bottom app bars are only recommended for compact screens, ").add("which affects " + VisualLintAnalyzer.Companion.previewConfigurations(count) + ".").newline().add("Material Design recommends replacing bottom app bar with ").addLink("navigation rail", "https://d.android.com/r/studio-ui/designer/material/navigation-rail").add(", ").addLink("navigation drawer", "https://d.android.com/r/studio-ui/designer/material/navigation-drawer").add(" or ").addLink("top app bar", "https://d.android.com/r/studio-ui/designer/material/top-app-bar").add(" for breakpoints over 600dp.");
    }
}

